/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.fluids;

import java.util.Random;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Blocks;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.event.ForgeEventFactory;
import net.minecraftforge.fluids.BlockFluidBase;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidStack;

public class BlockFluidClassic
extends BlockFluidBase {
    protected boolean[] isOptimalFlowDirection = new boolean[4];
    protected int[] flowCost = new int[4];
    protected FluidStack stack;

    public BlockFluidClassic(Fluid fluid, Material material) {
        super(fluid, material);
        this.stack = new FluidStack(fluid, 1000);
    }

    public BlockFluidClassic setFluidStack(FluidStack stack) {
        this.stack = stack;
        return this;
    }

    public BlockFluidClassic setFluidStackAmount(int amount) {
        this.stack.amount = amount;
        return this;
    }

    @Override
    public int getQuantaValue(IBlockAccess world, BlockPos pos) {
        IBlockState state = world.getBlockState(pos);
        if (state.getBlock() == Blocks.AIR) {
            return 0;
        }
        if (state.getBlock() != this) {
            return -1;
        }
        int quantaRemaining = this.quantaPerBlock - state.getValue(LEVEL);
        return quantaRemaining;
    }

    @Override
    public boolean canCollideCheck(@Nonnull IBlockState state, boolean fullHit) {
        return fullHit && state.getValue(LEVEL) == 0;
    }

    @Override
    public int getMaxRenderHeightMeta() {
        return 0;
    }

    @Override
    public int getLightValue(@Nonnull IBlockState state, @Nonnull IBlockAccess world, @Nonnull BlockPos pos) {
        if (this.maxScaledLight == 0) {
            return super.getLightValue(state, world, pos);
        }
        int data = this.quantaPerBlock - state.getValue(LEVEL) - 1;
        return (int)((float)data / this.quantaPerBlockFloat * (float)this.maxScaledLight);
    }

    @Override
    public void updateTick(@Nonnull World world, @Nonnull BlockPos pos, @Nonnull IBlockState state, @Nonnull Random rand) {
        int adjacentSourceBlocks;
        if (!this.isSourceBlock(world, pos) && ForgeEventFactory.canCreateFluidSource(world, pos, state, false) && (adjacentSourceBlocks = (this.isSourceBlock(world, pos.north()) ? 1 : 0) + (this.isSourceBlock(world, pos.south()) ? 1 : 0) + (this.isSourceBlock(world, pos.east()) ? 1 : 0) + (this.isSourceBlock(world, pos.west()) ? 1 : 0)) >= 2 && (world.getBlockState(pos.up(this.densityDir)).getMaterial().isSolid() || this.isSourceBlock(world, pos.up(this.densityDir)))) {
            world.setBlockState(pos, state.withProperty(LEVEL, 0));
        }
        int quantaRemaining = this.quantaPerBlock - state.getValue(LEVEL);
        int expQuanta = -101;
        if (quantaRemaining < this.quantaPerBlock) {
            if (world.getBlockState(pos.add(0, -this.densityDir, 0)).getBlock() == this || world.getBlockState(pos.add(-1, -this.densityDir, 0)).getBlock() == this || world.getBlockState(pos.add(1, -this.densityDir, 0)).getBlock() == this || world.getBlockState(pos.add(0, -this.densityDir, -1)).getBlock() == this || world.getBlockState(pos.add(0, -this.densityDir, 1)).getBlock() == this) {
                expQuanta = this.quantaPerBlock - 1;
            } else {
                int maxQuanta = -100;
                maxQuanta = this.getLargerQuanta(world, pos.add(-1, 0, 0), maxQuanta);
                maxQuanta = this.getLargerQuanta(world, pos.add(1, 0, 0), maxQuanta);
                maxQuanta = this.getLargerQuanta(world, pos.add(0, 0, -1), maxQuanta);
                maxQuanta = this.getLargerQuanta(world, pos.add(0, 0, 1), maxQuanta);
                expQuanta = maxQuanta - 1;
            }
            if (expQuanta != quantaRemaining) {
                quantaRemaining = expQuanta;
                if (expQuanta <= 0) {
                    world.setBlockToAir(pos);
                } else {
                    world.setBlockState(pos, state.withProperty(LEVEL, this.quantaPerBlock - expQuanta), 2);
                    world.scheduleUpdate(pos, this, this.tickRate);
                    world.notifyNeighborsOfStateChange(pos, this, false);
                }
            }
        } else if (quantaRemaining >= this.quantaPerBlock) {
            world.setBlockState(pos, this.getDefaultState(), 2);
        }
        if (this.canDisplace(world, pos.up(this.densityDir))) {
            this.flowIntoBlock(world, pos.up(this.densityDir), 1);
            return;
        }
        int flowMeta = this.quantaPerBlock - quantaRemaining + 1;
        if (flowMeta >= this.quantaPerBlock) {
            return;
        }
        if (this.isSourceBlock(world, pos) || !this.isFlowingVertically(world, pos)) {
            boolean[] flowTo;
            if (world.getBlockState(pos.down(this.densityDir)).getBlock() == this) {
                flowMeta = 1;
            }
            if ((flowTo = this.getOptimalFlowDirections(world, pos))[0]) {
                this.flowIntoBlock(world, pos.add(-1, 0, 0), flowMeta);
            }
            if (flowTo[1]) {
                this.flowIntoBlock(world, pos.add(1, 0, 0), flowMeta);
            }
            if (flowTo[2]) {
                this.flowIntoBlock(world, pos.add(0, 0, -1), flowMeta);
            }
            if (flowTo[3]) {
                this.flowIntoBlock(world, pos.add(0, 0, 1), flowMeta);
            }
        }
    }

    public boolean isFlowingVertically(IBlockAccess world, BlockPos pos) {
        return world.getBlockState(pos.up(this.densityDir)).getBlock() == this || world.getBlockState(pos).getBlock() == this && this.canFlowInto(world, pos.up(this.densityDir));
    }

    public boolean isSourceBlock(IBlockAccess world, BlockPos pos) {
        IBlockState state = world.getBlockState(pos);
        return state.getBlock() == this && state.getValue(LEVEL) == 0;
    }

    protected boolean[] getOptimalFlowDirections(World world, BlockPos pos) {
        int side;
        for (int side2 = 0; side2 < 4; ++side2) {
            this.flowCost[side2] = 1000;
            BlockPos pos2 = pos;
            switch (side2) {
                case 0: {
                    pos2 = pos2.add(-1, 0, 0);
                    break;
                }
                case 1: {
                    pos2 = pos2.add(1, 0, 0);
                    break;
                }
                case 2: {
                    pos2 = pos2.add(0, 0, -1);
                    break;
                }
                case 3: {
                    pos2 = pos2.add(0, 0, 1);
                }
            }
            if (!this.canFlowInto(world, pos2) || this.isSourceBlock(world, pos2)) continue;
            this.flowCost[side2] = this.canFlowInto(world, pos2.add(0, this.densityDir, 0)) ? 0 : this.calculateFlowCost(world, pos2, 1, side2);
        }
        int min = this.flowCost[0];
        for (side = 1; side < 4; ++side) {
            if (this.flowCost[side] >= min) continue;
            min = this.flowCost[side];
        }
        for (side = 0; side < 4; ++side) {
            this.isOptimalFlowDirection[side] = this.flowCost[side] == min;
        }
        return this.isOptimalFlowDirection;
    }

    protected int calculateFlowCost(World world, BlockPos pos, int recurseDepth, int side) {
        int cost = 1000;
        for (int adjSide = 0; adjSide < 4; ++adjSide) {
            int min;
            if (adjSide == 0 && side == 1 || adjSide == 1 && side == 0 || adjSide == 2 && side == 3 || adjSide == 3 && side == 2) continue;
            BlockPos pos2 = pos;
            switch (adjSide) {
                case 0: {
                    pos2 = pos2.add(-1, 0, 0);
                    break;
                }
                case 1: {
                    pos2 = pos2.add(1, 0, 0);
                    break;
                }
                case 2: {
                    pos2 = pos2.add(0, 0, -1);
                    break;
                }
                case 3: {
                    pos2 = pos2.add(0, 0, 1);
                }
            }
            if (!this.canFlowInto(world, pos2) || this.isSourceBlock(world, pos2)) continue;
            if (this.canFlowInto(world, pos2.add(0, this.densityDir, 0))) {
                return recurseDepth;
            }
            if (recurseDepth >= 4 || (min = this.calculateFlowCost(world, pos2, recurseDepth + 1, adjSide)) >= cost) continue;
            cost = min;
        }
        return cost;
    }

    protected void flowIntoBlock(World world, BlockPos pos, int meta) {
        if (meta < 0) {
            return;
        }
        if (this.displaceIfPossible(world, pos)) {
            world.setBlockState(pos, this.getBlockState().getBaseState().withProperty(LEVEL, meta), 3);
        }
    }

    protected boolean canFlowInto(IBlockAccess world, BlockPos pos) {
        if (world.isAirBlock(pos)) {
            return true;
        }
        IBlockState state = world.getBlockState(pos);
        if (state.getBlock() == this) {
            return true;
        }
        if (this.displacements.containsKey(state.getBlock())) {
            return (Boolean)this.displacements.get(state.getBlock());
        }
        Material material = state.getMaterial();
        if (material.blocksMovement() || material == Material.WATER || material == Material.LAVA || material == Material.PORTAL) {
            return false;
        }
        int density = BlockFluidClassic.getDensity(world, pos);
        if (density == Integer.MAX_VALUE) {
            return true;
        }
        return this.density > density;
    }

    protected int getLargerQuanta(IBlockAccess world, BlockPos pos, int compare) {
        int quantaRemaining = this.getQuantaValue(world, pos);
        if (quantaRemaining <= 0) {
            return compare;
        }
        return quantaRemaining >= compare ? quantaRemaining : compare;
    }

    @Override
    public int place(World world, BlockPos pos, @Nonnull FluidStack fluidStack, boolean doPlace) {
        if (fluidStack.amount < 1000) {
            return 0;
        }
        if (doPlace) {
            world.setBlockState(pos, this.getDefaultState(), 11);
        }
        return 1000;
    }

    @Override
    @Nullable
    public FluidStack drain(World world, BlockPos pos, boolean doDrain) {
        if (!this.isSourceBlock(world, pos)) {
            return null;
        }
        if (doDrain) {
            world.setBlockToAir(pos);
        }
        return this.stack.copy();
    }

    @Override
    public boolean canDrain(World world, BlockPos pos) {
        return this.isSourceBlock(world, pos);
    }
}

