/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.fluids;

import java.util.Locale;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.EnumRarity;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.translation.I18n;
import net.minecraft.world.World;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fml.common.FMLLog;

public class Fluid {
    public static final int BUCKET_VOLUME = 1000;
    protected final String fluidName;
    protected String unlocalizedName;
    protected final ResourceLocation still;
    protected final ResourceLocation flowing;
    private SoundEvent fillSound;
    private SoundEvent emptySound;
    protected int luminosity = 0;
    protected int density = 1000;
    protected int temperature = 300;
    protected int viscosity = 1000;
    protected boolean isGaseous;
    protected EnumRarity rarity = EnumRarity.COMMON;
    protected Block block = null;

    public Fluid(String fluidName, ResourceLocation still, ResourceLocation flowing) {
        this.fluidName = fluidName.toLowerCase(Locale.ENGLISH);
        this.unlocalizedName = fluidName;
        this.still = still;
        this.flowing = flowing;
    }

    public Fluid setUnlocalizedName(String unlocalizedName) {
        this.unlocalizedName = unlocalizedName;
        return this;
    }

    public Fluid setBlock(Block block) {
        if (this.block == null || this.block == block) {
            this.block = block;
        } else {
            FMLLog.warning("A mod has attempted to assign Block " + block + " to the Fluid '" + this.fluidName + "' but this Fluid has already been linked to the Block " + this.block + ". You may have duplicate Fluid Blocks as a result. It *may* be possible to configure your mods to avoid this.", new Object[0]);
        }
        return this;
    }

    public Fluid setLuminosity(int luminosity) {
        this.luminosity = luminosity;
        return this;
    }

    public Fluid setDensity(int density) {
        this.density = density;
        return this;
    }

    public Fluid setTemperature(int temperature) {
        this.temperature = temperature;
        return this;
    }

    public Fluid setViscosity(int viscosity) {
        this.viscosity = viscosity;
        return this;
    }

    public Fluid setGaseous(boolean isGaseous) {
        this.isGaseous = isGaseous;
        return this;
    }

    public Fluid setRarity(EnumRarity rarity) {
        this.rarity = rarity;
        return this;
    }

    public Fluid setFillSound(SoundEvent fillSound) {
        this.fillSound = fillSound;
        return this;
    }

    public Fluid setEmptySound(SoundEvent emptySound) {
        this.emptySound = emptySound;
        return this;
    }

    public final String getName() {
        return this.fluidName;
    }

    public final Block getBlock() {
        return this.block;
    }

    public final boolean canBePlacedInWorld() {
        return this.block != null;
    }

    public boolean doesVaporize(FluidStack fluidStack) {
        if (this.block == null) {
            return false;
        }
        return this.block.getDefaultState().getMaterial() == Material.WATER;
    }

    public void vaporize(@Nullable EntityPlayer player, World worldIn, BlockPos pos, FluidStack fluidStack) {
        worldIn.playSound(player, pos, SoundEvents.BLOCK_FIRE_EXTINGUISH, SoundCategory.BLOCKS, 0.5f, 2.6f + (worldIn.rand.nextFloat() - worldIn.rand.nextFloat()) * 0.8f);
        for (int l = 0; l < 8; ++l) {
            worldIn.spawnParticle(EnumParticleTypes.SMOKE_LARGE, (double)pos.getX() + Math.random(), (double)pos.getY() + Math.random(), (double)pos.getZ() + Math.random(), 0.0, 0.0, 0.0, new int[0]);
        }
    }

    public String getLocalizedName(FluidStack stack) {
        String s = this.getUnlocalizedName();
        return s == null ? "" : I18n.translateToLocal(s);
    }

    public String getUnlocalizedName(FluidStack stack) {
        return this.getUnlocalizedName();
    }

    public String getUnlocalizedName() {
        return "fluid." + this.unlocalizedName;
    }

    public final int getLuminosity() {
        return this.luminosity;
    }

    public final int getDensity() {
        return this.density;
    }

    public final int getTemperature() {
        return this.temperature;
    }

    public final int getViscosity() {
        return this.viscosity;
    }

    public final boolean isGaseous() {
        return this.isGaseous;
    }

    public EnumRarity getRarity() {
        return this.rarity;
    }

    public int getColor() {
        return -1;
    }

    public ResourceLocation getStill() {
        return this.still;
    }

    public ResourceLocation getFlowing() {
        return this.flowing;
    }

    public SoundEvent getFillSound() {
        if (this.fillSound == null) {
            this.fillSound = this.getBlock() != null && this.getBlock().getDefaultState().getMaterial() == Material.LAVA ? SoundEvents.ITEM_BUCKET_FILL_LAVA : SoundEvents.ITEM_BUCKET_FILL;
        }
        return this.fillSound;
    }

    public SoundEvent getEmptySound() {
        if (this.emptySound == null) {
            this.emptySound = this.getBlock() != null && this.getBlock().getDefaultState().getMaterial() == Material.LAVA ? SoundEvents.ITEM_BUCKET_EMPTY_LAVA : SoundEvents.ITEM_BUCKET_EMPTY;
        }
        return this.emptySound;
    }

    public int getLuminosity(FluidStack stack) {
        return this.getLuminosity();
    }

    public int getDensity(FluidStack stack) {
        return this.getDensity();
    }

    public int getTemperature(FluidStack stack) {
        return this.getTemperature();
    }

    public int getViscosity(FluidStack stack) {
        return this.getViscosity();
    }

    public boolean isGaseous(FluidStack stack) {
        return this.isGaseous();
    }

    public EnumRarity getRarity(FluidStack stack) {
        return this.getRarity();
    }

    public int getColor(FluidStack stack) {
        return this.getColor();
    }

    public ResourceLocation getStill(FluidStack stack) {
        return this.getStill();
    }

    public ResourceLocation getFlowing(FluidStack stack) {
        return this.getFlowing();
    }

    public SoundEvent getFillSound(FluidStack stack) {
        return this.getFillSound();
    }

    public SoundEvent getEmptySound(FluidStack stack) {
        return this.getEmptySound();
    }

    public int getLuminosity(World world, BlockPos pos) {
        return this.getLuminosity();
    }

    public int getDensity(World world, BlockPos pos) {
        return this.getDensity();
    }

    public int getTemperature(World world, BlockPos pos) {
        return this.getTemperature();
    }

    public int getViscosity(World world, BlockPos pos) {
        return this.getViscosity();
    }

    public boolean isGaseous(World world, BlockPos pos) {
        return this.isGaseous();
    }

    public EnumRarity getRarity(World world, BlockPos pos) {
        return this.getRarity();
    }

    public int getColor(World world, BlockPos pos) {
        return this.getColor();
    }

    public ResourceLocation getStill(World world, BlockPos pos) {
        return this.getStill();
    }

    public ResourceLocation getFlowing(World world, BlockPos pos) {
        return this.getFlowing();
    }

    public SoundEvent getFillSound(World world, BlockPos pos) {
        return this.getFillSound();
    }

    public SoundEvent getEmptySound(World world, BlockPos pos) {
        return this.getEmptySound();
    }
}

