/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.fluids;

import javax.annotation.Nullable;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidUtil;
import net.minecraftforge.fml.common.FMLLog;
import net.minecraftforge.fml.common.registry.RegistryDelegate;

public class FluidStack {
    public int amount;
    public NBTTagCompound tag;
    private RegistryDelegate<Fluid> fluidDelegate;

    public FluidStack(Fluid fluid, int amount) {
        if (fluid == null) {
            FMLLog.bigWarning("Null fluid supplied to fluidstack. Did you try and create a stack for an unregistered fluid?", new Object[0]);
            throw new IllegalArgumentException("Cannot create a fluidstack from a null fluid");
        }
        if (!FluidRegistry.isFluidRegistered(fluid)) {
            FMLLog.bigWarning("Failed attempt to create a FluidStack for an unregistered Fluid %s (type %s)", fluid.getName(), fluid.getClass().getName());
            throw new IllegalArgumentException("Cannot create a fluidstack from an unregistered fluid");
        }
        this.fluidDelegate = FluidRegistry.makeDelegate(fluid);
        this.amount = amount;
    }

    public FluidStack(Fluid fluid, int amount, NBTTagCompound nbt) {
        this(fluid, amount);
        if (nbt != null) {
            this.tag = nbt.copy();
        }
    }

    public FluidStack(FluidStack stack, int amount) {
        this(stack.getFluid(), amount, stack.tag);
    }

    @Nullable
    public static FluidStack loadFluidStackFromNBT(NBTTagCompound nbt) {
        if (nbt == null) {
            return null;
        }
        if (!nbt.hasKey("FluidName", 8)) {
            return null;
        }
        String fluidName = nbt.getString("FluidName");
        if (FluidRegistry.getFluid(fluidName) == null) {
            return null;
        }
        FluidStack stack = new FluidStack(FluidRegistry.getFluid(fluidName), nbt.getInteger("Amount"));
        if (nbt.hasKey("Tag")) {
            stack.tag = nbt.getCompoundTag("Tag");
        }
        return stack;
    }

    public NBTTagCompound writeToNBT(NBTTagCompound nbt) {
        nbt.setString("FluidName", FluidRegistry.getFluidName(this.getFluid()));
        nbt.setInteger("Amount", this.amount);
        if (this.tag != null) {
            nbt.setTag("Tag", this.tag);
        }
        return nbt;
    }

    public final Fluid getFluid() {
        return this.fluidDelegate.get();
    }

    public String getLocalizedName() {
        return this.getFluid().getLocalizedName(this);
    }

    public String getUnlocalizedName() {
        return this.getFluid().getUnlocalizedName(this);
    }

    public FluidStack copy() {
        return new FluidStack(this.getFluid(), this.amount, this.tag);
    }

    public boolean isFluidEqual(@Nullable FluidStack other) {
        return other != null && this.getFluid() == other.getFluid() && this.isFluidStackTagEqual(other);
    }

    private boolean isFluidStackTagEqual(FluidStack other) {
        return this.tag == null ? other.tag == null : (other.tag == null ? false : this.tag.equals(other.tag));
    }

    public static boolean areFluidStackTagsEqual(@Nullable FluidStack stack1, @Nullable FluidStack stack2) {
        return stack1 == null && stack2 == null ? true : (stack1 == null || stack2 == null ? false : stack1.isFluidStackTagEqual(stack2));
    }

    public boolean containsFluid(@Nullable FluidStack other) {
        return this.isFluidEqual(other) && this.amount >= other.amount;
    }

    public boolean isFluidStackIdentical(FluidStack other) {
        return this.isFluidEqual(other) && this.amount == other.amount;
    }

    public boolean isFluidEqual(ItemStack other) {
        if (other == null) {
            return false;
        }
        return this.isFluidEqual(FluidUtil.getFluidContained(other));
    }

    public final int hashCode() {
        int code = 1;
        code = 31 * code + this.getFluid().hashCode();
        code = 31 * code + this.amount;
        if (this.tag != null) {
            code = 31 * code + this.tag.hashCode();
        }
        return code;
    }

    public final boolean equals(Object o) {
        if (!(o instanceof FluidStack)) {
            return false;
        }
        return this.isFluidEqual((FluidStack)o);
    }
}

