/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.fluids;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockLiquid;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidActionResult;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.IFluidBlock;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandlerItem;
import net.minecraftforge.fluids.capability.templates.VoidFluidHandler;
import net.minecraftforge.fluids.capability.wrappers.BlockLiquidWrapper;
import net.minecraftforge.fluids.capability.wrappers.BlockWrapper;
import net.minecraftforge.fluids.capability.wrappers.FluidBlockWrapper;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemHandlerHelper;
import net.minecraftforge.items.wrapper.InvWrapper;

public class FluidUtil {
    private FluidUtil() {
    }

    @Nonnull
    public static FluidActionResult interactWithFluidHandler(@Nonnull ItemStack stack, IFluidHandler fluidHandler, EntityPlayer player) {
        if (stack.isEmpty() || fluidHandler == null || player == null) {
            return FluidActionResult.FAILURE;
        }
        InvWrapper playerInventory = new InvWrapper(player.inventory);
        FluidActionResult fillResult = FluidUtil.tryFillContainerAndStow(stack, fluidHandler, playerInventory, Integer.MAX_VALUE, player);
        if (fillResult.isSuccess()) {
            return fillResult;
        }
        return FluidUtil.tryEmptyContainerAndStow(stack, fluidHandler, playerInventory, Integer.MAX_VALUE, player);
    }

    @Nonnull
    public static FluidActionResult tryFillContainer(@Nonnull ItemStack container, IFluidHandler fluidSource, int maxAmount, @Nullable EntityPlayer player, boolean doFill) {
        FluidStack simulatedTransfer;
        ItemStack containerCopy = container.copy();
        containerCopy.setCount(1);
        IFluidHandlerItem containerFluidHandler = FluidUtil.getFluidHandler(containerCopy);
        if (containerFluidHandler != null && (simulatedTransfer = FluidUtil.tryFluidTransfer(containerFluidHandler, fluidSource, maxAmount, false)) != null) {
            if (doFill) {
                FluidUtil.tryFluidTransfer(containerFluidHandler, fluidSource, maxAmount, true);
                if (player != null) {
                    SoundEvent soundevent = simulatedTransfer.getFluid().getFillSound(simulatedTransfer);
                    player.playSound(soundevent, 1.0f, 1.0f);
                }
            } else {
                containerFluidHandler.fill(simulatedTransfer, true);
            }
            ItemStack resultContainer = containerFluidHandler.getContainer();
            return new FluidActionResult(resultContainer);
        }
        return FluidActionResult.FAILURE;
    }

    @Nonnull
    public static FluidActionResult tryEmptyContainer(@Nonnull ItemStack container, IFluidHandler fluidDestination, int maxAmount, @Nullable EntityPlayer player, boolean doDrain) {
        FluidStack simulatedTransfer;
        ItemStack containerCopy = container.copy();
        containerCopy.setCount(1);
        IFluidHandlerItem containerFluidHandler = FluidUtil.getFluidHandler(containerCopy);
        if (containerFluidHandler != null && (simulatedTransfer = FluidUtil.tryFluidTransfer(fluidDestination, containerFluidHandler, maxAmount, false)) != null) {
            if (doDrain) {
                FluidUtil.tryFluidTransfer(fluidDestination, containerFluidHandler, maxAmount, true);
                if (player != null) {
                    SoundEvent soundevent = simulatedTransfer.getFluid().getEmptySound(simulatedTransfer);
                    player.playSound(soundevent, 1.0f, 1.0f);
                }
            } else {
                containerFluidHandler.drain(simulatedTransfer, true);
            }
            ItemStack resultContainer = containerFluidHandler.getContainer();
            return new FluidActionResult(resultContainer);
        }
        return FluidActionResult.FAILURE;
    }

    @Nonnull
    public static FluidActionResult tryFillContainerAndStow(@Nonnull ItemStack container, IFluidHandler fluidSource, IItemHandler inventory, int maxAmount, @Nullable EntityPlayer player) {
        if (container.isEmpty()) {
            return FluidActionResult.FAILURE;
        }
        if (player != null && player.capabilities.isCreativeMode) {
            FluidActionResult filledReal = FluidUtil.tryFillContainer(container, fluidSource, maxAmount, player, true);
            if (filledReal.isSuccess()) {
                return new FluidActionResult(container);
            }
        } else if (container.getCount() == 1) {
            FluidActionResult filledReal = FluidUtil.tryFillContainer(container, fluidSource, maxAmount, player, true);
            if (filledReal.isSuccess()) {
                return filledReal;
            }
        } else {
            ItemStack remainder;
            FluidActionResult filledSimulated = FluidUtil.tryFillContainer(container, fluidSource, maxAmount, player, false);
            if (filledSimulated.isSuccess() && ((remainder = ItemHandlerHelper.insertItemStacked(inventory, filledSimulated.getResult(), true)).isEmpty() || player != null)) {
                FluidActionResult filledReal = FluidUtil.tryFillContainer(container, fluidSource, maxAmount, player, true);
                remainder = ItemHandlerHelper.insertItemStacked(inventory, filledReal.getResult(), false);
                if (!remainder.isEmpty() && player != null) {
                    ItemHandlerHelper.giveItemToPlayer(player, remainder);
                }
                ItemStack containerCopy = container.copy();
                containerCopy.shrink(1);
                return new FluidActionResult(containerCopy);
            }
        }
        return FluidActionResult.FAILURE;
    }

    @Nonnull
    public static FluidActionResult tryEmptyContainerAndStow(@Nonnull ItemStack container, IFluidHandler fluidDestination, IItemHandler inventory, int maxAmount, @Nullable EntityPlayer player) {
        if (container.isEmpty()) {
            return FluidActionResult.FAILURE;
        }
        if (player != null && player.capabilities.isCreativeMode) {
            FluidActionResult emptiedReal = FluidUtil.tryEmptyContainer(container, fluidDestination, maxAmount, player, true);
            if (emptiedReal.isSuccess()) {
                return new FluidActionResult(container);
            }
        } else if (container.getCount() == 1) {
            FluidActionResult emptiedReal = FluidUtil.tryEmptyContainer(container, fluidDestination, maxAmount, player, true);
            if (emptiedReal.isSuccess()) {
                return emptiedReal;
            }
        } else {
            ItemStack remainder;
            FluidActionResult emptiedSimulated = FluidUtil.tryEmptyContainer(container, fluidDestination, maxAmount, player, false);
            if (emptiedSimulated.isSuccess() && ((remainder = ItemHandlerHelper.insertItemStacked(inventory, emptiedSimulated.getResult(), true)).isEmpty() || player != null)) {
                FluidActionResult emptiedReal = FluidUtil.tryEmptyContainer(container, fluidDestination, maxAmount, player, true);
                remainder = ItemHandlerHelper.insertItemStacked(inventory, emptiedReal.getResult(), false);
                if (!remainder.isEmpty() && player != null) {
                    ItemHandlerHelper.giveItemToPlayer(player, remainder);
                }
                ItemStack containerCopy = container.copy();
                containerCopy.shrink(1);
                return new FluidActionResult(containerCopy);
            }
        }
        return FluidActionResult.FAILURE;
    }

    @Nullable
    public static FluidStack tryFluidTransfer(IFluidHandler fluidDestination, IFluidHandler fluidSource, int maxAmount, boolean doTransfer) {
        int fillableAmount;
        FluidStack drainable = fluidSource.drain(maxAmount, false);
        if (drainable != null && drainable.amount > 0 && (fillableAmount = fluidDestination.fill(drainable, false)) > 0) {
            if (doTransfer) {
                FluidStack drained = fluidSource.drain(fillableAmount, true);
                if (drained != null) {
                    drained.amount = fluidDestination.fill(drained, true);
                    return drained;
                }
            } else {
                drainable.amount = fillableAmount;
                return drainable;
            }
        }
        return null;
    }

    @Nullable
    public static IFluidHandlerItem getFluidHandler(@Nonnull ItemStack itemStack) {
        if (itemStack.hasCapability(CapabilityFluidHandler.FLUID_HANDLER_ITEM_CAPABILITY, null)) {
            return itemStack.getCapability(CapabilityFluidHandler.FLUID_HANDLER_ITEM_CAPABILITY, null);
        }
        return null;
    }

    @Nullable
    public static FluidStack getFluidContained(@Nonnull ItemStack container) {
        if (!container.isEmpty()) {
            container = container.copy();
            container.setCount(1);
            IFluidHandlerItem fluidHandler = FluidUtil.getFluidHandler(container);
            if (fluidHandler != null) {
                return fluidHandler.drain(Integer.MAX_VALUE, false);
            }
        }
        return null;
    }

    @Nullable
    public static IFluidHandler getFluidHandler(World world, BlockPos blockPos, @Nullable EnumFacing side) {
        IBlockState state = world.getBlockState(blockPos);
        Block block = state.getBlock();
        if (block.hasTileEntity(state)) {
            TileEntity tileEntity = world.getTileEntity(blockPos);
            if (tileEntity != null && tileEntity.hasCapability(CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY, side)) {
                return tileEntity.getCapability(CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY, side);
            }
        } else {
            if (block instanceof IFluidBlock) {
                return new FluidBlockWrapper((IFluidBlock)((Object)block), world, blockPos);
            }
            if (block instanceof BlockLiquid) {
                return new BlockLiquidWrapper((BlockLiquid)block, world, blockPos);
            }
        }
        return null;
    }

    @Nonnull
    public static FluidActionResult tryPickUpFluid(@Nonnull ItemStack emptyContainer, @Nullable EntityPlayer playerIn, World worldIn, BlockPos pos, EnumFacing side) {
        FluidActionResult fluidActionResult;
        IFluidHandler targetFluidHandler;
        if (emptyContainer.isEmpty() || worldIn == null || pos == null) {
            return FluidActionResult.FAILURE;
        }
        IBlockState state = worldIn.getBlockState(pos);
        Block block = state.getBlock();
        if ((block instanceof IFluidBlock || block instanceof BlockLiquid) && (targetFluidHandler = FluidUtil.getFluidHandler(worldIn, pos, side)) != null && (fluidActionResult = FluidUtil.tryFillContainer(emptyContainer, targetFluidHandler, Integer.MAX_VALUE, playerIn, true)).isSuccess()) {
            return fluidActionResult;
        }
        return FluidActionResult.FAILURE;
    }

    @Nonnull
    public static FluidActionResult tryPlaceFluid(@Nullable EntityPlayer player, World world, BlockPos pos, @Nonnull ItemStack container, FluidStack resource) {
        Block block;
        IFluidHandler handler;
        FluidActionResult result;
        if (world == null || resource == null || pos == null) {
            return FluidActionResult.FAILURE;
        }
        Fluid fluid = resource.getFluid();
        if (fluid == null || !fluid.canBePlacedInWorld()) {
            return FluidActionResult.FAILURE;
        }
        IBlockState destBlockState = world.getBlockState(pos);
        Material destMaterial = destBlockState.getMaterial();
        boolean isDestNonSolid = !destMaterial.isSolid();
        boolean isDestReplaceable = destBlockState.getBlock().isReplaceable(world, pos);
        if (!(world.isAirBlock(pos) || isDestNonSolid || isDestReplaceable)) {
            return FluidActionResult.FAILURE;
        }
        if (world.provider.doesWaterVaporize() && fluid.doesVaporize(resource)) {
            fluid.vaporize(player, world, pos, resource);
            return FluidUtil.tryEmptyContainer(container, new VoidFluidHandler(), Integer.MAX_VALUE, player, true);
        }
        if (!world.isRemote && (isDestNonSolid || isDestReplaceable) && !destMaterial.isLiquid()) {
            world.destroyBlock(pos, true);
        }
        if ((result = FluidUtil.tryEmptyContainer(container, handler = (block = fluid.getBlock()) instanceof IFluidBlock ? new FluidBlockWrapper((IFluidBlock)((Object)block), world, pos) : (block instanceof BlockLiquid ? new BlockLiquidWrapper((BlockLiquid)block, world, pos) : new BlockWrapper(block, world, pos)), Integer.MAX_VALUE, player, true)).isSuccess()) {
            SoundEvent soundevent = fluid.getEmptySound(resource);
            world.playSound(player, pos, soundevent, SoundCategory.BLOCKS, 1.0f, 1.0f);
        }
        return result;
    }
}

