/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.fluids.capability.wrappers;

import javax.annotation.Nullable;
import net.minecraft.block.BlockLiquid;
import net.minecraft.block.BlockStaticLiquid;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Blocks;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.FluidTankProperties;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fluids.capability.IFluidTankProperties;

public class BlockLiquidWrapper
implements IFluidHandler {
    protected final BlockLiquid blockLiquid;
    protected final World world;
    protected final BlockPos blockPos;

    public BlockLiquidWrapper(BlockLiquid blockLiquid, World world, BlockPos blockPos) {
        this.blockLiquid = blockLiquid;
        this.world = world;
        this.blockPos = blockPos;
    }

    @Override
    public IFluidTankProperties[] getTankProperties() {
        FluidStack containedStack = null;
        IBlockState blockState = this.world.getBlockState(this.blockPos);
        if (blockState.getBlock() == this.blockLiquid) {
            containedStack = this.getStack(blockState);
        }
        return new FluidTankProperties[]{new FluidTankProperties(containedStack, 1000, false, true)};
    }

    @Override
    public int fill(FluidStack resource, boolean doFill) {
        if (resource.amount < 1000) {
            return 0;
        }
        if (doFill) {
            Material material = this.blockLiquid.getDefaultState().getMaterial();
            BlockStaticLiquid block = BlockLiquid.getStaticBlock(material);
            this.world.setBlockState(this.blockPos, block.getDefaultState().withProperty(BlockLiquid.LEVEL, 0), 11);
        }
        return 1000;
    }

    @Override
    @Nullable
    public FluidStack drain(FluidStack resource, boolean doDrain) {
        FluidStack containedStack;
        if (resource == null || resource.amount < 1000) {
            return null;
        }
        IBlockState blockState = this.world.getBlockState(this.blockPos);
        if (blockState.getBlock() == this.blockLiquid && blockState.getValue(BlockLiquid.LEVEL) == 0 && (containedStack = this.getStack(blockState)) != null && resource.containsFluid(containedStack)) {
            if (doDrain) {
                this.world.setBlockState(this.blockPos, Blocks.AIR.getDefaultState(), 11);
            }
            return containedStack;
        }
        return null;
    }

    @Override
    @Nullable
    public FluidStack drain(int maxDrain, boolean doDrain) {
        FluidStack containedStack;
        if (maxDrain < 1000) {
            return null;
        }
        IBlockState blockState = this.world.getBlockState(this.blockPos);
        if (blockState.getBlock() == this.blockLiquid && (containedStack = this.getStack(blockState)) != null && containedStack.amount <= maxDrain) {
            if (doDrain) {
                this.world.setBlockState(this.blockPos, Blocks.AIR.getDefaultState(), 11);
            }
            return containedStack;
        }
        return null;
    }

    @Nullable
    private FluidStack getStack(IBlockState blockState) {
        Material material = blockState.getMaterial();
        if (material == Material.WATER && blockState.getValue(BlockLiquid.LEVEL) == 0) {
            return new FluidStack(FluidRegistry.WATER, 1000);
        }
        if (material == Material.LAVA && blockState.getValue(BlockLiquid.LEVEL) == 0) {
            return new FluidStack(FluidRegistry.LAVA, 1000);
        }
        return null;
    }
}

