/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.fml.client;

import java.awt.Desktop;
import java.io.File;
import java.io.IOException;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.GuiErrorScreen;
import net.minecraft.client.resources.I18n;
import net.minecraft.util.text.TextFormatting;
import net.minecraftforge.fml.common.FMLLog;
import net.minecraftforge.fml.common.Loader;
import net.minecraftforge.fml.common.MissingModsException;
import net.minecraftforge.fml.common.versioning.ArtifactVersion;
import net.minecraftforge.fml.common.versioning.DefaultArtifactVersion;
import org.apache.logging.log4j.Level;

public class GuiModsMissing
extends GuiErrorScreen {
    private File minecraftDir = new File(Loader.instance().getConfigDir().getParent());
    private File clientLog = new File(this.minecraftDir, "logs/fml-client-latest.log");
    private MissingModsException modsMissing;

    public GuiModsMissing(MissingModsException modsMissing) {
        super(null, null);
        this.modsMissing = modsMissing;
    }

    @Override
    public void initGui() {
        super.initGui();
        this.buttonList.clear();
        this.buttonList.add(new GuiButton(1, 50, this.height - 38, this.width / 2 - 55, 20, I18n.format("fml.button.open.mods.folder", new Object[0])));
        String openFileText = I18n.format("fml.button.open.file", this.clientLog.getName());
        this.buttonList.add(new GuiButton(2, this.width / 2 + 5, this.height - 38, this.width / 2 - 55, 20, openFileText));
    }

    @Override
    protected void actionPerformed(GuiButton button) throws IOException {
        if (button.id == 1) {
            try {
                File modsDir = new File(this.minecraftDir, "mods");
                Desktop.getDesktop().open(modsDir);
            }
            catch (Exception e) {
                FMLLog.log(Level.ERROR, e, "Problem opening mods folder", new Object[0]);
            }
        } else if (button.id == 2) {
            try {
                Desktop.getDesktop().open(this.clientLog);
            }
            catch (Exception e) {
                FMLLog.log(Level.ERROR, e, "Problem opening log file " + this.clientLog, new Object[0]);
            }
        }
    }

    @Override
    public void drawScreen(int mouseX, int mouseY, float partialTicks) {
        this.drawDefaultBackground();
        int offset = Math.max(85 - this.modsMissing.missingMods.size() * 10, 10);
        String modMissingDependenciesText = I18n.format("fml.messages.mod.missing.dependencies", (Object)((Object)TextFormatting.BOLD) + this.modsMissing.getModName() + (Object)((Object)TextFormatting.RESET));
        this.drawCenteredString(this.fontRendererObj, modMissingDependenciesText, this.width / 2, offset, 0xFFFFFF);
        String fixMissingDependenciesText = I18n.format("fml.messages.mod.missing.dependencies.fix", this.modsMissing.getModName());
        this.drawCenteredString(this.fontRendererObj, fixMissingDependenciesText, this.width / 2, offset += 10, 0xFFFFFF);
        offset += 5;
        for (ArtifactVersion v : this.modsMissing.missingMods) {
            DefaultArtifactVersion dav;
            offset += 10;
            if (v instanceof DefaultArtifactVersion && (dav = (DefaultArtifactVersion)v).getRange() != null) {
                String message = String.format((Object)((Object)TextFormatting.BOLD) + "%s " + (Object)((Object)TextFormatting.RESET) + "%s", v.getLabel(), dav.getRange().toStringFriendly());
                this.drawCenteredString(this.fontRendererObj, message, this.width / 2, offset, 0xEEEEEE);
                continue;
            }
            this.drawCenteredString(this.fontRendererObj, String.format("%s : %s", v.getLabel(), v.getRangeString()), this.width / 2, offset, 0xEEEEEE);
        }
        String seeLogText = I18n.format("fml.messages.mod.missing.dependencies.see.log", this.clientLog.getName());
        this.drawCenteredString(this.fontRendererObj, seeLogText, this.width / 2, offset += 20, 0xFFFFFF);
        for (int i = 0; i < this.buttonList.size(); ++i) {
            ((GuiButton)this.buttonList.get(i)).drawButton(this.mc, mouseX, mouseY);
        }
    }
}

