/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.fml.client;

import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.resources.I18n;
import net.minecraftforge.fml.client.FMLClientHandler;
import net.minecraftforge.fml.common.MissingModsException;
import net.minecraftforge.fml.common.versioning.ArtifactVersion;

public class GuiModsMissingForServer
extends GuiScreen {
    private MissingModsException modsMissing;

    public GuiModsMissingForServer(MissingModsException modsMissing) {
        this.modsMissing = modsMissing;
    }

    @Override
    public void initGui() {
        this.buttonList.add(new GuiButton(1, this.width / 2 - 75, this.height - 38, I18n.format("gui.done", new Object[0])));
    }

    @Override
    protected void actionPerformed(GuiButton p_73875_1_) {
        if (p_73875_1_.enabled && p_73875_1_.id == 1) {
            FMLClientHandler.instance().showGuiScreen(null);
        }
    }

    @Override
    public void drawScreen(int mouseX, int mouseY, float partialTicks) {
        this.drawDefaultBackground();
        int offset = Math.max(85 - this.modsMissing.missingMods.size() * 10, 10);
        this.drawCenteredString(this.fontRendererObj, "Forge Mod Loader could not connect to this server", this.width / 2, offset, 0xFFFFFF);
        this.drawCenteredString(this.fontRendererObj, "The mods and versions listed below could not be found", this.width / 2, offset += 10, 0xFFFFFF);
        this.drawCenteredString(this.fontRendererObj, "They are required to play on this server", this.width / 2, offset += 10, 0xFFFFFF);
        offset += 5;
        for (ArtifactVersion v : this.modsMissing.missingMods) {
            this.drawCenteredString(this.fontRendererObj, String.format("%s : %s", v.getLabel(), v.getRangeString()), this.width / 2, offset += 10, 0xEEEEEE);
        }
        super.drawScreen(mouseX, mouseY, partialTicks);
    }
}

