/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.fml.client;

import java.io.IOException;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Gui;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.ScaledResolution;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.VertexBuffer;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import org.lwjgl.input.Mouse;
import org.lwjgl.opengl.GL11;

public abstract class GuiScrollingList {
    private final Minecraft client;
    protected final int listWidth;
    protected final int listHeight;
    protected final int screenWidth;
    protected final int screenHeight;
    protected final int top;
    protected final int bottom;
    protected final int right;
    protected final int left;
    protected final int slotHeight;
    private int scrollUpActionId;
    private int scrollDownActionId;
    protected int mouseX;
    protected int mouseY;
    private float initialMouseClickY = -2.0f;
    private float scrollFactor;
    private float scrollDistance;
    protected int selectedIndex = -1;
    private long lastClickTime = 0L;
    private boolean highlightSelected = true;
    private boolean hasHeader;
    private int headerHeight;
    protected boolean captureMouse = true;

    @Deprecated
    public GuiScrollingList(Minecraft client, int width, int height, int top, int bottom, int left, int entryHeight) {
        this(client, width, height, top, bottom, left, entryHeight, width, height);
    }

    public GuiScrollingList(Minecraft client, int width, int height, int top, int bottom, int left, int entryHeight, int screenWidth, int screenHeight) {
        this.client = client;
        this.listWidth = width;
        this.listHeight = height;
        this.top = top;
        this.bottom = bottom;
        this.slotHeight = entryHeight;
        this.left = left;
        this.right = width + this.left;
        this.screenWidth = screenWidth;
        this.screenHeight = screenHeight;
    }

    @Deprecated
    public void func_27258_a(boolean p_27258_1_) {
        this.highlightSelected = p_27258_1_;
    }

    @Deprecated
    protected void func_27259_a(boolean hasFooter, int footerHeight) {
        this.setHeaderInfo(hasFooter, footerHeight);
    }

    protected void setHeaderInfo(boolean hasHeader, int headerHeight) {
        this.hasHeader = hasHeader;
        this.headerHeight = headerHeight;
        if (!hasHeader) {
            this.headerHeight = 0;
        }
    }

    protected abstract int getSize();

    protected abstract void elementClicked(int var1, boolean var2);

    protected abstract boolean isSelected(int var1);

    protected int getContentHeight() {
        return this.getSize() * this.slotHeight + this.headerHeight;
    }

    protected abstract void drawBackground();

    protected abstract void drawSlot(int var1, int var2, int var3, int var4, Tessellator var5);

    @Deprecated
    protected void func_27260_a(int entryRight, int relativeY, Tessellator tess) {
    }

    protected void drawHeader(int entryRight, int relativeY, Tessellator tess) {
        this.func_27260_a(entryRight, relativeY, tess);
    }

    @Deprecated
    protected void func_27255_a(int x, int y) {
    }

    protected void clickHeader(int x, int y) {
        this.func_27255_a(x, y);
    }

    @Deprecated
    protected void func_27257_b(int mouseX, int mouseY) {
    }

    protected void drawScreen(int mouseX, int mouseY) {
        this.func_27257_b(mouseX, mouseY);
    }

    @Deprecated
    public int func_27256_c(int x, int y) {
        int left = this.left + 1;
        int right = this.left + this.listWidth - 7;
        int relativeY = y - this.top - this.headerHeight + (int)this.scrollDistance - 4;
        int entryIndex = relativeY / this.slotHeight;
        return x >= left && x <= right && entryIndex >= 0 && relativeY >= 0 && entryIndex < this.getSize() ? entryIndex : -1;
    }

    public void registerScrollButtons(List<GuiButton> buttons, int upActionID, int downActionID) {
        this.scrollUpActionId = upActionID;
        this.scrollDownActionId = downActionID;
    }

    private void applyScrollLimits() {
        int listHeight = this.getContentHeight() - (this.bottom - this.top - 4);
        if (listHeight < 0) {
            listHeight /= 2;
        }
        if (this.scrollDistance < 0.0f) {
            this.scrollDistance = 0.0f;
        }
        if (this.scrollDistance > (float)listHeight) {
            this.scrollDistance = listHeight;
        }
    }

    public void actionPerformed(GuiButton button) {
        if (button.enabled) {
            if (button.id == this.scrollUpActionId) {
                this.scrollDistance -= (float)(this.slotHeight * 2 / 3);
                this.initialMouseClickY = -2.0f;
                this.applyScrollLimits();
            } else if (button.id == this.scrollDownActionId) {
                this.scrollDistance += (float)(this.slotHeight * 2 / 3);
                this.initialMouseClickY = -2.0f;
                this.applyScrollLimits();
            }
        }
    }

    public void handleMouseInput(int mouseX, int mouseY) throws IOException {
        boolean isHovering;
        boolean bl = isHovering = mouseX >= this.left && mouseX <= this.left + this.listWidth && mouseY >= this.top && mouseY <= this.bottom;
        if (!isHovering) {
            return;
        }
        int scroll = Mouse.getEventDWheel();
        if (scroll != 0) {
            this.scrollDistance += (float)(-1 * scroll) / 120.0f * (float)this.slotHeight / 2.0f;
        }
    }

    public void drawScreen(int mouseX, int mouseY, float partialTicks) {
        this.mouseX = mouseX;
        this.mouseY = mouseY;
        this.drawBackground();
        boolean isHovering = mouseX >= this.left && mouseX <= this.left + this.listWidth && mouseY >= this.top && mouseY <= this.bottom;
        int listLength = this.getSize();
        int scrollBarWidth = 6;
        int scrollBarRight = this.left + this.listWidth;
        int scrollBarLeft = scrollBarRight - scrollBarWidth;
        int entryLeft = this.left;
        int entryRight = scrollBarLeft - 1;
        int viewHeight = this.bottom - this.top;
        int border = 4;
        if (Mouse.isButtonDown((int)0)) {
            if (this.initialMouseClickY == -1.0f) {
                if (isHovering) {
                    int mouseListY = mouseY - this.top - this.headerHeight + (int)this.scrollDistance - border;
                    int slotIndex = mouseListY / this.slotHeight;
                    if (mouseX >= entryLeft && mouseX <= entryRight && slotIndex >= 0 && mouseListY >= 0 && slotIndex < listLength) {
                        this.elementClicked(slotIndex, slotIndex == this.selectedIndex && System.currentTimeMillis() - this.lastClickTime < 250L);
                        this.selectedIndex = slotIndex;
                        this.lastClickTime = System.currentTimeMillis();
                    } else if (mouseX >= entryLeft && mouseX <= entryRight && mouseListY < 0) {
                        this.clickHeader(mouseX - entryLeft, mouseY - this.top + (int)this.scrollDistance - border);
                    }
                    if (mouseX >= scrollBarLeft && mouseX <= scrollBarRight) {
                        int var13;
                        this.scrollFactor = -1.0f;
                        int scrollHeight = this.getContentHeight() - viewHeight - border;
                        if (scrollHeight < 1) {
                            scrollHeight = 1;
                        }
                        if ((var13 = (int)((float)(viewHeight * viewHeight) / (float)this.getContentHeight())) < 32) {
                            var13 = 32;
                        }
                        if (var13 > viewHeight - border * 2) {
                            var13 = viewHeight - border * 2;
                        }
                        this.scrollFactor /= (float)(viewHeight - var13) / (float)scrollHeight;
                    } else {
                        this.scrollFactor = 1.0f;
                    }
                    this.initialMouseClickY = mouseY;
                } else {
                    this.initialMouseClickY = -2.0f;
                }
            } else if (this.initialMouseClickY >= 0.0f) {
                this.scrollDistance -= ((float)mouseY - this.initialMouseClickY) * this.scrollFactor;
                this.initialMouseClickY = mouseY;
            }
        } else {
            this.initialMouseClickY = -1.0f;
        }
        this.applyScrollLimits();
        Tessellator tess = Tessellator.getInstance();
        VertexBuffer worldr = tess.getBuffer();
        ScaledResolution res = new ScaledResolution(this.client);
        double scaleW = (double)this.client.displayWidth / res.getScaledWidth_double();
        double scaleH = (double)this.client.displayHeight / res.getScaledHeight_double();
        GL11.glEnable((int)3089);
        GL11.glScissor((int)((int)((double)this.left * scaleW)), (int)((int)((double)this.client.displayHeight - (double)this.bottom * scaleH)), (int)((int)((double)this.listWidth * scaleW)), (int)((int)((double)viewHeight * scaleH)));
        if (this.client.world != null) {
            this.drawGradientRect(this.left, this.top, this.right, this.bottom, -1072689136, -804253680);
        } else {
            GlStateManager.disableLighting();
            GlStateManager.disableFog();
            this.client.renderEngine.bindTexture(Gui.OPTIONS_BACKGROUND);
            GlStateManager.color(1.0f, 1.0f, 1.0f, 1.0f);
            float scale = 32.0f;
            worldr.begin(7, DefaultVertexFormats.POSITION_TEX_COLOR);
            worldr.pos(this.left, this.bottom, 0.0).tex((float)this.left / scale, (float)(this.bottom + (int)this.scrollDistance) / scale).color(32, 32, 32, 255).endVertex();
            worldr.pos(this.right, this.bottom, 0.0).tex((float)this.right / scale, (float)(this.bottom + (int)this.scrollDistance) / scale).color(32, 32, 32, 255).endVertex();
            worldr.pos(this.right, this.top, 0.0).tex((float)this.right / scale, (float)(this.top + (int)this.scrollDistance) / scale).color(32, 32, 32, 255).endVertex();
            worldr.pos(this.left, this.top, 0.0).tex((float)this.left / scale, (float)(this.top + (int)this.scrollDistance) / scale).color(32, 32, 32, 255).endVertex();
            tess.draw();
        }
        int baseY = this.top + border - (int)this.scrollDistance;
        if (this.hasHeader) {
            this.drawHeader(entryRight, baseY, tess);
        }
        for (int slotIdx = 0; slotIdx < listLength; ++slotIdx) {
            int slotTop = baseY + slotIdx * this.slotHeight + this.headerHeight;
            int slotBuffer = this.slotHeight - border;
            if (slotTop > this.bottom || slotTop + slotBuffer < this.top) continue;
            if (this.highlightSelected && this.isSelected(slotIdx)) {
                int min = this.left;
                int max = entryRight;
                GlStateManager.color(1.0f, 1.0f, 1.0f, 1.0f);
                GlStateManager.disableTexture2D();
                worldr.begin(7, DefaultVertexFormats.POSITION_TEX_COLOR);
                worldr.pos(min, slotTop + slotBuffer + 2, 0.0).tex(0.0, 1.0).color(128, 128, 128, 255).endVertex();
                worldr.pos(max, slotTop + slotBuffer + 2, 0.0).tex(1.0, 1.0).color(128, 128, 128, 255).endVertex();
                worldr.pos(max, slotTop - 2, 0.0).tex(1.0, 0.0).color(128, 128, 128, 255).endVertex();
                worldr.pos(min, slotTop - 2, 0.0).tex(0.0, 0.0).color(128, 128, 128, 255).endVertex();
                worldr.pos(min + 1, slotTop + slotBuffer + 1, 0.0).tex(0.0, 1.0).color(0, 0, 0, 255).endVertex();
                worldr.pos(max - 1, slotTop + slotBuffer + 1, 0.0).tex(1.0, 1.0).color(0, 0, 0, 255).endVertex();
                worldr.pos(max - 1, slotTop - 1, 0.0).tex(1.0, 0.0).color(0, 0, 0, 255).endVertex();
                worldr.pos(min + 1, slotTop - 1, 0.0).tex(0.0, 0.0).color(0, 0, 0, 255).endVertex();
                tess.draw();
                GlStateManager.enableTexture2D();
            }
            this.drawSlot(slotIdx, entryRight, slotTop, slotBuffer, tess);
        }
        GlStateManager.disableDepth();
        int extraHeight = this.getContentHeight() + border - viewHeight;
        if (extraHeight > 0) {
            int barTop;
            int height = viewHeight * viewHeight / this.getContentHeight();
            if (height < 32) {
                height = 32;
            }
            if (height > viewHeight - border * 2) {
                height = viewHeight - border * 2;
            }
            if ((barTop = (int)this.scrollDistance * (viewHeight - height) / extraHeight + this.top) < this.top) {
                barTop = this.top;
            }
            GlStateManager.disableTexture2D();
            worldr.begin(7, DefaultVertexFormats.POSITION_TEX_COLOR);
            worldr.pos(scrollBarLeft, this.bottom, 0.0).tex(0.0, 1.0).color(0, 0, 0, 255).endVertex();
            worldr.pos(scrollBarRight, this.bottom, 0.0).tex(1.0, 1.0).color(0, 0, 0, 255).endVertex();
            worldr.pos(scrollBarRight, this.top, 0.0).tex(1.0, 0.0).color(0, 0, 0, 255).endVertex();
            worldr.pos(scrollBarLeft, this.top, 0.0).tex(0.0, 0.0).color(0, 0, 0, 255).endVertex();
            tess.draw();
            worldr.begin(7, DefaultVertexFormats.POSITION_TEX_COLOR);
            worldr.pos(scrollBarLeft, barTop + height, 0.0).tex(0.0, 1.0).color(128, 128, 128, 255).endVertex();
            worldr.pos(scrollBarRight, barTop + height, 0.0).tex(1.0, 1.0).color(128, 128, 128, 255).endVertex();
            worldr.pos(scrollBarRight, barTop, 0.0).tex(1.0, 0.0).color(128, 128, 128, 255).endVertex();
            worldr.pos(scrollBarLeft, barTop, 0.0).tex(0.0, 0.0).color(128, 128, 128, 255).endVertex();
            tess.draw();
            worldr.begin(7, DefaultVertexFormats.POSITION_TEX_COLOR);
            worldr.pos(scrollBarLeft, barTop + height - 1, 0.0).tex(0.0, 1.0).color(192, 192, 192, 255).endVertex();
            worldr.pos(scrollBarRight - 1, barTop + height - 1, 0.0).tex(1.0, 1.0).color(192, 192, 192, 255).endVertex();
            worldr.pos(scrollBarRight - 1, barTop, 0.0).tex(1.0, 0.0).color(192, 192, 192, 255).endVertex();
            worldr.pos(scrollBarLeft, barTop, 0.0).tex(0.0, 0.0).color(192, 192, 192, 255).endVertex();
            tess.draw();
        }
        this.drawScreen(mouseX, mouseY);
        GlStateManager.enableTexture2D();
        GlStateManager.shadeModel(7424);
        GlStateManager.enableAlpha();
        GlStateManager.disableBlend();
        GL11.glDisable((int)3089);
    }

    protected void drawGradientRect(int left, int top, int right, int bottom, int color1, int color2) {
        float a1 = (float)(color1 >> 24 & 0xFF) / 255.0f;
        float r1 = (float)(color1 >> 16 & 0xFF) / 255.0f;
        float g1 = (float)(color1 >> 8 & 0xFF) / 255.0f;
        float b1 = (float)(color1 & 0xFF) / 255.0f;
        float a2 = (float)(color2 >> 24 & 0xFF) / 255.0f;
        float r2 = (float)(color2 >> 16 & 0xFF) / 255.0f;
        float g2 = (float)(color2 >> 8 & 0xFF) / 255.0f;
        float b2 = (float)(color2 & 0xFF) / 255.0f;
        GlStateManager.disableTexture2D();
        GlStateManager.enableBlend();
        GlStateManager.disableAlpha();
        GlStateManager.tryBlendFuncSeparate(770, 771, 1, 0);
        GlStateManager.shadeModel(7425);
        Tessellator tessellator = Tessellator.getInstance();
        VertexBuffer VertexBuffer2 = tessellator.getBuffer();
        VertexBuffer2.begin(7, DefaultVertexFormats.POSITION_COLOR);
        VertexBuffer2.pos(right, top, 0.0).color(r1, g1, b1, a1).endVertex();
        VertexBuffer2.pos(left, top, 0.0).color(r1, g1, b1, a1).endVertex();
        VertexBuffer2.pos(left, bottom, 0.0).color(r2, g2, b2, a2).endVertex();
        VertexBuffer2.pos(right, bottom, 0.0).color(r2, g2, b2, a2).endVertex();
        tessellator.draw();
        GlStateManager.shadeModel(7424);
        GlStateManager.disableBlend();
        GlStateManager.enableAlpha();
        GlStateManager.enableTexture2D();
    }
}

