/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.fml.client;

import java.util.ArrayList;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.Gui;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.StringUtils;
import net.minecraftforge.common.ForgeVersion;
import net.minecraftforge.fml.client.GuiModList;
import net.minecraftforge.fml.client.GuiScrollingList;
import net.minecraftforge.fml.common.Loader;
import net.minecraftforge.fml.common.LoaderState;
import net.minecraftforge.fml.common.ModContainer;

public class GuiSlotModList
extends GuiScrollingList {
    private static final ResourceLocation VERSION_CHECK_ICONS = new ResourceLocation("forge", "textures/gui/version_check_icons.png");
    private GuiModList parent;
    private ArrayList<ModContainer> mods;

    public GuiSlotModList(GuiModList parent, ArrayList<ModContainer> mods, int listWidth, int slotHeight) {
        super(parent.getMinecraftInstance(), listWidth, parent.height, 32, parent.height - 88 + 4, 10, slotHeight, parent.width, parent.height);
        this.parent = parent;
        this.mods = mods;
    }

    @Override
    protected int getSize() {
        return this.mods.size();
    }

    @Override
    protected void elementClicked(int index, boolean doubleClick) {
        this.parent.selectModIndex(index);
    }

    @Override
    protected boolean isSelected(int index) {
        return this.parent.modIndexSelected(index);
    }

    @Override
    protected void drawBackground() {
        this.parent.drawDefaultBackground();
    }

    @Override
    protected int getContentHeight() {
        return this.getSize() * 35 + 1;
    }

    ArrayList<ModContainer> getMods() {
        return this.mods;
    }

    @Override
    protected void drawSlot(int idx, int right, int top, int height, Tessellator tess) {
        ModContainer mc = this.mods.get(idx);
        String name = StringUtils.stripControlCodes(mc.getName());
        String version = StringUtils.stripControlCodes(mc.getDisplayVersion());
        FontRenderer font = this.parent.getFontRenderer();
        ForgeVersion.CheckResult vercheck = ForgeVersion.getResult(mc);
        if (Loader.instance().getModState(mc) == LoaderState.ModState.DISABLED) {
            font.drawString(font.trimStringToWidth(name, this.listWidth - 10), this.left + 3, top + 2, 0xFF2222);
            font.drawString(font.trimStringToWidth(version, this.listWidth - (5 + height)), this.left + 3, top + 12, 0xFF2222);
            font.drawString(font.trimStringToWidth("DISABLED", this.listWidth - 10), this.left + 3, top + 22, 0xFF2222);
        } else {
            font.drawString(font.trimStringToWidth(name, this.listWidth - 10), this.left + 3, top + 2, 0xFFFFFF);
            font.drawString(font.trimStringToWidth(version, this.listWidth - (5 + height)), this.left + 3, top + 12, 0xCCCCCC);
            font.drawString(font.trimStringToWidth(mc.getMetadata() != null ? mc.getMetadata().getChildModCountString() : "Metadata not found", this.listWidth - 10), this.left + 3, top + 22, 0xCCCCCC);
            if (vercheck.status.shouldDraw()) {
                Minecraft.getMinecraft().getTextureManager().bindTexture(VERSION_CHECK_ICONS);
                GlStateManager.color(1.0f, 1.0f, 1.0f, 1.0f);
                GlStateManager.pushMatrix();
                Gui.drawModalRectWithCustomSizedTexture(right - (height / 2 + 4), top + (height / 2 - 4), vercheck.status.getSheetOffset() * 8, vercheck.status.isAnimated() && (System.currentTimeMillis() / 800L & 1L) == 1L ? 8.0f : 0.0f, 8, 8, 64.0f, 16.0f);
                GlStateManager.popMatrix();
            }
        }
    }
}

