/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.fml.client.config;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiListExtended;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.gui.GuiTextField;
import net.minecraft.client.resources.I18n;
import net.minecraft.util.text.TextFormatting;
import net.minecraftforge.fml.client.config.ConfigGuiType;
import net.minecraftforge.fml.client.config.GuiButtonExt;
import net.minecraftforge.fml.client.config.GuiConfig;
import net.minecraftforge.fml.client.config.GuiEditArray;
import net.minecraftforge.fml.client.config.GuiSelectString;
import net.minecraftforge.fml.client.config.GuiSlider;
import net.minecraftforge.fml.client.config.GuiUtils;
import net.minecraftforge.fml.client.config.HoverChecker;
import net.minecraftforge.fml.client.config.IConfigElement;
import net.minecraftforge.fml.common.FMLLog;
import net.minecraftforge.fml.common.Loader;
import net.minecraftforge.fml.common.ModContainer;

public class GuiConfigEntries
extends GuiListExtended {
    public final GuiConfig owningScreen;
    public final Minecraft mc;
    public List<IConfigEntry> listEntries;
    public int maxLabelTextWidth = 0;
    public int maxEntryRightBound = 0;
    public int labelX;
    public int controlX;
    public int controlWidth;
    public int resetX;
    public int scrollBarX;

    public GuiConfigEntries(GuiConfig parent, Minecraft mc) {
        super(mc, parent.width, parent.height, parent.titleLine2 != null ? 33 : 23, parent.height - 32, 20);
        this.owningScreen = parent;
        this.setShowSelectionBox(false);
        this.mc = mc;
        this.listEntries = new ArrayList<IConfigEntry>();
        for (IConfigElement configElement : parent.configElements) {
            int length;
            if (configElement == null || !configElement.isProperty() || !configElement.showInGui() || (length = !I18n.format(configElement.getLanguageKey(), new Object[0]).equals(configElement.getLanguageKey()) ? mc.fontRendererObj.getStringWidth(I18n.format(configElement.getLanguageKey(), new Object[0])) : mc.fontRendererObj.getStringWidth(configElement.getName())) <= this.maxLabelTextWidth) continue;
            this.maxLabelTextWidth = length;
        }
        int viewWidth = this.maxLabelTextWidth + 8 + this.width / 2;
        this.labelX = this.width / 2 - viewWidth / 2;
        this.controlX = this.labelX + this.maxLabelTextWidth + 8;
        this.resetX = this.width / 2 + viewWidth / 2 - 45;
        this.controlWidth = this.resetX - this.controlX - 5;
        this.scrollBarX = this.width;
        for (IConfigElement configElement : parent.configElements) {
            if (configElement == null || !configElement.showInGui()) continue;
            if (configElement.getConfigEntryClass() != null) {
                try {
                    this.listEntries.add(configElement.getConfigEntryClass().getConstructor(GuiConfig.class, GuiConfigEntries.class, IConfigElement.class).newInstance(this.owningScreen, this, configElement));
                }
                catch (Throwable e) {
                    FMLLog.severe("There was a critical error instantiating the custom IConfigEntry for config element %s.", configElement.getName());
                    e.printStackTrace();
                }
                continue;
            }
            if (configElement.isProperty()) {
                if (configElement.isList()) {
                    this.listEntries.add(new ArrayEntry(this.owningScreen, this, configElement));
                    continue;
                }
                if (configElement.getType() == ConfigGuiType.BOOLEAN) {
                    this.listEntries.add(new BooleanEntry(this.owningScreen, this, configElement));
                    continue;
                }
                if (configElement.getType() == ConfigGuiType.INTEGER) {
                    this.listEntries.add(new IntegerEntry(this.owningScreen, this, configElement));
                    continue;
                }
                if (configElement.getType() == ConfigGuiType.DOUBLE) {
                    this.listEntries.add(new DoubleEntry(this.owningScreen, this, configElement));
                    continue;
                }
                if (configElement.getType() == ConfigGuiType.COLOR) {
                    if (configElement.getValidValues() != null && configElement.getValidValues().length > 0) {
                        this.listEntries.add(new ChatColorEntry(this.owningScreen, this, configElement));
                        continue;
                    }
                    this.listEntries.add(new StringEntry(this.owningScreen, this, configElement));
                    continue;
                }
                if (configElement.getType() == ConfigGuiType.MOD_ID) {
                    TreeMap<Object, String> values = new TreeMap<Object, String>();
                    for (ModContainer mod : Loader.instance().getActiveModList()) {
                        values.put(mod.getModId(), mod.getName());
                    }
                    values.put("minecraft", "Minecraft");
                    this.listEntries.add(new SelectValueEntry(this.owningScreen, this, configElement, values));
                    continue;
                }
                if (configElement.getType() != ConfigGuiType.STRING) continue;
                if (configElement.getValidValues() != null && configElement.getValidValues().length > 0) {
                    this.listEntries.add(new CycleValueEntry(this.owningScreen, this, configElement));
                    continue;
                }
                this.listEntries.add(new StringEntry(this.owningScreen, this, configElement));
                continue;
            }
            if (configElement.getType() != ConfigGuiType.CONFIG_CATEGORY) continue;
            this.listEntries.add(new CategoryEntry(this.owningScreen, this, configElement));
        }
    }

    protected void initGui() {
        this.width = this.owningScreen.width;
        this.height = this.owningScreen.height;
        this.maxLabelTextWidth = 0;
        for (IConfigEntry entry : this.listEntries) {
            if (entry.getLabelWidth() <= this.maxLabelTextWidth) continue;
            this.maxLabelTextWidth = entry.getLabelWidth();
        }
        this.top = this.owningScreen.titleLine2 != null ? 33 : 23;
        this.bottom = this.owningScreen.height - 32;
        this.left = 0;
        this.right = this.width;
        int viewWidth = this.maxLabelTextWidth + 8 + this.width / 2;
        this.labelX = this.width / 2 - viewWidth / 2;
        this.controlX = this.labelX + this.maxLabelTextWidth + 8;
        this.resetX = this.width / 2 + viewWidth / 2 - 45;
        this.maxEntryRightBound = 0;
        for (IConfigEntry entry : this.listEntries) {
            if (entry.getEntryRightBound() <= this.maxEntryRightBound) continue;
            this.maxEntryRightBound = entry.getEntryRightBound();
        }
        this.scrollBarX = this.maxEntryRightBound + 5;
        this.controlWidth = this.maxEntryRightBound - this.controlX - 45;
    }

    @Override
    public int getSize() {
        return this.listEntries.size();
    }

    @Override
    public IConfigEntry getListEntry(int index) {
        return this.listEntries.get(index);
    }

    @Override
    public int getScrollBarX() {
        return this.scrollBarX;
    }

    @Override
    public int getListWidth() {
        return this.owningScreen.width;
    }

    public void keyTyped(char eventChar, int eventKey) {
        for (IConfigEntry entry : this.listEntries) {
            entry.keyTyped(eventChar, eventKey);
        }
    }

    public void updateScreen() {
        for (IConfigEntry entry : this.listEntries) {
            entry.updateCursorCounter();
        }
    }

    public void mouseClickedPassThru(int mouseX, int mouseY, int mouseEvent) {
        for (IConfigEntry entry : this.listEntries) {
            entry.mouseClicked(mouseX, mouseY, mouseEvent);
        }
    }

    public void onGuiClosed() {
        for (IConfigEntry entry : this.listEntries) {
            entry.onGuiClosed();
        }
    }

    public boolean saveConfigElements() {
        boolean requiresRestart = false;
        for (IConfigEntry entry : this.listEntries) {
            if (!entry.saveConfigElement()) continue;
            requiresRestart = true;
        }
        return requiresRestart;
    }

    public boolean areAllEntriesDefault(boolean includeChildren) {
        for (IConfigEntry entry : this.listEntries) {
            if (!includeChildren && entry instanceof CategoryEntry || entry.isDefault()) continue;
            return false;
        }
        return true;
    }

    public void setAllToDefault(boolean includeChildren) {
        for (IConfigEntry entry : this.listEntries) {
            if (!includeChildren && entry instanceof CategoryEntry) continue;
            entry.setToDefault();
        }
    }

    public boolean hasChangedEntry(boolean includeChildren) {
        for (IConfigEntry entry : this.listEntries) {
            if (!includeChildren && entry instanceof CategoryEntry || !entry.isChanged()) continue;
            return true;
        }
        return false;
    }

    public boolean areAnyEntriesEnabled(boolean includeChildren) {
        for (IConfigEntry entry : this.listEntries) {
            if (!includeChildren && entry instanceof CategoryEntry || !entry.enabled()) continue;
            return true;
        }
        return false;
    }

    public void undoAllChanges(boolean includeChildren) {
        for (IConfigEntry entry : this.listEntries) {
            if (!includeChildren && entry instanceof CategoryEntry) continue;
            entry.undoChanges();
        }
    }

    public void drawScreenPost(int mouseX, int mouseY, float partialTicks) {
        for (IConfigEntry entry : this.listEntries) {
            entry.drawToolTip(mouseX, mouseY);
        }
    }

    public static interface IConfigEntry
    extends GuiListExtended.IGuiListEntry {
        public IConfigElement getConfigElement();

        public String getName();

        public Object getCurrentValue();

        public Object[] getCurrentValues();

        public boolean enabled();

        public void keyTyped(char var1, int var2);

        public void updateCursorCounter();

        public void mouseClicked(int var1, int var2, int var3);

        public boolean isDefault();

        public void setToDefault();

        public void undoChanges();

        public boolean isChanged();

        public boolean saveConfigElement();

        public void drawToolTip(int var1, int var2);

        public int getLabelWidth();

        public int getEntryRightBound();

        public void onGuiClosed();
    }

    public static abstract class ListEntryBase
    implements IConfigEntry {
        protected final GuiConfig owningScreen;
        protected final GuiConfigEntries owningEntryList;
        protected final IConfigElement configElement;
        protected final Minecraft mc;
        protected final String name;
        protected final GuiButtonExt btnUndoChanges;
        protected final GuiButtonExt btnDefault;
        protected List<String> toolTip;
        protected List<String> undoToolTip;
        protected List<String> defaultToolTip;
        protected boolean isValidValue = true;
        protected HoverChecker tooltipHoverChecker;
        protected HoverChecker undoHoverChecker;
        protected HoverChecker defaultHoverChecker;
        protected boolean drawLabel;

        public ListEntryBase(GuiConfig owningScreen, GuiConfigEntries owningEntryList, IConfigElement configElement) {
            this.owningScreen = owningScreen;
            this.owningEntryList = owningEntryList;
            this.configElement = configElement;
            this.mc = Minecraft.getMinecraft();
            String trans = I18n.format(configElement.getLanguageKey(), new Object[0]);
            this.name = !trans.equals(configElement.getLanguageKey()) ? trans : configElement.getName();
            this.btnUndoChanges = new GuiButtonExt(0, 0, 0, 18, 18, "\u21b6");
            this.btnDefault = new GuiButtonExt(0, 0, 0, 18, 18, "\u2604");
            this.undoHoverChecker = new HoverChecker(this.btnUndoChanges, 800);
            this.defaultHoverChecker = new HoverChecker(this.btnDefault, 800);
            this.undoToolTip = Arrays.asList(I18n.format("fml.configgui.tooltip.undoChanges", new Object[0]));
            this.defaultToolTip = Arrays.asList(I18n.format("fml.configgui.tooltip.resetToDefault", new Object[0]));
            this.toolTip = new ArrayList<String>();
            this.drawLabel = true;
            String comment = I18n.format(configElement.getLanguageKey() + ".tooltip", new Object[0]).replace("\\n", "\n");
            if (!comment.equals(configElement.getLanguageKey() + ".tooltip")) {
                Collections.addAll(this.toolTip, ((Object)((Object)TextFormatting.GREEN) + this.name + "\n" + (Object)((Object)TextFormatting.YELLOW) + this.removeTag(comment, "[default:", "]")).split("\n"));
            } else if (configElement.getComment() != null && !configElement.getComment().trim().isEmpty()) {
                Collections.addAll(this.toolTip, ((Object)((Object)TextFormatting.GREEN) + this.name + "\n" + (Object)((Object)TextFormatting.YELLOW) + this.removeTag(configElement.getComment(), "[default:", "]")).split("\n"));
            } else {
                Collections.addAll(this.toolTip, ((Object)((Object)TextFormatting.GREEN) + this.name + "\n" + (Object)((Object)TextFormatting.RED) + "No tooltip defined.").split("\n"));
            }
            if (configElement.getType() == ConfigGuiType.INTEGER && (Integer.valueOf(configElement.getMinValue().toString()) != Integer.MIN_VALUE || Integer.valueOf(configElement.getMaxValue().toString()) != Integer.MAX_VALUE) || configElement.getType() == ConfigGuiType.DOUBLE && (Double.valueOf(configElement.getMinValue().toString()) != -1.7976931348623157E308 || Double.valueOf(configElement.getMaxValue().toString()) != Double.MAX_VALUE)) {
                Collections.addAll(this.toolTip, ((Object)((Object)TextFormatting.AQUA) + I18n.format("fml.configgui.tooltip.defaultNumeric", configElement.getMinValue(), configElement.getMaxValue(), configElement.getDefault())).split("\n"));
            } else if (configElement.getType() != ConfigGuiType.CONFIG_CATEGORY) {
                Collections.addAll(this.toolTip, ((Object)((Object)TextFormatting.AQUA) + I18n.format("fml.configgui.tooltip.default", configElement.getDefault())).split("\n"));
            }
            if (configElement.requiresMcRestart() || owningScreen.allRequireMcRestart) {
                this.toolTip.add((Object)((Object)TextFormatting.RED) + "[" + I18n.format("fml.configgui.gameRestartTitle", new Object[0]) + "]");
            }
        }

        @Override
        public void drawEntry(int slotIndex, int x, int y, int listWidth, int slotHeight, int mouseX, int mouseY, boolean isSelected) {
            boolean isChanged = this.isChanged();
            if (this.drawLabel) {
                String label = (!this.isValidValue ? TextFormatting.RED.toString() : (isChanged ? TextFormatting.WHITE.toString() : TextFormatting.GRAY.toString())) + (isChanged ? TextFormatting.ITALIC.toString() : "") + this.name;
                this.mc.fontRendererObj.drawString(label, this.owningScreen.entryList.labelX, y + slotHeight / 2 - this.mc.fontRendererObj.FONT_HEIGHT / 2, 0xFFFFFF);
            }
            this.btnUndoChanges.xPosition = this.owningEntryList.scrollBarX - 44;
            this.btnUndoChanges.yPosition = y;
            this.btnUndoChanges.enabled = this.enabled() && isChanged;
            this.btnUndoChanges.drawButton(this.mc, mouseX, mouseY);
            this.btnDefault.xPosition = this.owningEntryList.scrollBarX - 22;
            this.btnDefault.yPosition = y;
            this.btnDefault.enabled = this.enabled() && !this.isDefault();
            this.btnDefault.drawButton(this.mc, mouseX, mouseY);
            if (this.tooltipHoverChecker == null) {
                this.tooltipHoverChecker = new HoverChecker(y, y + slotHeight, x, this.owningScreen.entryList.controlX - 8, 800);
            } else {
                this.tooltipHoverChecker.updateBounds(y, y + slotHeight, x, this.owningScreen.entryList.controlX - 8);
            }
        }

        @Override
        public void drawToolTip(int mouseX, int mouseY) {
            boolean canHover;
            boolean bl = canHover = mouseY < this.owningScreen.entryList.bottom && mouseY > this.owningScreen.entryList.top;
            if (this.toolTip != null && this.tooltipHoverChecker != null && this.tooltipHoverChecker.checkHover(mouseX, mouseY, canHover)) {
                this.owningScreen.drawToolTip(this.toolTip, mouseX, mouseY);
            }
            if (this.undoHoverChecker.checkHover(mouseX, mouseY, canHover)) {
                this.owningScreen.drawToolTip(this.undoToolTip, mouseX, mouseY);
            }
            if (this.defaultHoverChecker.checkHover(mouseX, mouseY, canHover)) {
                this.owningScreen.drawToolTip(this.defaultToolTip, mouseX, mouseY);
            }
        }

        @Override
        public boolean mousePressed(int index, int x, int y, int mouseEvent, int relativeX, int relativeY) {
            if (this.btnDefault.mousePressed(this.mc, x, y)) {
                this.btnDefault.playPressSound(this.mc.getSoundHandler());
                this.setToDefault();
                return true;
            }
            if (this.btnUndoChanges.mousePressed(this.mc, x, y)) {
                this.btnUndoChanges.playPressSound(this.mc.getSoundHandler());
                this.undoChanges();
                return true;
            }
            return false;
        }

        @Override
        public void mouseReleased(int index, int x, int y, int mouseEvent, int relativeX, int relativeY) {
            this.btnDefault.mouseReleased(x, y);
        }

        @Override
        public abstract boolean isDefault();

        @Override
        public abstract void setToDefault();

        @Override
        public abstract void keyTyped(char var1, int var2);

        @Override
        public abstract void updateCursorCounter();

        @Override
        public abstract void mouseClicked(int var1, int var2, int var3);

        @Override
        public abstract boolean isChanged();

        @Override
        public abstract void undoChanges();

        @Override
        public abstract boolean saveConfigElement();

        @Override
        public void setSelected(int p_178011_1_, int p_178011_2_, int p_178011_3_) {
        }

        @Override
        public boolean enabled() {
            return this.owningScreen.isWorldRunning ? !this.owningScreen.allRequireWorldRestart && !this.configElement.requiresWorldRestart() : true;
        }

        @Override
        public int getLabelWidth() {
            return this.mc.fontRendererObj.getStringWidth(this.name);
        }

        @Override
        public int getEntryRightBound() {
            return this.owningEntryList.resetX + 40;
        }

        @Override
        public IConfigElement getConfigElement() {
            return this.configElement;
        }

        @Override
        public String getName() {
            return this.configElement.getName();
        }

        @Override
        public abstract Object getCurrentValue();

        @Override
        public abstract Object[] getCurrentValues();

        @Override
        public void onGuiClosed() {
        }

        private String removeTag(String target, String tagStart, String tagEnd) {
            int tagStartPosition = target.indexOf(tagStart);
            int tagEndPosition = target.indexOf(tagEnd, tagStartPosition + tagStart.length());
            if (-1 == tagStartPosition || -1 == tagEndPosition) {
                return target;
            }
            String taglessResult = target.substring(0, tagStartPosition);
            taglessResult = taglessResult + target.substring(tagEndPosition + 1, target.length());
            return taglessResult;
        }
    }

    public static class CategoryEntry
    extends ListEntryBase {
        protected GuiScreen childScreen = this.buildChildScreen();
        protected final GuiButtonExt btnSelectCategory = new GuiButtonExt(0, 0, 0, 300, 18, I18n.format(this.name, new Object[0]));

        public CategoryEntry(GuiConfig owningScreen, GuiConfigEntries owningEntryList, IConfigElement configElement) {
            super(owningScreen, owningEntryList, configElement);
            this.tooltipHoverChecker = new HoverChecker(this.btnSelectCategory, 800);
            this.drawLabel = false;
        }

        protected GuiScreen buildChildScreen() {
            return new GuiConfig((GuiScreen)this.owningScreen, this.configElement.getChildElements(), this.owningScreen.modID, this.owningScreen.allRequireWorldRestart || this.configElement.requiresWorldRestart(), this.owningScreen.allRequireMcRestart || this.configElement.requiresMcRestart(), this.owningScreen.title, (this.owningScreen.titleLine2 == null ? "" : this.owningScreen.titleLine2) + " > " + this.name);
        }

        @Override
        public void drawEntry(int slotIndex, int x, int y, int listWidth, int slotHeight, int mouseX, int mouseY, boolean isSelected) {
            this.btnSelectCategory.xPosition = listWidth / 2 - 150;
            this.btnSelectCategory.yPosition = y;
            this.btnSelectCategory.enabled = this.enabled();
            this.btnSelectCategory.drawButton(this.mc, mouseX, mouseY);
            super.drawEntry(slotIndex, x, y, listWidth, slotHeight, mouseX, mouseY, isSelected);
        }

        @Override
        public void drawToolTip(int mouseX, int mouseY) {
            boolean canHover;
            boolean bl = canHover = mouseY < this.owningScreen.entryList.bottom && mouseY > this.owningScreen.entryList.top;
            if (this.tooltipHoverChecker.checkHover(mouseX, mouseY, canHover)) {
                this.owningScreen.drawToolTip(this.toolTip, mouseX, mouseY);
            }
            super.drawToolTip(mouseX, mouseY);
        }

        @Override
        public boolean mousePressed(int index, int x, int y, int mouseEvent, int relativeX, int relativeY) {
            if (this.btnSelectCategory.mousePressed(this.mc, x, y)) {
                this.btnSelectCategory.playPressSound(this.mc.getSoundHandler());
                Minecraft.getMinecraft().displayGuiScreen(this.childScreen);
                return true;
            }
            return super.mousePressed(index, x, y, mouseEvent, relativeX, relativeY);
        }

        @Override
        public void mouseReleased(int index, int x, int y, int mouseEvent, int relativeX, int relativeY) {
            this.btnSelectCategory.mouseReleased(x, y);
        }

        @Override
        public boolean isDefault() {
            if (this.childScreen instanceof GuiConfig && ((GuiConfig)this.childScreen).entryList != null) {
                return ((GuiConfig)this.childScreen).entryList.areAllEntriesDefault(true);
            }
            return true;
        }

        @Override
        public void setToDefault() {
            if (this.childScreen instanceof GuiConfig && ((GuiConfig)this.childScreen).entryList != null) {
                ((GuiConfig)this.childScreen).entryList.setAllToDefault(true);
            }
        }

        @Override
        public void keyTyped(char eventChar, int eventKey) {
        }

        @Override
        public void updateCursorCounter() {
        }

        @Override
        public void mouseClicked(int x, int y, int mouseEvent) {
        }

        @Override
        public boolean saveConfigElement() {
            boolean requiresRestart = false;
            if (this.childScreen instanceof GuiConfig && ((GuiConfig)this.childScreen).entryList != null) {
                boolean bl = requiresRestart = this.configElement.requiresMcRestart() && ((GuiConfig)this.childScreen).entryList.hasChangedEntry(true);
                if (((GuiConfig)this.childScreen).entryList.saveConfigElements()) {
                    requiresRestart = true;
                }
            }
            return requiresRestart;
        }

        @Override
        public boolean isChanged() {
            if (this.childScreen instanceof GuiConfig && ((GuiConfig)this.childScreen).entryList != null) {
                return ((GuiConfig)this.childScreen).entryList.hasChangedEntry(true);
            }
            return false;
        }

        @Override
        public void undoChanges() {
            if (this.childScreen instanceof GuiConfig && ((GuiConfig)this.childScreen).entryList != null) {
                ((GuiConfig)this.childScreen).entryList.undoAllChanges(true);
            }
        }

        @Override
        public boolean enabled() {
            return true;
        }

        @Override
        public int getLabelWidth() {
            return 0;
        }

        @Override
        public int getEntryRightBound() {
            return this.owningEntryList.width / 2 + 155 + 22 + 18;
        }

        @Override
        public String getCurrentValue() {
            return "";
        }

        public String[] getCurrentValues() {
            return new String[]{this.getCurrentValue()};
        }
    }

    public static class StringEntry
    extends ListEntryBase {
        protected final GuiTextField textFieldValue;
        protected final String beforeValue;

        public StringEntry(GuiConfig owningScreen, GuiConfigEntries owningEntryList, IConfigElement configElement) {
            super(owningScreen, owningEntryList, configElement);
            this.beforeValue = configElement.get().toString();
            this.textFieldValue = new GuiTextField(10, this.mc.fontRendererObj, this.owningEntryList.controlX + 1, 0, this.owningEntryList.controlWidth - 3, 16);
            this.textFieldValue.setMaxStringLength(10000);
            this.textFieldValue.setText(configElement.get().toString());
        }

        @Override
        public void drawEntry(int slotIndex, int x, int y, int listWidth, int slotHeight, int mouseX, int mouseY, boolean isSelected) {
            super.drawEntry(slotIndex, x, y, listWidth, slotHeight, mouseX, mouseY, isSelected);
            this.textFieldValue.xPosition = this.owningEntryList.controlX + 2;
            this.textFieldValue.yPosition = y + 1;
            this.textFieldValue.width = this.owningEntryList.controlWidth - 4;
            this.textFieldValue.setEnabled(this.enabled());
            this.textFieldValue.drawTextBox();
        }

        @Override
        public void keyTyped(char eventChar, int eventKey) {
            if (this.enabled() || eventKey == 203 || eventKey == 205 || eventKey == 199 || eventKey == 207) {
                this.textFieldValue.textboxKeyTyped(this.enabled() ? eventChar : (char)'\u0000', eventKey);
                if (this.configElement.getValidationPattern() != null) {
                    this.isValidValue = this.configElement.getValidationPattern().matcher(this.textFieldValue.getText().trim()).matches();
                }
            }
        }

        @Override
        public void updateCursorCounter() {
            this.textFieldValue.updateCursorCounter();
        }

        @Override
        public void mouseClicked(int x, int y, int mouseEvent) {
            this.textFieldValue.mouseClicked(x, y, mouseEvent);
        }

        @Override
        public boolean isDefault() {
            return this.configElement.getDefault() != null ? this.configElement.getDefault().toString().equals(this.textFieldValue.getText()) : this.textFieldValue.getText().trim().isEmpty();
        }

        @Override
        public void setToDefault() {
            if (this.enabled()) {
                this.textFieldValue.setText(this.configElement.getDefault().toString());
                this.keyTyped('\u0000', 199);
            }
        }

        @Override
        public boolean isChanged() {
            return this.beforeValue != null ? !this.beforeValue.equals(this.textFieldValue.getText()) : this.textFieldValue.getText().trim().isEmpty();
        }

        @Override
        public void undoChanges() {
            if (this.enabled()) {
                this.textFieldValue.setText(this.beforeValue);
            }
        }

        @Override
        public boolean saveConfigElement() {
            if (this.enabled()) {
                if (this.isChanged() && this.isValidValue) {
                    this.configElement.set(this.textFieldValue.getText());
                    return this.configElement.requiresMcRestart();
                }
                if (this.isChanged() && !this.isValidValue) {
                    this.configElement.setToDefault();
                    return this.configElement.requiresMcRestart() && this.beforeValue != null ? this.beforeValue.equals(this.configElement.getDefault()) : this.configElement.getDefault() == null;
                }
            }
            return false;
        }

        @Override
        public Object getCurrentValue() {
            return this.textFieldValue.getText();
        }

        @Override
        public Object[] getCurrentValues() {
            return new Object[]{this.getCurrentValue()};
        }
    }

    public static class DoubleEntry
    extends StringEntry {
        protected final double beforeValue;

        public DoubleEntry(GuiConfig owningScreen, GuiConfigEntries owningEntryList, IConfigElement configElement) {
            super(owningScreen, owningEntryList, configElement);
            this.beforeValue = Double.valueOf(configElement.get().toString());
        }

        @Override
        public void keyTyped(char eventChar, int eventKey) {
            block7: {
                if (this.enabled() || eventKey == 203 || eventKey == 205 || eventKey == 199 || eventKey == 207) {
                    String validChars = "0123456789";
                    String before = this.textFieldValue.getText();
                    if (validChars.contains(String.valueOf(eventChar)) || !before.startsWith("-") && this.textFieldValue.getCursorPosition() == 0 && eventChar == '-' || !before.contains(".") && eventChar == '.' || eventKey == 14 || eventKey == 211 || eventKey == 203 || eventKey == 205 || eventKey == 199 || eventKey == 207) {
                        this.textFieldValue.textboxKeyTyped(this.enabled() ? eventChar : (char)'\u0000', eventKey);
                    }
                    if (!this.textFieldValue.getText().trim().isEmpty() && !this.textFieldValue.getText().trim().equals("-")) {
                        try {
                            double value = Double.parseDouble(this.textFieldValue.getText().trim());
                            if (value < Double.valueOf(this.configElement.getMinValue().toString()) || value > Double.valueOf(this.configElement.getMaxValue().toString())) {
                                this.isValidValue = false;
                                break block7;
                            }
                            this.isValidValue = true;
                        }
                        catch (Throwable e) {
                            this.isValidValue = false;
                        }
                    } else {
                        this.isValidValue = false;
                    }
                }
            }
        }

        @Override
        public boolean isChanged() {
            try {
                return this.beforeValue != Double.parseDouble(this.textFieldValue.getText().trim());
            }
            catch (Throwable e) {
                return true;
            }
        }

        @Override
        public void undoChanges() {
            if (this.enabled()) {
                this.textFieldValue.setText(String.valueOf(this.beforeValue));
            }
        }

        @Override
        public boolean saveConfigElement() {
            if (this.enabled()) {
                if (this.isChanged() && this.isValidValue) {
                    try {
                        double value = Double.parseDouble(this.textFieldValue.getText().trim());
                        this.configElement.set(value);
                        return this.configElement.requiresMcRestart();
                    }
                    catch (Throwable e) {
                        this.configElement.setToDefault();
                    }
                } else if (this.isChanged() && !this.isValidValue) {
                    try {
                        double value = Double.parseDouble(this.textFieldValue.getText().trim());
                        if (value < Double.valueOf(this.configElement.getMinValue().toString())) {
                            this.configElement.set(this.configElement.getMinValue());
                        } else {
                            this.configElement.set(this.configElement.getMaxValue());
                        }
                    }
                    catch (Throwable e) {
                        this.configElement.setToDefault();
                    }
                }
                return this.configElement.requiresMcRestart() && this.beforeValue != Double.parseDouble(this.configElement.get().toString());
            }
            return false;
        }
    }

    public static class IntegerEntry
    extends StringEntry {
        protected final int beforeValue;

        public IntegerEntry(GuiConfig owningScreen, GuiConfigEntries owningEntryList, IConfigElement configElement) {
            super(owningScreen, owningEntryList, configElement);
            this.beforeValue = Integer.valueOf(configElement.get().toString());
        }

        @Override
        public void keyTyped(char eventChar, int eventKey) {
            block7: {
                if (this.enabled() || eventKey == 203 || eventKey == 205 || eventKey == 199 || eventKey == 207) {
                    String validChars = "0123456789";
                    String before = this.textFieldValue.getText();
                    if (validChars.contains(String.valueOf(eventChar)) || !before.startsWith("-") && this.textFieldValue.getCursorPosition() == 0 && eventChar == '-' || eventKey == 14 || eventKey == 211 || eventKey == 203 || eventKey == 205 || eventKey == 199 || eventKey == 207) {
                        this.textFieldValue.textboxKeyTyped(this.enabled() ? eventChar : (char)'\u0000', eventKey);
                    }
                    if (!this.textFieldValue.getText().trim().isEmpty() && !this.textFieldValue.getText().trim().equals("-")) {
                        try {
                            long value = Long.parseLong(this.textFieldValue.getText().trim());
                            if (value < (long)Integer.valueOf(this.configElement.getMinValue().toString()).intValue() || value > (long)Integer.valueOf(this.configElement.getMaxValue().toString()).intValue()) {
                                this.isValidValue = false;
                                break block7;
                            }
                            this.isValidValue = true;
                        }
                        catch (Throwable e) {
                            this.isValidValue = false;
                        }
                    } else {
                        this.isValidValue = false;
                    }
                }
            }
        }

        @Override
        public boolean isChanged() {
            try {
                return this.beforeValue != Integer.parseInt(this.textFieldValue.getText().trim());
            }
            catch (Throwable e) {
                return true;
            }
        }

        @Override
        public void undoChanges() {
            if (this.enabled()) {
                this.textFieldValue.setText(String.valueOf(this.beforeValue));
            }
        }

        @Override
        public boolean saveConfigElement() {
            if (this.enabled()) {
                if (this.isChanged() && this.isValidValue) {
                    try {
                        int value = Integer.parseInt(this.textFieldValue.getText().trim());
                        this.configElement.set(value);
                        return this.configElement.requiresMcRestart();
                    }
                    catch (Throwable e) {
                        this.configElement.setToDefault();
                    }
                } else if (this.isChanged() && !this.isValidValue) {
                    try {
                        int value = Integer.parseInt(this.textFieldValue.getText().trim());
                        if (value < Integer.valueOf(this.configElement.getMinValue().toString())) {
                            this.configElement.set(this.configElement.getMinValue());
                        } else {
                            this.configElement.set(this.configElement.getMaxValue());
                        }
                    }
                    catch (Throwable e) {
                        this.configElement.setToDefault();
                    }
                }
                return this.configElement.requiresMcRestart() && this.beforeValue != Integer.parseInt(this.configElement.get().toString());
            }
            return false;
        }
    }

    public static abstract class ButtonEntry
    extends ListEntryBase {
        protected final GuiButtonExt btnValue;

        public ButtonEntry(GuiConfig owningScreen, GuiConfigEntries owningEntryList, IConfigElement configElement) {
            this(owningScreen, owningEntryList, configElement, new GuiButtonExt(0, owningEntryList.controlX, 0, owningEntryList.controlWidth, 18, configElement.get() != null ? I18n.format(String.valueOf(configElement.get()), new Object[0]) : ""));
        }

        public ButtonEntry(GuiConfig owningScreen, GuiConfigEntries owningEntryList, IConfigElement configElement, GuiButtonExt button) {
            super(owningScreen, owningEntryList, configElement);
            this.btnValue = button;
        }

        public abstract void updateValueButtonText();

        public abstract void valueButtonPressed(int var1);

        @Override
        public void drawEntry(int slotIndex, int x, int y, int listWidth, int slotHeight, int mouseX, int mouseY, boolean isSelected) {
            super.drawEntry(slotIndex, x, y, listWidth, slotHeight, mouseX, mouseY, isSelected);
            this.btnValue.width = this.owningEntryList.controlWidth;
            this.btnValue.xPosition = this.owningScreen.entryList.controlX;
            this.btnValue.yPosition = y;
            this.btnValue.enabled = this.enabled();
            this.btnValue.drawButton(this.mc, mouseX, mouseY);
        }

        @Override
        public boolean mousePressed(int index, int x, int y, int mouseEvent, int relativeX, int relativeY) {
            if (this.btnValue.mousePressed(this.mc, x, y)) {
                this.btnValue.playPressSound(this.mc.getSoundHandler());
                this.valueButtonPressed(index);
                this.updateValueButtonText();
                return true;
            }
            return super.mousePressed(index, x, y, mouseEvent, relativeX, relativeY);
        }

        @Override
        public void mouseReleased(int index, int x, int y, int mouseEvent, int relativeX, int relativeY) {
            super.mouseReleased(index, x, y, mouseEvent, relativeX, relativeY);
            this.btnValue.mouseReleased(x, y);
        }

        @Override
        public void keyTyped(char eventChar, int eventKey) {
        }

        @Override
        public void updateCursorCounter() {
        }

        @Override
        public void mouseClicked(int x, int y, int mouseEvent) {
        }
    }

    public static class NumberSliderEntry
    extends ButtonEntry {
        protected final double beforeValue;

        public NumberSliderEntry(GuiConfig owningScreen, GuiConfigEntries owningEntryList, IConfigElement configElement) {
            super(owningScreen, owningEntryList, configElement, new GuiSlider(0, owningEntryList.controlX, 0, owningEntryList.controlWidth, 18, "", "", Double.valueOf(configElement.getMinValue().toString()), Double.valueOf(configElement.getMaxValue().toString()), Double.valueOf(configElement.get().toString()), configElement.getType() == ConfigGuiType.DOUBLE, true));
            this.beforeValue = configElement.getType() == ConfigGuiType.INTEGER ? (double)Integer.valueOf(configElement.get().toString()).intValue() : Double.valueOf(configElement.get().toString());
        }

        @Override
        public void updateValueButtonText() {
            ((GuiSlider)this.btnValue).updateSlider();
        }

        @Override
        public void valueButtonPressed(int slotIndex) {
        }

        @Override
        public boolean isDefault() {
            if (this.configElement.getType() == ConfigGuiType.INTEGER) {
                return ((GuiSlider)this.btnValue).getValueInt() == Integer.valueOf(this.configElement.getDefault().toString()).intValue();
            }
            return ((GuiSlider)this.btnValue).getValue() == Double.valueOf(this.configElement.getDefault().toString()).doubleValue();
        }

        @Override
        public void setToDefault() {
            if (this.enabled()) {
                ((GuiSlider)this.btnValue).setValue(Double.valueOf(this.configElement.getDefault().toString()));
                ((GuiSlider)this.btnValue).updateSlider();
            }
        }

        @Override
        public boolean isChanged() {
            if (this.configElement.getType() == ConfigGuiType.INTEGER) {
                return ((GuiSlider)this.btnValue).getValueInt() != (int)Math.round(this.beforeValue);
            }
            return ((GuiSlider)this.btnValue).getValue() != this.beforeValue;
        }

        @Override
        public void undoChanges() {
            if (this.enabled()) {
                ((GuiSlider)this.btnValue).setValue(this.beforeValue);
                ((GuiSlider)this.btnValue).updateSlider();
            }
        }

        @Override
        public boolean saveConfigElement() {
            if (this.enabled() && this.isChanged()) {
                if (this.configElement.getType() == ConfigGuiType.INTEGER) {
                    this.configElement.set(((GuiSlider)this.btnValue).getValueInt());
                } else {
                    this.configElement.set(((GuiSlider)this.btnValue).getValue());
                }
                return this.configElement.requiresMcRestart();
            }
            return false;
        }

        @Override
        public Object getCurrentValue() {
            if (this.configElement.getType() == ConfigGuiType.INTEGER) {
                return ((GuiSlider)this.btnValue).getValueInt();
            }
            return ((GuiSlider)this.btnValue).getValue();
        }

        @Override
        public Object[] getCurrentValues() {
            return new Object[]{this.getCurrentValue()};
        }
    }

    public static class ArrayEntry
    extends ButtonEntry {
        protected final Object[] beforeValues;
        protected Object[] currentValues;

        public ArrayEntry(GuiConfig owningScreen, GuiConfigEntries owningEntryList, IConfigElement configElement) {
            super(owningScreen, owningEntryList, configElement);
            this.beforeValues = configElement.getList();
            this.currentValues = configElement.getList();
            this.updateValueButtonText();
        }

        @Override
        public void updateValueButtonText() {
            this.btnValue.displayString = "";
            for (Object o : this.currentValues) {
                this.btnValue.displayString = this.btnValue.displayString + ", [" + o + "]";
            }
            this.btnValue.displayString = this.btnValue.displayString.replaceFirst(", ", "");
        }

        @Override
        public void valueButtonPressed(int slotIndex) {
            this.mc.displayGuiScreen(new GuiEditArray(this.owningScreen, this.configElement, slotIndex, this.currentValues, this.enabled()));
        }

        public void setListFromChildScreen(Object[] newList) {
            if (this.enabled() && !Arrays.deepEquals(this.currentValues, newList)) {
                this.currentValues = newList;
                this.updateValueButtonText();
            }
        }

        @Override
        public boolean isDefault() {
            return Arrays.deepEquals(this.configElement.getDefaults(), this.currentValues);
        }

        @Override
        public void setToDefault() {
            if (this.enabled()) {
                this.currentValues = this.configElement.getDefaults();
                this.updateValueButtonText();
            }
        }

        @Override
        public boolean isChanged() {
            return !Arrays.deepEquals(this.beforeValues, this.currentValues);
        }

        @Override
        public void undoChanges() {
            if (this.enabled()) {
                this.currentValues = this.beforeValues;
                this.updateValueButtonText();
            }
        }

        @Override
        public boolean saveConfigElement() {
            if (this.enabled() && this.isChanged()) {
                this.configElement.set(this.currentValues);
                return this.configElement.requiresMcRestart();
            }
            return false;
        }

        @Override
        public Object getCurrentValue() {
            return this.btnValue.displayString;
        }

        @Override
        public Object[] getCurrentValues() {
            return this.currentValues;
        }
    }

    public static class SelectValueEntry
    extends ButtonEntry {
        protected final String beforeValue;
        protected Object currentValue;
        protected Map<Object, String> selectableValues;

        public SelectValueEntry(GuiConfig owningScreen, GuiConfigEntries owningEntryList, IConfigElement configElement, Map<Object, String> selectableValues) {
            super(owningScreen, owningEntryList, configElement);
            this.beforeValue = configElement.get().toString();
            this.currentValue = configElement.get().toString();
            this.selectableValues = selectableValues;
            this.updateValueButtonText();
        }

        @Override
        public void updateValueButtonText() {
            this.btnValue.displayString = this.currentValue.toString();
        }

        @Override
        public void valueButtonPressed(int slotIndex) {
            this.mc.displayGuiScreen(new GuiSelectString(this.owningScreen, this.configElement, slotIndex, this.selectableValues, this.currentValue, this.enabled()));
        }

        public void setValueFromChildScreen(Object newValue) {
            if (this.enabled() && this.currentValue != null ? !this.currentValue.equals(newValue) : newValue != null) {
                this.currentValue = newValue;
                this.updateValueButtonText();
            }
        }

        @Override
        public boolean isDefault() {
            if (this.configElement.getDefault() != null) {
                return this.configElement.getDefault().equals(this.currentValue);
            }
            return this.currentValue == null;
        }

        @Override
        public void setToDefault() {
            if (this.enabled()) {
                this.currentValue = this.configElement.getDefault().toString();
                this.updateValueButtonText();
            }
        }

        @Override
        public boolean isChanged() {
            if (this.beforeValue != null) {
                return !this.beforeValue.equals(this.currentValue);
            }
            return this.currentValue == null;
        }

        @Override
        public void undoChanges() {
            if (this.enabled()) {
                this.currentValue = this.beforeValue;
                this.updateValueButtonText();
            }
        }

        @Override
        public boolean saveConfigElement() {
            if (this.enabled() && this.isChanged()) {
                this.configElement.set(this.currentValue);
                return this.configElement.requiresMcRestart();
            }
            return false;
        }

        @Override
        public String getCurrentValue() {
            return this.currentValue.toString();
        }

        public String[] getCurrentValues() {
            return new String[]{this.getCurrentValue()};
        }
    }

    public static class ChatColorEntry
    extends CycleValueEntry {
        ChatColorEntry(GuiConfig owningScreen, GuiConfigEntries owningEntryList, IConfigElement configElement) {
            super(owningScreen, owningEntryList, configElement);
            this.btnValue.enabled = this.enabled();
            this.updateValueButtonText();
        }

        @Override
        public void drawEntry(int slotIndex, int x, int y, int listWidth, int slotHeight, int mouseX, int mouseY, boolean isSelected) {
            this.btnValue.packedFGColour = GuiUtils.getColorCode(this.configElement.getValidValues()[this.currentIndex].charAt(0), true);
            super.drawEntry(slotIndex, x, y, listWidth, slotHeight, mouseX, mouseY, isSelected);
        }

        @Override
        public void updateValueButtonText() {
            this.btnValue.displayString = I18n.format(this.configElement.getValidValues()[this.currentIndex], new Object[0]) + " - " + I18n.format("fml.configgui.sampletext", new Object[0]);
        }
    }

    public static class CycleValueEntry
    extends ButtonEntry {
        protected final int beforeIndex;
        protected final int defaultIndex;
        protected int currentIndex;

        private CycleValueEntry(GuiConfig owningScreen, GuiConfigEntries owningEntryList, IConfigElement configElement) {
            super(owningScreen, owningEntryList, configElement);
            this.beforeIndex = this.getIndex(configElement.get().toString());
            this.defaultIndex = this.getIndex(configElement.getDefault().toString());
            this.currentIndex = this.beforeIndex;
            this.btnValue.enabled = this.enabled();
            this.updateValueButtonText();
        }

        private int getIndex(String s) {
            for (int i = 0; i < this.configElement.getValidValues().length; ++i) {
                if (!this.configElement.getValidValues()[i].equalsIgnoreCase(s)) continue;
                return i;
            }
            return 0;
        }

        @Override
        public void updateValueButtonText() {
            this.btnValue.displayString = I18n.format(this.configElement.getValidValues()[this.currentIndex], new Object[0]);
        }

        @Override
        public void valueButtonPressed(int slotIndex) {
            if (this.enabled()) {
                if (++this.currentIndex >= this.configElement.getValidValues().length) {
                    this.currentIndex = 0;
                }
                this.updateValueButtonText();
            }
        }

        @Override
        public boolean isDefault() {
            return this.currentIndex == this.defaultIndex;
        }

        @Override
        public void setToDefault() {
            if (this.enabled()) {
                this.currentIndex = this.defaultIndex;
                this.updateValueButtonText();
            }
        }

        @Override
        public boolean isChanged() {
            return this.currentIndex != this.beforeIndex;
        }

        @Override
        public void undoChanges() {
            if (this.enabled()) {
                this.currentIndex = this.beforeIndex;
                this.updateValueButtonText();
            }
        }

        @Override
        public boolean saveConfigElement() {
            if (this.enabled() && this.isChanged()) {
                this.configElement.set(this.configElement.getValidValues()[this.currentIndex]);
                return this.configElement.requiresMcRestart();
            }
            return false;
        }

        @Override
        public String getCurrentValue() {
            return this.configElement.getValidValues()[this.currentIndex];
        }

        public String[] getCurrentValues() {
            return new String[]{this.getCurrentValue()};
        }
    }

    public static class BooleanEntry
    extends ButtonEntry {
        protected final boolean beforeValue;
        protected boolean currentValue;

        private BooleanEntry(GuiConfig owningScreen, GuiConfigEntries owningEntryList, IConfigElement configElement) {
            super(owningScreen, owningEntryList, configElement);
            this.currentValue = this.beforeValue = Boolean.valueOf(configElement.get().toString()).booleanValue();
            this.btnValue.enabled = this.enabled();
            this.updateValueButtonText();
        }

        @Override
        public void updateValueButtonText() {
            this.btnValue.displayString = I18n.format(String.valueOf(this.currentValue), new Object[0]);
            this.btnValue.packedFGColour = this.currentValue ? GuiUtils.getColorCode('2', true) : GuiUtils.getColorCode('4', true);
        }

        @Override
        public void valueButtonPressed(int slotIndex) {
            if (this.enabled()) {
                this.currentValue = !this.currentValue;
            }
        }

        @Override
        public boolean isDefault() {
            return this.currentValue == Boolean.valueOf(this.configElement.getDefault().toString());
        }

        @Override
        public void setToDefault() {
            if (this.enabled()) {
                this.currentValue = Boolean.valueOf(this.configElement.getDefault().toString());
                this.updateValueButtonText();
            }
        }

        @Override
        public boolean isChanged() {
            return this.currentValue != this.beforeValue;
        }

        @Override
        public void undoChanges() {
            if (this.enabled()) {
                this.currentValue = this.beforeValue;
                this.updateValueButtonText();
            }
        }

        @Override
        public boolean saveConfigElement() {
            if (this.enabled() && this.isChanged()) {
                this.configElement.set(this.currentValue);
                return this.configElement.requiresMcRestart();
            }
            return false;
        }

        @Override
        public Boolean getCurrentValue() {
            return this.currentValue;
        }

        public Boolean[] getCurrentValues() {
            return new Boolean[]{this.getCurrentValue()};
        }
    }
}

