/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.fml.client.config;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.resources.I18n;
import net.minecraft.util.text.TextFormatting;
import net.minecraftforge.fml.client.config.GuiButtonExt;
import net.minecraftforge.fml.client.config.GuiConfig;
import net.minecraftforge.fml.client.config.GuiSelectStringEntries;
import net.minecraftforge.fml.client.config.GuiUnicodeGlyphButton;
import net.minecraftforge.fml.client.config.GuiUtils;
import net.minecraftforge.fml.client.config.HoverChecker;
import net.minecraftforge.fml.client.config.IConfigElement;

public class GuiSelectString
extends GuiScreen {
    protected GuiScreen parentScreen;
    protected IConfigElement configElement;
    protected GuiSelectStringEntries entryList;
    protected GuiButtonExt btnUndoChanges;
    protected GuiButtonExt btnDefault;
    protected GuiButtonExt btnDone;
    protected String title;
    protected String titleLine2;
    protected String titleLine3;
    protected int slotIndex;
    protected final Map<Object, String> selectableValues;
    public final Object beforeValue;
    public Object currentValue;
    protected HoverChecker tooltipHoverChecker;
    protected List<String> toolTip;
    protected boolean enabled;

    public GuiSelectString(GuiScreen parentScreen, IConfigElement configElement, int slotIndex, Map<Object, String> selectableValues, Object currentValue, boolean enabled) {
        this.mc = Minecraft.getMinecraft();
        this.parentScreen = parentScreen;
        this.configElement = configElement;
        this.slotIndex = slotIndex;
        this.selectableValues = selectableValues;
        this.beforeValue = currentValue;
        this.currentValue = currentValue;
        this.toolTip = new ArrayList<String>();
        this.enabled = enabled;
        String propName = I18n.format(configElement.getLanguageKey(), new Object[0]);
        String comment = I18n.format(configElement.getLanguageKey() + ".tooltip", "\n" + (Object)((Object)TextFormatting.AQUA), configElement.getDefault(), configElement.getMinValue(), configElement.getMaxValue());
        if (!comment.equals(configElement.getLanguageKey() + ".tooltip")) {
            Collections.addAll(this.toolTip, ((Object)((Object)TextFormatting.GREEN) + propName + "\n" + (Object)((Object)TextFormatting.YELLOW) + comment).split("\n"));
        } else if (configElement.getComment() != null && !configElement.getComment().trim().isEmpty()) {
            Collections.addAll(this.toolTip, ((Object)((Object)TextFormatting.GREEN) + propName + "\n" + (Object)((Object)TextFormatting.YELLOW) + configElement.getComment()).split("\n"));
        } else {
            Collections.addAll(this.toolTip, ((Object)((Object)TextFormatting.GREEN) + propName + "\n" + (Object)((Object)TextFormatting.RED) + "No tooltip defined.").split("\n"));
        }
        if (parentScreen instanceof GuiConfig) {
            this.title = ((GuiConfig)parentScreen).title;
            this.titleLine2 = ((GuiConfig)parentScreen).titleLine2;
            this.titleLine3 = I18n.format(configElement.getLanguageKey(), new Object[0]);
            this.tooltipHoverChecker = new HoverChecker(28, 37, 0, parentScreen.width, 800);
            if (this.titleLine3 != null && this.titleLine2 == null) {
                ((GuiConfig)parentScreen).titleLine2 = "";
                this.titleLine2 = "";
            }
        } else {
            this.title = I18n.format(configElement.getLanguageKey(), new Object[0]);
            this.tooltipHoverChecker = new HoverChecker(8, 17, 0, parentScreen.width, 800);
        }
    }

    @Override
    public void initGui() {
        this.entryList = new GuiSelectStringEntries(this, this.mc, this.configElement, this.selectableValues);
        int undoGlyphWidth = this.mc.fontRendererObj.getStringWidth("\u21b6") * 2;
        int resetGlyphWidth = this.mc.fontRendererObj.getStringWidth("\u2604") * 2;
        int doneWidth = Math.max(this.mc.fontRendererObj.getStringWidth(I18n.format("gui.done", new Object[0])) + 20, 100);
        int undoWidth = this.mc.fontRendererObj.getStringWidth(" " + I18n.format("fml.configgui.tooltip.undoChanges", new Object[0])) + undoGlyphWidth + 20;
        int resetWidth = this.mc.fontRendererObj.getStringWidth(" " + I18n.format("fml.configgui.tooltip.resetToDefault", new Object[0])) + resetGlyphWidth + 20;
        int buttonWidthHalf = (doneWidth + 5 + undoWidth + 5 + resetWidth) / 2;
        this.btnDone = new GuiButtonExt(2000, this.width / 2 - buttonWidthHalf, this.height - 29, doneWidth, 20, I18n.format("gui.done", new Object[0]));
        this.buttonList.add(this.btnDone);
        this.btnDefault = new GuiUnicodeGlyphButton(2001, this.width / 2 - buttonWidthHalf + doneWidth + 5 + undoWidth + 5, this.height - 29, resetWidth, 20, " " + I18n.format("fml.configgui.tooltip.resetToDefault", new Object[0]), "\u2604", 2.0f);
        this.buttonList.add(this.btnDefault);
        this.btnUndoChanges = new GuiUnicodeGlyphButton(2002, this.width / 2 - buttonWidthHalf + doneWidth + 5, this.height - 29, undoWidth, 20, " " + I18n.format("fml.configgui.tooltip.undoChanges", new Object[0]), "\u21b6", 2.0f);
        this.buttonList.add(this.btnUndoChanges);
    }

    @Override
    protected void actionPerformed(GuiButton button) {
        if (button.id == 2000) {
            try {
                this.entryList.saveChanges();
            }
            catch (Throwable e) {
                e.printStackTrace();
            }
            this.mc.displayGuiScreen(this.parentScreen);
        } else if (button.id == 2001) {
            this.currentValue = this.configElement.getDefault();
            this.entryList = new GuiSelectStringEntries(this, this.mc, this.configElement, this.selectableValues);
        } else if (button.id == 2002) {
            this.currentValue = this.beforeValue;
            this.entryList = new GuiSelectStringEntries(this, this.mc, this.configElement, this.selectableValues);
        }
    }

    @Override
    public void handleMouseInput() throws IOException {
        super.handleMouseInput();
        this.entryList.handleMouseInput();
    }

    @Override
    protected void mouseReleased(int x, int y, int mouseEvent) {
        if (mouseEvent != 0 || !this.entryList.mouseReleased(x, y, mouseEvent)) {
            super.mouseReleased(x, y, mouseEvent);
        }
    }

    @Override
    public void drawScreen(int par1, int par2, float par3) {
        this.drawDefaultBackground();
        this.entryList.drawScreen(par1, par2, par3);
        this.drawCenteredString(this.fontRendererObj, this.title, this.width / 2, 8, 0xFFFFFF);
        if (this.titleLine2 != null) {
            this.drawCenteredString(this.fontRendererObj, this.titleLine2, this.width / 2, 18, 0xFFFFFF);
        }
        if (this.titleLine3 != null) {
            this.drawCenteredString(this.fontRendererObj, this.titleLine3, this.width / 2, 28, 0xFFFFFF);
        }
        this.btnDone.enabled = this.currentValue != null;
        this.btnDefault.enabled = this.enabled && !this.entryList.isDefault();
        this.btnUndoChanges.enabled = this.enabled && this.entryList.isChanged();
        super.drawScreen(par1, par2, par3);
        if (this.tooltipHoverChecker != null && this.tooltipHoverChecker.checkHover(par1, par2)) {
            this.drawToolTip(this.toolTip, par1, par2);
        }
    }

    public void drawToolTip(List<String> stringList, int x, int y) {
        GuiUtils.drawHoveringText(stringList, x, y, this.width, this.height, 300, this.fontRendererObj);
    }
}

