/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.fml.client.config;

import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraftforge.fml.client.config.GuiButtonExt;
import net.minecraftforge.fml.client.config.GuiUtils;

public class GuiUnicodeGlyphButton
extends GuiButtonExt {
    public String glyph;
    public float glyphScale;

    public GuiUnicodeGlyphButton(int id, int xPos, int yPos, int width, int height, String displayString, String glyph, float glyphScale) {
        super(id, xPos, yPos, width, height, displayString);
        this.glyph = glyph;
        this.glyphScale = glyphScale;
    }

    @Override
    public void drawButton(Minecraft mc, int mouseX, int mouseY) {
        if (this.visible) {
            this.hovered = mouseX >= this.xPosition && mouseY >= this.yPosition && mouseX < this.xPosition + this.width && mouseY < this.yPosition + this.height;
            int k = this.getHoverState(this.hovered);
            GuiUtils.drawContinuousTexturedBox(GuiButton.BUTTON_TEXTURES, this.xPosition, this.yPosition, 0, 46 + k * 20, this.width, this.height, 200, 20, 2, 3, 2, 2, this.zLevel);
            this.mouseDragged(mc, mouseX, mouseY);
            int color = 0xE0E0E0;
            if (this.packedFGColour != 0) {
                color = this.packedFGColour;
            } else if (!this.enabled) {
                color = 0xA0A0A0;
            } else if (this.hovered) {
                color = 0xFFFFA0;
            }
            String buttonText = this.displayString;
            int glyphWidth = (int)((float)mc.fontRendererObj.getStringWidth(this.glyph) * this.glyphScale);
            int strWidth = mc.fontRendererObj.getStringWidth(buttonText);
            int ellipsisWidth = mc.fontRendererObj.getStringWidth("...");
            int totalWidth = strWidth + glyphWidth;
            if (totalWidth > this.width - 6 && totalWidth > ellipsisWidth) {
                buttonText = mc.fontRendererObj.trimStringToWidth(buttonText, this.width - 6 - ellipsisWidth).trim() + "...";
            }
            strWidth = mc.fontRendererObj.getStringWidth(buttonText);
            totalWidth = glyphWidth + strWidth;
            GlStateManager.pushMatrix();
            GlStateManager.scale(this.glyphScale, this.glyphScale, 1.0f);
            this.drawCenteredString(mc.fontRendererObj, this.glyph, (int)((float)(this.xPosition + this.width / 2 - strWidth / 2) / this.glyphScale - (float)glyphWidth / (2.0f * this.glyphScale) + 2.0f), (int)(((float)this.yPosition + (float)(this.height - 8) / this.glyphScale / 2.0f - 1.0f) / this.glyphScale), color);
            GlStateManager.popMatrix();
            this.drawCenteredString(mc.fontRendererObj, buttonText, (int)((float)(this.xPosition + this.width / 2) + (float)glyphWidth / this.glyphScale), this.yPosition + (this.height - 8) / 2, color);
        }
    }
}

