/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.fml.client.registry;

import com.google.common.collect.Maps;
import java.util.Map;
import net.minecraft.client.renderer.entity.Render;
import net.minecraft.client.renderer.entity.RenderManager;
import net.minecraft.entity.Entity;
import net.minecraftforge.fml.client.registry.IRenderFactory;

public class RenderingRegistry {
    private static final RenderingRegistry INSTANCE = new RenderingRegistry();
    private Map<Class<? extends Entity>, IRenderFactory<? extends Entity>> entityRenderers = Maps.newHashMap();
    private Map<Class<? extends Entity>, Render<? extends Entity>> entityRenderersOld = Maps.newHashMap();

    @Deprecated
    public static void registerEntityRenderingHandler(Class<? extends Entity> entityClass, Render<? extends Entity> renderer) {
        RenderingRegistry.INSTANCE.entityRenderersOld.put(entityClass, renderer);
    }

    public static void loadEntityRenderers(Map<Class<? extends Entity>, Render<? extends Entity>> entityRenderMap) {
        entityRenderMap.putAll(RenderingRegistry.INSTANCE.entityRenderersOld);
    }

    public static <T extends Entity> void registerEntityRenderingHandler(Class<T> entityClass, IRenderFactory<? super T> renderFactory) {
        RenderingRegistry.INSTANCE.entityRenderers.put(entityClass, renderFactory);
    }

    public static void loadEntityRenderers(RenderManager manager, Map<Class<? extends Entity>, Render<? extends Entity>> renderMap) {
        for (Map.Entry<Class<? extends Entity>, IRenderFactory<? extends Entity>> entry : RenderingRegistry.INSTANCE.entityRenderers.entrySet()) {
            RenderingRegistry.register(manager, renderMap, entry.getKey(), entry.getValue());
        }
    }

    private static <T extends Entity> void register(RenderManager manager, Map<Class<? extends Entity>, Render<? extends Entity>> renderMap, Class<T> entityClass, IRenderFactory<?> renderFactory) {
        renderMap.put(entityClass, renderFactory.createRenderFor(manager));
    }
}

