/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.fml.common;

import com.google.common.base.Throwables;
import net.minecraftforge.fml.common.event.FMLConstructionEvent;
import net.minecraftforge.fml.common.event.FMLInitializationEvent;
import net.minecraftforge.fml.common.event.FMLLoadCompleteEvent;
import net.minecraftforge.fml.common.event.FMLPostInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import net.minecraftforge.fml.common.event.FMLServerAboutToStartEvent;
import net.minecraftforge.fml.common.event.FMLServerStartedEvent;
import net.minecraftforge.fml.common.event.FMLServerStartingEvent;
import net.minecraftforge.fml.common.event.FMLServerStoppedEvent;
import net.minecraftforge.fml.common.event.FMLServerStoppingEvent;
import net.minecraftforge.fml.common.event.FMLStateEvent;

public enum LoaderState {
    NOINIT("Uninitialized", null),
    LOADING("Loading", null),
    CONSTRUCTING("Constructing mods", FMLConstructionEvent.class),
    PREINITIALIZATION("Pre-initializing mods", FMLPreInitializationEvent.class),
    INITIALIZATION("Initializing mods", FMLInitializationEvent.class),
    POSTINITIALIZATION("Post-initializing mods", FMLPostInitializationEvent.class),
    AVAILABLE("Mod loading complete", FMLLoadCompleteEvent.class),
    SERVER_ABOUT_TO_START("Server about to start", FMLServerAboutToStartEvent.class),
    SERVER_STARTING("Server starting", FMLServerStartingEvent.class),
    SERVER_STARTED("Server started", FMLServerStartedEvent.class),
    SERVER_STOPPING("Server stopping", FMLServerStoppingEvent.class),
    SERVER_STOPPED("Server stopped", FMLServerStoppedEvent.class),
    ERRORED("Mod Loading errored", null);

    private Class<? extends FMLStateEvent> eventClass;
    private String name;

    private LoaderState(String name, Class<? extends FMLStateEvent> event) {
        this.name = name;
        this.eventClass = event;
    }

    public LoaderState transition(boolean errored) {
        if (errored) {
            return ERRORED;
        }
        if (this == SERVER_STOPPED) {
            return AVAILABLE;
        }
        return LoaderState.values()[this.ordinal() < LoaderState.values().length ? this.ordinal() + 1 : this.ordinal()];
    }

    public boolean hasEvent() {
        return this.eventClass != null;
    }

    public FMLStateEvent getEvent(Object ... eventData) {
        try {
            return this.eventClass.getConstructor(Object[].class).newInstance(new Object[]{eventData});
        }
        catch (Exception e) {
            throw Throwables.propagate((Throwable)e);
        }
    }

    public LoaderState requiredState() {
        if (this == NOINIT) {
            return NOINIT;
        }
        return LoaderState.values()[this.ordinal() - 1];
    }

    public String getPrettyName() {
        return this.name;
    }

    public static enum ModState {
        UNLOADED("Unloaded", "U"),
        LOADED("Loaded", "L"),
        CONSTRUCTED("Constructed", "C"),
        PREINITIALIZED("Pre-initialized", "H"),
        INITIALIZED("Initialized", "I"),
        POSTINITIALIZED("Post-initialized", "J"),
        AVAILABLE("Available", "A"),
        DISABLED("Disabled", "D"),
        ERRORED("Errored", "E");

        private String label;
        private String marker;

        private ModState(String label, String marker) {
            this.label = label;
            this.marker = marker;
        }

        public String toString() {
            return this.label;
        }

        public String getMarker() {
            return this.marker;
        }
    }
}

