/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.fml.common.event;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Map;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.common.event.FMLEvent;

public class FMLModIdMappingEvent
extends FMLEvent {
    public final ImmutableList<ModRemapping> remappedIds;
    public final boolean isFrozen;

    public FMLModIdMappingEvent(Map<ResourceLocation, Integer[]> blocks, Map<ResourceLocation, Integer[]> items, boolean isFrozen) {
        this.isFrozen = isFrozen;
        ArrayList remappings = Lists.newArrayList();
        for (Map.Entry<ResourceLocation, Integer[]> mapping : blocks.entrySet()) {
            remappings.add(new ModRemapping(mapping.getValue()[0], mapping.getValue()[1], mapping.getKey(), RemapTarget.BLOCK));
        }
        for (Map.Entry<ResourceLocation, Integer[]> mapping : items.entrySet()) {
            remappings.add(new ModRemapping(mapping.getValue()[0], mapping.getValue()[1], mapping.getKey(), RemapTarget.ITEM));
        }
        Collections.sort(remappings, new Comparator<ModRemapping>(){

            @Override
            public int compare(ModRemapping o1, ModRemapping o2) {
                return o1.newId < o2.newId ? -1 : (o1.newId == o2.newId ? 0 : 1);
            }
        });
        this.remappedIds = ImmutableList.copyOf((Collection)remappings);
    }

    public class ModRemapping {
        public final int oldId;
        public final int newId;
        public final String tag;
        public final RemapTarget remapTarget;
        public final ResourceLocation resourceLocation;

        public ModRemapping(int oldId, int newId, ResourceLocation tag, RemapTarget type) {
            this.oldId = oldId;
            this.newId = newId;
            this.tag = tag.toString();
            this.remapTarget = type;
            this.resourceLocation = tag;
        }
    }

    public static enum RemapTarget {
        BLOCK,
        ITEM;

    }
}

