/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.fml.common.network;

import com.google.common.collect.ImmutableSet;
import java.util.Set;
import net.minecraft.network.INetHandler;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.play.INetHandlerPlayClient;
import net.minecraft.network.play.INetHandlerPlayServer;
import net.minecraftforge.fml.common.eventhandler.Event;
import net.minecraftforge.fml.common.network.internal.FMLProxyPacket;
import net.minecraftforge.fml.relauncher.Side;

public class FMLNetworkEvent<T extends INetHandler>
extends Event {
    private final T handler;
    private final NetworkManager manager;
    private final Class<T> type;

    FMLNetworkEvent(T thing, Class<T> type, NetworkManager manager) {
        this.handler = thing;
        this.type = type;
        this.manager = manager;
    }

    public Class<T> getHandlerType() {
        return this.getType();
    }

    public T getHandler() {
        return this.handler;
    }

    public NetworkManager getManager() {
        return this.manager;
    }

    public Class<T> getType() {
        return this.type;
    }

    public static class CustomNetworkEvent
    extends Event {
        private final Object wrappedEvent;

        public CustomNetworkEvent(Object wrappedEvent) {
            this.wrappedEvent = wrappedEvent;
        }

        public Object getWrappedEvent() {
            return this.wrappedEvent;
        }
    }

    public static class ServerCustomPacketEvent
    extends CustomPacketEvent<INetHandlerPlayServer> {
        public ServerCustomPacketEvent(NetworkManager manager, FMLProxyPacket packet) {
            super((INetHandlerPlayServer)manager.getNetHandler(), INetHandlerPlayServer.class, manager, packet);
        }

        @Override
        public Side side() {
            return Side.SERVER;
        }
    }

    public static class ClientCustomPacketEvent
    extends CustomPacketEvent<INetHandlerPlayClient> {
        public ClientCustomPacketEvent(NetworkManager manager, FMLProxyPacket packet) {
            super((INetHandlerPlayClient)manager.getNetHandler(), INetHandlerPlayClient.class, manager, packet);
        }

        @Override
        public Side side() {
            return Side.CLIENT;
        }
    }

    public static abstract class CustomPacketEvent<S extends INetHandler>
    extends FMLNetworkEvent<S> {
        private final FMLProxyPacket packet;
        private FMLProxyPacket reply;

        CustomPacketEvent(S thing, Class<S> type, NetworkManager manager, FMLProxyPacket packet) {
            super(thing, type, manager);
            this.packet = packet;
        }

        public abstract Side side();

        public FMLProxyPacket getPacket() {
            return this.packet;
        }

        public FMLProxyPacket getReply() {
            return this.reply;
        }

        public void setReply(FMLProxyPacket reply) {
            this.reply = reply;
        }
    }

    public static class CustomPacketRegistrationEvent<S extends INetHandler>
    extends FMLNetworkEvent<S> {
        private final ImmutableSet<String> registrations;
        private final String operation;
        private final Side side;

        public CustomPacketRegistrationEvent(NetworkManager manager, Set<String> registrations, String operation, Side side, Class<S> type) {
            super((INetHandler)type.cast(manager.getNetHandler()), type, manager);
            this.registrations = ImmutableSet.copyOf(registrations);
            this.side = side;
            this.operation = operation;
        }

        public ImmutableSet<String> getRegistrations() {
            return this.registrations;
        }

        public String getOperation() {
            return this.operation;
        }

        public Side getSide() {
            return this.side;
        }
    }

    public static class ClientDisconnectionFromServerEvent
    extends FMLNetworkEvent<INetHandlerPlayClient> {
        public ClientDisconnectionFromServerEvent(NetworkManager manager) {
            super((INetHandlerPlayClient)manager.getNetHandler(), INetHandlerPlayClient.class, manager);
        }
    }

    public static class ServerDisconnectionFromClientEvent
    extends FMLNetworkEvent<INetHandlerPlayServer> {
        public ServerDisconnectionFromClientEvent(NetworkManager manager) {
            super((INetHandlerPlayServer)manager.getNetHandler(), INetHandlerPlayServer.class, manager);
        }
    }

    public static class ServerConnectionFromClientEvent
    extends FMLNetworkEvent<INetHandlerPlayServer> {
        private final boolean isLocal;

        public ServerConnectionFromClientEvent(NetworkManager manager) {
            super((INetHandlerPlayServer)manager.getNetHandler(), INetHandlerPlayServer.class, manager);
            this.isLocal = manager.isLocalChannel();
        }

        public boolean isLocal() {
            return this.isLocal;
        }
    }

    public static class ClientConnectedToServerEvent
    extends FMLNetworkEvent<INetHandlerPlayClient> {
        private final boolean isLocal;
        private final String connectionType;

        public ClientConnectedToServerEvent(NetworkManager manager, String connectionType) {
            super((INetHandlerPlayClient)manager.getNetHandler(), INetHandlerPlayClient.class, manager);
            this.isLocal = manager.isLocalChannel();
            this.connectionType = connectionType;
        }

        public boolean isLocal() {
            return this.isLocal;
        }

        public String getConnectionType() {
            return this.connectionType;
        }
    }
}

