/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.fml.common.network;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelOutboundHandlerAdapter;
import io.netty.channel.ChannelPipeline;
import io.netty.channel.ChannelPromise;
import io.netty.channel.SimpleChannelInboundHandler;
import java.util.List;
import net.minecraft.network.EnumPacketDirection;
import net.minecraft.network.NettyVarint21FrameDecoder;
import net.minecraft.network.NettyVarint21FrameEncoder;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.Packet;
import net.minecraft.network.PacketBuffer;
import net.minecraftforge.fml.common.FMLLog;
import net.minecraftforge.fml.common.network.ByteBufUtils;
import org.apache.logging.log4j.Level;

public class PacketLoggingHandler {
    public static void register(NetworkManager manager) {
        ChannelPipeline pipeline = manager.channel().pipeline();
        final EnumPacketDirection direction = manager.getDirection();
        if (manager.isLocalChannel()) {
            pipeline.addBefore("packet_handler", "splitter", (ChannelHandler)new SimpleChannelInboundHandler<Packet<?>>(){
                String prefix;
                {
                    this.prefix = direction == EnumPacketDirection.SERVERBOUND ? "SERVER: C->S" : "CLIENT: S->C";
                }

                protected void channelRead0(ChannelHandlerContext ctx, Packet<?> msg) throws Exception {
                    PacketBuffer buf = new PacketBuffer(Unpooled.buffer());
                    msg.writePacketData(buf);
                    FMLLog.log(Level.DEBUG, "%s %s:\n%s", this.prefix, msg.getClass().getSimpleName(), ByteBufUtils.getContentDump(buf));
                    ctx.fireChannelRead(msg);
                }
            });
            pipeline.addBefore("splitter", "prepender", (ChannelHandler)new ChannelOutboundHandlerAdapter(){
                String prefix;
                {
                    this.prefix = direction == EnumPacketDirection.SERVERBOUND ? "SERVER: S->C" : "CLIENT: C->S";
                }

                public void write(ChannelHandlerContext ctx, Object msg, ChannelPromise promise) throws Exception {
                    if (msg instanceof Packet) {
                        PacketBuffer buf = new PacketBuffer(Unpooled.buffer());
                        ((Packet)msg).writePacketData(buf);
                        FMLLog.log(Level.DEBUG, "%s %s:\n%s", this.prefix, msg.getClass().getSimpleName(), ByteBufUtils.getContentDump(buf));
                    }
                    ctx.write(msg, promise);
                }
            });
        } else {
            pipeline.replace("splitter", "splitter", (ChannelHandler)new NettyVarint21FrameDecoder(){
                String prefix;
                {
                    this.prefix = direction == EnumPacketDirection.SERVERBOUND ? "SERVER: C->S" : "CLIENT: S->C";
                }

                @Override
                protected void decode(ChannelHandlerContext context, ByteBuf input, List<Object> output) throws Exception {
                    super.decode(context, input, output);
                    for (ByteBuf byteBuf : output) {
                        byteBuf.markReaderIndex();
                        FMLLog.log(Level.DEBUG, "%s:\n%s", this.prefix, ByteBufUtils.getContentDump(byteBuf));
                        byteBuf.resetReaderIndex();
                    }
                }
            });
            pipeline.replace("prepender", "prepender", (ChannelHandler)new NettyVarint21FrameEncoder(){
                String prefix;
                {
                    this.prefix = direction == EnumPacketDirection.SERVERBOUND ? "SERVER: S->C" : "CLIENT: C->S";
                }

                @Override
                protected void encode(ChannelHandlerContext context, ByteBuf input, ByteBuf output) throws Exception {
                    input.markReaderIndex();
                    FMLLog.log(Level.DEBUG, "%s:\n%s", this.prefix, ByteBufUtils.getContentDump(input));
                    input.resetReaderIndex();
                    super.encode(context, input, output);
                }
            });
        }
    }
}

