/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.fml.common.network.internal;

import com.google.common.base.Throwables;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.SimpleChannelInboundHandler;
import net.minecraft.client.entity.EntityPlayerSP;
import net.minecraft.client.multiplayer.WorldClient;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityTracker;
import net.minecraft.network.INetHandler;
import net.minecraft.util.IThreadListener;
import net.minecraft.world.World;
import net.minecraftforge.fml.client.FMLClientHandler;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.common.FMLLog;
import net.minecraftforge.fml.common.Loader;
import net.minecraftforge.fml.common.ModContainer;
import net.minecraftforge.fml.common.network.NetworkRegistry;
import net.minecraftforge.fml.common.network.internal.FMLMessage;
import net.minecraftforge.fml.common.registry.EntityRegistry;
import net.minecraftforge.fml.common.registry.IEntityAdditionalSpawnData;
import net.minecraftforge.fml.common.registry.IThrowableEntity;
import org.apache.logging.log4j.Level;

public class EntitySpawnHandler
extends SimpleChannelInboundHandler<FMLMessage.EntityMessage> {
    protected void channelRead0(ChannelHandlerContext ctx, final FMLMessage.EntityMessage msg) throws Exception {
        IThreadListener thread = FMLCommonHandler.instance().getWorldThread((INetHandler)ctx.channel().attr(NetworkRegistry.NET_HANDLER).get());
        if (thread.isCallingFromMinecraftThread()) {
            this.process(msg);
        } else {
            thread.addScheduledTask(new Runnable(){

                @Override
                public void run() {
                    EntitySpawnHandler.this.process(msg);
                }
            });
        }
    }

    private void process(FMLMessage.EntityMessage msg) {
        if (msg.getClass().equals(FMLMessage.EntitySpawnMessage.class)) {
            this.spawnEntity((FMLMessage.EntitySpawnMessage)msg);
        }
    }

    private void spawnEntity(FMLMessage.EntitySpawnMessage spawnMsg) {
        ModContainer mc = Loader.instance().getIndexedModList().get(spawnMsg.modId);
        EntityRegistry.EntityRegistration er = EntityRegistry.instance().lookupModSpawn(mc, spawnMsg.modEntityTypeId);
        if (er == null) {
            throw new RuntimeException("Could not spawn mod entity ModID: " + spawnMsg.modId + " EntityID: " + spawnMsg.modEntityTypeId + " at ( " + spawnMsg.rawX + "," + spawnMsg.rawY + ", " + spawnMsg.rawZ + ") Please contact mod author or server admin.");
        }
        WorldClient wc = FMLClientHandler.instance().getWorldClient();
        Class<? extends Entity> cls = er.getEntityClass();
        try {
            Entity entity;
            if (er.hasCustomSpawning()) {
                entity = er.doCustomSpawning(spawnMsg);
            } else {
                Entity[] parts;
                entity = cls.getConstructor(World.class).newInstance(wc);
                int offset = spawnMsg.entityId - entity.getEntityId();
                entity.setEntityId(spawnMsg.entityId);
                entity.setUniqueId(spawnMsg.entityUUID);
                entity.setLocationAndAngles(spawnMsg.rawX, spawnMsg.rawY, spawnMsg.rawZ, spawnMsg.scaledYaw, spawnMsg.scaledPitch);
                if (entity instanceof EntityLiving) {
                    ((EntityLiving)entity).rotationYawHead = spawnMsg.scaledHeadYaw;
                }
                if ((parts = entity.getParts()) != null) {
                    for (int j = 0; j < parts.length; ++j) {
                        parts[j].setEntityId(parts[j].getEntityId() + offset);
                    }
                }
            }
            EntityTracker.updateServerPosition(entity, spawnMsg.rawX, spawnMsg.rawY, spawnMsg.rawZ);
            EntityPlayerSP clientPlayer = FMLClientHandler.instance().getClientPlayerEntity();
            if (entity instanceof IThrowableEntity) {
                EntityPlayerSP thrower = clientPlayer.getEntityId() == spawnMsg.throwerId ? clientPlayer : wc.getEntityByID(spawnMsg.throwerId);
                ((IThrowableEntity)((Object)entity)).setThrower(thrower);
            }
            if (spawnMsg.dataWatcherList != null) {
                entity.getDataManager().setEntryValues(spawnMsg.dataWatcherList);
            }
            if (spawnMsg.throwerId > 0) {
                entity.setVelocity(spawnMsg.speedScaledX, spawnMsg.speedScaledY, spawnMsg.speedScaledZ);
            }
            if (entity instanceof IEntityAdditionalSpawnData) {
                ((IEntityAdditionalSpawnData)((Object)entity)).readSpawnData(spawnMsg.dataStream);
            }
            wc.addEntityToWorld(spawnMsg.entityId, entity);
        }
        catch (Exception e) {
            FMLLog.log(Level.ERROR, e, "A severe problem occurred during the spawning of an entity at ( " + spawnMsg.rawX + "," + spawnMsg.rawY + ", " + spawnMsg.rawZ + ")", new Object[0]);
            throw Throwables.propagate((Throwable)e);
        }
    }

    public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) throws Exception {
        FMLLog.log(Level.ERROR, cause, "EntitySpawnHandler exception", new Object[0]);
        super.exceptionCaught(ctx, cause);
    }
}

