/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.fml.common.network.internal;

import com.google.common.base.Throwables;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import java.io.IOException;
import java.util.List;
import java.util.UUID;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.network.PacketBuffer;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraftforge.fml.common.FMLLog;
import net.minecraftforge.fml.common.ModContainer;
import net.minecraftforge.fml.common.network.ByteBufUtils;
import net.minecraftforge.fml.common.registry.EntityRegistry;
import net.minecraftforge.fml.common.registry.IEntityAdditionalSpawnData;
import net.minecraftforge.fml.common.registry.IThrowableEntity;
import net.minecraftforge.fml.relauncher.Side;
import org.apache.logging.log4j.Level;

public abstract class FMLMessage {
    abstract void toBytes(ByteBuf var1);

    abstract void fromBytes(ByteBuf var1);

    public static class EntitySpawnMessage
    extends EntityMessage {
        String modId;
        int modEntityTypeId;
        UUID entityUUID;
        double rawX;
        double rawY;
        double rawZ;
        float scaledYaw;
        float scaledPitch;
        float scaledHeadYaw;
        int throwerId;
        double speedScaledX;
        double speedScaledY;
        double speedScaledZ;
        List<EntityDataManager.DataEntry<?>> dataWatcherList;
        ByteBuf dataStream;

        public EntitySpawnMessage() {
        }

        public EntitySpawnMessage(EntityRegistry.EntityRegistration er, Entity entity, ModContainer modContainer) {
            super(entity);
            this.modId = modContainer.getModId();
            this.modEntityTypeId = er.getModEntityId();
        }

        @Override
        void toBytes(ByteBuf buf) {
            super.toBytes(buf);
            ByteBufUtils.writeUTF8String(buf, this.modId);
            buf.writeInt(this.modEntityTypeId);
            buf.writeLong(this.entity.getUniqueID().getMostSignificantBits());
            buf.writeLong(this.entity.getUniqueID().getLeastSignificantBits());
            buf.writeDouble(this.entity.posX);
            buf.writeDouble(this.entity.posY);
            buf.writeDouble(this.entity.posZ);
            buf.writeByte((int)((byte)(this.entity.rotationYaw * 256.0f / 360.0f)));
            buf.writeByte((int)((byte)(this.entity.rotationPitch * 256.0f / 360.0f)));
            if (this.entity instanceof EntityLivingBase) {
                buf.writeByte((int)((byte)(((EntityLivingBase)this.entity).rotationYawHead * 256.0f / 360.0f)));
            } else {
                buf.writeByte(0);
            }
            ByteBuf tmpBuf = Unpooled.buffer();
            PacketBuffer pb = new PacketBuffer(tmpBuf);
            try {
                this.entity.getDataManager().writeEntries(pb);
            }
            catch (IOException e) {
                FMLLog.log(Level.FATAL, e, "Encountered fatal exception trying to send entity spawn data watchers", new Object[0]);
                throw Throwables.propagate((Throwable)e);
            }
            buf.writeBytes(tmpBuf);
            if (this.entity instanceof IThrowableEntity) {
                Entity owner = ((IThrowableEntity)((Object)this.entity)).getThrower();
                buf.writeInt(owner == null ? this.entity.getEntityId() : owner.getEntityId());
                double maxVel = 3.9;
                double mX = this.entity.motionX;
                double mY = this.entity.motionY;
                double mZ = this.entity.motionZ;
                if (mX < -maxVel) {
                    mX = -maxVel;
                }
                if (mY < -maxVel) {
                    mY = -maxVel;
                }
                if (mZ < -maxVel) {
                    mZ = -maxVel;
                }
                if (mX > maxVel) {
                    mX = maxVel;
                }
                if (mY > maxVel) {
                    mY = maxVel;
                }
                if (mZ > maxVel) {
                    mZ = maxVel;
                }
                buf.writeInt((int)(mX * 8000.0));
                buf.writeInt((int)(mY * 8000.0));
                buf.writeInt((int)(mZ * 8000.0));
            } else {
                buf.writeInt(0);
            }
            if (this.entity instanceof IEntityAdditionalSpawnData) {
                tmpBuf = Unpooled.buffer();
                ((IEntityAdditionalSpawnData)((Object)this.entity)).writeSpawnData(tmpBuf);
                buf.writeBytes(tmpBuf);
            }
        }

        @Override
        void fromBytes(ByteBuf dat) {
            super.fromBytes(dat);
            this.modId = ByteBufUtils.readUTF8String(dat);
            this.modEntityTypeId = dat.readInt();
            this.entityUUID = new UUID(dat.readLong(), dat.readLong());
            this.rawX = dat.readDouble();
            this.rawY = dat.readDouble();
            this.rawZ = dat.readDouble();
            this.scaledYaw = (float)dat.readByte() * 360.0f / 256.0f;
            this.scaledPitch = (float)dat.readByte() * 360.0f / 256.0f;
            this.scaledHeadYaw = (float)dat.readByte() * 360.0f / 256.0f;
            try {
                this.dataWatcherList = EntityDataManager.readEntries(new PacketBuffer(dat));
            }
            catch (IOException e) {
                FMLLog.log(Level.FATAL, e, "There was a critical error decoding the datawatcher stream for a mod entity.", new Object[0]);
                throw Throwables.propagate((Throwable)e);
            }
            this.throwerId = dat.readInt();
            if (this.throwerId != 0) {
                this.speedScaledX = (double)dat.readInt() / 8000.0;
                this.speedScaledY = (double)dat.readInt() / 8000.0;
                this.speedScaledZ = (double)dat.readInt() / 8000.0;
            }
            this.dataStream = dat;
        }
    }

    public static abstract class EntityMessage
    extends FMLMessage {
        Entity entity;
        int entityId;

        public EntityMessage() {
        }

        EntityMessage(Entity entity) {
            this.entity = entity;
        }

        @Override
        void toBytes(ByteBuf buf) {
            buf.writeInt(this.entity.getEntityId());
        }

        @Override
        void fromBytes(ByteBuf buf) {
            this.entityId = buf.readInt();
        }
    }

    public static class OpenGui
    extends FMLMessage {
        int windowId;
        String modId;
        int modGuiId;
        int x;
        int y;
        int z;

        public OpenGui() {
        }

        OpenGui(int windowId, String modId, int modGuiId, int x, int y, int z) {
            this.windowId = windowId;
            this.modId = modId;
            this.modGuiId = modGuiId;
            this.x = x;
            this.y = y;
            this.z = z;
        }

        @Override
        void toBytes(ByteBuf buf) {
            buf.writeInt(this.windowId);
            ByteBufUtils.writeUTF8String(buf, this.modId);
            buf.writeInt(this.modGuiId);
            buf.writeInt(this.x);
            buf.writeInt(this.y);
            buf.writeInt(this.z);
        }

        @Override
        void fromBytes(ByteBuf buf) {
            this.windowId = buf.readInt();
            this.modId = ByteBufUtils.readUTF8String(buf);
            this.modGuiId = buf.readInt();
            this.x = buf.readInt();
            this.y = buf.readInt();
            this.z = buf.readInt();
        }
    }

    public static class CompleteHandshake
    extends FMLMessage {
        Side target;

        public CompleteHandshake() {
        }

        public CompleteHandshake(Side target) {
            this.target = target;
        }

        @Override
        void fromBytes(ByteBuf buf) {
            this.target = Side.values()[buf.readByte()];
        }

        @Override
        void toBytes(ByteBuf buf) {
            buf.writeByte(this.target.ordinal());
        }
    }
}

