/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.fml.common.registry;

import com.google.common.base.Throwables;
import java.lang.reflect.Constructor;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityList;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.registry.IForgeRegistryEntry;

public class EntityEntry
extends IForgeRegistryEntry.Impl<EntityEntry> {
    private Class<? extends Entity> cls;
    private String name;
    private EntityList.EntityEggInfo egg;
    private Constructor<?> ctr;

    public EntityEntry(Class<? extends Entity> cls, String name) {
        this.cls = cls;
        this.name = name;
        this.init();
    }

    protected void init() {
        try {
            this.ctr = this.cls.getConstructor(World.class);
        }
        catch (NoSuchMethodException e) {
            throw new RuntimeException("Invalid class " + this.cls + " no constructor taking " + World.class.getName());
        }
        catch (SecurityException e) {
            Throwables.propagate((Throwable)e);
        }
    }

    public Class<? extends Entity> getEntityClass() {
        return this.cls;
    }

    public String getName() {
        return this.name;
    }

    public EntityList.EntityEggInfo getEgg() {
        return this.egg;
    }

    public void setEgg(EntityList.EntityEggInfo egg) {
        this.egg = egg;
        if (this.getRegistryName() != null) {
            EntityList.ENTITY_EGGS.put(this.getRegistryName(), egg);
        }
    }

    public Entity newInstance(World world) {
        try {
            return (Entity)this.ctr.newInstance(world);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }
}

