/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.fml.common.registry;

import com.google.common.base.Function;
import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.BiMap;
import com.google.common.collect.HashBiMap;
import com.google.common.collect.ListMultimap;
import java.util.Iterator;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityList;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityTracker;
import net.minecraft.entity.EnumCreatureType;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.biome.Biome;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.common.FMLLog;
import net.minecraftforge.fml.common.ModContainer;
import net.minecraftforge.fml.common.network.internal.FMLMessage;
import net.minecraftforge.fml.common.registry.EntityEntry;
import net.minecraftforge.fml.common.registry.ForgeRegistries;
import org.apache.logging.log4j.Level;

public class EntityRegistry {
    private static final EntityRegistry INSTANCE = new EntityRegistry();
    private ListMultimap<ModContainer, EntityRegistration> entityRegistrations = ArrayListMultimap.create();
    private BiMap<Class<? extends Entity>, EntityRegistration> entityClassRegistrations = HashBiMap.create();

    public static EntityRegistry instance() {
        return INSTANCE;
    }

    private EntityRegistry() {
    }

    public static void registerModEntity(ResourceLocation registryName, Class<? extends Entity> entityClass, String entityName, int id, Object mod, int trackingRange, int updateFrequency, boolean sendsVelocityUpdates) {
        EntityRegistry.instance().doModEntityRegistration(registryName, entityClass, entityName, id, mod, trackingRange, updateFrequency, sendsVelocityUpdates);
    }

    public static void registerModEntity(ResourceLocation registryName, Class<? extends Entity> entityClass, String entityName, int id, Object mod, int trackingRange, int updateFrequency, boolean sendsVelocityUpdates, int eggPrimary, int eggSecondary) {
        EntityRegistry.instance().doModEntityRegistration(registryName, entityClass, entityName, id, mod, trackingRange, updateFrequency, sendsVelocityUpdates);
        EntityRegistry.registerEgg(registryName, eggPrimary, eggSecondary);
    }

    private void doModEntityRegistration(ResourceLocation registryName, Class<? extends Entity> entityClass, String entityName, int id, Object mod, int trackingRange, int updateFrequency, boolean sendsVelocityUpdates) {
        ModContainer mc = FMLCommonHandler.instance().findContainerFor(mod);
        EntityRegistration er = new EntityRegistration(mc, registryName, entityClass, entityName, id, trackingRange, updateFrequency, sendsVelocityUpdates);
        try {
            this.entityClassRegistrations.put(entityClass, (Object)er);
            if (!ForgeRegistries.ENTITIES.containsKey(registryName)) {
                EntityEntry entry = (EntityEntry)new EntityEntry(entityClass, entityName).setRegistryName(registryName);
                ForgeRegistries.ENTITIES.register(entry);
                FMLLog.finer("Automatically registered mod %s entity %s as %s", mc.getModId(), entityName, entry.getRegistryName());
            } else {
                FMLLog.fine("Skipping automatic mod %s entity registration for already registered entry %s class %s", mc.getModId(), registryName, entityClass.getName());
            }
        }
        catch (IllegalArgumentException e) {
            FMLLog.log(Level.WARN, e, "The mod %s tried to register the entity (registry,name,class) (%s,%s,%s) one or both of which are already registered", mc.getModId(), registryName, entityName, entityClass.getName());
            return;
        }
        this.entityRegistrations.put((Object)mc, (Object)er);
    }

    public static void registerEgg(ResourceLocation name, int primary, int secondary) {
        EntityEntry entry = ForgeRegistries.ENTITIES.getValue(name);
        if (entry == null) {
            FMLLog.bigWarning("Attempted to registry a entity egg for entity (%s) that is not in the Entity Registry", name);
            return;
        }
        entry.setEgg(new EntityList.EntityEggInfo(name, primary, secondary));
    }

    public static void addSpawn(Class<? extends EntityLiving> entityClass, int weightedProb, int min, int max, EnumCreatureType typeOfCreature, Biome ... biomes) {
        for (Biome biome : biomes) {
            List<Biome.SpawnListEntry> spawns = biome.getSpawnableList(typeOfCreature);
            boolean found = false;
            for (Biome.SpawnListEntry entry : spawns) {
                if (entry.entityClass != entityClass) continue;
                entry.itemWeight = weightedProb;
                entry.minGroupCount = min;
                entry.maxGroupCount = max;
                found = true;
                break;
            }
            if (found) continue;
            spawns.add(new Biome.SpawnListEntry(entityClass, weightedProb, min, max));
        }
    }

    public static void addSpawn(String entityName, int weightedProb, int min, int max, EnumCreatureType typeOfCreature, Biome ... biomes) {
        Class<?> entityClazz = null;
        if (EntityLiving.class.isAssignableFrom(entityClazz)) {
            EntityRegistry.addSpawn(entityClazz, weightedProb, min, max, typeOfCreature, biomes);
        }
    }

    public static void removeSpawn(Class<? extends EntityLiving> entityClass, EnumCreatureType typeOfCreature, Biome ... biomes) {
        for (Biome biome : biomes) {
            Iterator<Biome.SpawnListEntry> spawns = biome.getSpawnableList(typeOfCreature).iterator();
            while (spawns.hasNext()) {
                Biome.SpawnListEntry entry = spawns.next();
                if (entry.entityClass != entityClass) continue;
                spawns.remove();
            }
        }
    }

    public static void removeSpawn(String entityName, EnumCreatureType typeOfCreature, Biome ... biomes) {
        Class<?> entityClazz = null;
        if (EntityLiving.class.isAssignableFrom(entityClazz)) {
            EntityRegistry.removeSpawn(entityClazz, typeOfCreature, biomes);
        }
    }

    @Nullable
    public EntityRegistration lookupModSpawn(Class<? extends Entity> clazz, boolean keepLooking) {
        Class<? extends Entity> localClazz = clazz;
        do {
            EntityRegistration er;
            if ((er = (EntityRegistration)this.entityClassRegistrations.get(localClazz)) == null) continue;
            return er;
        } while (keepLooking &= !Object.class.equals(localClazz = localClazz.getSuperclass()));
        return null;
    }

    @Nullable
    public EntityRegistration lookupModSpawn(ModContainer mc, int modEntityId) {
        for (EntityRegistration er : this.entityRegistrations.get((Object)mc)) {
            if (er.getModEntityId() != modEntityId) continue;
            return er;
        }
        return null;
    }

    public boolean tryTrackingEntity(EntityTracker entityTracker, Entity entity) {
        EntityRegistration er = this.lookupModSpawn(entity.getClass(), true);
        if (er != null) {
            entityTracker.track(entity, er.getTrackingRange(), er.getUpdateFrequency(), er.sendsVelocityUpdates());
            return true;
        }
        return false;
    }

    @Nullable
    public static EntityEntry getEntry(Class<? extends Entity> entry) {
        for (EntityEntry e : ForgeRegistries.ENTITIES) {
            if (e.getEntityClass() != entry) continue;
            return e;
        }
        return null;
    }

    public class EntityRegistration {
        private Class<? extends Entity> entityClass;
        private ModContainer container;
        private ResourceLocation regName;
        private String entityName;
        private int modId;
        private int trackingRange;
        private int updateFrequency;
        private boolean sendsVelocityUpdates;
        private Function<FMLMessage.EntitySpawnMessage, Entity> customSpawnCallback;
        private boolean usesVanillaSpawning;

        public EntityRegistration(ModContainer mc, ResourceLocation registryName, Class<? extends Entity> entityClass, String entityName, int id, int trackingRange, int updateFrequency, boolean sendsVelocityUpdates) {
            this.container = mc;
            this.regName = registryName;
            this.entityClass = entityClass;
            this.entityName = entityName;
            this.modId = id;
            this.trackingRange = trackingRange;
            this.updateFrequency = updateFrequency;
            this.sendsVelocityUpdates = sendsVelocityUpdates;
        }

        public ResourceLocation getRegistryName() {
            return this.regName;
        }

        public Class<? extends Entity> getEntityClass() {
            return this.entityClass;
        }

        public ModContainer getContainer() {
            return this.container;
        }

        public String getEntityName() {
            return this.entityName;
        }

        public int getModEntityId() {
            return this.modId;
        }

        public int getTrackingRange() {
            return this.trackingRange;
        }

        public int getUpdateFrequency() {
            return this.updateFrequency;
        }

        public boolean sendsVelocityUpdates() {
            return this.sendsVelocityUpdates;
        }

        public boolean usesVanillaSpawning() {
            return this.usesVanillaSpawning;
        }

        public boolean hasCustomSpawning() {
            return this.customSpawnCallback != null;
        }

        public Entity doCustomSpawning(FMLMessage.EntitySpawnMessage spawnMsg) throws Exception {
            return (Entity)this.customSpawnCallback.apply((Object)spawnMsg);
        }

        public void setCustomSpawning(Function<FMLMessage.EntitySpawnMessage, Entity> callable, boolean usesVanillaSpawning) {
            this.customSpawnCallback = callable;
            this.usesVanillaSpawning = usesVanillaSpawning;
        }
    }
}

