/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.fml.common.registry;

import com.google.common.base.Joiner;
import com.google.common.base.Preconditions;
import com.google.common.collect.BiMap;
import com.google.common.collect.HashBiMap;
import com.google.common.collect.Iterators;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.registry.RegistryNamespacedDefaultedByKey;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.fml.common.FMLLog;
import net.minecraftforge.fml.common.functions.GenericIterableFactory;
import net.minecraftforge.fml.common.registry.ExistingSubstitutionException;
import net.minecraftforge.fml.common.registry.IForgeRegistry;
import net.minecraftforge.fml.common.registry.IForgeRegistryEntry;
import net.minecraftforge.fml.common.registry.IncompatibleSubstitutionException;
import net.minecraftforge.fml.common.registry.PersistentRegistryManager;
import net.minecraftforge.fml.common.registry.RegistryDelegate;
import net.minecraftforge.fml.relauncher.ReflectionHelper;
import org.apache.commons.lang3.Validate;
import org.apache.logging.log4j.Level;

public class FMLControlledNamespacedRegistry<I extends IForgeRegistryEntry<I>>
extends RegistryNamespacedDefaultedByKey<ResourceLocation, I>
implements IForgeRegistry<I> {
    public static final boolean DEBUG = Boolean.parseBoolean(System.getProperty("fml.debugRegistryEntries", "false"));
    private final Class<I> superType;
    private final boolean isDelegated;
    @Nullable
    private ResourceLocation optionalDefaultKey;
    @Nullable
    private I optionalDefaultObject;
    private int maxId;
    private int minId;
    private final Map<ResourceLocation, ResourceLocation> aliases = Maps.newHashMap();
    private final BiMap<ResourceLocation, I> persistentSubstitutions = HashBiMap.create();
    private final BiMap<ResourceLocation, I> substitutionOriginals = HashBiMap.create();
    private final BiMap<ResourceLocation, I> activeSubstitutions = HashBiMap.create();
    private final Set<Integer> blockedIds = Sets.newHashSet();
    private final Set<ResourceLocation> dummiedLocations = Sets.newHashSet();
    private final BitSet availabilityMap;
    private final Map<ResourceLocation, ?> slaves = Maps.newHashMap();
    @Nullable
    private final IForgeRegistry.AddCallback<I> addCallback;
    @Nullable
    private final IForgeRegistry.ClearCallback<I> clearCallback;
    @Nullable
    private final IForgeRegistry.CreateCallback<I> createCallback;
    @Nullable
    private final IForgeRegistry.SubstitutionCallback<I> substitutionCallback;

    FMLControlledNamespacedRegistry(@Nullable ResourceLocation defaultKey, int minIdValue, int maxIdValue, Class<I> type, BiMap<ResourceLocation, ? extends IForgeRegistry<?>> registries, @Nullable IForgeRegistry.AddCallback<I> addCallback, @Nullable IForgeRegistry.ClearCallback<I> clearCallback, @Nullable IForgeRegistry.CreateCallback<I> createCallback, @Nullable IForgeRegistry.SubstitutionCallback<I> substitutionCallback) {
        super(defaultKey);
        this.superType = type;
        this.optionalDefaultKey = defaultKey;
        this.minId = minIdValue;
        this.maxId = maxIdValue;
        this.availabilityMap = new BitSet(Math.min(maxIdValue + 1, 65535));
        this.isDelegated = IForgeRegistryEntry.Impl.class.isAssignableFrom(type);
        this.addCallback = addCallback;
        this.clearCallback = clearCallback;
        this.createCallback = createCallback;
        this.substitutionCallback = substitutionCallback;
        if (createCallback != null) {
            createCallback.onCreate(this.slaves, registries);
        }
    }

    void validateContent(ResourceLocation registryName) {
        try {
            ReflectionHelper.findMethod(BitSet.class, this.availabilityMap, new String[]{"trimToSize"}, new Class[0]).invoke((Object)this.availabilityMap, new Object[0]);
        }
        catch (Exception exception) {
            // empty catch block
        }
        for (IForgeRegistryEntry obj : this.typeSafeIterable()) {
            int id = this.getId(obj);
            ResourceLocation name = this.getNameForObject((I)obj);
            boolean isSubstituted = this.activeSubstitutions.containsKey((Object)name);
            if (name == null) {
                throw new IllegalStateException(String.format("Registry entry for %s %s, id %d, doesn't yield a name.", registryName, obj, id));
            }
            if (!isSubstituted && id < 0) {
                throw new IllegalStateException(String.format("Registry entry for %s %s, name %s, doesn't yield an id.", registryName, obj, name));
            }
            if (id > this.maxId) {
                throw new IllegalStateException(String.format("Registry entry for %s %s, name %s uses the too large id %d.", registryName, obj, name, id));
            }
            if (isSubstituted) continue;
            if (this.getRaw(id) != obj) {
                throw new IllegalStateException(String.format("Registry entry for id %d, name %s, doesn't yield the expected %s %s.", id, name, registryName, obj));
            }
            if (this.getRaw(name) != obj) {
                throw new IllegalStateException(String.format("Registry entry for name %s, id %d, doesn't yield the expected %s %s.", name, id, registryName, obj));
            }
            if (this.getId(name) == id) continue;
            throw new IllegalStateException(String.format("Registry entry for name %s doesn't yield the expected id %d.", name, id));
        }
    }

    void set(FMLControlledNamespacedRegistry<I> otherRegistry) {
        if (this.superType != otherRegistry.superType) {
            throw new IllegalArgumentException("incompatible registry");
        }
        HashMap slaves = Maps.newHashMap(this.slaves);
        slaves.put(PersistentRegistryManager.SUBSTITUTION_ORIGINALS, this.substitutionOriginals);
        if (this.clearCallback != null) {
            this.clearCallback.onClear(this, slaves);
        }
        this.optionalDefaultKey = otherRegistry.optionalDefaultKey;
        this.maxId = otherRegistry.maxId;
        this.minId = otherRegistry.minId;
        this.aliases.clear();
        this.aliases.putAll(otherRegistry.aliases);
        this.persistentSubstitutions.clear();
        this.persistentSubstitutions.putAll(otherRegistry.getPersistentSubstitutions());
        this.activeSubstitutions.clear();
        this.dummiedLocations.clear();
        this.dummiedLocations.addAll(otherRegistry.dummiedLocations);
        this.underlyingIntegerMap.clear();
        this.registryObjects.clear();
        for (IForgeRegistryEntry thing : otherRegistry.typeSafeIterable()) {
            this.addObjectRaw(otherRegistry.getId(thing), otherRegistry.getNameForObject(thing), thing);
        }
        for (ResourceLocation resloc : otherRegistry.activeSubstitutions.keySet()) {
            this.activateSubstitution(resloc);
        }
        this.substitutionOriginals.clear();
        this.substitutionOriginals.putAll(otherRegistry.substitutionOriginals);
    }

    @Override
    @Deprecated
    public void register(int id, @Nonnull ResourceLocation name, @Nonnull I thing) {
        this.add(id, name, thing);
    }

    @Override
    @Deprecated
    public void putObject(@Nonnull ResourceLocation name, @Nonnull I thing) {
        Preconditions.checkNotNull((Object)name, (Object)"Can't use a null-name for the registry.");
        Preconditions.checkNotNull(thing, (Object)"Can't add null-object to the registry.");
        ResourceLocation existingName = this.getNameForObject(thing);
        if (existingName == null) {
            FMLLog.bigWarning("Ignoring putObject(%s, %s), not resolvable", name, thing);
        } else if (existingName.equals(name)) {
            FMLLog.bigWarning("Ignoring putObject(%s, %s), already added", name, thing);
        } else {
            FMLLog.bigWarning("Ignoring putObject(%s, %s), adding alias to %s instead", name, thing, existingName);
            this.addAlias(name, existingName);
        }
    }

    @Override
    @Nullable
    public I getObject(ResourceLocation name) {
        I object = this.getRaw(name);
        return object == null ? this.optionalDefaultObject : object;
    }

    @Override
    @Nullable
    public I getObjectById(int id) {
        I object = this.getRaw(id);
        return object == null ? this.optionalDefaultObject : object;
    }

    public int getId(@Nullable I thing) {
        return this.getIDForObjectBypass(thing);
    }

    @Nullable
    public I getRaw(int id) {
        return (I)((IForgeRegistryEntry)super.getObjectById(id));
    }

    @Nullable
    private I getRaw(ResourceLocation name) {
        IForgeRegistryEntry ret = (IForgeRegistryEntry)super.getObject(name);
        if (ret == null && (name = this.aliases.get(name)) != null) {
            return this.getRaw(name);
        }
        return (I)ret;
    }

    @Override
    public boolean containsKey(@Nonnull ResourceLocation name) {
        boolean ret = super.containsKey(name);
        if (!ret && (name = this.aliases.get(name)) != null) {
            return this.containsKey(name);
        }
        return ret;
    }

    public int getId(ResourceLocation itemName) {
        I obj = this.getRaw(itemName);
        if (obj == null) {
            return -1;
        }
        return this.getId(obj);
    }

    public Iterable<I> typeSafeIterable() {
        return GenericIterableFactory.newCastingIterable(super.iterator(), this.superType);
    }

    public void serializeIds(Map<ResourceLocation, Integer> idMapping) {
        for (IForgeRegistryEntry thing : this.typeSafeIterable()) {
            idMapping.put(this.getNameForObject((I)thing), this.getId(thing));
        }
    }

    public void serializeAliases(Map<ResourceLocation, ResourceLocation> map) {
        map.putAll(this.aliases);
    }

    public void serializeSubstitutions(Set<ResourceLocation> set) {
        set.addAll(this.activeSubstitutions.keySet());
    }

    public void serializeDummied(Set<ResourceLocation> set) {
        set.addAll(this.dummiedLocations);
    }

    public boolean isDummied(ResourceLocation key) {
        return this.dummiedLocations.contains(key);
    }

    int add(int id, @Nonnull ResourceLocation name, @Nonnull I thing) {
        Preconditions.checkNotNull((Object)name, (String)"Can't use a null-name for the registry, object %s.", (Object[])new Object[]{thing});
        Preconditions.checkNotNull(thing, (String)"Can't add null-object to the registry, name %s.", (Object[])new Object[]{name});
        if (this.optionalDefaultKey != null && this.optionalDefaultKey.equals(name) && this.optionalDefaultObject == null) {
            this.optionalDefaultObject = thing;
        }
        if (this.getPersistentSubstitutions().containsValue(thing)) {
            throw new IllegalArgumentException(String.format("The object %s (%s) cannot be added to the registry. It is already being used as a substitute for %s", thing.getClass(), name, this.getPersistentSubstitutions().inverse().get(thing)));
        }
        int idToUse = id;
        if (idToUse < 0 || this.availabilityMap.get(idToUse)) {
            idToUse = this.availabilityMap.nextClearBit(this.minId);
        }
        if (idToUse > this.maxId) {
            throw new RuntimeException(String.format("Invalid id %d - maximum id range exceeded.", idToUse));
        }
        if (this.getRaw(name) == thing) {
            FMLLog.bigWarning("The object %s has been registered twice for the same name %s.", thing, name);
            return this.getId(thing);
        }
        if (this.getRaw(name) != null) {
            throw new IllegalArgumentException(String.format("The name %s has been registered twice, for %s and %s.", name, this.getRaw(name), thing));
        }
        if (this.getId(thing) >= 0) {
            int foundId = this.getId(thing);
            I otherThing = this.getRaw(foundId);
            throw new IllegalArgumentException(String.format("The object %s{%x} has been registered twice, using the names %s and %s. (Other object at this id is %s{%x})", thing, System.identityHashCode(thing), this.getNameForObject((I)thing), name, otherThing, System.identityHashCode(otherThing)));
        }
        if (PersistentRegistryManager.isFrozen(this)) {
            FMLLog.bigWarning("The object %s (name %s) is being added too late.", thing, name);
        }
        if (this.activeSubstitutions.containsKey((Object)name)) {
            I oldThing = thing;
            thing = (IForgeRegistryEntry)this.activeSubstitutions.get((Object)name);
            if (DEBUG) {
                FMLLog.getLogger().log(Level.DEBUG, "Active substitution: {} {}@{} -> {}@{}", new Object[]{name, oldThing.getClass().getName(), System.identityHashCode(oldThing), thing.getClass().getName(), System.identityHashCode(thing)});
            }
        }
        this.addObjectRaw(idToUse, name, thing);
        if (this.isDelegated) {
            this.getExistingDelegate(thing).setName(name);
        }
        if (this.dummiedLocations.remove(name) && DEBUG) {
            FMLLog.fine("Registry Dummy Remove: %s", name);
        }
        if (DEBUG) {
            FMLLog.finer("Registry add: %s %d %s (req. id %d)", name, idToUse, thing, id);
        }
        return idToUse;
    }

    void markDummy(ResourceLocation rl, Integer id, I thing) {
        if (DEBUG) {
            FMLLog.finer("Registry Dummy Add: %s %d -> %s", rl, id, thing);
        }
        this.dummiedLocations.add(rl);
        this.addObjectRaw(id, rl, thing);
    }

    void addAlias(ResourceLocation from, ResourceLocation to) {
        this.aliases.put(from, to);
        if (DEBUG) {
            FMLLog.finer("Registry alias: %s -> %s", from, to);
        }
    }

    Map<ResourceLocation, Integer> getEntriesNotIn(FMLControlledNamespacedRegistry<I> registry) {
        HashMap<ResourceLocation, Integer> ret = new HashMap<ResourceLocation, Integer>();
        for (IForgeRegistryEntry thing : this.typeSafeIterable()) {
            if (registry.inverseObjectRegistry.containsKey(thing) || registry.activeSubstitutions.containsKey((Object)this.getNameForObject((I)thing))) continue;
            ret.put(this.getNameForObject((I)thing), this.getId(thing));
        }
        return ret;
    }

    void dump(ResourceLocation registryName) {
        if (!DEBUG) {
            return;
        }
        ArrayList<Integer> ids = new ArrayList<Integer>();
        for (IForgeRegistryEntry thing : this.typeSafeIterable()) {
            ids.add(this.getId(thing));
        }
        Collections.sort(ids);
        FMLLog.finer("Registry Name : {}", registryName);
        Iterator<Object> iterator = ids.iterator();
        while (iterator.hasNext()) {
            int id = (Integer)iterator.next();
            I thing = this.getRaw(id);
            FMLLog.finer("Registry: %d %s %s", id, this.getNameForObject(thing), thing);
        }
    }

    private void addObjectRaw(int id, ResourceLocation name, I thing) {
        Preconditions.checkNotNull((Object)name, (Object)"The name to be added to the registry is null. This can only happen with a corrupted registry state. Reflection/ASM hackery? Registry bug?");
        Preconditions.checkNotNull(thing, (Object)"The object to be added to the registry is null. This can only happen with a corrupted registry state. Reflection/ASM hackery? Registry bug?");
        Preconditions.checkState((boolean)this.superType.isInstance(thing), (Object)"The object to be added to the registry is not of the right type. Reflection/ASM hackery? Registry bug?");
        this.underlyingIntegerMap.put(thing, id);
        super.putObject(name, thing);
        this.availabilityMap.set(id);
        if (this.addCallback != null) {
            this.addCallback.onAdd(thing, id, this.slaves);
        }
    }

    @Nullable
    public I getDefaultValue() {
        return this.optionalDefaultObject;
    }

    public RegistryDelegate<I> getDelegate(I thing, Class<I> clazz) {
        return new RegistryDelegate.Delegate<I>(thing, clazz);
    }

    @Nonnull
    private RegistryDelegate.Delegate<I> getExistingDelegate(I thing) {
        if (this.isDelegated) {
            return (RegistryDelegate.Delegate)((IForgeRegistryEntry.Impl)thing).delegate;
        }
        throw new IllegalStateException("Tried to get existing delegate from registry that is not delegated.");
    }

    @Nullable
    I activateSubstitution(ResourceLocation nameToReplace) {
        if (this.getPersistentSubstitutions().containsKey((Object)nameToReplace)) {
            I original = this.getRaw(nameToReplace);
            IForgeRegistryEntry sub = (IForgeRegistryEntry)this.getPersistentSubstitutions().get((Object)nameToReplace);
            this.getExistingDelegate(original).changeReference(sub);
            this.activeSubstitutions.put((Object)nameToReplace, (Object)sub);
            int id = this.getIDForObjectBypass(original);
            this.addObjectRaw(id, nameToReplace, sub);
            this.substitutionOriginals.put((Object)nameToReplace, original);
            if (this.substitutionCallback != null) {
                this.substitutionCallback.onSubstituteActivated(this.slaves, original, sub, nameToReplace);
            }
            return original;
        }
        return null;
    }

    void addSubstitutionAlias(String modId, ResourceLocation nameToReplace, I replacement) throws ExistingSubstitutionException {
        if (this.getPersistentSubstitutions().containsKey((Object)nameToReplace) || this.getPersistentSubstitutions().containsValue(replacement)) {
            FMLLog.severe("The substitution of %s has already occurred. You cannot duplicate substitutions", nameToReplace);
            throw new ExistingSubstitutionException(nameToReplace, replacement);
        }
        I original = this.getRaw(nameToReplace);
        if (original == null) {
            throw new NullPointerException("The replacement target is not present. This won't work");
        }
        if (!original.getClass().isAssignableFrom(replacement.getClass())) {
            FMLLog.severe("The substitute %s for %s (type %s) is type incompatible. This won't work", replacement.getClass().getName(), nameToReplace, original.getClass().getName());
            throw new IncompatibleSubstitutionException(nameToReplace, replacement, original);
        }
        int existingId = this.getId(replacement);
        if (existingId != -1) {
            FMLLog.severe("The substitute %s for %s is registered into the game independently. This won't work", replacement.getClass().getName(), nameToReplace);
            throw new IllegalArgumentException("The object substitution is already registered. This won't work");
        }
        FMLLog.log(Level.DEBUG, "Adding substitution %s with %s (name %s)", original, replacement, nameToReplace);
        this.getPersistentSubstitutions().put((Object)nameToReplace, replacement);
    }

    BiMap<ResourceLocation, I> getPersistentSubstitutions() {
        return this.persistentSubstitutions;
    }

    @Override
    public void validateKey() {
        if (this.optionalDefaultKey != null) {
            Validate.notNull(this.optionalDefaultObject);
        }
    }

    @Override
    @Nonnull
    public Iterator<I> iterator() {
        return Iterators.concat(super.iterator(), this.getPersistentSubstitutions().values().iterator());
    }

    FMLControlledNamespacedRegistry<I> makeShallowCopy(BiMap<ResourceLocation, ? extends IForgeRegistry<?>> registries) {
        return new FMLControlledNamespacedRegistry<I>(this.optionalDefaultKey, this.minId, this.maxId, this.superType, registries, this.addCallback, this.clearCallback, this.createCallback, this.substitutionCallback);
    }

    void resetSubstitutionDelegates() {
        if (!this.isDelegated) {
            return;
        }
        for (IForgeRegistryEntry obj : this.typeSafeIterable()) {
            RegistryDelegate.Delegate<IForgeRegistryEntry> delegate = this.getExistingDelegate(obj);
            delegate.changeReference(obj);
        }
    }

    public <T extends IForgeRegistryEntry<T>> FMLControlledNamespacedRegistry<T> asType(Class<? extends T> type) {
        return this;
    }

    public void serializeBlockList(Set<Integer> blocked) {
        blocked.addAll(this.blockedIds);
    }

    public Set<? extends ResourceLocation> getActiveSubstitutions() {
        return this.activeSubstitutions.keySet();
    }

    public void loadAliases(Map<ResourceLocation, ResourceLocation> aliases) {
        for (Map.Entry<ResourceLocation, ResourceLocation> alias : aliases.entrySet()) {
            this.addAlias(alias.getKey(), alias.getValue());
        }
    }

    public void loadSubstitutions(Set<ResourceLocation> substitutions) {
        for (ResourceLocation rl : substitutions) {
            this.activateSubstitution(rl);
        }
    }

    public void loadBlocked(Set<Integer> blocked) {
        for (Integer id : blocked) {
            this.blockedIds.add(id);
            this.availabilityMap.set(id);
        }
    }

    public void loadDummied(Set<ResourceLocation> dummied) {
        if (DEBUG && dummied.size() > 0) {
            FMLLog.fine("Registry Dummy Load: [%s]", Joiner.on((String)", ").join(dummied));
        }
        this.dummiedLocations.addAll(dummied);
    }

    public void loadIds(Map<ResourceLocation, Integer> ids, Map<ResourceLocation, Integer> missingIds, Map<ResourceLocation, Integer[]> remappedIds, FMLControlledNamespacedRegistry<I> currentRegistry, ResourceLocation registryName) {
        for (Map.Entry<ResourceLocation, Integer> entry : ids.entrySet()) {
            Object obj;
            ResourceLocation itemName = entry.getKey();
            int newId = entry.getValue();
            int currId = currentRegistry.getId(itemName);
            if (currId == -1) {
                FMLLog.info("Found a missing id from the world %s", itemName);
                missingIds.put(itemName, newId);
                continue;
            }
            if (currId != newId) {
                FMLLog.fine("Fixed %s id mismatch %s: %d (init) -> %d (map).", registryName, itemName, currId, newId);
                remappedIds.put(itemName, new Integer[]{currId, newId});
            }
            Preconditions.checkState(((obj = super.getRaw(itemName)) != null ? 1 : 0) != 0, (Object)"objectKey has an ID but no object. Reflection/ASM hackery? Registry bug?");
            I sub = obj;
            if (currentRegistry.substitutionOriginals.containsKey((Object)itemName)) {
                obj = (IForgeRegistryEntry)currentRegistry.substitutionOriginals.get((Object)itemName);
            }
            this.add(newId, itemName, obj);
            if (!currentRegistry.substitutionOriginals.containsKey((Object)itemName) || this.substitutionCallback == null) continue;
            this.substitutionCallback.onSubstituteActivated(this.slaves, sub, obj, itemName);
        }
    }

    public void blockId(int id) {
        this.blockedIds.add(id);
    }

    public void notifyCallbacks() {
        if (this.addCallback == null) {
            return;
        }
        for (IForgeRegistryEntry i : this.underlyingIntegerMap) {
            this.addCallback.onAdd(i, this.underlyingIntegerMap.add(i), this.slaves);
        }
    }

    @Override
    @Nullable
    public ResourceLocation getNameForObject(@Nonnull I p_177774_1_) {
        ResourceLocation rl = (ResourceLocation)super.getNameForObjectBypass(p_177774_1_);
        if (rl == null) {
            rl = (ResourceLocation)this.activeSubstitutions.inverse().get(p_177774_1_);
        }
        return rl;
    }

    @Override
    public Class<I> getRegistrySuperType() {
        return this.superType;
    }

    @Override
    public void register(@Nonnull I value) {
        ResourceLocation key = value.getRegistryName();
        if (key == null) {
            FMLLog.severe("Attempted to register a entry with a null name: %s", value);
            throw new NullPointerException(String.format("Attempted to register a entry with a null name: %s", value));
        }
        this.add(-1, key, value);
    }

    @Override
    public void registerAll(I ... values) {
        for (I value : values) {
            this.register(value);
        }
    }

    @Override
    public boolean containsValue(@Nonnull I value) {
        return this.getKey(value) != null;
    }

    @Override
    public I getValue(ResourceLocation key) {
        return this.getObject(key);
    }

    @Override
    @Nullable
    public ResourceLocation getKey(I value) {
        return this.getNameForObject(value);
    }

    @Override
    @Nonnull
    public Set<ResourceLocation> getKeys() {
        return super.getKeys();
    }

    @Override
    @Nonnull
    public List<I> getValues() {
        return Lists.newArrayList(this.iterator());
    }

    @Override
    @Nonnull
    public Set<Map.Entry<ResourceLocation, I>> getEntries() {
        return Sets.newHashSet((Iterator)new Iterator<Map.Entry<ResourceLocation, I>>(){
            Iterator<I> itr;
            {
                this.itr = FMLControlledNamespacedRegistry.this.iterator();
            }

            @Override
            public boolean hasNext() {
                return this.itr.hasNext();
            }

            @Override
            public Map.Entry<ResourceLocation, I> next() {
                final IForgeRegistryEntry value = (IForgeRegistryEntry)this.itr.next();
                final ResourceLocation key = FMLControlledNamespacedRegistry.this.getKey(value);
                return new Map.Entry<ResourceLocation, I>(){

                    @Override
                    public ResourceLocation getKey() {
                        return key;
                    }

                    @Override
                    public I getValue() {
                        return value;
                    }

                    @Override
                    public I setValue(I value2) {
                        throw new UnsupportedOperationException("Setting the value in an iterator is not allowed");
                    }
                };
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException("This is a READ ONLY view of this registry.");
            }
        });
    }

    @Override
    public <T> T getSlaveMap(ResourceLocation slaveMapName, Class<T> type) {
        return (T)this.slaves.get(slaveMapName);
    }

    RegistryEvent.Register<I> buildRegistryRegisterEvent(ResourceLocation location) {
        return new RegistryEvent.Register(location, this);
    }
}

