/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.fml.common.registry;

import com.google.common.base.Throwables;
import com.google.common.collect.BiMap;
import com.google.common.collect.HashBiMap;
import java.lang.reflect.Field;
import java.util.Map;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.entity.EntityList;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.potion.Potion;
import net.minecraft.potion.PotionType;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ObjectIntIdentityMap;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraft.world.biome.Biome;
import net.minecraftforge.fml.common.FMLLog;
import net.minecraftforge.fml.common.Loader;
import net.minecraftforge.fml.common.registry.EntityEntry;
import net.minecraftforge.fml.common.registry.ExistingSubstitutionException;
import net.minecraftforge.fml.common.registry.FMLControlledNamespacedRegistry;
import net.minecraftforge.fml.common.registry.FinalFieldHelper;
import net.minecraftforge.fml.common.registry.GameRegistry;
import net.minecraftforge.fml.common.registry.IForgeRegistry;
import net.minecraftforge.fml.common.registry.IForgeRegistryEntry;
import net.minecraftforge.fml.common.registry.LegacyNamespacedRegistry;
import net.minecraftforge.fml.common.registry.PersistentRegistryManager;
import net.minecraftforge.fml.common.registry.RegistryBuilder;
import net.minecraftforge.fml.common.registry.RegistryDelegate;
import net.minecraftforge.fml.relauncher.ReflectionHelper;
import org.apache.logging.log4j.Level;

public class GameData {
    private static final int MIN_BLOCK_ID = 0;
    private static final int MAX_BLOCK_ID = 4095;
    private static final int MIN_ITEM_ID = 4096;
    private static final int MAX_ITEM_ID = 31999;
    private static final int MIN_POTION_ID = 0;
    private static final int MAX_POTION_ID = 255;
    private static final int MIN_BIOME_ID = 0;
    private static final int MAX_BIOME_ID = 255;
    private static final int MIN_SOUND_ID = 0;
    private static final int MAX_SOUND_ID = 0x3FFFFFF;
    private static final int MIN_POTIONTYPE_ID = 0;
    private static final int MAX_POTIONTYPE_ID = 0x3FFFFFF;
    private static final int MIN_ENCHANTMENT_ID = 0;
    private static final int MAX_ENCHANTMENT_ID = 32766;
    private static final int MIN_ENTITY_ID = 0;
    private static final int MAX_ENTITY_ID = 0x3FFFFFF;
    private static final ResourceLocation BLOCK_TO_ITEM = new ResourceLocation("minecraft:blocktoitemmap");
    private static final ResourceLocation BLOCKSTATE_TO_ID = new ResourceLocation("minecraft:blockstatetoid");
    private static final GameData mainData = new GameData();
    private static Field blockField;
    private final FMLControlledNamespacedRegistry<Block> iBlockRegistry = PersistentRegistryManager.createRegistry(PersistentRegistryManager.BLOCKS, Block.class, new ResourceLocation("minecraft:air"), 0, 4095, true, BlockCallbacks.INSTANCE, BlockCallbacks.INSTANCE, BlockCallbacks.INSTANCE, BlockCallbacks.INSTANCE);
    private final FMLControlledNamespacedRegistry<Item> iItemRegistry = PersistentRegistryManager.createRegistry(PersistentRegistryManager.ITEMS, Item.class, null, 4096, 31999, true, ItemCallbacks.INSTANCE, ItemCallbacks.INSTANCE, ItemCallbacks.INSTANCE, ItemCallbacks.INSTANCE);
    private final FMLControlledNamespacedRegistry<Potion> iPotionRegistry = PersistentRegistryManager.createRegistry(PersistentRegistryManager.POTIONS, Potion.class, null, 0, 255, false, PotionCallbacks.INSTANCE, PotionCallbacks.INSTANCE, PotionCallbacks.INSTANCE, null);
    private final FMLControlledNamespacedRegistry<Biome> iBiomeRegistry = PersistentRegistryManager.createRegistry(PersistentRegistryManager.BIOMES, Biome.class, null, 0, 255, false, BiomeCallbacks.INSTANCE, BiomeCallbacks.INSTANCE, BiomeCallbacks.INSTANCE, null);
    private final FMLControlledNamespacedRegistry<SoundEvent> iSoundEventRegistry = PersistentRegistryManager.createRegistry(PersistentRegistryManager.SOUNDEVENTS, SoundEvent.class, null, 0, 0x3FFFFFF, false, null, null, null, null);
    private final FMLControlledNamespacedRegistry<PotionType> iPotionTypeRegistry;
    private final FMLControlledNamespacedRegistry<Enchantment> iEnchantmentRegistry;
    private final FMLControlledNamespacedRegistry<EntityEntry> iEntityRegistry;
    private final LegacyNamespacedRegistry<Class<? extends TileEntity>> iTileEntityRegistry;

    public GameData() {
        ResourceLocation WATER = new ResourceLocation("water");
        this.iPotionTypeRegistry = PersistentRegistryManager.createRegistry(PersistentRegistryManager.POTIONTYPES, PotionType.class, WATER, 0, 0x3FFFFFF, false, null, null, null, null);
        this.iEnchantmentRegistry = PersistentRegistryManager.createRegistry(PersistentRegistryManager.ENCHANTMENTS, Enchantment.class, null, 0, 32766, false, null, null, null, null);
        this.iEntityRegistry = (FMLControlledNamespacedRegistry)new RegistryBuilder().setName(PersistentRegistryManager.ENTITIES).setType(EntityEntry.class).setIDRange(0, 0x3FFFFFF).addCallback(EntityCallbacks.INSTANCE).create();
        try {
            blockField = FinalFieldHelper.makeWritable(ReflectionHelper.findField(ItemBlock.class, "block", "field_150939_a"));
        }
        catch (Exception e) {
            FMLLog.log(Level.FATAL, e, "Cannot access the 'block' field from ItemBlock, this is fatal!", new Object[0]);
            throw Throwables.propagate((Throwable)e);
        }
        this.iTileEntityRegistry = new LegacyNamespacedRegistry();
    }

    @Deprecated
    public static FMLControlledNamespacedRegistry<Block> getBlockRegistry() {
        return GameData.getMain().iBlockRegistry;
    }

    @Deprecated
    public static FMLControlledNamespacedRegistry<Item> getItemRegistry() {
        return GameData.getMain().iItemRegistry;
    }

    @Deprecated
    public static FMLControlledNamespacedRegistry<Potion> getPotionRegistry() {
        return GameData.getMain().iPotionRegistry;
    }

    @Deprecated
    public static FMLControlledNamespacedRegistry<Biome> getBiomeRegistry() {
        return GameData.getMain().iBiomeRegistry;
    }

    @Deprecated
    public static FMLControlledNamespacedRegistry<SoundEvent> getSoundEventRegistry() {
        return GameData.getMain().iSoundEventRegistry;
    }

    @Deprecated
    public static FMLControlledNamespacedRegistry<PotionType> getPotionTypesRegistry() {
        return GameData.getMain().iPotionTypeRegistry;
    }

    @Deprecated
    public static FMLControlledNamespacedRegistry<Enchantment> getEnchantmentRegistry() {
        return GameData.getMain().iEnchantmentRegistry;
    }

    @Deprecated
    public static LegacyNamespacedRegistry<Class<? extends TileEntity>> getTileEntityRegistry() {
        return GameData.getMain().iTileEntityRegistry;
    }

    @Deprecated
    public static FMLControlledNamespacedRegistry<EntityEntry> getEntityRegistry() {
        return GameData.getMain().iEntityRegistry;
    }

    @Deprecated
    static Item findItem(String modId, String name) {
        return GameData.getMain().iItemRegistry.getObject(new ResourceLocation(modId, name));
    }

    @Deprecated
    static Block findBlock(String modId, String name) {
        return GameData.getMain().iBlockRegistry.getObject(new ResourceLocation(modId, name));
    }

    protected static GameData getMain() {
        return mainData;
    }

    void registerSubstitutionAlias(String name, GameRegistry.Type type, Object toReplace) throws ExistingSubstitutionException {
        ResourceLocation nameToSubstitute = new ResourceLocation(name);
        BiMap<Block, Item> blockItemMap = GameData.getBlockItemMap();
        if (type == GameRegistry.Type.BLOCK) {
            this.iBlockRegistry.addSubstitutionAlias(Loader.instance().activeModContainer().getModId(), nameToSubstitute, (Block)toReplace);
            this.iBlockRegistry.activateSubstitution(nameToSubstitute);
        } else if (type == GameRegistry.Type.ITEM) {
            this.iItemRegistry.addSubstitutionAlias(Loader.instance().activeModContainer().getModId(), nameToSubstitute, (Item)toReplace);
            this.iItemRegistry.activateSubstitution(nameToSubstitute);
        }
    }

    public static BiMap<Block, Item> getBlockItemMap() {
        return GameData.getMain().iItemRegistry.getSlaveMap(BLOCK_TO_ITEM, BiMap.class);
    }

    static <K extends IForgeRegistryEntry<K>> K register_impl(Object object, ResourceLocation location) {
        if (object == null) {
            FMLLog.getLogger().log(Level.ERROR, "Attempt to register a null object");
            throw new NullPointerException("Attempt to register a null object");
        }
        ((IForgeRegistryEntry)object).setRegistryName(location);
        return GameData.register_impl(object);
    }

    static <K extends IForgeRegistryEntry<K>> K register_impl(Object object) {
        IForgeRegistryEntry castedObj = (IForgeRegistryEntry)object;
        if (object == null) {
            FMLLog.getLogger().log(Level.ERROR, "Attempt to register a null object");
            throw new NullPointerException("Attempt to register a null object");
        }
        if (castedObj.getRegistryName() == null) {
            FMLLog.getLogger().log(Level.ERROR, "Attempt to register object without having set a registry name {} (type {})", new Object[]{object, object.getClass().getName()});
            throw new IllegalArgumentException(String.format("No registry name set for object %s (%s)", object, object.getClass().getName()));
        }
        IForgeRegistry<IForgeRegistryEntry> registry = PersistentRegistryManager.findRegistry(castedObj);
        registry.register(castedObj);
        return (K)castedObj;
    }

    public static ObjectIntIdentityMap<IBlockState> getBlockStateIDMap() {
        return GameData.getMain().iBlockRegistry.getSlaveMap(BLOCKSTATE_TO_ID, ObjectIntIdentityMap.class);
    }

    public static void vanillaSnapshot() {
        PersistentRegistryManager.freezeVanilla();
    }

    public <T extends IForgeRegistryEntry<T>> RegistryDelegate<T> makeDelegate(T obj, Class<T> rootClass) {
        return PersistentRegistryManager.makeDelegate(obj, rootClass);
    }

    private static class EntityCallbacks
    implements IForgeRegistry.AddCallback<EntityEntry>,
    IForgeRegistry.ClearCallback<EntityEntry>,
    IForgeRegistry.CreateCallback<EntityEntry> {
        static final EntityCallbacks INSTANCE = new EntityCallbacks();

        private EntityCallbacks() {
        }

        @Override
        public void onAdd(EntityEntry entry, int id, Map<ResourceLocation, ?> slaves) {
            if (entry.getEgg() != null) {
                EntityList.ENTITY_EGGS.put(entry.getRegistryName(), entry.getEgg());
            }
        }

        @Override
        public void onClear(IForgeRegistry<EntityEntry> registry, Map<ResourceLocation, ?> slaveset) {
        }

        @Override
        public void onCreate(Map<ResourceLocation, ?> slaveset, BiMap<ResourceLocation, ? extends IForgeRegistry<?>> registries) {
        }
    }

    private static class BiomeCallbacks
    implements IForgeRegistry.AddCallback<Biome>,
    IForgeRegistry.ClearCallback<Biome>,
    IForgeRegistry.CreateCallback<Biome> {
        static final BiomeCallbacks INSTANCE = new BiomeCallbacks();

        private BiomeCallbacks() {
        }

        @Override
        public void onAdd(Biome biome, int id, Map<ResourceLocation, ?> slaves) {
        }

        @Override
        public void onClear(IForgeRegistry<Biome> registry, Map<ResourceLocation, ?> slaveset) {
        }

        @Override
        public void onCreate(Map<ResourceLocation, ?> slaveset, BiMap<ResourceLocation, ? extends IForgeRegistry<?>> registries) {
        }
    }

    private static class PotionCallbacks
    implements IForgeRegistry.AddCallback<Potion>,
    IForgeRegistry.ClearCallback<Potion>,
    IForgeRegistry.CreateCallback<Potion> {
        static final PotionCallbacks INSTANCE = new PotionCallbacks();

        private PotionCallbacks() {
        }

        @Override
        public void onAdd(Potion potion, int id, Map<ResourceLocation, ?> slaves) {
        }

        @Override
        public void onClear(IForgeRegistry<Potion> registry, Map<ResourceLocation, ?> slaveset) {
        }

        @Override
        public void onCreate(Map<ResourceLocation, ?> slaveset, BiMap<ResourceLocation, ? extends IForgeRegistry<?>> registries) {
        }
    }

    private static class ItemCallbacks
    implements IForgeRegistry.AddCallback<Item>,
    IForgeRegistry.ClearCallback<Item>,
    IForgeRegistry.CreateCallback<Item>,
    IForgeRegistry.SubstitutionCallback<Item> {
        static final ItemCallbacks INSTANCE = new ItemCallbacks();

        private ItemCallbacks() {
        }

        @Override
        public void onAdd(Item item, int blockId, Map<ResourceLocation, ?> slaves) {
            if (item instanceof ItemBlock) {
                ItemBlock itemBlock = (ItemBlock)item;
                BiMap blockToItem = (BiMap)slaves.get(BLOCK_TO_ITEM);
                Block block = (Block)itemBlock.getBlock().delegate.get();
                blockToItem.forcePut((Object)block, (Object)item);
            }
        }

        @Override
        public void onClear(IForgeRegistry<Item> registry, Map<ResourceLocation, ?> slaveset) {
            Map map = (Map)slaveset.get(BLOCK_TO_ITEM);
            map.clear();
        }

        @Override
        public void onCreate(Map<ResourceLocation, ?> slaveset, BiMap<ResourceLocation, ? extends IForgeRegistry<?>> registries) {
            BiMap blockItemMap = ((IForgeRegistry)registries.get((Object)PersistentRegistryManager.BLOCKS)).getSlaveMap(BLOCK_TO_ITEM, BiMap.class);
            slaveset.put(BLOCK_TO_ITEM, blockItemMap);
        }

        @Override
        public void onSubstituteActivated(Map<ResourceLocation, ?> slaveset, Item original, Item replacement, ResourceLocation name) {
            BiMap blockItemMap = (BiMap)slaveset.get(BLOCK_TO_ITEM);
        }
    }

    private static class BlockCallbacks
    implements IForgeRegistry.AddCallback<Block>,
    IForgeRegistry.ClearCallback<Block>,
    IForgeRegistry.CreateCallback<Block>,
    IForgeRegistry.SubstitutionCallback<Block> {
        static final BlockCallbacks INSTANCE = new BlockCallbacks();

        private BlockCallbacks() {
        }

        @Override
        public void onAdd(Block block, int blockId, Map<ResourceLocation, ?> slaves) {
            ClearableObjectIntIdentityMap blockstateMap = (ClearableObjectIntIdentityMap)slaves.get(BLOCKSTATE_TO_ID);
            boolean[] usedMeta = new boolean[16];
            for (IBlockState state : block.getBlockState().getValidStates()) {
                int meta = block.getMetaFromState(state);
                blockstateMap.put(state, blockId << 4 | meta);
                usedMeta[meta] = true;
            }
            for (int meta = 0; meta < 16; ++meta) {
                if (!usedMeta[meta]) continue;
                blockstateMap.put(block.getStateFromMeta(meta), blockId << 4 | meta);
            }
        }

        @Override
        public void onClear(IForgeRegistry<Block> registry, Map<ResourceLocation, ?> slaveset) {
            ClearableObjectIntIdentityMap blockstateMap = (ClearableObjectIntIdentityMap)slaveset.get(BLOCKSTATE_TO_ID);
            blockstateMap.clear();
            Map originals = (Map)slaveset.get(PersistentRegistryManager.SUBSTITUTION_ORIGINALS);
            BiMap blockItemMap = (BiMap)slaveset.get(BLOCK_TO_ITEM);
            for (Item it : blockItemMap.values()) {
                if (!(it instanceof ItemBlock)) continue;
                ItemBlock itemBlock = (ItemBlock)it;
                ResourceLocation registryKey = registry.getKey(itemBlock.block);
                if (!originals.containsKey(registryKey)) continue;
                try {
                    FinalFieldHelper.setField(blockField, itemBlock, originals.get(registryKey));
                }
                catch (Exception e) {
                    throw Throwables.propagate((Throwable)e);
                }
            }
        }

        @Override
        public void onCreate(Map<ResourceLocation, ?> slaveset, BiMap<ResourceLocation, ? extends IForgeRegistry<?>> registries) {
            ClearableObjectIntIdentityMap<IBlockState> idMap = new ClearableObjectIntIdentityMap<IBlockState>(){

                @Override
                public int get(IBlockState key) {
                    Integer integer = (Integer)this.identityMap.get(key);
                    if (integer == null && key != null) {
                        integer = (Integer)this.identityMap.get(key.getBlock().getStateFromMeta(key.getBlock().getMetaFromState(key)));
                    }
                    return integer == null ? -1 : integer;
                }
            };
            slaveset.put(BLOCKSTATE_TO_ID, idMap);
            HashBiMap map = HashBiMap.create();
            slaveset.put(BLOCK_TO_ITEM, map);
        }

        @Override
        public void onSubstituteActivated(Map<ResourceLocation, ?> slaveset, Block original, Block replacement, ResourceLocation name) {
            BiMap blockItemMap = (BiMap)slaveset.get(BLOCK_TO_ITEM);
            if (blockItemMap.containsKey((Object)original)) {
                Item i = (Item)blockItemMap.get((Object)original);
                if (i instanceof ItemBlock) {
                    try {
                        FinalFieldHelper.setField(blockField, i, replacement);
                    }
                    catch (Exception e) {
                        throw Throwables.propagate((Throwable)e);
                    }
                }
                blockItemMap.forcePut((Object)replacement, (Object)i);
            }
        }
    }

    static class ClearableObjectIntIdentityMap<I>
    extends ObjectIntIdentityMap<I> {
        ClearableObjectIntIdentityMap() {
        }

        void clear() {
            this.identityMap.clear();
            this.objectList.clear();
        }
    }
}

