/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.fml.common.registry;

import com.google.common.base.Strings;
import com.google.common.base.Throwables;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.google.common.primitives.Ints;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import javax.annotation.Nonnull;
import net.minecraft.block.Block;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.CraftingManager;
import net.minecraft.item.crafting.FurnaceRecipes;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.nbt.JsonToNBT;
import net.minecraft.nbt.NBTException;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import net.minecraft.world.chunk.IChunkGenerator;
import net.minecraft.world.chunk.IChunkProvider;
import net.minecraftforge.fml.common.FMLLog;
import net.minecraftforge.fml.common.IFuelHandler;
import net.minecraftforge.fml.common.IWorldGenerator;
import net.minecraftforge.fml.common.registry.ExistingSubstitutionException;
import net.minecraftforge.fml.common.registry.GameData;
import net.minecraftforge.fml.common.registry.IForgeRegistry;
import net.minecraftforge.fml.common.registry.IForgeRegistryEntry;
import net.minecraftforge.fml.common.registry.PersistentRegistryManager;
import org.apache.logging.log4j.Level;

public class GameRegistry {
    private static Set<IWorldGenerator> worldGenerators = Sets.newHashSet();
    private static Map<IWorldGenerator, Integer> worldGeneratorIndex = Maps.newHashMap();
    private static List<IFuelHandler> fuelHandlers = Lists.newArrayList();
    private static List<IWorldGenerator> sortedGeneratorList;

    public static void registerWorldGenerator(IWorldGenerator generator, int modGenerationWeight) {
        worldGenerators.add(generator);
        worldGeneratorIndex.put(generator, modGenerationWeight);
        if (sortedGeneratorList != null) {
            sortedGeneratorList = null;
        }
    }

    public static void generateWorld(int chunkX, int chunkZ, World world, IChunkGenerator chunkGenerator, IChunkProvider chunkProvider) {
        if (sortedGeneratorList == null) {
            GameRegistry.computeSortedGeneratorList();
        }
        long worldSeed = world.getSeed();
        Random fmlRandom = new Random(worldSeed);
        long xSeed = fmlRandom.nextLong() >> 3;
        long zSeed = fmlRandom.nextLong() >> 3;
        long chunkSeed = xSeed * (long)chunkX + zSeed * (long)chunkZ ^ worldSeed;
        for (IWorldGenerator generator : sortedGeneratorList) {
            fmlRandom.setSeed(chunkSeed);
            generator.generate(fmlRandom, chunkX, chunkZ, world, chunkGenerator, chunkProvider);
        }
    }

    private static void computeSortedGeneratorList() {
        ArrayList list = Lists.newArrayList(worldGenerators);
        Collections.sort(list, new Comparator<IWorldGenerator>(){

            @Override
            public int compare(IWorldGenerator o1, IWorldGenerator o2) {
                return Ints.compare((int)((Integer)worldGeneratorIndex.get(o1)), (int)((Integer)worldGeneratorIndex.get(o2)));
            }
        });
        sortedGeneratorList = ImmutableList.copyOf((Collection)list);
    }

    public static <K extends IForgeRegistryEntry<?>> K register(K object) {
        return GameData.register_impl(object);
    }

    public static <K extends IForgeRegistryEntry<?>> K register(K object, ResourceLocation name) {
        return GameData.register_impl(object, name);
    }

    @Deprecated
    public static Block registerWithItem(Block block) {
        GameRegistry.register(block);
        GameRegistry.register(new ItemBlock(block).setRegistryName(block.getRegistryName()));
        return block;
    }

    public static <K extends IForgeRegistryEntry<K>> IForgeRegistry<K> findRegistry(Class<K> registryType) {
        return PersistentRegistryManager.findRegistryByType(registryType);
    }

    public static void addSubstitutionAlias(String nameToSubstitute, Type type, Object object) throws ExistingSubstitutionException {
        GameData.getMain().registerSubstitutionAlias(nameToSubstitute, type, object);
    }

    public static void addRecipe(@Nonnull ItemStack output, Object ... params) {
        GameRegistry.addShapedRecipe(output, params);
    }

    public static IRecipe addShapedRecipe(@Nonnull ItemStack output, Object ... params) {
        return CraftingManager.getInstance().addRecipe(output, params);
    }

    public static void addShapelessRecipe(@Nonnull ItemStack output, Object ... params) {
        CraftingManager.getInstance().addShapelessRecipe(output, params);
    }

    public static void addRecipe(IRecipe recipe) {
        CraftingManager.getInstance().getRecipeList().add(recipe);
    }

    public static void addSmelting(Block input, @Nonnull ItemStack output, float xp) {
        FurnaceRecipes.instance().addSmeltingRecipeForBlock(input, output, xp);
    }

    public static void addSmelting(Item input, @Nonnull ItemStack output, float xp) {
        FurnaceRecipes.instance().addSmelting(input, output, xp);
    }

    public static void addSmelting(@Nonnull ItemStack input, @Nonnull ItemStack output, float xp) {
        FurnaceRecipes.instance().addSmeltingRecipe(input, output, xp);
    }

    public static void registerTileEntity(Class<? extends TileEntity> tileEntityClass, String id) {
        GameData.getTileEntityRegistry().putObject(new ResourceLocation(id), tileEntityClass);
    }

    public static void registerTileEntityWithAlternatives(Class<? extends TileEntity> tileEntityClass, String id, String ... alternatives) {
        GameRegistry.registerTileEntity(tileEntityClass, id);
        for (String s : alternatives) {
            GameData.getTileEntityRegistry().addLegacyName(new ResourceLocation(s), new ResourceLocation(id));
        }
    }

    public static void registerFuelHandler(IFuelHandler handler) {
        fuelHandlers.add(handler);
    }

    public static int getFuelValue(@Nonnull ItemStack itemStack) {
        int fuelValue = 0;
        for (IFuelHandler handler : fuelHandlers) {
            fuelValue = Math.max(fuelValue, handler.getBurnTime(itemStack));
        }
        return fuelValue;
    }

    @Nonnull
    public static ItemStack makeItemStack(String itemName, int meta, int stackSize, String nbtString) {
        if (itemName == null) {
            throw new IllegalArgumentException("The itemName cannot be null");
        }
        Item item = GameData.getItemRegistry().getObject(new ResourceLocation(itemName));
        if (item == null) {
            FMLLog.getLogger().log(Level.TRACE, "Unable to find item with name {}", new Object[]{itemName});
            return ItemStack.EMPTY;
        }
        ItemStack is = new ItemStack(item, stackSize, meta);
        if (!Strings.isNullOrEmpty((String)nbtString)) {
            NBTTagCompound nbttag = null;
            try {
                nbttag = JsonToNBT.getTagFromJson(nbtString);
            }
            catch (NBTException e) {
                FMLLog.getLogger().log(Level.WARN, "Encountered an exception parsing ItemStack NBT string {}", new Object[]{nbtString, e});
                throw Throwables.propagate((Throwable)e);
            }
            if (!(nbttag instanceof NBTTagCompound)) {
                FMLLog.getLogger().log(Level.WARN, "Unexpected NBT string - multiple values {}", new Object[]{nbtString});
                throw new RuntimeException("Invalid NBT JSON");
            }
            is.setTagCompound(nbttag);
        }
        return is;
    }

    @Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={ElementType.FIELD})
    public static @interface ItemStackHolder {
        public String value();

        public int meta() default 0;

        public String nbt() default "";
    }

    @Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={ElementType.TYPE, ElementType.FIELD})
    public static @interface ObjectHolder {
        public String value();
    }

    public static enum Type {
        BLOCK,
        ITEM;

    }
}

