/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.fml.common.registry;

import com.google.common.collect.Maps;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.registry.RegistryNamespaced;

public class LegacyNamespacedRegistry<V>
extends RegistryNamespaced<ResourceLocation, V> {
    private Map<ResourceLocation, ResourceLocation> legacy_names = Maps.newHashMap();

    @Override
    @Nullable
    public V getObject(@Nullable ResourceLocation name) {
        ResourceLocation new_name;
        Object ret = super.getObject(name);
        if (ret == null && (new_name = this.legacy_names.get(name)) != null) {
            ret = super.getObject(new_name);
        }
        return ret;
    }

    public void addLegacyName(ResourceLocation old_name, ResourceLocation new_name) {
        this.legacy_names.put(old_name, new_name);
    }
}

