/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.fml.common.registry;

import com.google.common.base.Function;
import com.google.common.base.Throwables;
import com.google.common.collect.BiMap;
import com.google.common.collect.HashBiMap;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.io.IOException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockAir;
import net.minecraft.item.Item;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.fml.common.EnhancedRuntimeException;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.common.FMLLog;
import net.minecraftforge.fml.common.Loader;
import net.minecraftforge.fml.common.StartupQuery;
import net.minecraftforge.fml.common.ZipperUtil;
import net.minecraftforge.fml.common.event.FMLMissingMappingsEvent;
import net.minecraftforge.fml.common.registry.FMLControlledNamespacedRegistry;
import net.minecraftforge.fml.common.registry.GameRegistry;
import net.minecraftforge.fml.common.registry.IForgeRegistry;
import net.minecraftforge.fml.common.registry.IForgeRegistryEntry;
import net.minecraftforge.fml.common.registry.ObjectHolderRegistry;
import net.minecraftforge.fml.common.registry.RegistryDelegate;
import net.minecraftforge.fml.common.registry.VillagerRegistry;
import org.apache.logging.log4j.Level;

public class PersistentRegistryManager {
    public static final ResourceLocation BLOCKS = new ResourceLocation("minecraft:blocks");
    public static final ResourceLocation ITEMS = new ResourceLocation("minecraft:items");
    public static final ResourceLocation POTIONS = new ResourceLocation("minecraft:potions");
    public static final ResourceLocation BIOMES = new ResourceLocation("minecraft:biomes");
    public static final ResourceLocation SOUNDEVENTS = new ResourceLocation("minecraft:soundevents");
    public static final ResourceLocation POTIONTYPES = new ResourceLocation("minecraft:potiontypes");
    public static final ResourceLocation ENCHANTMENTS = new ResourceLocation("minecraft:enchantments");
    public static final ResourceLocation ENTITIES = new ResourceLocation("minecraft:entities");
    static final ResourceLocation SUBSTITUTION_ORIGINALS = new ResourceLocation("fml:suboriginals");

    public static void fireCreateRegistryEvents() {
        MinecraftForge.EVENT_BUS.post(new RegistryEvent.NewRegistry());
    }

    public static void fireRegistryEvents() {
        ArrayList registryKeys = Lists.newArrayList((Iterable)PersistentRegistry.ACTIVE.registries.keySet());
        Collections.sort(registryKeys, new Comparator<ResourceLocation>(){

            @Override
            public int compare(ResourceLocation o1, ResourceLocation o2) {
                return o1.toString().compareToIgnoreCase(o2.toString());
            }
        });
        PersistentRegistryManager.fireRegistryEvent(PersistentRegistry.ACTIVE.registries, BLOCKS);
        ObjectHolderRegistry.INSTANCE.applyObjectHolders();
        PersistentRegistryManager.fireRegistryEvent(PersistentRegistry.ACTIVE.registries, ITEMS);
        ObjectHolderRegistry.INSTANCE.applyObjectHolders();
        for (ResourceLocation rl : registryKeys) {
            if (rl == BLOCKS || rl == ITEMS) continue;
            PersistentRegistryManager.fireRegistryEvent(PersistentRegistry.ACTIVE.registries, rl);
        }
        ObjectHolderRegistry.INSTANCE.applyObjectHolders();
    }

    private static void fireRegistryEvent(BiMap<ResourceLocation, FMLControlledNamespacedRegistry<?>> registries, ResourceLocation name) {
        RegistryEvent.Register event = ((FMLControlledNamespacedRegistry)registries.get((Object)name)).buildRegistryRegisterEvent(name);
        MinecraftForge.EVENT_BUS.post(event);
    }

    @Deprecated
    public static <T extends IForgeRegistryEntry<T>> FMLControlledNamespacedRegistry<T> createRegistry(ResourceLocation registryName, Class<T> registryType, ResourceLocation optionalDefaultKey, int minId, int maxId, boolean hasDelegates, @Nullable IForgeRegistry.AddCallback<T> addCallback, @Nullable IForgeRegistry.ClearCallback<T> clearCallback, @Nullable IForgeRegistry.CreateCallback<T> createCallback) {
        return PersistentRegistry.ACTIVE.createRegistry(registryName, registryType, optionalDefaultKey, minId, maxId, PersistentRegistryManager.getLegacyAdd(addCallback), PersistentRegistryManager.getLegacyClear(clearCallback), PersistentRegistryManager.getLegacyCreate(createCallback), null);
    }

    @Deprecated
    public static <T extends IForgeRegistryEntry<T>> FMLControlledNamespacedRegistry<T> createRegistry(ResourceLocation registryName, Class<T> registryType, @Nullable ResourceLocation optionalDefaultKey, int minId, int maxId, boolean hasDelegates, @Nullable IForgeRegistry.AddCallback<T> addCallback, @Nullable IForgeRegistry.ClearCallback<T> clearCallback, @Nullable IForgeRegistry.CreateCallback<T> createCallback, @Nullable IForgeRegistry.SubstitutionCallback<T> substitutionCallback) {
        return PersistentRegistry.ACTIVE.createRegistry(registryName, registryType, optionalDefaultKey, minId, maxId, addCallback, clearCallback, createCallback, substitutionCallback);
    }

    static <V extends IForgeRegistryEntry<V>> IForgeRegistry<V> findRegistry(IForgeRegistryEntry<?> entry) {
        Class<?> registryType = entry.getRegistryType();
        FMLControlledNamespacedRegistry<?> registry = PersistentRegistry.ACTIVE.getRegistry(registryType);
        if (registry == null) {
            FMLLog.getLogger().log(Level.ERROR, "Unable to locate registry for registered object of type {}", new Object[]{entry.getClass().getName()});
            throw new IllegalArgumentException("Unable to locate registry for registered object");
        }
        return registry;
    }

    static <V extends IForgeRegistryEntry<V>> IForgeRegistry<V> findRegistryByType(Class<V> registryType) {
        return PersistentRegistry.ACTIVE.getRegistry(registryType);
    }

    public static List<String> injectSnapshot(GameDataSnapshot snapshot, boolean injectFrozenData, boolean isLocalWorld) {
        Class registrySuperType;
        FMLLog.info("Injecting existing block and item data into this %s instance", FMLCommonHandler.instance().getEffectiveSide().isServer() ? "server" : "client");
        HashMap remaps = Maps.newHashMap();
        LinkedHashMap missing = Maps.newLinkedHashMap();
        PersistentRegistryManager.forAllRegistries(PersistentRegistry.ACTIVE, ValidateRegistryFunction.OPERATION);
        PersistentRegistryManager.forAllRegistries(PersistentRegistry.ACTIVE, DumpRegistryFunction.OPERATION);
        PersistentRegistryManager.forAllRegistries(PersistentRegistry.ACTIVE, ResetDelegatesFunction.OPERATION);
        ArrayList missingRegs = Lists.newArrayList();
        for (ResourceLocation resourceLocation : snapshot.entries.keySet()) {
            ResourceLocation resourceLocation2 = PersistentRegistryManager.getFixedName(resourceLocation);
            if (PersistentRegistry.ACTIVE.getRegistry(resourceLocation2, null) != null) continue;
            missingRegs.add(resourceLocation2);
        }
        if (missingRegs.size() > 0) {
            Object text = "Forge Mod Loader detected missing/unknown registrie(s).\n\nThere are " + missingRegs.size() + " missing registries in this save.\n" + "If you continue the missing registries will get removed.\n" + "This may cause issues, it is advised that you create a world backup before continuing.\n\n" + "Missing Registries:\n";
            for (ResourceLocation s : missingRegs) {
                text = (String)text + s.toString() + "\n";
            }
            boolean bl = StartupQuery.confirm((String)text);
            if (!bl) {
                StartupQuery.abort();
            }
        }
        for (Map.Entry<ResourceLocation, GameDataSnapshot.Entry> entry : snapshot.entries.entrySet()) {
            Class registrySuperType2 = PersistentRegistry.ACTIVE.getRegistrySuperType(entry.getKey());
            PersistentRegistryManager.loadPersistentDataToStagingRegistry(injectFrozenData, remaps, missing, entry, registrySuperType2);
        }
        for (ResourceLocation resourceLocation : snapshot.entries.get((Object)PersistentRegistryManager.BLOCKS).dummied) {
            Integer id;
            if (((Map)missing.get(BLOCKS)).containsKey(resourceLocation)) {
                id = (Integer)((Map)missing.get(BLOCKS)).remove(resourceLocation);
                PersistentRegistry.STAGING.getRegistry(PersistentRegistryManager.BLOCKS, Block.class).markDummy(resourceLocation, id, new BlockDummyAir());
                continue;
            }
            if (isLocalWorld) {
                if (!FMLControlledNamespacedRegistry.DEBUG) continue;
                FMLLog.log(Level.DEBUG, "Registry: Resuscitating dummy block %s", resourceLocation);
                continue;
            }
            id = PersistentRegistry.STAGING.getRegistry(PersistentRegistryManager.BLOCKS, Block.class).getId(resourceLocation);
            FMLLog.log(Level.WARN, "The ID %d is currently locally mapped - it will be replaced with air for this session", id);
            PersistentRegistry.STAGING.getRegistry(PersistentRegistryManager.BLOCKS, Block.class).markDummy(resourceLocation, id, new BlockDummyAir());
        }
        List<String> missedMappings = Loader.instance().fireMissingMappingEvent((Map)missing.get(BLOCKS), (Map)missing.get(ITEMS), isLocalWorld, (Map)remaps.get(BLOCKS), (Map)remaps.get(ITEMS));
        if (!missedMappings.isEmpty()) {
            return missedMappings;
        }
        if (injectFrozenData) {
            for (Map.Entry missingBlock : ((Map)missing.get(BLOCKS)).entrySet()) {
                ResourceLocation rl = (ResourceLocation)missingBlock.getKey();
                Integer id = (Integer)missingBlock.getValue();
                FMLLog.log(Level.DEBUG, "Replacing id %s named as %s with air block. If the mod becomes available again later, it can reload here", id, rl);
                PersistentRegistry.STAGING.getRegistry(PersistentRegistryManager.BLOCKS, Block.class).markDummy(rl, id, new BlockDummyAir());
            }
        }
        if (injectFrozenData) {
            for (Map.Entry r : PersistentRegistry.ACTIVE.registries.entrySet()) {
                registrySuperType = PersistentRegistry.ACTIVE.getRegistrySuperType((ResourceLocation)r.getKey());
                PersistentRegistryManager.loadFrozenDataToStagingRegistry(remaps, (ResourceLocation)r.getKey(), registrySuperType);
            }
        }
        PersistentRegistryManager.forAllRegistries(PersistentRegistry.STAGING, ValidateRegistryFunction.OPERATION);
        for (Map.Entry r : PersistentRegistry.ACTIVE.registries.entrySet()) {
            registrySuperType = PersistentRegistry.ACTIVE.getRegistrySuperType((ResourceLocation)r.getKey());
            PersistentRegistryManager.loadRegistry((ResourceLocation)r.getKey(), PersistentRegistry.STAGING, PersistentRegistry.ACTIVE, registrySuperType);
        }
        PersistentRegistryManager.forAllRegistries(PersistentRegistry.ACTIVE, DumpRegistryFunction.OPERATION);
        Loader.instance().fireRemapEvent((Map)remaps.get(BLOCKS), (Map)remaps.get(ITEMS), false);
        ObjectHolderRegistry.INSTANCE.applyObjectHolders();
        PersistentRegistry.STAGING.clean();
        return ImmutableList.of();
    }

    private static void forAllRegistries(PersistentRegistry registrySet, Function<Map.Entry<ResourceLocation, FMLControlledNamespacedRegistry<?>>, Void> operation) {
        for (Map.Entry r : registrySet.registries.entrySet()) {
            operation.apply((Object)r);
        }
    }

    private static <T extends IForgeRegistryEntry<T>> void loadRegistry(final ResourceLocation registryName, final PersistentRegistry from, final PersistentRegistry to, Class<T> regType) {
        FMLControlledNamespacedRegistry fromRegistry = from.getRegistry(registryName, regType);
        if (fromRegistry == null) {
            FMLControlledNamespacedRegistry toRegistry = to.getRegistry(registryName, regType);
            if (toRegistry == null) {
                throw new EnhancedRuntimeException("Could not find registry to load: " + registryName){
                    private static final long serialVersionUID = 1L;

                    @Override
                    protected void printStackTrace(EnhancedRuntimeException.WrappedPrintStream stream) {
                        stream.println("Looking For: " + registryName);
                        stream.println("Found From:");
                        for (ResourceLocation name : from.registries.keySet()) {
                            stream.println("  " + name);
                        }
                        stream.println("Found To:");
                        for (ResourceLocation name : to.registries.keySet()) {
                            stream.println("  " + name);
                        }
                    }
                };
            }
            toRegistry.notifyCallbacks();
        } else {
            FMLControlledNamespacedRegistry toRegistry = to.getOrShallowCopyRegistry(registryName, regType, fromRegistry);
            toRegistry.set(fromRegistry);
        }
    }

    private static <T extends IForgeRegistryEntry<T>> void loadFrozenDataToStagingRegistry(Map<ResourceLocation, Map<ResourceLocation, Integer[]>> remaps, ResourceLocation registryName, Class<T> regType) {
        FMLControlledNamespacedRegistry frozenRegistry = PersistentRegistry.FROZEN.getRegistry(registryName, regType);
        FMLControlledNamespacedRegistry newRegistry = PersistentRegistry.STAGING.getOrShallowCopyRegistry(registryName, regType, frozenRegistry);
        newRegistry.loadIds(frozenRegistry.getEntriesNotIn(newRegistry), Maps.newLinkedHashMap(), remaps.get(registryName), frozenRegistry, registryName);
    }

    private static ResourceLocation getFixedName(ResourceLocation registryName) {
        if ("fml:blocks".equals(registryName.toString())) {
            registryName = BLOCKS;
        } else if ("fml:items".equals(registryName.toString())) {
            registryName = ITEMS;
        } else if ("fmlgr:villagerprofessions".equals(registryName.toString())) {
            registryName = VillagerRegistry.PROFESSIONS;
        }
        return registryName;
    }

    private static <T extends IForgeRegistryEntry<T>> void loadPersistentDataToStagingRegistry(boolean injectFrozenData, Map<ResourceLocation, Map<ResourceLocation, Integer[]>> remaps, LinkedHashMap<ResourceLocation, Map<ResourceLocation, Integer>> missing, Map.Entry<ResourceLocation, GameDataSnapshot.Entry> snapEntry, Class<T> regType) {
        ResourceLocation registryName = PersistentRegistryManager.getFixedName(snapEntry.getKey());
        FMLControlledNamespacedRegistry currentRegistry = PersistentRegistry.ACTIVE.getRegistry(registryName, regType);
        if (currentRegistry == null) {
            return;
        }
        FMLControlledNamespacedRegistry newRegistry = PersistentRegistry.STAGING.getOrShallowCopyRegistry(registryName, regType, currentRegistry);
        newRegistry.getPersistentSubstitutions().putAll(currentRegistry.getPersistentSubstitutions());
        GameDataSnapshot.Entry snapshotEntry = snapEntry.getValue();
        Sets.SetView substitutions = snapshotEntry.substitutions;
        if (injectFrozenData) {
            substitutions = Sets.union(snapshotEntry.substitutions, currentRegistry.getActiveSubstitutions());
        }
        newRegistry.loadAliases(snapshotEntry.aliases);
        newRegistry.loadBlocked(snapshotEntry.blocked);
        missing.put(registryName, Maps.newLinkedHashMap());
        remaps.put(registryName, Maps.newHashMap());
        newRegistry.loadDummied(snapshotEntry.dummied);
        newRegistry.loadIds(snapshotEntry.ids, missing.get(registryName), remaps.get(registryName), currentRegistry, registryName);
        newRegistry.loadSubstitutions((Set<ResourceLocation>)substitutions);
    }

    public static boolean isFrozen(FMLControlledNamespacedRegistry<?> registry) {
        return PersistentRegistry.FROZEN.containsRegistry(registry);
    }

    public static void revertToFrozen() {
        if (!PersistentRegistry.FROZEN.isPopulated()) {
            FMLLog.warning("Can't revert to frozen GameData state without freezing first.", new Object[0]);
            return;
        }
        FMLLog.fine("Reverting to frozen data state.", new Object[0]);
        for (Map.Entry r : PersistentRegistry.ACTIVE.registries.entrySet()) {
            Class registrySuperType = PersistentRegistry.ACTIVE.getRegistrySuperType((ResourceLocation)r.getKey());
            PersistentRegistryManager.loadRegistry((ResourceLocation)r.getKey(), PersistentRegistry.FROZEN, PersistentRegistry.ACTIVE, registrySuperType);
        }
        Loader.instance().fireRemapEvent((Map<ResourceLocation, Integer[]>)ImmutableMap.of(), (Map<ResourceLocation, Integer[]>)ImmutableMap.of(), true);
        ObjectHolderRegistry.INSTANCE.applyObjectHolders();
        FMLLog.fine("Frozen state restored.", new Object[0]);
    }

    public static void freezeData() {
        FMLLog.fine("Freezing block and item id maps", new Object[0]);
        for (Map.Entry r : PersistentRegistry.ACTIVE.registries.entrySet()) {
            Class registrySuperType = PersistentRegistry.ACTIVE.getRegistrySuperType((ResourceLocation)r.getKey());
            PersistentRegistryManager.loadRegistry((ResourceLocation)r.getKey(), PersistentRegistry.ACTIVE, PersistentRegistry.FROZEN, registrySuperType);
        }
        PersistentRegistryManager.forAllRegistries(PersistentRegistry.FROZEN, ValidateRegistryFunction.OPERATION);
    }

    public static void freezeVanilla() {
        FMLLog.fine("Creating vanilla freeze snapshot", new Object[0]);
        for (Map.Entry r : PersistentRegistry.ACTIVE.registries.entrySet()) {
            Class registrySuperType = PersistentRegistry.ACTIVE.getRegistrySuperType((ResourceLocation)r.getKey());
            PersistentRegistryManager.loadRegistry((ResourceLocation)r.getKey(), PersistentRegistry.ACTIVE, PersistentRegistry.VANILLA, registrySuperType);
        }
        PersistentRegistryManager.forAllRegistries(PersistentRegistry.VANILLA, ValidateRegistryFunction.OPERATION);
        FMLLog.fine("Vanilla freeze snapshot created", new Object[0]);
    }

    public static List<String> processIdRematches(Iterable<FMLMissingMappingsEvent.MissingMapping> missedMappings, boolean isLocalWorld, Map<ResourceLocation, Integer> missingBlocks, Map<ResourceLocation, Integer> missingItems, Map<ResourceLocation, Integer[]> remapBlocks, Map<ResourceLocation, Integer[]> remapItems) {
        ArrayList failed = Lists.newArrayList();
        ArrayList ignored = Lists.newArrayList();
        ArrayList warned = Lists.newArrayList();
        ArrayList defaulted = Lists.newArrayList();
        PersistentRegistry staging = PersistentRegistry.STAGING;
        PersistentRegistry active = PersistentRegistry.ACTIVE;
        for (FMLMissingMappingsEvent.MissingMapping missingMapping : missedMappings) {
            FMLMissingMappingsEvent.Action action = missingMapping.getAction();
            if (action == FMLMissingMappingsEvent.Action.REMAP) {
                ResourceLocation newName;
                int currId = -1;
                int newId = -1;
                if (missingMapping.type == GameRegistry.Type.BLOCK) {
                    currId = staging.getRegistry(PersistentRegistryManager.BLOCKS, Block.class).getId((Block)missingMapping.getTarget());
                    newName = active.getRegistry(PersistentRegistryManager.BLOCKS, Block.class).getNameForObject((Block)missingMapping.getTarget());
                    FMLLog.fine("The Block %s is being remapped to %s.", missingMapping.name, newName);
                    missingBlocks.remove(new ResourceLocation(missingMapping.name));
                    newId = staging.getRegistry(PersistentRegistryManager.BLOCKS, Block.class).add(missingMapping.id, newName, (Block)missingMapping.getTarget());
                    staging.getRegistry(PersistentRegistryManager.BLOCKS, Block.class).addAlias(missingMapping.resourceLocation, newName);
                } else {
                    if (missingMapping.type != GameRegistry.Type.ITEM) continue;
                    currId = staging.getRegistry(PersistentRegistryManager.ITEMS, Item.class).getId((Item)missingMapping.getTarget());
                    newName = active.getRegistry(PersistentRegistryManager.ITEMS, Item.class).getNameForObject((Item)missingMapping.getTarget());
                    FMLLog.fine("The Item %s is being remapped to %s.", missingMapping.name, newName);
                    missingItems.remove(new ResourceLocation(missingMapping.name));
                    newId = staging.getRegistry(PersistentRegistryManager.ITEMS, Item.class).add(missingMapping.id, newName, (Item)missingMapping.getTarget());
                    staging.getRegistry(PersistentRegistryManager.ITEMS, Item.class).addAlias(missingMapping.resourceLocation, newName);
                }
                if (newId != missingMapping.id) {
                    throw new IllegalStateException();
                }
                if (currId == newId) continue;
                FMLLog.info("Fixed %s id mismatch %s: %d (init) -> %d (map).", missingMapping.type == GameRegistry.Type.BLOCK ? "block" : "item", newName, currId, newId);
                (missingMapping.type == GameRegistry.Type.BLOCK ? remapBlocks : remapItems).put(newName, new Integer[]{currId, newId});
                continue;
            }
            if (action == FMLMissingMappingsEvent.Action.BLOCKONLY) {
                FMLLog.fine("The ItemBlock %s is no longer present in the game. The residual block will remain", missingMapping.name);
                continue;
            }
            if (action == FMLMissingMappingsEvent.Action.DEFAULT) {
                defaulted.add(missingMapping.name);
            } else if (action == FMLMissingMappingsEvent.Action.IGNORE) {
                ignored.add(missingMapping.name);
            } else if (action == FMLMissingMappingsEvent.Action.FAIL) {
                failed.add(missingMapping.name);
            } else if (action == FMLMissingMappingsEvent.Action.WARN) {
                warned.add(missingMapping.name);
            }
            if (missingMapping.type == GameRegistry.Type.BLOCK) {
                staging.getRegistry(PersistentRegistryManager.BLOCKS, Block.class).blockId(missingMapping.id);
                continue;
            }
            if (missingMapping.type != GameRegistry.Type.ITEM) continue;
            staging.getRegistry(PersistentRegistryManager.ITEMS, Item.class).blockId(missingMapping.id);
        }
        if (!defaulted.isEmpty()) {
            String text = "Forge Mod Loader detected missing blocks/items.\n\nThere are " + defaulted.size() + " missing blocks and items in this save.\n" + "If you continue the missing blocks/items will get removed.\n" + "A world backup will be automatically created in your saves directory.\n\n" + "Missing Blocks/Items:\n";
            for (String s : defaulted) {
                text = text + s + "\n";
            }
            boolean bl = StartupQuery.confirm(text);
            if (!bl) {
                StartupQuery.abort();
            }
            try {
                String skip = System.getProperty("fml.doNotBackup");
                if (skip == null || !"true".equals(skip)) {
                    ZipperUtil.backupWorld();
                } else {
                    for (int x = 0; x < 10; ++x) {
                        FMLLog.severe("!!!!!!!!!! UPDATING WORLD WITHOUT DOING BACKUP !!!!!!!!!!!!!!!!", new Object[0]);
                    }
                }
            }
            catch (IOException e) {
                StartupQuery.notify("The world backup couldn't be created.\n\n" + e);
                StartupQuery.abort();
            }
            warned.addAll(defaulted);
        }
        if (!failed.isEmpty()) {
            FMLLog.severe("This world contains blocks and items that refuse to be remapped. The world will not be loaded", new Object[0]);
            return failed;
        }
        if (!warned.isEmpty()) {
            FMLLog.warning("This world contains block and item mappings that may cause world breakage", new Object[0]);
            return failed;
        }
        if (!ignored.isEmpty()) {
            FMLLog.fine("There were %d missing mappings that have been ignored", ignored.size());
        }
        return failed;
    }

    public static GameDataSnapshot takeSnapshot() {
        final GameDataSnapshot snap = new GameDataSnapshot();
        PersistentRegistryManager.forAllRegistries(PersistentRegistry.ACTIVE, new Function<Map.Entry<ResourceLocation, FMLControlledNamespacedRegistry<?>>, Void>(){

            public Void apply(Map.Entry<ResourceLocation, FMLControlledNamespacedRegistry<?>> input) {
                snap.entries.put(input.getKey(), new GameDataSnapshot.Entry(input.getValue()));
                return null;
            }
        });
        return snap;
    }

    public static <T extends IForgeRegistryEntry<T>> RegistryDelegate<T> makeDelegate(T obj, Class<T> rootClass) {
        return PersistentRegistry.ACTIVE.getRegistry(rootClass).getDelegate(obj, rootClass);
    }

    @Nullable
    private static <T extends IForgeRegistryEntry<T>> IForgeRegistry.ClearCallback<T> getLegacyClear(final @Nullable IForgeRegistry.ClearCallback<T> cb) {
        if (cb == null) {
            return null;
        }
        try {
            final Method mtd = cb.getClass().getMethod("onClear", Map.class);
            return new IForgeRegistry.ClearCallback<T>(){

                @Override
                public void onClear(IForgeRegistry<T> is, Map<ResourceLocation, ?> slaveset) {
                    try {
                        mtd.invoke((Object)cb, slaveset);
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                        Throwables.propagate((Throwable)e);
                    }
                }
            };
        }
        catch (NoSuchMethodException e) {
            e.printStackTrace();
            return cb;
        }
        catch (SecurityException e) {
            e.printStackTrace();
            throw Throwables.propagate((Throwable)e);
        }
    }

    @Nullable
    private static <T extends IForgeRegistryEntry<T>> IForgeRegistry.CreateCallback<T> getLegacyCreate(final @Nullable IForgeRegistry.CreateCallback<T> cb) {
        if (cb == null) {
            return null;
        }
        try {
            final Method mtd = cb.getClass().getMethod("onCreate", Map.class);
            return new IForgeRegistry.CreateCallback<T>(){

                @Override
                public void onCreate(Map<ResourceLocation, ?> slaveset, BiMap<ResourceLocation, ? extends IForgeRegistry<?>> registries) {
                    try {
                        mtd.invoke((Object)cb, slaveset);
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                        Throwables.propagate((Throwable)e);
                    }
                }
            };
        }
        catch (NoSuchMethodException e) {
            e.printStackTrace();
            return cb;
        }
        catch (SecurityException e) {
            e.printStackTrace();
            throw Throwables.propagate((Throwable)e);
        }
    }

    @Nullable
    private static <T extends IForgeRegistryEntry<T>> IForgeRegistry.AddCallback<T> getLegacyAdd(final @Nullable IForgeRegistry.AddCallback<T> cb) {
        if (cb == null) {
            return null;
        }
        try {
            final Method mtd = cb.getClass().getMethod("onAdd", Object.class, Integer.TYPE, Map.class);
            return new IForgeRegistry.AddCallback<T>(){

                @Override
                public void onAdd(T obj, int id, Map<ResourceLocation, ?> slaveset) {
                    try {
                        mtd.invoke((Object)cb, obj, id, slaveset);
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                        Throwables.propagate((Throwable)e);
                    }
                }
            };
        }
        catch (NoSuchMethodException e) {
            e.printStackTrace();
            return cb;
        }
        catch (SecurityException e) {
            e.printStackTrace();
            throw Throwables.propagate((Throwable)e);
        }
    }

    private static class ResetDelegatesFunction
    implements Function<Map.Entry<ResourceLocation, FMLControlledNamespacedRegistry<?>>, Void> {
        static final ResetDelegatesFunction OPERATION = new ResetDelegatesFunction();

        private ResetDelegatesFunction() {
        }

        public Void apply(Map.Entry<ResourceLocation, FMLControlledNamespacedRegistry<?>> input) {
            input.getValue().resetSubstitutionDelegates();
            return null;
        }
    }

    private static class ValidateRegistryFunction
    implements Function<Map.Entry<ResourceLocation, FMLControlledNamespacedRegistry<?>>, Void> {
        static final ValidateRegistryFunction OPERATION = new ValidateRegistryFunction();

        private ValidateRegistryFunction() {
        }

        public Void apply(Map.Entry<ResourceLocation, FMLControlledNamespacedRegistry<?>> input) {
            input.getValue().validateContent(input.getKey());
            return null;
        }
    }

    private static class DumpRegistryFunction
    implements Function<Map.Entry<ResourceLocation, FMLControlledNamespacedRegistry<?>>, Void> {
        static final DumpRegistryFunction OPERATION = new DumpRegistryFunction();

        private DumpRegistryFunction() {
        }

        public Void apply(Map.Entry<ResourceLocation, FMLControlledNamespacedRegistry<?>> input) {
            input.getValue().dump(input.getKey());
            return null;
        }
    }

    public static class GameDataSnapshot {
        public final Map<ResourceLocation, Entry> entries = Maps.newHashMap();

        public static class Entry {
            public final Map<ResourceLocation, Integer> ids;
            public final Set<ResourceLocation> substitutions;
            public final Map<ResourceLocation, ResourceLocation> aliases;
            public final Set<Integer> blocked;
            public final Set<ResourceLocation> dummied;

            public Entry() {
                this(new HashMap<ResourceLocation, Integer>(), new HashSet<ResourceLocation>(), new HashMap<ResourceLocation, ResourceLocation>(), new HashSet<Integer>(), new HashSet<ResourceLocation>());
            }

            public Entry(Map<ResourceLocation, Integer> ids, Set<ResourceLocation> substitutions, Map<ResourceLocation, ResourceLocation> aliases, Set<Integer> blocked, Set<ResourceLocation> dummies) {
                this.ids = ids;
                this.substitutions = substitutions;
                this.aliases = aliases;
                this.blocked = blocked;
                this.dummied = dummies;
            }

            public Entry(FMLControlledNamespacedRegistry<?> registry) {
                this.ids = Maps.newHashMap();
                this.substitutions = Sets.newHashSet();
                this.aliases = Maps.newHashMap();
                this.blocked = Sets.newHashSet();
                this.dummied = Sets.newHashSet();
                registry.serializeIds(this.ids);
                registry.serializeSubstitutions(this.substitutions);
                registry.serializeAliases(this.aliases);
                registry.serializeBlockList(this.blocked);
                registry.serializeDummied(this.dummied);
            }
        }
    }

    private static class BlockDummyAir
    extends BlockAir {
        private BlockDummyAir() {
            this.setUnlocalizedName("air");
        }
    }

    static enum PersistentRegistry {
        ACTIVE,
        VANILLA,
        FROZEN,
        STAGING;

        private final BiMap<ResourceLocation, FMLControlledNamespacedRegistry<?>> registries = HashBiMap.create();
        private final BiMap<Class<? extends IForgeRegistryEntry<?>>, ResourceLocation> registrySuperTypes = HashBiMap.create();

        private <T extends IForgeRegistryEntry<T>> Class<T> getRegistrySuperType(ResourceLocation key) {
            return (Class)this.registrySuperTypes.inverse().get((Object)key);
        }

        private <T extends IForgeRegistryEntry<T>> FMLControlledNamespacedRegistry<T> getRegistry(ResourceLocation key, @Nullable Class<T> regType) {
            return (FMLControlledNamespacedRegistry)this.registries.get((Object)key);
        }

        private <T extends IForgeRegistryEntry<T>> FMLControlledNamespacedRegistry<T> getOrShallowCopyRegistry(ResourceLocation key, Class<T> regType, FMLControlledNamespacedRegistry<T> other) {
            if (!this.registries.containsKey((Object)key)) {
                this.registries.put((Object)key, other.makeShallowCopy(this.registries));
                this.registrySuperTypes.put(regType, (Object)key);
            }
            return this.getRegistry(key, regType);
        }

        private <T extends IForgeRegistryEntry<T>> FMLControlledNamespacedRegistry<T> createRegistry(ResourceLocation registryName, Class<T> type, ResourceLocation defaultObjectKey, int minId, int maxId, @Nullable IForgeRegistry.AddCallback<T> addCallback, @Nullable IForgeRegistry.ClearCallback<T> clearCallback, @Nullable IForgeRegistry.CreateCallback<T> createCallback, @Nullable IForgeRegistry.SubstitutionCallback<T> substitutionCallback) {
            HashSet parents = Sets.newHashSet();
            this.findSuperTypes(type, parents);
            Sets.SetView overlappedTypes = Sets.intersection((Set)parents, (Set)this.registrySuperTypes.keySet());
            if (!overlappedTypes.isEmpty()) {
                Class foundType = (Class)overlappedTypes.iterator().next();
                FMLLog.severe("Found existing registry of type %1s named %2s, you cannot create a new registry (%3s) with type %4s, as %4s has a parent of that type", foundType, this.registrySuperTypes.get((Object)foundType), registryName, type);
                throw new IllegalArgumentException("Duplicate registry parent type found - you can only have one registry for a particular super type");
            }
            FMLControlledNamespacedRegistry<T> fmlControlledNamespacedRegistry = new FMLControlledNamespacedRegistry<T>(defaultObjectKey, minId, maxId, type, this.registries, addCallback, clearCallback, createCallback, substitutionCallback);
            this.registries.put((Object)registryName, fmlControlledNamespacedRegistry);
            this.registrySuperTypes.put(type, (Object)registryName);
            return this.getRegistry(registryName, type);
        }

        private void findSuperTypes(Class<?> type, Set<Class<?>> types) {
            if (type == null || type == Object.class) {
                return;
            }
            types.add(type);
            for (Class<?> interfac : type.getInterfaces()) {
                this.findSuperTypes(interfac, types);
            }
            this.findSuperTypes(type.getSuperclass(), types);
        }

        void clean() {
            this.registries.clear();
            this.registrySuperTypes.clear();
        }

        boolean isPopulated() {
            return !this.registries.isEmpty();
        }

        boolean containsRegistry(FMLControlledNamespacedRegistry<?> registry) {
            return this.registries.containsValue(registry);
        }

        public <T extends IForgeRegistryEntry<T>> FMLControlledNamespacedRegistry<T> getRegistry(Class<T> rootClass) {
            ResourceLocation rl = (ResourceLocation)this.registrySuperTypes.get(rootClass);
            return this.getRegistry(rl, rootClass);
        }
    }
}

