/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.fml.server;

import com.google.common.collect.ImmutableList;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import net.minecraft.launchwrapper.Launch;
import net.minecraft.network.INetHandler;
import net.minecraft.network.NetHandlerPlayServer;
import net.minecraft.network.NetworkManager;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.dedicated.DedicatedServer;
import net.minecraft.server.dedicated.PendingCommand;
import net.minecraft.util.IThreadListener;
import net.minecraft.util.text.translation.LanguageMap;
import net.minecraft.world.storage.SaveFormatOld;
import net.minecraftforge.common.util.CompoundDataFixer;
import net.minecraftforge.common.util.Java6Utils;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.common.FMLLog;
import net.minecraftforge.fml.common.IFMLSidedHandler;
import net.minecraftforge.fml.common.Loader;
import net.minecraftforge.fml.common.ModContainer;
import net.minecraftforge.fml.common.StartupQuery;
import net.minecraftforge.fml.common.eventhandler.EventBus;
import net.minecraftforge.fml.common.functions.GenericIterableFactory;
import net.minecraftforge.fml.common.network.FMLNetworkEvent;
import net.minecraftforge.fml.relauncher.Side;
import org.apache.commons.io.IOUtils;

public class FMLServerHandler
implements IFMLSidedHandler {
    private static final FMLServerHandler INSTANCE = new FMLServerHandler();
    private MinecraftServer server;
    private List<String> injectedModContainers = FMLCommonHandler.instance().beginLoading(this);

    private FMLServerHandler() {
    }

    @Override
    public void beginServerLoading(MinecraftServer minecraftServer) {
        this.server = minecraftServer;
        Loader.instance().loadMods(this.injectedModContainers);
        Loader.instance().preinitializeMods();
    }

    @Override
    public void finishServerLoading() {
        Loader.instance().initializeMods();
    }

    @Override
    public void haltGame(String message, Throwable exception) {
        throw new RuntimeException(message, exception);
    }

    @Override
    public File getSavesDirectory() {
        return ((SaveFormatOld)this.server.getActiveAnvilConverter()).savesDirectory;
    }

    @Override
    public MinecraftServer getServer() {
        return this.server;
    }

    public static FMLServerHandler instance() {
        return INSTANCE;
    }

    @Override
    public List<String> getAdditionalBrandingInformation() {
        return ImmutableList.of();
    }

    @Override
    public Side getSide() {
        return Side.SERVER;
    }

    @Override
    public void showGuiScreen(Object clientGuiElement) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void queryUser(StartupQuery query) throws InterruptedException {
        if (query.getResult() == null) {
            FMLLog.warning("%s", query.getText());
            query.finish();
        } else {
            String text = query.getText() + "\n\nRun the command /fml confirm or or /fml cancel to proceed." + "\nAlternatively start the server with -Dfml.queryResult=confirm or -Dfml.queryResult=cancel to preselect the answer.";
            FMLLog.warning("%s", text);
            if (!query.isSynchronous()) {
                return;
            }
            boolean done = false;
            while (!done && this.server.isServerRunning()) {
                if (Thread.interrupted()) {
                    throw new InterruptedException();
                }
                DedicatedServer dedServer = (DedicatedServer)this.server;
                List<PendingCommand> list = dedServer.pendingCommandList;
                synchronized (list) {
                    Iterator<PendingCommand> it = GenericIterableFactory.newCastingIterable(dedServer.pendingCommandList, PendingCommand.class).iterator();
                    while (it.hasNext()) {
                        String cmd = it.next().command.trim().toLowerCase();
                        if (cmd.equals("/fml confirm")) {
                            FMLLog.info("confirmed", new Object[0]);
                            query.setResult(true);
                            done = true;
                            it.remove();
                            continue;
                        }
                        if (cmd.equals("/fml cancel")) {
                            FMLLog.info("cancelled", new Object[0]);
                            query.setResult(false);
                            done = true;
                            it.remove();
                            continue;
                        }
                        if (!cmd.equals("/stop")) continue;
                        StartupQuery.abort();
                    }
                }
                Thread.sleep(10L);
            }
            query.finish();
        }
    }

    @Override
    public boolean shouldServerShouldBeKilledQuietly() {
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    @Override
    public void addModAsResource(ModContainer container) {
        String langFile = "assets/" + container.getModId().toLowerCase() + "/lang/en_US.lang";
        File source = container.getSource();
        InputStream stream = null;
        ZipFile zip = null;
        try {
            if (source.isDirectory() && ((Boolean)Launch.blackboard.get("fml.deobfuscatedEnvironment")).booleanValue()) {
                stream = new FileInputStream(new File(source.toURI().resolve(langFile).getPath()));
            } else {
                zip = new ZipFile(source);
                ZipEntry entry = zip.getEntry(langFile);
                if (entry == null) {
                    throw new FileNotFoundException();
                }
                stream = zip.getInputStream(entry);
            }
            LanguageMap.inject(stream);
        }
        catch (IOException entry) {
            IOUtils.closeQuietly(stream);
            Java6Utils.closeZipQuietly(zip);
        }
        catch (Exception e) {
            FMLLog.getLogger().error((Object)e);
            {
                catch (Throwable throwable) {
                    IOUtils.closeQuietly(stream);
                    Java6Utils.closeZipQuietly(zip);
                    throw throwable;
                }
            }
            IOUtils.closeQuietly(stream);
            Java6Utils.closeZipQuietly(zip);
        }
        IOUtils.closeQuietly((InputStream)stream);
        Java6Utils.closeZipQuietly(zip);
    }

    @Override
    public String getCurrentLanguage() {
        return "en_US";
    }

    @Override
    public void serverStopped() {
    }

    @Override
    public NetworkManager getClientToServerNetworkManager() {
        throw new RuntimeException("Missing");
    }

    @Override
    public INetHandler getClientPlayHandler() {
        return null;
    }

    @Override
    public void fireNetRegistrationEvent(EventBus bus, NetworkManager manager, Set<String> channelSet, String channel, Side side) {
        bus.post(new FMLNetworkEvent.CustomPacketRegistrationEvent<NetHandlerPlayServer>(manager, channelSet, channel, side, NetHandlerPlayServer.class));
    }

    @Override
    public boolean shouldAllowPlayerLogins() {
        return DedicatedServer.allowPlayerLogins;
    }

    @Override
    public void allowLogins() {
        DedicatedServer.allowPlayerLogins = true;
    }

    @Override
    public IThreadListener getWorldThread(INetHandler net) {
        return this.getServer();
    }

    @Override
    public void processWindowMessages() {
    }

    @Override
    public String stripSpecialChars(String message) {
        return message;
    }

    @Override
    public void reloadRenderers() {
    }

    @Override
    public void fireSidedRegistryEvents() {
    }

    @Override
    public CompoundDataFixer getDataFixer() {
        return (CompoundDataFixer)this.server.getDataFixer();
    }
}

