/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.items.wrapper;

import javax.annotation.Nonnull;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraftforge.items.IItemHandlerModifiable;
import net.minecraftforge.items.ItemHandlerHelper;

public class InvWrapper
implements IItemHandlerModifiable {
    private final IInventory inv;

    public InvWrapper(IInventory inv) {
        this.inv = inv;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        InvWrapper that = (InvWrapper)o;
        return this.getInv().equals(that.getInv());
    }

    public int hashCode() {
        return this.getInv().hashCode();
    }

    @Override
    public int getSlots() {
        return this.getInv().getSizeInventory();
    }

    @Override
    @Nonnull
    public ItemStack getStackInSlot(int slot) {
        return this.getInv().getStackInSlot(slot);
    }

    @Override
    @Nonnull
    public ItemStack insertItem(int slot, @Nonnull ItemStack stack, boolean simulate) {
        if (stack.isEmpty()) {
            return ItemStack.EMPTY;
        }
        ItemStack stackInSlot = this.getInv().getStackInSlot(slot);
        if (!stackInSlot.isEmpty()) {
            if (!ItemHandlerHelper.canItemStacksStack(stack, stackInSlot)) {
                return stack;
            }
            if (!this.getInv().isItemValidForSlot(slot, stack)) {
                return stack;
            }
            int m = Math.min(stack.getMaxStackSize(), this.getSlotLimit(slot)) - stackInSlot.getCount();
            if (stack.getCount() <= m) {
                if (!simulate) {
                    ItemStack copy = stack.copy();
                    copy.grow(stackInSlot.getCount());
                    this.getInv().setInventorySlotContents(slot, copy);
                    this.getInv().markDirty();
                }
                return ItemStack.EMPTY;
            }
            stack = stack.copy();
            if (!simulate) {
                ItemStack copy = stack.splitStack(m);
                copy.grow(stackInSlot.getCount());
                this.getInv().setInventorySlotContents(slot, copy);
                this.getInv().markDirty();
                return stack;
            }
            stack.shrink(m);
            return stack;
        }
        if (!this.getInv().isItemValidForSlot(slot, stack)) {
            return stack;
        }
        int m = Math.min(stack.getMaxStackSize(), this.getSlotLimit(slot));
        if (m < stack.getCount()) {
            stack = stack.copy();
            if (!simulate) {
                this.getInv().setInventorySlotContents(slot, stack.splitStack(m));
                this.getInv().markDirty();
                return stack;
            }
            stack.shrink(m);
            return stack;
        }
        if (!simulate) {
            this.getInv().setInventorySlotContents(slot, stack);
            this.getInv().markDirty();
        }
        return ItemStack.EMPTY;
    }

    @Override
    @Nonnull
    public ItemStack extractItem(int slot, int amount, boolean simulate) {
        if (amount == 0) {
            return ItemStack.EMPTY;
        }
        ItemStack stackInSlot = this.getInv().getStackInSlot(slot);
        if (stackInSlot.isEmpty()) {
            return ItemStack.EMPTY;
        }
        if (simulate) {
            if (stackInSlot.getCount() < amount) {
                return stackInSlot.copy();
            }
            ItemStack copy = stackInSlot.copy();
            copy.setCount(amount);
            return copy;
        }
        int m = Math.min(stackInSlot.getCount(), amount);
        ItemStack decrStackSize = this.getInv().decrStackSize(slot, m);
        this.getInv().markDirty();
        return decrStackSize;
    }

    @Override
    public void setStackInSlot(int slot, @Nonnull ItemStack stack) {
        this.getInv().setInventorySlotContents(slot, stack);
    }

    @Override
    public int getSlotLimit(int slot) {
        return this.getInv().getInventoryStackLimit();
    }

    public IInventory getInv() {
        return this.inv;
    }
}

