/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.items.wrapper;

import javax.annotation.Nonnull;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.item.ItemStack;
import net.minecraftforge.items.wrapper.InvWrapper;
import net.minecraftforge.items.wrapper.RangedWrapper;

public class PlayerMainInvWrapper
extends RangedWrapper {
    private final InventoryPlayer inventoryPlayer;

    public PlayerMainInvWrapper(InventoryPlayer inv) {
        super(new InvWrapper(inv), 0, inv.mainInventory.size());
        this.inventoryPlayer = inv;
    }

    @Override
    @Nonnull
    public ItemStack insertItem(int slot, @Nonnull ItemStack stack, boolean simulate) {
        ItemStack inSlot;
        ItemStack rest = super.insertItem(slot, stack, simulate);
        if (rest.getCount() != stack.getCount() && !(inSlot = this.getStackInSlot(slot)).isEmpty()) {
            if (this.getInventoryPlayer().player.world.isRemote) {
                inSlot.setAnimationsToGo(5);
            } else if (this.getInventoryPlayer().player instanceof EntityPlayerMP) {
                this.getInventoryPlayer().player.openContainer.detectAndSendChanges();
            }
        }
        return rest;
    }

    public InventoryPlayer getInventoryPlayer() {
        return this.inventoryPlayer;
    }
}

