/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.items.wrapper;

import javax.annotation.Nonnull;
import net.minecraft.inventory.ISidedInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraftforge.items.IItemHandlerModifiable;
import net.minecraftforge.items.ItemHandlerHelper;

public class SidedInvWrapper
implements IItemHandlerModifiable {
    protected final ISidedInventory inv;
    protected final EnumFacing side;

    public SidedInvWrapper(ISidedInventory inv, EnumFacing side) {
        this.inv = inv;
        this.side = side;
    }

    public static int getSlot(ISidedInventory inv, int slot, EnumFacing side) {
        int[] slots = inv.getSlotsForFace(side);
        if (slot < slots.length) {
            return slots[slot];
        }
        return -1;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SidedInvWrapper that = (SidedInvWrapper)o;
        return this.inv.equals(that.inv) && this.side == that.side;
    }

    public int hashCode() {
        int result = this.inv.hashCode();
        result = 31 * result + this.side.hashCode();
        return result;
    }

    @Override
    public int getSlots() {
        return this.inv.getSlotsForFace(this.side).length;
    }

    @Override
    @Nonnull
    public ItemStack getStackInSlot(int slot) {
        int i = SidedInvWrapper.getSlot(this.inv, slot, this.side);
        return i == -1 ? ItemStack.EMPTY : this.inv.getStackInSlot(i);
    }

    @Override
    @Nonnull
    public ItemStack insertItem(int slot, @Nonnull ItemStack stack, boolean simulate) {
        if (stack.isEmpty()) {
            return ItemStack.EMPTY;
        }
        int slot1 = SidedInvWrapper.getSlot(this.inv, slot, this.side);
        if (slot1 == -1) {
            return stack;
        }
        ItemStack stackInSlot = this.inv.getStackInSlot(slot1);
        if (!stackInSlot.isEmpty()) {
            if (!ItemHandlerHelper.canItemStacksStack(stack, stackInSlot)) {
                return stack;
            }
            if (!this.inv.isItemValidForSlot(slot1, stack) || !this.inv.canInsertItem(slot1, stack, this.side)) {
                return stack;
            }
            int m = Math.min(stack.getMaxStackSize(), this.getSlotLimit(slot)) - stackInSlot.getCount();
            if (stack.getCount() <= m) {
                if (!simulate) {
                    ItemStack copy = stack.copy();
                    copy.grow(stackInSlot.getCount());
                    this.inv.setInventorySlotContents(slot1, copy);
                }
                return ItemStack.EMPTY;
            }
            stack = stack.copy();
            if (!simulate) {
                ItemStack copy = stack.splitStack(m);
                copy.grow(stackInSlot.getCount());
                this.inv.setInventorySlotContents(slot1, copy);
                return stack;
            }
            stack.shrink(m);
            return stack;
        }
        if (!this.inv.isItemValidForSlot(slot1, stack) || !this.inv.canInsertItem(slot1, stack, this.side)) {
            return stack;
        }
        int m = Math.min(stack.getMaxStackSize(), this.getSlotLimit(slot));
        if (m < stack.getCount()) {
            stack = stack.copy();
            if (!simulate) {
                this.inv.setInventorySlotContents(slot1, stack.splitStack(m));
                return stack;
            }
            stack.shrink(m);
            return stack;
        }
        if (!simulate) {
            this.inv.setInventorySlotContents(slot1, stack);
        }
        return ItemStack.EMPTY;
    }

    @Override
    public void setStackInSlot(int slot, @Nonnull ItemStack stack) {
        int slot1 = SidedInvWrapper.getSlot(this.inv, slot, this.side);
        if (slot1 != -1) {
            this.inv.setInventorySlotContents(slot1, stack);
        }
    }

    @Override
    @Nonnull
    public ItemStack extractItem(int slot, int amount, boolean simulate) {
        if (amount == 0) {
            return ItemStack.EMPTY;
        }
        int slot1 = SidedInvWrapper.getSlot(this.inv, slot, this.side);
        if (slot1 == -1) {
            return ItemStack.EMPTY;
        }
        ItemStack stackInSlot = this.inv.getStackInSlot(slot1);
        if (stackInSlot.isEmpty()) {
            return ItemStack.EMPTY;
        }
        if (!this.inv.canExtractItem(slot1, stackInSlot, this.side)) {
            return ItemStack.EMPTY;
        }
        if (simulate) {
            if (stackInSlot.getCount() < amount) {
                return stackInSlot.copy();
            }
            ItemStack copy = stackInSlot.copy();
            copy.setCount(amount);
            return copy;
        }
        int m = Math.min(stackInSlot.getCount(), amount);
        return this.inv.decrStackSize(slot1, m);
    }

    @Override
    public int getSlotLimit(int slot) {
        return this.inv.getInventoryStackLimit();
    }
}

