/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.server.command;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.command.CommandBase;
import net.minecraft.command.CommandException;
import net.minecraft.command.ICommand;
import net.minecraft.command.ICommandSender;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.TextComponentString;

public abstract class CommandTreeBase
extends CommandBase {
    private final Map<String, ICommand> commandMap = new HashMap<String, ICommand>();

    public void addSubcommand(ICommand c) {
        this.commandMap.put(c.getName(), c);
    }

    public Collection<ICommand> getSubCommands() {
        return this.getCommandMap().values();
    }

    public Map<String, ICommand> getCommandMap() {
        return Collections.unmodifiableMap(this.commandMap);
    }

    public List<ICommand> getSortedCommandList() {
        ArrayList<ICommand> list = new ArrayList<ICommand>(this.getSubCommands());
        Collections.sort(list);
        return list;
    }

    private static String[] shiftArgs(String[] s) {
        if (s == null || s.length == 0) {
            return new String[0];
        }
        String[] s1 = new String[s.length - 1];
        System.arraycopy(s, 1, s1, 0, s1.length);
        return s1;
    }

    @Override
    @Nonnull
    public List<String> getTabCompletions(@Nonnull MinecraftServer server, @Nonnull ICommandSender sender, @Nonnull String[] args, @Nullable BlockPos pos) {
        if (args.length == 1) {
            ArrayList<String> keys = new ArrayList<String>();
            for (ICommand c : this.getCommandMap().values()) {
                if (!c.checkPermission(server, sender)) continue;
                keys.add(c.getName());
            }
            Collections.sort(keys, null);
            return CommandTreeBase.getListOfStringsMatchingLastWord(args, keys);
        }
        ICommand cmd = this.getCommandMap().get(args[0]);
        if (cmd != null) {
            return cmd.getTabCompletions(server, sender, CommandTreeBase.shiftArgs(args), pos);
        }
        return super.getTabCompletions(server, sender, args, pos);
    }

    @Override
    public boolean isUsernameIndex(@Nonnull String[] args, int index) {
        ICommand cmd;
        if (index > 0 && args.length > 1 && (cmd = this.getCommandMap().get(args[0])) != null) {
            return cmd.isUsernameIndex(CommandTreeBase.shiftArgs(args), index - 1);
        }
        return false;
    }

    @Override
    public void execute(@Nonnull MinecraftServer server, @Nonnull ICommandSender sender, @Nonnull String[] args) throws CommandException {
        if (args.length < 1) {
            sender.sendMessage(new TextComponentString(CommandBase.joinNiceStringFromCollection(this.commandMap.keySet())));
        } else {
            ICommand cmd = this.getCommandMap().get(args[0]);
            if (cmd == null) {
                throw new CommandException("commands.tree_base.invalid_cmd", args[0]);
            }
            if (!cmd.checkPermission(server, sender)) {
                throw new CommandException("commands.generic.permission", new Object[0]);
            }
            cmd.execute(server, sender, CommandTreeBase.shiftArgs(args));
        }
    }
}

