/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.server.console;

import com.google.common.base.Function;
import com.google.common.collect.ImmutableMap;
import java.util.Map;
import java.util.regex.Pattern;
import net.minecraft.util.text.TextFormatting;
import org.fusesource.jansi.Ansi;

public final class ConsoleFormatter
implements Function<String, String> {
    private static final String RESET = Ansi.ansi().reset().toString();
    private static final ImmutableMap<Pattern, String> REPLACEMENTS = ImmutableMap.builder().put((Object)ConsoleFormatter.compile(TextFormatting.BLACK), (Object)Ansi.ansi().reset().fg(Ansi.Color.BLACK).boldOff().toString()).put((Object)ConsoleFormatter.compile(TextFormatting.DARK_BLUE), (Object)Ansi.ansi().reset().fg(Ansi.Color.BLUE).boldOff().toString()).put((Object)ConsoleFormatter.compile(TextFormatting.DARK_GREEN), (Object)Ansi.ansi().reset().fg(Ansi.Color.GREEN).boldOff().toString()).put((Object)ConsoleFormatter.compile(TextFormatting.DARK_AQUA), (Object)Ansi.ansi().reset().fg(Ansi.Color.CYAN).boldOff().toString()).put((Object)ConsoleFormatter.compile(TextFormatting.DARK_RED), (Object)Ansi.ansi().reset().fg(Ansi.Color.RED).boldOff().toString()).put((Object)ConsoleFormatter.compile(TextFormatting.DARK_PURPLE), (Object)Ansi.ansi().reset().fg(Ansi.Color.MAGENTA).boldOff().toString()).put((Object)ConsoleFormatter.compile(TextFormatting.GOLD), (Object)Ansi.ansi().reset().fg(Ansi.Color.YELLOW).boldOff().toString()).put((Object)ConsoleFormatter.compile(TextFormatting.GRAY), (Object)Ansi.ansi().reset().fg(Ansi.Color.WHITE).boldOff().toString()).put((Object)ConsoleFormatter.compile(TextFormatting.DARK_GRAY), (Object)Ansi.ansi().reset().fg(Ansi.Color.BLACK).bold().toString()).put((Object)ConsoleFormatter.compile(TextFormatting.BLUE), (Object)Ansi.ansi().reset().fg(Ansi.Color.BLUE).bold().toString()).put((Object)ConsoleFormatter.compile(TextFormatting.GREEN), (Object)Ansi.ansi().reset().fg(Ansi.Color.GREEN).bold().toString()).put((Object)ConsoleFormatter.compile(TextFormatting.AQUA), (Object)Ansi.ansi().reset().fg(Ansi.Color.CYAN).bold().toString()).put((Object)ConsoleFormatter.compile(TextFormatting.RED), (Object)Ansi.ansi().reset().fg(Ansi.Color.RED).bold().toString()).put((Object)ConsoleFormatter.compile(TextFormatting.LIGHT_PURPLE), (Object)Ansi.ansi().reset().fg(Ansi.Color.MAGENTA).bold().toString()).put((Object)ConsoleFormatter.compile(TextFormatting.YELLOW), (Object)Ansi.ansi().reset().fg(Ansi.Color.YELLOW).bold().toString()).put((Object)ConsoleFormatter.compile(TextFormatting.WHITE), (Object)Ansi.ansi().reset().fg(Ansi.Color.WHITE).bold().toString()).put((Object)ConsoleFormatter.compile(TextFormatting.OBFUSCATED), (Object)Ansi.ansi().a(Ansi.Attribute.BLINK_SLOW).toString()).put((Object)ConsoleFormatter.compile(TextFormatting.BOLD), (Object)Ansi.ansi().a(Ansi.Attribute.UNDERLINE_DOUBLE).toString()).put((Object)ConsoleFormatter.compile(TextFormatting.STRIKETHROUGH), (Object)Ansi.ansi().a(Ansi.Attribute.STRIKETHROUGH_ON).toString()).put((Object)ConsoleFormatter.compile(TextFormatting.UNDERLINE), (Object)Ansi.ansi().a(Ansi.Attribute.UNDERLINE).toString()).put((Object)ConsoleFormatter.compile(TextFormatting.ITALIC), (Object)Ansi.ansi().a(Ansi.Attribute.ITALIC).toString()).put((Object)ConsoleFormatter.compile(TextFormatting.RESET), (Object)RESET).build();

    private static Pattern compile(TextFormatting formatting) {
        return Pattern.compile(formatting.toString(), 18);
    }

    public String apply(String text) {
        for (Map.Entry entry : REPLACEMENTS.entrySet()) {
            text = ((Pattern)entry.getKey()).matcher(text).replaceAll((String)entry.getValue());
        }
        return text + RESET;
    }
}

