/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.realms;

import java.net.InetAddress;
import java.net.UnknownHostException;
import net.minecraft.realms.DisconnectedRealmsScreen;
import net.minecraft.realms.Realms;
import net.minecraft.realms.RealmsScreen;
import net.minecraftforge.fml.client.FMLClientHandler;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@SideOnly(value=Side.CLIENT)
public class RealmsConnect {
    private static final Logger LOGGER = LogManager.getLogger();
    private final RealmsScreen onlineScreen;
    private volatile boolean aborted;
    private er connection;

    public RealmsConnect(RealmsScreen onlineScreenIn) {
        this.onlineScreen = onlineScreenIn;
    }

    public void connect(final String p_connect_1_, final int p_connect_2_) {
        Realms.setConnectedToRealms(true);
        new Thread("Realms-connect-task"){

            @Override
            public void run() {
                InetAddress inetaddress = null;
                try {
                    FMLClientHandler.instance().connectToRealmsServer(p_connect_1_, p_connect_2_);
                    inetaddress = InetAddress.getByName(p_connect_1_);
                    if (RealmsConnect.this.aborted) {
                        return;
                    }
                    RealmsConnect.this.connection = er.a(inetaddress, p_connect_2_, bes.z().u.f());
                    if (RealmsConnect.this.aborted) {
                        return;
                    }
                    RealmsConnect.this.connection.a(new bnn(RealmsConnect.this.connection, bes.z(), RealmsConnect.this.onlineScreen.getProxy()));
                    if (RealmsConnect.this.aborted) {
                        return;
                    }
                    RealmsConnect.this.connection.a(new jp(316, p_connect_1_, p_connect_2_, es.d, true));
                    if (RealmsConnect.this.aborted) {
                        return;
                    }
                    RealmsConnect.this.connection.a(new jy(bes.z().K().e()));
                }
                catch (UnknownHostException unknownhostexception) {
                    Realms.clearResourcePack();
                    if (RealmsConnect.this.aborted) {
                        return;
                    }
                    LOGGER.error("Couldn't connect to world", (Throwable)unknownhostexception);
                    Realms.setScreen(new DisconnectedRealmsScreen(RealmsConnect.this.onlineScreen, "connect.failed", new fi("disconnect.genericReason", "Unknown host '" + p_connect_1_ + "'")));
                }
                catch (Exception exception) {
                    Realms.clearResourcePack();
                    if (RealmsConnect.this.aborted) {
                        return;
                    }
                    LOGGER.error("Couldn't connect to world", (Throwable)exception);
                    String s2 = exception.toString();
                    if (inetaddress != null) {
                        String s1 = inetaddress + ":" + p_connect_2_;
                        s2 = s2.replaceAll(s1, "");
                    }
                    Realms.setScreen(new DisconnectedRealmsScreen(RealmsConnect.this.onlineScreen, "connect.failed", new fi("disconnect.genericReason", s2)));
                }
            }
        }.start();
    }

    public void abort() {
        this.aborted = true;
        if (this.connection != null && this.connection.g()) {
            this.connection.a(new fi("disconnect.genericReason", new Object[0]));
            this.connection.l();
        }
    }

    public void tick() {
        if (this.connection != null) {
            if (this.connection.g()) {
                this.connection.a();
            } else {
                this.connection.l();
            }
        }
    }
}

