/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.server;

import com.google.common.base.Charsets;
import com.google.common.collect.Lists;
import com.google.common.collect.Queues;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.ListenableFutureTask;
import com.mojang.authlib.GameProfile;
import com.mojang.authlib.GameProfileRepository;
import com.mojang.authlib.minecraft.MinecraftSessionService;
import com.mojang.authlib.yggdrasil.YggdrasilAuthenticationService;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufOutputStream;
import io.netty.buffer.Unpooled;
import io.netty.handler.codec.base64.Base64;
import java.awt.GraphicsEnvironment;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.net.Proxy;
import java.net.URLEncoder;
import java.security.KeyPair;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.Hashtable;
import java.util.List;
import java.util.Queue;
import java.util.Random;
import java.util.UUID;
import java.util.concurrent.Callable;
import java.util.concurrent.Executors;
import java.util.concurrent.FutureTask;
import javax.annotation.Nullable;
import javax.imageio.ImageIO;
import net.minecraftforge.common.DimensionManager;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.chunkio.ChunkIOExecutor;
import net.minecraftforge.event.world.WorldEvent;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.common.StartupQuery;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.apache.commons.lang3.Validate;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public abstract class MinecraftServer
implements Runnable,
n,
qy,
rt {
    private static final Logger k = LogManager.getLogger();
    public static final File a = new File("usercache.json");
    private final bby l;
    private final rs m = new rs("server", this, MinecraftServer.aw());
    private final File n;
    private final List<lf> o = Lists.newArrayList();
    public final m b;
    public final ou c = new ou();
    private final mh p;
    private final kf q = new kf();
    private final Random r = new Random();
    private final ph s;
    @SideOnly(value=Side.SERVER)
    private String t;
    private int u = -1;
    public lw[] d = new lw[0];
    private mt v;
    private boolean w = true;
    private boolean x;
    private int y;
    protected final Proxy e;
    public String f;
    public int g;
    private boolean z;
    private boolean A;
    private boolean B;
    private boolean C;
    private boolean D;
    private boolean E;
    private String F;
    private int G;
    private int H;
    public final long[] h = new long[100];
    public Hashtable<Integer, long[]> worldTickTimes = new Hashtable();
    private KeyPair I;
    private String J;
    private String K;
    @SideOnly(value=Side.CLIENT)
    private String L;
    private boolean M;
    private boolean N;
    private String O = "";
    private String P = "";
    private boolean Q;
    private long R;
    private String S;
    private boolean T;
    private boolean U;
    private final YggdrasilAuthenticationService V;
    private final MinecraftSessionService W;
    private final GameProfileRepository X;
    private final mp Y;
    private long Z;
    public final Queue<FutureTask<?>> j = Queues.newArrayDeque();
    private Thread aa;
    private long ab = MinecraftServer.aw();
    @SideOnly(value=Side.CLIENT)
    private boolean ac;

    public MinecraftServer(File anvilFileIn, Proxy proxyIn, ph dataFixerIn, YggdrasilAuthenticationService authServiceIn, MinecraftSessionService sessionServiceIn, GameProfileRepository profileRepoIn, mp profileCacheIn) {
        this.e = proxyIn;
        this.V = authServiceIn;
        this.W = sessionServiceIn;
        this.X = profileRepoIn;
        this.Y = profileCacheIn;
        this.n = anvilFileIn;
        this.p = new mh(this);
        this.b = this.i();
        this.l = new bbr(anvilFileIn, dataFixerIn);
        this.s = dataFixerIn;
    }

    public bd i() {
        return new bd(this);
    }

    public abstract boolean j() throws IOException;

    public void a(String worldNameIn) {
        if (this.W().b(worldNameIn)) {
            k.info("Converting map!");
            this.b("menu.convertingLevel");
            this.W().a(worldNameIn, new ov(){
                private long b = System.currentTimeMillis();

                @Override
                public void a(String message) {
                }

                @Override
                public void a(int progress) {
                    if (System.currentTimeMillis() - this.b >= 1000L) {
                        this.b = System.currentTimeMillis();
                        k.info("Converting... {}%", new Object[]{progress});
                    }
                }

                @Override
                @SideOnly(value=Side.CLIENT)
                public void b(String message) {
                }

                @Override
                @SideOnly(value=Side.CLIENT)
                public void a() {
                }

                @Override
                public void c(String message) {
                }
            });
        }
    }

    protected synchronized void b(String message) {
        this.S = message;
    }

    @Nullable
    @SideOnly(value=Side.CLIENT)
    public synchronized String k() {
        return this.S;
    }

    public void a(String saveName, String worldNameIn, long seed, ajx type, String generatorOptions) {
        ajv worldsettings;
        this.a(saveName);
        this.b("menu.loadingLevel");
        bbw isavehandler = this.l.a(saveName, true);
        this.a(this.S(), isavehandler);
        bbv worldinfo = isavehandler.d();
        if (worldinfo == null) {
            if (this.V()) {
                worldsettings = lq.a;
            } else {
                worldsettings = new ajv(seed, this.n(), this.m(), this.p(), type);
                worldsettings.a(generatorOptions);
                if (this.N) {
                    worldsettings.a();
                }
            }
            worldinfo = new bbv(worldsettings, worldNameIn);
        } else {
            worldinfo.a(worldNameIn);
            worldsettings = new ajv(worldinfo);
        }
        lw overWorld = (lw)(this.V() ? new lq(this, isavehandler, worldinfo, 0, this.c).b() : new lw(this, isavehandler, worldinfo, 0, this.c).b());
        overWorld.a(worldsettings);
        Integer[] integerArray = DimensionManager.getStaticDimensionIDs();
        int n2 = integerArray.length;
        for (int i2 = 0; i2 < n2; ++i2) {
            int dim = integerArray[i2];
            lw world = dim == 0 ? overWorld : (lw)new ls(this, isavehandler, dim, overWorld, this.c).b();
            world.a(new lx(this, world));
            if (!this.R()) {
                world.T().a(this.n());
            }
            MinecraftForge.EVENT_BUS.post(new WorldEvent.Load(world));
        }
        this.v.a(new lw[]{overWorld});
        this.a(this.o());
        this.l();
    }

    public void l() {
        int i2 = 16;
        int j2 = 4;
        int k2 = 192;
        int l2 = 625;
        int i1 = 0;
        this.b("menu.generatingTerrain");
        int j1 = 0;
        k.info("Preparing start region for level 0");
        lw worldserver = DimensionManager.getWorld(j1);
        co blockpos = worldserver.R();
        long k1 = MinecraftServer.aw();
        for (int l1 = -192; l1 <= 192 && this.w(); l1 += 16) {
            for (int i22 = -192; i22 <= 192 && this.w(); i22 += 16) {
                long j22 = MinecraftServer.aw();
                if (j22 - k1 > 1000L) {
                    this.a_("Preparing spawn area", i1 * 100 / 625);
                    k1 = j22;
                }
                ++i1;
                worldserver.r().c(blockpos.p() + l1 >> 4, blockpos.r() + i22 >> 4);
            }
        }
        this.t();
    }

    public void a(String worldNameIn, bbw saveHandlerIn) {
        File file1 = new File(saveHandlerIn.b(), "resources.zip");
        if (file1.isFile()) {
            try {
                this.a_("level://" + URLEncoder.encode(worldNameIn, Charsets.UTF_8.toString()) + "/" + "resources.zip", "");
            }
            catch (UnsupportedEncodingException var5) {
                k.warn("Something went wrong url encoding {}", new Object[]{worldNameIn});
            }
        }
    }

    public abstract boolean m();

    public abstract ajq n();

    public abstract rg o();

    public abstract boolean p();

    public abstract int q();

    public abstract boolean r();

    public abstract boolean s();

    protected void a_(String message, int percent) {
        this.f = message;
        this.g = percent;
        k.info("{}: {}%", new Object[]{message, percent});
    }

    protected void t() {
        this.f = null;
        this.g = 0;
    }

    public void a(boolean isSilent) {
        for (lw worldserver : this.d) {
            if (worldserver == null) continue;
            if (!isSilent) {
                k.info("Saving chunks for level '{}'/{}", new Object[]{worldserver.T().j(), worldserver.s.q().b()});
            }
            try {
                worldserver.a(true, (ov)null);
            }
            catch (ajt minecraftexception) {
                k.warn(minecraftexception.getMessage());
            }
        }
    }

    public void u() {
        k.info("Stopping server");
        if (this.an() != null) {
            this.an().b();
        }
        if (this.v != null) {
            k.info("Saving players");
            this.v.j();
            this.v.u();
        }
        if (this.d != null) {
            lw[] tmp;
            k.info("Saving worlds");
            for (lw worldserver : this.d) {
                if (worldserver == null) continue;
                worldserver.b = false;
            }
            this.a(false);
            for (lw worldserver1 : this.d) {
                if (worldserver1 == null) continue;
                MinecraftForge.EVENT_BUS.post(new WorldEvent.Unload(worldserver1));
                worldserver1.s();
            }
            for (lw world : tmp = this.d) {
                DimensionManager.setWorld(world.s.getDimension(), null, this);
            }
        }
        if (this.m.d()) {
            this.m.e();
        }
    }

    public boolean w() {
        return this.w;
    }

    public void x() {
        this.w = false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void run() {
        long i2;
        try {
            if (!this.j()) {
                FMLCommonHandler.instance().expectServerStopped();
                this.a((b)null);
                return;
            }
            FMLCommonHandler.instance().handleServerStarted();
            this.ab = MinecraftServer.aw();
            i2 = 0L;
            this.q.a(new fh(this.F));
            this.q.a(new kf.c("1.11.2", 316));
            this.a(this.q);
        }
        catch (StartupQuery.AbortedException e2) {
            FMLCommonHandler.instance().expectServerStopped();
            return;
        }
        catch (Throwable throwable1) {
            k.error("Encountered an unexpected exception", throwable1);
            b crashreport = null;
            crashreport = throwable1 instanceof f ? this.b(((f)throwable1).a()) : this.b(new b("Exception in server tick loop", throwable1));
            File file1 = new File(new File(this.A(), "crash-reports"), "crash-" + new SimpleDateFormat("yyyy-MM-dd_HH.mm.ss").format(new Date()) + "-server.txt");
            if (crashreport.a(file1)) {
                k.error("This crash report has been saved to: {}", new Object[]{file1.getAbsolutePath()});
            } else {
                k.error("We were unable to save this crash report to disk.");
            }
            FMLCommonHandler.instance().expectServerStopped();
            this.a(crashreport);
            return;
        }
        finally {
            try {
                this.u();
                this.x = true;
            }
            catch (Throwable throwable) {
                k.error("Exception stopping the server", throwable);
            }
            finally {
                FMLCommonHandler.instance().handleServerStopped();
                this.x = true;
                this.B();
            }
        }
        while (true) {
            if (!this.w) {
                FMLCommonHandler.instance().handleServerStopping();
                FMLCommonHandler.instance().expectServerStopped();
                return;
            }
            long k2 = MinecraftServer.aw();
            long j2 = k2 - this.ab;
            if (j2 > 2000L && this.ab - this.R >= 15000L) {
                k.warn("Can't keep up! Did the system time change, or is the server overloaded? Running {}ms behind, skipping {} tick(s)", new Object[]{j2, j2 / 50L});
                j2 = 2000L;
                this.R = this.ab;
            }
            if (j2 < 0L) {
                k.warn("Time ran backwards! Did the system time change?");
                j2 = 0L;
            }
            i2 += j2;
            this.ab = k2;
            if (this.d[0].g()) {
                this.C();
                i2 = 0L;
            } else {
                while (i2 > 50L) {
                    i2 -= 50L;
                    this.C();
                }
            }
            Thread.sleep(Math.max(1L, 50L - i2));
            this.Q = true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void a(kf response) {
        File file1 = this.d("server-icon.png");
        if (!file1.exists()) {
            file1 = this.W().b(this.S(), "icon.png");
        }
        if (file1.isFile()) {
            ByteBuf bytebuf = Unpooled.buffer();
            try {
                BufferedImage bufferedimage = ImageIO.read(file1);
                Validate.validState((bufferedimage.getWidth() == 64 ? 1 : 0) != 0, (String)"Must be 64 pixels wide", (Object[])new Object[0]);
                Validate.validState((bufferedimage.getHeight() == 64 ? 1 : 0) != 0, (String)"Must be 64 pixels high", (Object[])new Object[0]);
                ImageIO.write((RenderedImage)bufferedimage, "PNG", (OutputStream)new ByteBufOutputStream(bytebuf));
                ByteBuf bytebuf1 = Base64.encode((ByteBuf)bytebuf);
                response.a("data:image/png;base64," + bytebuf1.toString(Charsets.UTF_8));
            }
            catch (Exception exception) {
                k.error("Couldn't load server icon", (Throwable)exception);
            }
            finally {
                bytebuf.release();
            }
        }
    }

    @SideOnly(value=Side.CLIENT)
    public boolean y() {
        this.ac = this.ac || this.z().isFile();
        return this.ac;
    }

    @SideOnly(value=Side.CLIENT)
    public File z() {
        return this.W().b(this.S(), "icon.png");
    }

    public File A() {
        return new File(".");
    }

    public void a(b report) {
    }

    public void B() {
    }

    public void C() {
        long i2 = System.nanoTime();
        FMLCommonHandler.instance().onPreServerTick();
        ++this.y;
        if (this.T) {
            this.T = false;
            this.c.a = true;
            this.c.a();
        }
        this.c.a("root");
        this.D();
        if (i2 - this.Z >= 5000000000L) {
            this.Z = i2;
            this.q.a(new kf.a(this.I(), this.H()));
            GameProfile[] agameprofile = new GameProfile[Math.min(this.H(), 12)];
            int j2 = ot.a(this.r, 0, this.H() - agameprofile.length);
            for (int k2 = 0; k2 < agameprofile.length; ++k2) {
                agameprofile[k2] = this.v.v().get(j2 + k2).cS();
            }
            Collections.shuffle(Arrays.asList(agameprofile));
            this.q.b().a(agameprofile);
            this.q.invalidateJson();
        }
        if (this.y % 900 == 0) {
            this.c.a("save");
            this.v.j();
            this.a(true);
            this.c.b();
        }
        this.c.a("tallying");
        this.h[this.y % 100] = System.nanoTime() - i2;
        this.c.b();
        this.c.a("snooper");
        if (!this.m.d() && this.y > 100) {
            this.m.a();
        }
        if (this.y % 6000 == 0) {
            this.m.b();
        }
        this.c.b();
        this.c.b();
        FMLCommonHandler.instance().onPostServerTick();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void D() {
        this.c.a("jobs");
        Queue<FutureTask<?>> queue = this.j;
        synchronized (queue) {
            while (!this.j.isEmpty()) {
                h.a(this.j.poll(), k);
            }
        }
        this.c.c("levels");
        ChunkIOExecutor.tick();
        Integer[] ids = DimensionManager.getIDs(this.y % 200 == 0);
        for (int x2 = 0; x2 < ids.length; ++x2) {
            int id2 = ids[x2];
            long i2 = System.nanoTime();
            if (id2 == 0 || this.E()) {
                lw worldserver = DimensionManager.getWorld(id2);
                this.c.a(worldserver.T().j());
                if (this.y % 20 == 0) {
                    this.c.a("timeSync");
                    this.v.a(new id(worldserver.P(), worldserver.Q(), worldserver.U().b("doDaylightCycle")), worldserver.s.getDimension());
                    this.c.b();
                }
                this.c.a("tick");
                FMLCommonHandler.instance().onPreWorldTick(worldserver);
                try {
                    worldserver.d();
                }
                catch (Throwable throwable1) {
                    b crashreport = b.a(throwable1, "Exception ticking world");
                    worldserver.a(crashreport);
                    throw new f(crashreport);
                }
                try {
                    worldserver.k();
                }
                catch (Throwable throwable) {
                    b crashreport1 = b.a(throwable, "Exception ticking world entities");
                    worldserver.a(crashreport1);
                    throw new f(crashreport1);
                }
                FMLCommonHandler.instance().onPostWorldTick(worldserver);
                this.c.b();
                this.c.a("tracker");
                worldserver.v().a();
                this.c.b();
                this.c.b();
            }
            this.worldTickTimes.get((Object)Integer.valueOf((int)id2))[this.y % 100] = System.nanoTime() - i2;
        }
        this.c.c("dim_unloading");
        DimensionManager.unloadWorlds(this.worldTickTimes);
        this.c.c("connection");
        this.an().c();
        this.c.c("players");
        this.v.e();
        this.c.c("tickables");
        for (int k2 = 0; k2 < this.o.size(); ++k2) {
            this.o.get(k2).F_();
        }
        this.c.b();
    }

    public boolean E() {
        return true;
    }

    public void F() {
        StartupQuery.reset();
        this.aa = new Thread((Runnable)this, "Server thread");
        this.aa.start();
    }

    public File d(String fileName) {
        return new File(this.A(), fileName);
    }

    public void f(String msg) {
        k.warn(msg);
    }

    public lw a(int dimension) {
        lw ret = DimensionManager.getWorld(dimension);
        if (ret == null) {
            DimensionManager.initDimension(dimension);
            ret = DimensionManager.getWorld(dimension);
        }
        return ret;
    }

    public String G() {
        return "1.11.2";
    }

    public int H() {
        return this.v.o();
    }

    public int I() {
        return this.v.p();
    }

    public String[] J() {
        return this.v.f();
    }

    public GameProfile[] K() {
        return this.v.g();
    }

    public String getServerModName() {
        return FMLCommonHandler.instance().getModName();
    }

    public b b(b report) {
        report.g().a("Profiler Position", new d<String>(){

            @Override
            public String call() throws Exception {
                return MinecraftServer.this.c.a ? MinecraftServer.this.c.c() : "N/A (disabled)";
            }
        });
        if (this.v != null) {
            report.g().a("Player Count", new d<String>(){

                public String a() {
                    return MinecraftServer.this.v.o() + " / " + MinecraftServer.this.v.p() + "; " + MinecraftServer.this.v.v();
                }
            });
        }
        return report;
    }

    public List<String> a(n sender, String input, @Nullable co pos, boolean hasTargetBlock) {
        ArrayList list = Lists.newArrayList();
        boolean flag = input.startsWith("/");
        if (flag) {
            input = input.substring(1);
        }
        if (!flag && !hasTargetBlock) {
            String[] astring = input.split(" ", -1);
            String s2 = astring[astring.length - 1];
            for (String s1 : this.v.f()) {
                if (!j.a(s2, s1)) continue;
                list.add(s1);
            }
            return list;
        }
        boolean flag1 = !input.contains(" ");
        List<String> list1 = this.b.a(sender, input, pos);
        if (!list1.isEmpty()) {
            for (String s2 : list1) {
                if (flag1) {
                    list.add("/" + s2);
                    continue;
                }
                list.add(s2);
            }
        }
        return list;
    }

    public boolean M() {
        return this.n != null;
    }

    @Override
    public String h_() {
        return "Server";
    }

    @Override
    public void a(fb component) {
        k.info(component.c());
    }

    @Override
    public boolean a(int permLevel, String commandName) {
        return true;
    }

    public m N() {
        return this.b;
    }

    public KeyPair O() {
        return this.I;
    }

    public String Q() {
        return this.J;
    }

    public void i(String owner) {
        this.J = owner;
    }

    public boolean R() {
        return this.J != null;
    }

    public String S() {
        return this.K;
    }

    public void j(String name) {
        this.K = name;
    }

    @SideOnly(value=Side.CLIENT)
    public void k(String worldNameIn) {
        this.L = worldNameIn;
    }

    @SideOnly(value=Side.CLIENT)
    public String T() {
        return this.L;
    }

    public void a(KeyPair keyPair) {
        this.I = keyPair;
    }

    public void a(rg difficulty) {
        for (lw worldserver : this.d) {
            if (worldserver == null) continue;
            if (worldserver.T().s()) {
                worldserver.T().a(rg.d);
                worldserver.a(true, true);
                continue;
            }
            if (this.R()) {
                worldserver.T().a(difficulty);
                worldserver.a(worldserver.ae() != rg.a, true);
                continue;
            }
            worldserver.T().a(difficulty);
            worldserver.a(this.U(), this.B);
        }
    }

    public boolean U() {
        return true;
    }

    public boolean V() {
        return this.M;
    }

    public void b(boolean demo) {
        this.M = demo;
    }

    public void c(boolean enable) {
        this.N = enable;
    }

    public bby W() {
        return this.l;
    }

    public String X() {
        return this.O;
    }

    public String Y() {
        return this.P;
    }

    public void a_(String url, String hash) {
        this.O = url;
        this.P = hash;
    }

    @Override
    public void a(rs playerSnooper) {
        playerSnooper.a("whitelist_enabled", false);
        playerSnooper.a("whitelist_count", 0);
        if (this.v != null) {
            playerSnooper.a("players_current", this.H());
            playerSnooper.a("players_max", this.I());
            playerSnooper.a("players_seen", this.v.q().length);
        }
        playerSnooper.a("uses_auth", this.z);
        playerSnooper.a("gui_state", this.ap() ? "enabled" : "disabled");
        playerSnooper.a("run_time", (MinecraftServer.aw() - playerSnooper.g()) / 60L * 1000L);
        playerSnooper.a("avg_tick_ms", (int)(ot.a(this.h) * 1.0E-6));
        int i2 = 0;
        if (this.d != null) {
            for (lw worldserver : this.d) {
                if (worldserver == null) continue;
                bbv worldinfo = worldserver.T();
                playerSnooper.a("world[" + i2 + "][dimension]", worldserver.s.q().a());
                playerSnooper.a("world[" + i2 + "][mode]", (Object)worldinfo.q());
                playerSnooper.a("world[" + i2 + "][difficulty]", (Object)worldserver.ae());
                playerSnooper.a("world[" + i2 + "][hardcore]", worldinfo.s());
                playerSnooper.a("world[" + i2 + "][generator_name]", worldinfo.t().a());
                playerSnooper.a("world[" + i2 + "][generator_version]", worldinfo.t().d());
                playerSnooper.a("world[" + i2 + "][height]", this.G);
                playerSnooper.a("world[" + i2 + "][chunks_loaded]", worldserver.r().g());
                ++i2;
            }
        }
        playerSnooper.a("worlds", i2);
    }

    @Override
    public void b(rs playerSnooper) {
        playerSnooper.b("singleplayer", this.R());
        playerSnooper.b("server_brand", this.getServerModName());
        playerSnooper.b("gui_supported", GraphicsEnvironment.isHeadless() ? "headless" : "supported");
        playerSnooper.b("dedicated", this.aa());
    }

    @Override
    public boolean Z() {
        return true;
    }

    public abstract boolean aa();

    public boolean ab() {
        return this.z;
    }

    public void d(boolean online) {
        this.z = online;
    }

    public boolean ac() {
        return this.A;
    }

    public boolean ad() {
        return this.B;
    }

    public void f(boolean spawnAnimals) {
        this.B = spawnAnimals;
    }

    public boolean ae() {
        return this.C;
    }

    public abstract boolean af();

    public void g(boolean spawnNpcs) {
        this.C = spawnNpcs;
    }

    public boolean ag() {
        return this.D;
    }

    public void h(boolean allowPvp) {
        this.D = allowPvp;
    }

    public boolean ah() {
        return this.E;
    }

    public void i(boolean allow) {
        this.E = allow;
    }

    public abstract boolean ai();

    public String aj() {
        return this.F;
    }

    public void l(String motdIn) {
        this.F = motdIn;
    }

    public int ak() {
        return this.G;
    }

    public void c(int maxBuildHeight) {
        this.G = maxBuildHeight;
    }

    public boolean al() {
        return this.x;
    }

    public mt am() {
        return this.v;
    }

    public void a(mt list) {
        this.v = list;
    }

    public void a(ajq gameMode) {
        for (lw worldserver : this.d) {
            worldserver.T().a(gameMode);
        }
    }

    public mh an() {
        return this.p;
    }

    @SideOnly(value=Side.CLIENT)
    public boolean ao() {
        return this.Q;
    }

    public boolean ap() {
        return false;
    }

    public abstract String a(ajq var1, boolean var2);

    public int aq() {
        return this.y;
    }

    public void ar() {
        this.T = true;
    }

    @SideOnly(value=Side.CLIENT)
    public rs as() {
        return this.m;
    }

    @Override
    public co c() {
        return co.a;
    }

    @Override
    public bdw d() {
        return bdw.a;
    }

    @Override
    public ajs e() {
        return this.d[0];
    }

    @Override
    public sn f() {
        return null;
    }

    public boolean a(ajs worldIn, co pos, aay playerIn) {
        return false;
    }

    public boolean au() {
        return this.U;
    }

    public Proxy av() {
        return this.e;
    }

    public static long aw() {
        return System.currentTimeMillis();
    }

    public int ax() {
        return this.H;
    }

    public void d(int idleTimeout) {
        this.H = idleTimeout;
    }

    @Override
    public fb i_() {
        return new fh(this.h_());
    }

    public boolean ay() {
        return true;
    }

    public MinecraftSessionService az() {
        return this.W;
    }

    public GameProfileRepository aA() {
        return this.X;
    }

    public mp aB() {
        return this.Y;
    }

    public kf aC() {
        return this.q;
    }

    public void aD() {
        this.Z = 0L;
    }

    @Nullable
    public sn a(UUID uuid) {
        for (lw worldserver : this.d) {
            sn entity;
            if (worldserver == null || (entity = worldserver.a(uuid)) == null) continue;
            return entity;
        }
        return null;
    }

    @Override
    public boolean g() {
        return this.d[0].U().b("sendCommandFeedback");
    }

    @Override
    public void a(o.a type, int amount) {
    }

    @Override
    public MinecraftServer B_() {
        return this;
    }

    public int aE() {
        return 29999984;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <V> ListenableFuture<V> a(Callable<V> callable) {
        Validate.notNull(callable);
        if (!this.aF() && !this.al()) {
            ListenableFutureTask listenablefuturetask = ListenableFutureTask.create(callable);
            Queue<FutureTask<?>> queue = this.j;
            synchronized (queue) {
                this.j.add((FutureTask<?>)listenablefuturetask);
                return listenablefuturetask;
            }
        }
        try {
            return Futures.immediateFuture(callable.call());
        }
        catch (Exception exception) {
            return Futures.immediateFailedCheckedFuture((Exception)exception);
        }
    }

    @Override
    public ListenableFuture<Object> a(Runnable runnableToSchedule) {
        Validate.notNull((Object)runnableToSchedule);
        return this.a(Executors.callable(runnableToSchedule));
    }

    @Override
    public boolean aF() {
        return Thread.currentThread() == this.aa;
    }

    public int aG() {
        return 256;
    }

    public ph aJ() {
        return this.s;
    }

    public int a(@Nullable lw worldIn) {
        return worldIn != null ? worldIn.U().c("spawnRadius") : 10;
    }

    @SideOnly(value=Side.SERVER)
    public String v() {
        return this.t;
    }

    @SideOnly(value=Side.SERVER)
    public void c(String host) {
        this.t = host;
    }

    @SideOnly(value=Side.SERVER)
    public void a(lf tickable) {
        this.o.add(tickable);
    }

    @SideOnly(value=Side.SERVER)
    public static void main(String[] p_main_0_) {
        kt.c();
        try {
            boolean flag = true;
            String s2 = null;
            String s1 = ".";
            String s22 = null;
            boolean flag1 = false;
            boolean flag2 = false;
            int i2 = -1;
            for (int j2 = 0; j2 < p_main_0_.length; ++j2) {
                String s3 = p_main_0_[j2];
                String s4 = j2 == p_main_0_.length - 1 ? null : p_main_0_[j2 + 1];
                boolean flag3 = false;
                if (!"nogui".equals(s3) && !"--nogui".equals(s3)) {
                    if ("--port".equals(s3) && s4 != null) {
                        flag3 = true;
                        try {
                            i2 = Integer.parseInt(s4);
                        }
                        catch (NumberFormatException numberFormatException) {}
                    } else if ("--singleplayer".equals(s3) && s4 != null) {
                        flag3 = true;
                        s2 = s4;
                    } else if ("--universe".equals(s3) && s4 != null) {
                        flag3 = true;
                        s1 = s4;
                    } else if ("--world".equals(s3) && s4 != null) {
                        flag3 = true;
                        s22 = s4;
                    } else if ("--demo".equals(s3)) {
                        flag1 = true;
                    } else if ("--bonusChest".equals(s3)) {
                        flag2 = true;
                    }
                } else {
                    flag = false;
                }
                if (!flag3) continue;
                ++j2;
            }
            YggdrasilAuthenticationService yggdrasilauthenticationservice = new YggdrasilAuthenticationService(Proxy.NO_PROXY, UUID.randomUUID().toString());
            MinecraftSessionService minecraftsessionservice = yggdrasilauthenticationservice.createMinecraftSessionService();
            GameProfileRepository gameprofilerepository = yggdrasilauthenticationservice.createProfileRepository();
            mp playerprofilecache = new mp(gameprofilerepository, new File(s1, a.getName()));
            final lh dedicatedserver = new lh(new File(s1), pi.a(), yggdrasilauthenticationservice, minecraftsessionservice, gameprofilerepository, playerprofilecache);
            if (s2 != null) {
                dedicatedserver.i(s2);
            }
            if (s22 != null) {
                dedicatedserver.j(s22);
            }
            if (i2 >= 0) {
                dedicatedserver.b(i2);
            }
            if (flag1) {
                dedicatedserver.b(true);
            }
            if (flag2) {
                dedicatedserver.c(true);
            }
            if (flag && !GraphicsEnvironment.isHeadless()) {
                dedicatedserver.aO();
            }
            dedicatedserver.F();
            Runtime.getRuntime().addShutdownHook(new Thread("Server Shutdown Thread"){

                @Override
                public void run() {
                    dedicatedserver.u();
                }
            });
        }
        catch (Exception exception) {
            k.fatal("Failed to start the minecraft server", (Throwable)exception);
        }
    }

    @SideOnly(value=Side.SERVER)
    public void e(String msg) {
        k.info(msg);
    }

    @SideOnly(value=Side.SERVER)
    public boolean L() {
        return false;
    }

    @SideOnly(value=Side.SERVER)
    public void g(String msg) {
        k.error(msg);
    }

    @SideOnly(value=Side.SERVER)
    public void h(String msg) {
        if (this.L()) {
            k.info(msg);
        }
    }

    @SideOnly(value=Side.SERVER)
    public int P() {
        return this.u;
    }

    @SideOnly(value=Side.SERVER)
    public void b(int port) {
        this.u = port;
    }

    @SideOnly(value=Side.SERVER)
    public void e(boolean p_190517_1_) {
        this.A = p_190517_1_;
    }

    @SideOnly(value=Side.SERVER)
    public int at() {
        return 16;
    }

    @SideOnly(value=Side.SERVER)
    public void j(boolean force) {
        this.U = force;
    }

    @SideOnly(value=Side.SERVER)
    public long aH() {
        return this.ab;
    }

    @SideOnly(value=Side.SERVER)
    public Thread aI() {
        return this.aa;
    }
}

