/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.client.event;

import java.util.Collections;
import java.util.List;
import javax.annotation.Nonnull;
import net.minecraftforge.fml.common.eventhandler.Cancelable;
import net.minecraftforge.fml.common.eventhandler.Event;

public abstract class RenderTooltipEvent
extends Event {
    @Nonnull
    protected final afj stack;
    protected final List<String> lines;
    protected int x;
    protected int y;
    protected bfg fr;

    public RenderTooltipEvent(@Nonnull afj stack, @Nonnull List<String> lines, int x2, int y2, @Nonnull bfg fr2) {
        this.stack = stack;
        this.lines = Collections.unmodifiableList(lines);
        this.x = x2;
        this.y = y2;
        this.fr = fr2;
    }

    @Nonnull
    public afj getStack() {
        return this.stack;
    }

    @Nonnull
    public List<String> getLines() {
        return this.lines;
    }

    public int getX() {
        return this.x;
    }

    public int getY() {
        return this.y;
    }

    @Nonnull
    public bfg getFontRenderer() {
        return this.fr;
    }

    public static class PostText
    extends Post {
        public PostText(@Nonnull afj stack, @Nonnull List<String> textLines, int x2, int y2, @Nonnull bfg fr2, int width, int height) {
            super(stack, textLines, x2, y2, fr2, width, height);
        }
    }

    public static class PostBackground
    extends Post {
        public PostBackground(@Nonnull afj stack, @Nonnull List<String> textLines, int x2, int y2, @Nonnull bfg fr2, int width, int height) {
            super(stack, textLines, x2, y2, fr2, width, height);
        }
    }

    protected static abstract class Post
    extends RenderTooltipEvent {
        private final int width;
        private final int height;

        public Post(@Nonnull afj stack, @Nonnull List<String> textLines, int x2, int y2, @Nonnull bfg fr2, int width, int height) {
            super(stack, textLines, x2, y2, fr2);
            this.width = width;
            this.height = height;
        }

        public int getWidth() {
            return this.width;
        }

        public int getHeight() {
            return this.height;
        }
    }

    @Cancelable
    public static class Pre
    extends RenderTooltipEvent {
        private int screenWidth;
        private int screenHeight;
        private int maxWidth;

        public Pre(@Nonnull afj stack, @Nonnull List<String> lines, int x2, int y2, int screenWidth, int screenHeight, int maxWidth, @Nonnull bfg fr2) {
            super(stack, lines, x2, y2, fr2);
            this.screenWidth = screenWidth;
            this.screenHeight = screenHeight;
            this.maxWidth = maxWidth;
        }

        public int getScreenWidth() {
            return this.screenWidth;
        }

        public void setScreenWidth(int screenWidth) {
            this.screenWidth = screenWidth;
        }

        public int getScreenHeight() {
            return this.screenHeight;
        }

        public void setScreenHeight(int screenHeight) {
            this.screenHeight = screenHeight;
        }

        public int getMaxWidth() {
            return this.maxWidth;
        }

        public void setMaxWidth(int maxWidth) {
            this.maxWidth = maxWidth;
        }

        public void setFontRenderer(@Nonnull bfg fr2) {
            this.fr = fr2;
        }

        public void setX(int x2) {
            this.x = x2;
        }

        public void setY(int y2) {
            this.y = y2;
        }
    }
}

