/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.client.model;

import com.google.common.base.Function;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.annotation.Nullable;
import javax.vecmath.Matrix4f;
import javax.vecmath.Quat4f;
import javax.vecmath.Vector3f;
import net.minecraftforge.client.model.IModel;
import net.minecraftforge.client.model.IPerspectiveAwareModel;
import net.minecraftforge.client.model.ModelStateComposition;
import net.minecraftforge.client.model.SimpleModelFontRenderer;
import net.minecraftforge.common.ForgeModContainer;
import net.minecraftforge.common.model.IModelState;
import net.minecraftforge.common.model.TRSRTransformation;
import org.apache.commons.lang3.tuple.Pair;

final class FancyMissingModel
implements IModel {
    private static final kq font = new kq("minecraft", "textures/font/ascii.png");
    private static final kq font2 = new kq("minecraft", "font/ascii");
    private static final TRSRTransformation smallTransformation = TRSRTransformation.blockCenterToCorner(new TRSRTransformation(null, null, new Vector3f(0.25f, 0.25f, 0.25f), null));
    private static final LoadingCache<bzj, SimpleModelFontRenderer> fontCache = CacheBuilder.newBuilder().maximumSize(3L).build((CacheLoader)new CacheLoader<bzj, SimpleModelFontRenderer>(){

        public SimpleModelFontRenderer load(bzj format) throws Exception {
            Matrix4f m2 = new Matrix4f();
            m2.m20 = 0.0078125f;
            m2.m01 = m2.m12 = -m2.m20;
            m2.m33 = 1.0f;
            m2.setTranslation(new Vector3f(1.0f, 1.0039062f, 0.0f));
            return new SimpleModelFontRenderer(bes.z().u, font, bes.z().N(), false, m2, format){

                @Override
                protected float b(char c2, boolean italic) {
                    return super.a(126, italic);
                }
            };
        }
    });
    private final IModel missingModel;
    private final String message;

    public FancyMissingModel(IModel missingModel, String message) {
        this.missingModel = missingModel;
        this.message = message;
    }

    @Override
    public Collection<kq> getDependencies() {
        return ImmutableList.of();
    }

    @Override
    public Collection<kq> getTextures() {
        return ImmutableList.of((Object)font2);
    }

    @Override
    public cbh bake(IModelState state, bzj format, Function<kq, byz> bakedTextureGetter) {
        cbh bigMissing = this.missingModel.bake(state, format, bakedTextureGetter);
        ModelStateComposition smallState = new ModelStateComposition(state, smallTransformation);
        cbh smallMissing = this.missingModel.bake(smallState, format, bakedTextureGetter);
        return new BakedModel(bigMissing, smallMissing, (SimpleModelFontRenderer)fontCache.getUnchecked((Object)format), this.message, (byz)bakedTextureGetter.apply((Object)font2));
    }

    @Override
    public IModelState getDefaultState() {
        return TRSRTransformation.identity();
    }

    private static final class BakedModel
    implements IPerspectiveAwareModel {
        private final SimpleModelFontRenderer fontRenderer;
        private final String message;
        private final byz fontTexture;
        private final cbh missingModel;
        private final cbh otherModel;
        private final boolean big;
        private ImmutableList<brd> quads;

        public BakedModel(cbh bigMissing, cbh smallMissing, SimpleModelFontRenderer fontRenderer, String message, byz fontTexture) {
            this.missingModel = bigMissing;
            this.otherModel = new BakedModel(smallMissing, fontRenderer, message, fontTexture, this);
            this.big = true;
            this.fontRenderer = fontRenderer;
            this.message = message;
            this.fontTexture = fontTexture;
        }

        public BakedModel(cbh smallMissing, SimpleModelFontRenderer fontRenderer, String message, byz fontTexture, BakedModel big2) {
            this.missingModel = smallMissing;
            this.otherModel = big2;
            this.big = false;
            this.fontRenderer = fontRenderer;
            this.message = message;
            this.fontTexture = fontTexture;
        }

        @Override
        public List<brd> a(@Nullable atl state, @Nullable cv side, long rand) {
            if (side == null) {
                if (this.quads == null) {
                    int y2;
                    this.fontRenderer.setSprite(this.fontTexture);
                    this.fontRenderer.setFillBlanks(true);
                    String[] lines = this.message.split("\\r?\\n");
                    ArrayList splitLines = Lists.newArrayList();
                    for (y2 = 0; y2 < lines.length; ++y2) {
                        splitLines.addAll(this.fontRenderer.c(lines[y2], 128));
                    }
                    for (y2 = 0; y2 < splitLines.size(); ++y2) {
                        this.fontRenderer.a((String)splitLines.get(y2), 0, (int)(((float)y2 - (float)splitLines.size() / 2.0f) * (float)this.fontRenderer.a) + 64, -16711681);
                    }
                    ImmutableList.Builder builder = ImmutableList.builder();
                    builder.addAll(this.missingModel.a(state, side, rand));
                    builder.addAll(this.fontRenderer.build());
                    this.quads = builder.build();
                }
                return this.quads;
            }
            return this.missingModel.a(state, side, rand);
        }

        @Override
        public boolean a() {
            return true;
        }

        @Override
        public boolean b() {
            return false;
        }

        @Override
        public boolean c() {
            return false;
        }

        @Override
        public byz d() {
            return this.fontTexture;
        }

        @Override
        public brq e() {
            return brq.a;
        }

        @Override
        public bro f() {
            return bro.a;
        }

        @Override
        public Pair<? extends cbh, Matrix4f> handlePerspective(brq.b cameraTransformType) {
            TRSRTransformation transform = TRSRTransformation.identity();
            boolean big2 = true;
            switch (cameraTransformType) {
                case b: {
                    break;
                }
                case c: {
                    break;
                }
                case d: {
                    transform = new TRSRTransformation(new Vector3f(-0.62f, 0.5f, -0.5f), new Quat4f(1.0f, -1.0f, -1.0f, 1.0f), null, null);
                    big2 = false;
                    break;
                }
                case e: {
                    transform = new TRSRTransformation(new Vector3f(-0.5f, 0.5f, -0.5f), new Quat4f(1.0f, 1.0f, 1.0f, 1.0f), null, null);
                    big2 = false;
                    break;
                }
                case f: {
                    break;
                }
                case g: {
                    if (ForgeModContainer.zoomInMissingModelTextInGui) {
                        transform = new TRSRTransformation(null, new Quat4f(1.0f, 1.0f, 1.0f, 1.0f), new Vector3f(4.0f, 4.0f, 4.0f), null);
                        big2 = false;
                        break;
                    }
                    transform = new TRSRTransformation(null, new Quat4f(1.0f, 1.0f, 1.0f, 1.0f), null, null);
                    big2 = true;
                    break;
                }
                case i: {
                    transform = new TRSRTransformation(null, new Quat4f(-1.0f, -1.0f, 1.0f, 1.0f), null, null);
                    break;
                }
            }
            if (big2 != this.big) {
                return Pair.of((Object)this.otherModel, (Object)transform.getMatrix());
            }
            return Pair.of((Object)this, (Object)transform.getMatrix());
        }
    }
}

