/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.client.model;

import com.google.common.base.Function;
import com.google.common.base.Optional;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.util.Arrays;
import java.util.BitSet;
import java.util.Collection;
import java.util.List;
import javax.annotation.Nullable;
import javax.vecmath.Matrix4f;
import javax.vecmath.Tuple4f;
import javax.vecmath.Vector4f;
import net.minecraftforge.client.model.ICustomModelLoader;
import net.minecraftforge.client.model.IModel;
import net.minecraftforge.client.model.IPerspectiveAwareModel;
import net.minecraftforge.client.model.IRetexturableModel;
import net.minecraftforge.client.model.pipeline.UnpackedBakedQuad;
import net.minecraftforge.common.model.IModelPart;
import net.minecraftforge.common.model.IModelState;
import net.minecraftforge.common.model.TRSRTransformation;
import org.apache.commons.lang3.tuple.Pair;

public final class ItemLayerModel
implements IRetexturableModel {
    public static final ItemLayerModel INSTANCE = new ItemLayerModel((ImmutableList<kq>)ImmutableList.of());
    private final ImmutableList<kq> textures;
    private final bro overrides;

    public ItemLayerModel(ImmutableList<kq> textures) {
        this(textures, bro.a);
    }

    public ItemLayerModel(ImmutableList<kq> textures, bro overrides) {
        this.textures = textures;
        this.overrides = overrides;
    }

    public ItemLayerModel(bri model) {
        this(ItemLayerModel.getTextures(model), model.g());
    }

    private static ImmutableList<kq> getTextures(bri model) {
        ImmutableList.Builder builder = ImmutableList.builder();
        int i2 = 0;
        while (model.b("layer" + i2)) {
            builder.add((Object)new kq(model.c("layer" + i2)));
            ++i2;
        }
        return builder.build();
    }

    @Override
    public Collection<kq> getDependencies() {
        return ImmutableList.of();
    }

    @Override
    public Collection<kq> getTextures() {
        return this.textures;
    }

    @Override
    public IModelState getDefaultState() {
        return TRSRTransformation.identity();
    }

    @Override
    public ItemLayerModel retexture(ImmutableMap<String, String> textures) {
        ImmutableList.Builder builder = ImmutableList.builder();
        for (int i2 = 0; i2 < textures.size() + this.textures.size(); ++i2) {
            if (textures.containsKey((Object)("layer" + i2))) {
                builder.add((Object)new kq((String)textures.get((Object)("layer" + i2))));
                continue;
            }
            if (i2 >= this.textures.size()) continue;
            builder.add(this.textures.get(i2));
        }
        return new ItemLayerModel((ImmutableList<kq>)builder.build(), this.overrides);
    }

    @Override
    public cbh bake(IModelState state, bzj format, Function<kq, byz> bakedTextureGetter) {
        ImmutableList.Builder builder = ImmutableList.builder();
        Optional<TRSRTransformation> transform = state.apply((Optional<? extends IModelPart>)Optional.absent());
        for (int i2 = 0; i2 < this.textures.size(); ++i2) {
            byz sprite = (byz)bakedTextureGetter.apply(this.textures.get(i2));
            builder.addAll(ItemLayerModel.getQuadsForSprite(i2, sprite, format, transform));
        }
        byz particle = (byz)bakedTextureGetter.apply((Object)(this.textures.isEmpty() ? new kq("missingno") : (kq)this.textures.get(0)));
        ImmutableMap<brq.b, TRSRTransformation> map = IPerspectiveAwareModel.MapWrapper.getTransforms(state);
        return new BakedItemModel((ImmutableList<brd>)builder.build(), particle, map, this.overrides, null);
    }

    public static ImmutableList<brd> getQuadsForSprite(int tint, byz sprite, bzj format, Optional<TRSRTransformation> transform) {
        ImmutableList.Builder builder = ImmutableList.builder();
        int uMax = sprite.c();
        int vMax = sprite.d();
        BitSet faces = new BitSet((uMax + 1) * (vMax + 1) * 4);
        for (int f2 = 0; f2 < sprite.k(); ++f2) {
            int[] pixels = sprite.a(f2)[0];
            boolean[] ptv = new boolean[uMax];
            Arrays.fill(ptv, true);
            for (int v2 = 0; v2 < vMax; ++v2) {
                boolean ptu = true;
                for (int u2 = 0; u2 < uMax; ++u2) {
                    boolean t2 = ItemLayerModel.isTransparent(pixels, uMax, vMax, u2, v2);
                    if (ptu && !t2) {
                        ItemLayerModel.addSideQuad((ImmutableList.Builder<brd>)builder, faces, format, transform, cv.e, tint, sprite, uMax, vMax, u2, v2);
                    }
                    if (!ptu && t2) {
                        ItemLayerModel.addSideQuad((ImmutableList.Builder<brd>)builder, faces, format, transform, cv.f, tint, sprite, uMax, vMax, u2, v2);
                    }
                    if (ptv[u2] && !t2) {
                        ItemLayerModel.addSideQuad((ImmutableList.Builder<brd>)builder, faces, format, transform, cv.b, tint, sprite, uMax, vMax, u2, v2);
                    }
                    if (!ptv[u2] && t2) {
                        ItemLayerModel.addSideQuad((ImmutableList.Builder<brd>)builder, faces, format, transform, cv.a, tint, sprite, uMax, vMax, u2, v2);
                    }
                    ptu = t2;
                    ptv[u2] = t2;
                }
                if (ptu) continue;
                ItemLayerModel.addSideQuad((ImmutableList.Builder<brd>)builder, faces, format, transform, cv.f, tint, sprite, uMax, vMax, uMax, v2);
            }
            for (int u3 = 0; u3 < uMax; ++u3) {
                if (ptv[u3]) continue;
                ItemLayerModel.addSideQuad((ImmutableList.Builder<brd>)builder, faces, format, transform, cv.a, tint, sprite, uMax, vMax, u3, vMax);
            }
        }
        builder.add((Object)ItemLayerModel.buildQuad(format, transform, cv.c, sprite, tint, 0.0f, 0.0f, 0.46875f, sprite.e(), sprite.h(), 0.0f, 1.0f, 0.46875f, sprite.e(), sprite.g(), 1.0f, 1.0f, 0.46875f, sprite.f(), sprite.g(), 1.0f, 0.0f, 0.46875f, sprite.f(), sprite.h()));
        builder.add((Object)ItemLayerModel.buildQuad(format, transform, cv.d, sprite, tint, 0.0f, 0.0f, 0.53125f, sprite.e(), sprite.h(), 1.0f, 0.0f, 0.53125f, sprite.f(), sprite.h(), 1.0f, 1.0f, 0.53125f, sprite.f(), sprite.g(), 0.0f, 1.0f, 0.53125f, sprite.e(), sprite.g()));
        return builder.build();
    }

    private static boolean isTransparent(int[] pixels, int uMax, int vMax, int u2, int v2) {
        return (pixels[u2 + (vMax - 1 - v2) * uMax] >> 24 & 0xFF) == 0;
    }

    private static void addSideQuad(ImmutableList.Builder<brd> builder, BitSet faces, bzj format, Optional<TRSRTransformation> transform, cv side, int tint, byz sprite, int uMax, int vMax, int u2, int v2) {
        int index;
        int si2 = side.ordinal();
        if (si2 > 4) {
            si2 -= 2;
        }
        if (!faces.get(index = (vMax + 1) * ((uMax + 1) * si2 + u2) + v2)) {
            faces.set(index);
            builder.add((Object)ItemLayerModel.buildSideQuad(format, transform, side, tint, sprite, u2, v2));
        }
    }

    private static brd buildSideQuad(bzj format, Optional<TRSRTransformation> transform, cv side, int tint, byz sprite, int u2, int v2) {
        float eps0 = 3.0E-4f;
        float eps1 = 4.5E-4f;
        float eps2 = 0.5f;
        float eps3 = 0.5f;
        float x0 = (float)u2 / (float)sprite.c();
        float y0 = (float)v2 / (float)sprite.d();
        float x1 = x0;
        float y1 = y0;
        float z1 = 0.4683f;
        float z2 = 0.5317f;
        switch (side) {
            case e: {
                z1 = 0.5317f;
                z2 = 0.4683f;
            }
            case f: {
                y1 = ((float)v2 + 1.0f) / (float)sprite.d();
                break;
            }
            case a: {
                z1 = 0.5317f;
                z2 = 0.4683f;
            }
            case b: {
                x1 = ((float)u2 + 1.0f) / (float)sprite.c();
                break;
            }
            default: {
                throw new IllegalArgumentException("can't handle z-oriented side");
            }
        }
        float u0 = 16.0f * (x0 - (float)side.n().p() * 0.5f / (float)sprite.c());
        float u1 = 16.0f * (x1 - (float)side.n().p() * 0.5f / (float)sprite.c());
        float v0 = 16.0f * (1.0f - y0 - (float)side.n().q() * 0.5f / (float)sprite.d());
        float v1 = 16.0f * (1.0f - y1 - (float)side.n().q() * 0.5f / (float)sprite.d());
        switch (side) {
            case e: 
            case f: {
                y0 -= 4.5E-4f;
                y1 += 4.5E-4f;
                v0 -= 0.5f / (float)sprite.d();
                v1 += 0.5f / (float)sprite.d();
                break;
            }
            case a: 
            case b: {
                x0 -= 4.5E-4f;
                x1 += 4.5E-4f;
                u0 += 0.5f / (float)sprite.c();
                u1 -= 0.5f / (float)sprite.c();
                break;
            }
            default: {
                throw new IllegalArgumentException("can't handle z-oriented side");
            }
        }
        switch (side) {
            case e: {
                x0 += 3.0E-4f;
                x1 += 3.0E-4f;
                break;
            }
            case f: {
                x0 -= 3.0E-4f;
                x1 -= 3.0E-4f;
                break;
            }
            case a: {
                y0 -= 3.0E-4f;
                y1 -= 3.0E-4f;
                break;
            }
            case b: {
                y0 += 3.0E-4f;
                y1 += 3.0E-4f;
                break;
            }
            default: {
                throw new IllegalArgumentException("can't handle z-oriented side");
            }
        }
        return ItemLayerModel.buildQuad(format, transform, side.d(), sprite, tint, x0, y0, z1, sprite.a((double)u0), sprite.b((double)v0), x1, y1, z1, sprite.a((double)u1), sprite.b((double)v1), x1, y1, z2, sprite.a((double)u1), sprite.b((double)v1), x0, y0, z2, sprite.a((double)u0), sprite.b((double)v0));
    }

    private static final brd buildQuad(bzj format, Optional<TRSRTransformation> transform, cv side, byz sprite, int tint, float x0, float y0, float z0, float u0, float v0, float x1, float y1, float z1, float u1, float v1, float x2, float y2, float z2, float u2, float v2, float x3, float y3, float z3, float u3, float v3) {
        UnpackedBakedQuad.Builder builder = new UnpackedBakedQuad.Builder(format);
        builder.setQuadTint(tint);
        builder.setQuadOrientation(side);
        builder.setTexture(sprite);
        ItemLayerModel.putVertex(builder, format, transform, side, x0, y0, z0, u0, v0);
        ItemLayerModel.putVertex(builder, format, transform, side, x1, y1, z1, u1, v1);
        ItemLayerModel.putVertex(builder, format, transform, side, x2, y2, z2, u2, v2);
        ItemLayerModel.putVertex(builder, format, transform, side, x3, y3, z3, u3, v3);
        return builder.build();
    }

    private static void putVertex(UnpackedBakedQuad.Builder builder, bzj format, Optional<TRSRTransformation> transform, cv side, float x2, float y2, float z2, float u2, float v2) {
        Vector4f vec = new Vector4f();
        block6: for (int e2 = 0; e2 < format.i(); ++e2) {
            switch (format.c(e2).b()) {
                case a: {
                    if (transform.isPresent()) {
                        vec.x = x2;
                        vec.y = y2;
                        vec.z = z2;
                        vec.w = 1.0f;
                        ((TRSRTransformation)transform.get()).getMatrix().transform((Tuple4f)vec);
                        builder.put(e2, vec.x, vec.y, vec.z, vec.w);
                        continue block6;
                    }
                    builder.put(e2, x2, y2, z2, 1.0f);
                    continue block6;
                }
                case c: {
                    builder.put(e2, 1.0f, 1.0f, 1.0f, 1.0f);
                    continue block6;
                }
                case d: {
                    if (format.c(e2).d() == 0) {
                        builder.put(e2, u2, v2, 0.0f, 1.0f);
                        continue block6;
                    }
                }
                case b: {
                    builder.put(e2, side.g(), side.h(), side.i(), 0.0f);
                    continue block6;
                }
                default: {
                    builder.put(e2, new float[0]);
                }
            }
        }
    }

    public static enum Loader implements ICustomModelLoader
    {
        INSTANCE;


        @Override
        public void a(bzy resourceManager) {
        }

        @Override
        public boolean accepts(kq modelLocation) {
            return modelLocation.b().equals("forge") && (modelLocation.a().equals("item-layer") || modelLocation.a().equals("models/block/item-layer") || modelLocation.a().equals("models/item/item-layer"));
        }

        @Override
        public IModel loadModel(kq modelLocation) {
            return INSTANCE;
        }
    }

    private static final class BakedItemModel
    implements IPerspectiveAwareModel {
        private final ImmutableList<brd> quads;
        private final byz particle;
        private final ImmutableMap<brq.b, TRSRTransformation> transforms;
        private final cbh otherModel;
        private final boolean isCulled;
        private final bro overrides;

        public BakedItemModel(ImmutableList<brd> quads, byz particle, ImmutableMap<brq.b, TRSRTransformation> transforms, bro overrides, @Nullable cbh otherModel) {
            this.quads = quads;
            this.particle = particle;
            this.transforms = transforms;
            this.overrides = overrides;
            if (otherModel != null) {
                this.otherModel = otherModel;
                this.isCulled = true;
            } else {
                ImmutableList.Builder builder = ImmutableList.builder();
                for (brd quad : quads) {
                    if (quad.e() != cv.d) continue;
                    builder.add((Object)quad);
                }
                this.otherModel = new BakedItemModel((ImmutableList<brd>)builder.build(), particle, transforms, overrides, this);
                this.isCulled = false;
            }
        }

        @Override
        public boolean a() {
            return true;
        }

        @Override
        public boolean b() {
            return false;
        }

        @Override
        public boolean c() {
            return false;
        }

        @Override
        public byz d() {
            return this.particle;
        }

        @Override
        public brq e() {
            return brq.a;
        }

        @Override
        public bro f() {
            return this.overrides;
        }

        @Override
        public List<brd> a(atl state, cv side, long rand) {
            if (side == null) {
                return this.quads;
            }
            return ImmutableList.of();
        }

        @Override
        public Pair<? extends cbh, Matrix4f> handlePerspective(brq.b type) {
            Pair<? extends cbh, Matrix4f> pair = IPerspectiveAwareModel.MapWrapper.handlePerspective((cbh)this, this.transforms, type);
            if (type == brq.b.g && !this.isCulled && pair.getRight() == null) {
                return Pair.of((Object)this.otherModel, null);
            }
            if (type != brq.b.g && this.isCulled) {
                return Pair.of((Object)this.otherModel, (Object)pair.getRight());
            }
            return pair;
        }
    }
}

