/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.client.model;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import javax.vecmath.Tuple4f;
import javax.vecmath.Vector4f;
import net.minecraftforge.client.model.pipeline.UnpackedBakedQuad;
import net.minecraftforge.common.model.TRSRTransformation;

public final class ItemTextureQuadConverter {
    private ItemTextureQuadConverter() {
    }

    public static List<UnpackedBakedQuad> convertTexture(bzj format, TRSRTransformation transform, byz template, byz sprite, float z2, cv facing, int color) {
        List<UnpackedBakedQuad> horizontal = ItemTextureQuadConverter.convertTextureHorizontal(format, transform, template, sprite, z2, facing, color);
        List<UnpackedBakedQuad> vertical = ItemTextureQuadConverter.convertTextureVertical(format, transform, template, sprite, z2, facing, color);
        return horizontal.size() >= vertical.size() ? horizontal : vertical;
    }

    public static List<UnpackedBakedQuad> convertTextureHorizontal(bzj format, TRSRTransformation transform, byz template, byz sprite, float z2, cv facing, int color) {
        int w2 = template.c();
        int h2 = template.d();
        float wScale = 16.0f / (float)w2;
        float hScale = 16.0f / (float)h2;
        int[] data = template.a(0)[0];
        ArrayList quads = Lists.newArrayList();
        int start = -1;
        for (int y2 = 0; y2 < h2; ++y2) {
            for (int x2 = 0; x2 < w2; ++x2) {
                int pixel = data[y2 * w2 + x2];
                if (start < 0 && ItemTextureQuadConverter.isVisible(pixel)) {
                    start = x2;
                }
                if (start < 0 || ItemTextureQuadConverter.isVisible(pixel)) continue;
                int endY = y2 + 1;
                boolean sameRow = true;
                while (sameRow) {
                    for (int i2 = 0; i2 < w2; ++i2) {
                        int px1 = data[y2 * w2 + i2];
                        int px2 = data[endY * w2 + i2];
                        if (ItemTextureQuadConverter.isVisible(px1) == ItemTextureQuadConverter.isVisible(px2)) continue;
                        sameRow = false;
                        break;
                    }
                    if (!sameRow) continue;
                    ++endY;
                }
                quads.add(ItemTextureQuadConverter.genQuad(format, transform, (float)start * wScale, (float)y2 * hScale, (float)x2 * wScale, (float)endY * hScale, z2, sprite, facing, color));
                if (endY - y2 > 1) {
                    y2 = endY - 1;
                }
                start = -1;
            }
        }
        return quads;
    }

    public static List<UnpackedBakedQuad> convertTextureVertical(bzj format, TRSRTransformation transform, byz template, byz sprite, float z2, cv facing, int color) {
        int w2 = template.c();
        int h2 = template.d();
        float wScale = 16.0f / (float)w2;
        float hScale = 16.0f / (float)h2;
        int[] data = template.a(0)[0];
        ArrayList quads = Lists.newArrayList();
        int start = -1;
        for (int x2 = 0; x2 < w2; ++x2) {
            for (int y2 = 0; y2 < h2; ++y2) {
                int pixel = data[y2 * w2 + x2];
                if (start < 0 && ItemTextureQuadConverter.isVisible(pixel)) {
                    start = y2;
                }
                if (start < 0 || ItemTextureQuadConverter.isVisible(pixel)) continue;
                int endX = x2 + 1;
                boolean sameColumn = true;
                while (sameColumn) {
                    for (int i2 = 0; i2 < h2; ++i2) {
                        int px1 = data[i2 * w2 + x2];
                        int px2 = data[i2 * w2 + endX];
                        if (ItemTextureQuadConverter.isVisible(px1) == ItemTextureQuadConverter.isVisible(px2)) continue;
                        sameColumn = false;
                        break;
                    }
                    if (!sameColumn) continue;
                    ++endX;
                }
                quads.add(ItemTextureQuadConverter.genQuad(format, transform, (float)x2 * wScale, (float)start * hScale, (float)endX * wScale, (float)y2 * hScale, z2, sprite, facing, color));
                if (endX - x2 > 1) {
                    x2 = endX - 1;
                }
                start = -1;
            }
        }
        return quads;
    }

    private static boolean isVisible(int color) {
        return (color >> 24 & 0xFF) > 0;
    }

    public static UnpackedBakedQuad genQuad(bzj format, TRSRTransformation transform, float x1, float y1, float x2, float y2, float z2, byz sprite, cv facing, int color) {
        float u1 = sprite.a((double)x1);
        float v1 = sprite.b((double)y1);
        float u2 = sprite.a((double)x2);
        float v2 = sprite.b((double)y2);
        float tmp = y1 /= 16.0f;
        y1 = 1.0f - (y2 /= 16.0f);
        y2 = 1.0f - tmp;
        return ItemTextureQuadConverter.putQuad(format, transform, facing, sprite, color, x1 /= 16.0f, y1, x2 /= 16.0f, y2, z2, u1, v1, u2, v2);
    }

    private static UnpackedBakedQuad putQuad(bzj format, TRSRTransformation transform, cv side, byz sprite, int color, float x1, float y1, float x2, float y2, float z2, float u1, float v1, float u2, float v2) {
        side = side.d();
        UnpackedBakedQuad.Builder builder = new UnpackedBakedQuad.Builder(format);
        builder.setQuadTint(-1);
        builder.setQuadOrientation(side);
        builder.setTexture(sprite);
        if (side == cv.c) {
            ItemTextureQuadConverter.putVertex(builder, format, transform, side, x1, y1, z2, u1, v2, color);
            ItemTextureQuadConverter.putVertex(builder, format, transform, side, x2, y1, z2, u2, v2, color);
            ItemTextureQuadConverter.putVertex(builder, format, transform, side, x2, y2, z2, u2, v1, color);
            ItemTextureQuadConverter.putVertex(builder, format, transform, side, x1, y2, z2, u1, v1, color);
        } else {
            ItemTextureQuadConverter.putVertex(builder, format, transform, side, x1, y1, z2, u1, v2, color);
            ItemTextureQuadConverter.putVertex(builder, format, transform, side, x1, y2, z2, u1, v1, color);
            ItemTextureQuadConverter.putVertex(builder, format, transform, side, x2, y2, z2, u2, v1, color);
            ItemTextureQuadConverter.putVertex(builder, format, transform, side, x2, y1, z2, u2, v2, color);
        }
        return builder.build();
    }

    private static void putVertex(UnpackedBakedQuad.Builder builder, bzj format, TRSRTransformation transform, cv side, float x2, float y2, float z2, float u2, float v2, int color) {
        Vector4f vec = new Vector4f();
        block6: for (int e2 = 0; e2 < format.i(); ++e2) {
            switch (format.c(e2).b()) {
                case a: {
                    if (transform == TRSRTransformation.identity()) {
                        builder.put(e2, x2, y2, z2, 1.0f);
                        continue block6;
                    }
                    vec.x = x2;
                    vec.y = y2;
                    vec.z = z2;
                    vec.w = 1.0f;
                    transform.getMatrix().transform((Tuple4f)vec);
                    builder.put(e2, vec.x, vec.y, vec.z, vec.w);
                    continue block6;
                }
                case c: {
                    float r2 = (float)(color >> 16 & 0xFF) / 255.0f;
                    float g2 = (float)(color >> 8 & 0xFF) / 255.0f;
                    float b2 = (float)(color >> 0 & 0xFF) / 255.0f;
                    float a2 = (float)(color >> 24 & 0xFF) / 255.0f;
                    builder.put(e2, r2, g2, b2, a2);
                    continue block6;
                }
                case d: {
                    if (format.c(e2).d() == 0) {
                        builder.put(e2, u2, v2, 0.0f, 1.0f);
                        continue block6;
                    }
                }
                case b: {
                    builder.put(e2, side.g(), side.h(), side.i(), 0.0f);
                    continue block6;
                }
                default: {
                    builder.put(e2, new float[0]);
                }
            }
        }
    }
}

