/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.client.model;

import com.google.common.base.Function;
import com.google.common.base.Optional;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Maps;
import com.google.gson.JsonElement;
import com.google.gson.JsonParser;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumMap;
import java.util.List;
import javax.vecmath.Matrix4f;
import javax.vecmath.Tuple4f;
import javax.vecmath.Vector4f;
import net.minecraftforge.client.model.ICustomModelLoader;
import net.minecraftforge.client.model.IModel;
import net.minecraftforge.client.model.IModelCustomData;
import net.minecraftforge.client.model.IPerspectiveAwareModel;
import net.minecraftforge.client.model.pipeline.UnpackedBakedQuad;
import net.minecraftforge.common.model.IModelPart;
import net.minecraftforge.common.model.IModelState;
import net.minecraftforge.common.model.TRSRTransformation;
import net.minecraftforge.common.property.IExtendedBlockState;
import net.minecraftforge.fluids.BlockFluidBase;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fml.common.FMLLog;
import org.apache.commons.lang3.tuple.Pair;

public final class ModelFluid
implements IModelCustomData {
    public static final ModelFluid WATER = new ModelFluid(FluidRegistry.WATER);
    public static final ModelFluid LAVA = new ModelFluid(FluidRegistry.LAVA);
    private final Fluid fluid;

    public ModelFluid(Fluid fluid) {
        this.fluid = fluid;
    }

    @Override
    public Collection<kq> getDependencies() {
        return Collections.emptySet();
    }

    @Override
    public Collection<kq> getTextures() {
        return ImmutableSet.of((Object)this.fluid.getStill(), (Object)this.fluid.getFlowing());
    }

    @Override
    public cbh bake(IModelState state, bzj format, Function<kq, byz> bakedTextureGetter) {
        ImmutableMap<brq.b, TRSRTransformation> map = IPerspectiveAwareModel.MapWrapper.getTransforms(state);
        return new BakedFluid(state.apply((Optional<? extends IModelPart>)Optional.absent()), map, format, this.fluid.getColor(), (byz)bakedTextureGetter.apply((Object)this.fluid.getStill()), (byz)bakedTextureGetter.apply((Object)this.fluid.getFlowing()), this.fluid.isGaseous(), (Optional<IExtendedBlockState>)Optional.absent());
    }

    @Override
    public IModelState getDefaultState() {
        return cbi.a;
    }

    @Override
    public ModelFluid process(ImmutableMap<String, String> customData) {
        if (!customData.containsKey((Object)"fluid")) {
            return this;
        }
        String fluidStr = (String)customData.get((Object)"fluid");
        JsonElement e2 = new JsonParser().parse(fluidStr);
        String fluid = e2.getAsString();
        if (!FluidRegistry.isFluidRegistered(fluid)) {
            FMLLog.severe("fluid '%s' not found", fluid);
            return WATER;
        }
        return new ModelFluid(FluidRegistry.getFluid(fluid));
    }

    private static final class BakedFluid
    implements IPerspectiveAwareModel {
        private static final int[] x = new int[]{0, 0, 1, 1};
        private static final int[] z = new int[]{0, 1, 1, 0};
        private static final float eps = 0.001f;
        private final LoadingCache<Long, BakedFluid> modelCache = CacheBuilder.newBuilder().maximumSize(200L).build((CacheLoader)new CacheLoader<Long, BakedFluid>(){

            public BakedFluid load(Long key) throws Exception {
                boolean statePresent = (key & 1L) != 0L;
                key = key >>> 1;
                int[] cornerRound = new int[4];
                for (int i2 = 0; i2 < 4; ++i2) {
                    cornerRound[i2] = (int)(key & 0x3FFL);
                    key = key >>> 10;
                }
                int flowRound = (int)(key & 0x7FFL) - 1024;
                return new BakedFluid((Optional<TRSRTransformation>)BakedFluid.this.transformation, (ImmutableMap<brq.b, TRSRTransformation>)BakedFluid.this.transforms, BakedFluid.this.format, BakedFluid.this.color, BakedFluid.this.still, BakedFluid.this.flowing, BakedFluid.this.gas, statePresent, cornerRound, flowRound);
            }
        });
        private final Optional<TRSRTransformation> transformation;
        private final ImmutableMap<brq.b, TRSRTransformation> transforms;
        private final bzj format;
        private final int color;
        private final byz still;
        private final byz flowing;
        private final boolean gas;
        private final EnumMap<cv, List<brd>> faceQuads;

        public BakedFluid(Optional<TRSRTransformation> transformation, ImmutableMap<brq.b, TRSRTransformation> transforms, bzj format, int color, byz still, byz flowing, boolean gas, Optional<IExtendedBlockState> stateOption) {
            this(transformation, transforms, format, color, still, flowing, gas, stateOption.isPresent(), BakedFluid.getCorners(stateOption), BakedFluid.getFlow(stateOption));
        }

        private static int[] getCorners(Optional<IExtendedBlockState> stateOption) {
            int[] cornerRound = new int[]{0, 0, 0, 0};
            if (stateOption.isPresent()) {
                IExtendedBlockState state = (IExtendedBlockState)stateOption.get();
                for (int i2 = 0; i2 < 4; ++i2) {
                    Float level = state.getValue(BlockFluidBase.LEVEL_CORNERS[i2]);
                    cornerRound[i2] = Math.round((level == null ? 0.875f : level.floatValue()) * 768.0f);
                }
            }
            return cornerRound;
        }

        private static int getFlow(Optional<IExtendedBlockState> stateOption) {
            Float flow = Float.valueOf(-1000.0f);
            if (stateOption.isPresent() && (flow = ((IExtendedBlockState)stateOption.get()).getValue(BlockFluidBase.FLOW_DIRECTION)) == null) {
                flow = Float.valueOf(-1000.0f);
            }
            int flowRound = (int)Math.round(Math.toDegrees(flow.floatValue()));
            flowRound = ot.a(flowRound, -1000, 1000);
            return flowRound;
        }

        public BakedFluid(Optional<TRSRTransformation> transformation, ImmutableMap<brq.b, TRSRTransformation> transforms, bzj format, int color, byz still, byz flowing, boolean gas, boolean statePresent, int[] cornerRound, int flowRound) {
            int i2;
            this.transformation = transformation;
            this.transforms = transforms;
            this.format = format;
            this.color = color;
            this.still = still;
            this.flowing = flowing;
            this.gas = gas;
            this.faceQuads = Maps.newEnumMap(cv.class);
            for (cv side : cv.values()) {
                this.faceQuads.put(side, (List<brd>)ImmutableList.of());
            }
            if (statePresent) {
                int i3;
                UnpackedBakedQuad.Builder builder;
                float[] y2 = new float[4];
                for (i2 = 0; i2 < 4; ++i2) {
                    y2[i2] = gas ? 1.0f - (float)cornerRound[i2] / 768.0f : (float)cornerRound[i2] / 768.0f;
                }
                float flow = (float)Math.toRadians(flowRound);
                byz topSprite = flowing;
                float scale = 4.0f;
                if (flow < -17.0f) {
                    flow = 0.0f;
                    scale = 8.0f;
                    topSprite = still;
                }
                float c2 = ot.b(flow) * scale;
                float s2 = ot.a(flow) * scale;
                cv side = gas ? cv.a : cv.b;
                ImmutableList.Builder topFaceBuilder = ImmutableList.builder();
                for (int k2 = 0; k2 < 2; ++k2) {
                    builder = new UnpackedBakedQuad.Builder(format);
                    builder.setQuadOrientation(side);
                    builder.setTexture(topSprite);
                    for (int i4 = gas ? 3 : 0; i4 != (gas ? -1 : 4); i4 += gas ? -1 : 1) {
                        int l2 = k2 * 3 + (1 - 2 * k2) * i4;
                        this.putVertex(builder, side, x[l2], y2[l2], z[l2], topSprite.a((double)(8.0f + c2 * (float)(x[l2] * 2 - 1) + s2 * (float)(z[l2] * 2 - 1))), topSprite.b((double)(8.0f + c2 * (float)(x[(l2 + 1) % 4] * 2 - 1) + s2 * (float)(z[(l2 + 1) % 4] * 2 - 1))));
                    }
                    topFaceBuilder.add((Object)builder.build());
                }
                this.faceQuads.put(side, (List<brd>)topFaceBuilder.build());
                side = side.d();
                builder = new UnpackedBakedQuad.Builder(format);
                builder.setQuadOrientation(side);
                builder.setTexture(still);
                for (i3 = gas ? 3 : 0; i3 != (gas ? -1 : 4); i3 += gas ? -1 : 1) {
                    this.putVertex(builder, side, z[i3], gas ? 1.0f : 0.0f, x[i3], still.a((double)(z[i3] * 16)), still.b((double)(x[i3] * 16)));
                }
                this.faceQuads.put(side, (List<brd>)ImmutableList.of((Object)builder.build()));
                for (i3 = 0; i3 < 4; ++i3) {
                    side = cv.b((5 - i3) % 4);
                    brd[] q2 = new brd[2];
                    for (int k3 = 0; k3 < 2; ++k3) {
                        builder = new UnpackedBakedQuad.Builder(format);
                        builder.setQuadOrientation(side);
                        builder.setTexture(flowing);
                        for (int j2 = 0; j2 < 4; ++j2) {
                            int l3 = k3 * 3 + (1 - 2 * k3) * j2;
                            float yl2 = (float)z[l3] * y2[(i3 + x[l3]) % 4];
                            if (gas && z[l3] == 0) {
                                yl2 = 1.0f;
                            }
                            this.putVertex(builder, side, x[(i3 + x[l3]) % 4], yl2, z[(i3 + x[l3]) % 4], flowing.a((double)(x[l3] * 8)), flowing.b((double)((gas ? yl2 : 1.0f - yl2) * 8.0f)));
                        }
                        q2[k3] = builder.build();
                    }
                    this.faceQuads.put(side, (List<brd>)ImmutableList.of((Object)q2[0], (Object)q2[1]));
                }
            } else {
                UnpackedBakedQuad.Builder builder = new UnpackedBakedQuad.Builder(format);
                builder.setQuadOrientation(cv.b);
                builder.setTexture(still);
                for (i2 = 0; i2 < 4; ++i2) {
                    this.putVertex(builder, cv.b, z[i2], x[i2], 0.0f, still.a((double)(z[i2] * 16)), still.b((double)(x[i2] * 16)));
                }
                this.faceQuads.put(cv.d, (List<brd>)ImmutableList.of((Object)builder.build()));
            }
        }

        private void putVertex(UnpackedBakedQuad.Builder builder, cv side, float x2, float y2, float z2, float u2, float v2) {
            block6: for (int e2 = 0; e2 < this.format.i(); ++e2) {
                switch (this.format.c(e2).b()) {
                    case a: {
                        float[] data = new float[]{x2 - (float)side.n().p() * 0.001f, y2, z2 - (float)side.n().r() * 0.001f, 1.0f};
                        if (this.transformation.isPresent() && this.transformation.get() != TRSRTransformation.identity()) {
                            Vector4f vec = new Vector4f(data);
                            ((TRSRTransformation)this.transformation.get()).getMatrix().transform((Tuple4f)vec);
                            vec.get(data);
                        }
                        builder.put(e2, data);
                        continue block6;
                    }
                    case c: {
                        builder.put(e2, (float)(this.color >> 16 & 0xFF) / 255.0f, (float)(this.color >> 8 & 0xFF) / 255.0f, (float)(this.color & 0xFF) / 255.0f, (float)(this.color >> 24 & 0xFF) / 255.0f);
                        continue block6;
                    }
                    case d: {
                        if (this.format.c(e2).d() == 0) {
                            builder.put(e2, u2, v2, 0.0f, 1.0f);
                            continue block6;
                        }
                    }
                    case b: {
                        builder.put(e2, side.g(), side.h(), side.i(), 0.0f);
                        continue block6;
                    }
                    default: {
                        builder.put(e2, new float[0]);
                    }
                }
            }
        }

        @Override
        public boolean a() {
            return true;
        }

        @Override
        public boolean b() {
            return false;
        }

        @Override
        public boolean c() {
            return false;
        }

        @Override
        public byz d() {
            return this.still;
        }

        @Override
        public brq e() {
            return brq.a;
        }

        @Override
        public List<brd> a(atl state, cv side, long rand) {
            BakedFluid model = this;
            if (state instanceof IExtendedBlockState) {
                IExtendedBlockState exState = (IExtendedBlockState)state;
                int[] cornerRound = BakedFluid.getCorners((Optional<IExtendedBlockState>)Optional.of((Object)exState));
                int flowRound = BakedFluid.getFlow((Optional<IExtendedBlockState>)Optional.of((Object)exState));
                long key = flowRound + 1024;
                for (int i2 = 3; i2 >= 0; --i2) {
                    key <<= 10;
                    key |= (long)cornerRound[i2];
                }
                key <<= 1;
                model = (BakedFluid)this.modelCache.getUnchecked((Object)(key |= 1L));
            }
            if (side == null) {
                return ImmutableList.of();
            }
            return model.faceQuads.get(side);
        }

        @Override
        public bro f() {
            return bro.a;
        }

        @Override
        public Pair<? extends cbh, Matrix4f> handlePerspective(brq.b type) {
            return IPerspectiveAwareModel.MapWrapper.handlePerspective((cbh)this, this.transforms, type);
        }
    }

    public static enum FluidLoader implements ICustomModelLoader
    {
        INSTANCE;


        @Override
        public void a(bzy resourceManager) {
        }

        @Override
        public boolean accepts(kq modelLocation) {
            return modelLocation.b().equals("forge") && (modelLocation.a().equals("fluid") || modelLocation.a().equals("models/block/fluid") || modelLocation.a().equals("models/item/fluid"));
        }

        @Override
        public IModel loadModel(kq modelLocation) {
            return WATER;
        }
    }
}

