/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.client.model;

import com.google.common.base.Function;
import com.google.common.base.Joiner;
import com.google.common.base.Objects;
import com.google.common.base.Optional;
import com.google.common.base.Predicate;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Multimap;
import com.google.common.collect.Multimaps;
import com.google.common.collect.Sets;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.image.BufferedImage;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nonnull;
import net.minecraft.launchwrapper.Launch;
import net.minecraftforge.client.model.Attributes;
import net.minecraftforge.client.model.ICustomModelLoader;
import net.minecraftforge.client.model.IModel;
import net.minecraftforge.client.model.IModelSimpleProperties;
import net.minecraftforge.client.model.IModelUVLock;
import net.minecraftforge.client.model.IPerspectiveAwareModel;
import net.minecraftforge.client.model.IRetexturableModel;
import net.minecraftforge.client.model.ItemLayerModel;
import net.minecraftforge.client.model.ModelDynBucket;
import net.minecraftforge.client.model.ModelLoaderRegistry;
import net.minecraftforge.client.model.ModelStateComposition;
import net.minecraftforge.client.model.MultiModelState;
import net.minecraftforge.client.model.SimpleModelState;
import net.minecraftforge.client.model.animation.AnimationItemOverrideList;
import net.minecraftforge.client.model.animation.IAnimatedModel;
import net.minecraftforge.client.model.animation.ModelBlockAnimation;
import net.minecraftforge.common.ForgeModContainer;
import net.minecraftforge.common.model.IModelPart;
import net.minecraftforge.common.model.IModelState;
import net.minecraftforge.common.model.Models;
import net.minecraftforge.common.model.TRSRTransformation;
import net.minecraftforge.common.model.animation.IClip;
import net.minecraftforge.common.property.IExtendedBlockState;
import net.minecraftforge.common.property.Properties;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidUtil;
import net.minecraftforge.fluids.capability.IFluidHandlerItem;
import net.minecraftforge.fml.common.FMLLog;
import net.minecraftforge.fml.common.ProgressManager;
import net.minecraftforge.fml.common.registry.GameData;
import net.minecraftforge.fml.common.registry.RegistryDelegate;
import org.apache.commons.lang3.tuple.Pair;
import org.lwjgl.util.vector.Vector3f;

public final class ModelLoader
extends cbk {
    private static boolean firstLoad = Boolean.parseBoolean(System.getProperty("fml.skipFirstModelBake", "true"));
    private final Map<cbm, IModel> stateModels = Maps.newHashMap();
    private final Set<cbm> missingVariants = Sets.newHashSet();
    private final Map<kq, Exception> loadingExceptions = Maps.newHashMap();
    private IModel missingModel = null;
    private boolean isLoading = false;
    private final boolean enableVerboseMissingInfo = (Boolean)Launch.blackboard.get("fml.deobfuscatedEnvironment") != false || Boolean.parseBoolean(System.getProperty("forge.verboseMissingModelLogging", "false"));
    private final int verboseMissingInfoCount = Integer.parseInt(System.getProperty("forge.verboseMissingModelLoggingCount", "5"));
    private static final Map<RegistryDelegate<alu>, bsg> customStateMappers = Maps.newHashMap();
    private static final Map<RegistryDelegate<afh>, bqk> customMeshDefinitions = Maps.newHashMap();
    private static final Map<Pair<RegistryDelegate<afh>, Integer>, cbm> customModels = Maps.newHashMap();

    public boolean isLoading() {
        return this.isLoading;
    }

    public ModelLoader(bzy manager, byy map, bqz shapes) {
        super(manager, map, shapes);
        VanillaLoader.INSTANCE.setLoader(this);
        VariantLoader.INSTANCE.setLoader(this);
        ModelLoaderRegistry.clearModelCache(manager);
    }

    @Override
    public dh<cbm, cbh> a() {
        this.isLoading = true;
        this.b();
        this.c();
        this.missingModel = ModelLoaderRegistry.getMissingModel();
        this.stateModels.put(a, this.missingModel);
        final HashSet textures = Sets.newHashSet(ModelLoaderRegistry.getTextures());
        textures.remove(byy.f);
        textures.addAll(b);
        this.l.a(this.g, new byr(){

            @Override
            public void a(byy map) {
                for (kq t2 : textures) {
                    map.a(t2);
                }
            }
        });
        cbh missingBaked = this.missingModel.bake(this.missingModel.getDefaultState(), bzh.b, DefaultTextureGetter.INSTANCE);
        HashMap bakedModels = Maps.newHashMap();
        HashMultimap models = HashMultimap.create();
        Multimaps.invertFrom((Multimap)Multimaps.forMap(this.stateModels), (Multimap)models);
        if (firstLoad) {
            firstLoad = false;
            for (cbm mrl : this.stateModels.keySet()) {
                this.p.a(mrl, missingBaked);
            }
            return this.p;
        }
        ProgressManager.ProgressBar bakeBar = ProgressManager.push("ModelLoader: baking", models.keySet().size());
        for (IModel iModel : models.keySet()) {
            bakeBar.step("[" + Joiner.on((String)", ").join((Iterable)models.get((Object)iModel)) + "]");
            if (iModel == this.getMissingModel()) {
                bakedModels.put(iModel, missingBaked);
                continue;
            }
            bakedModels.put(iModel, iModel.bake(iModel.getDefaultState(), bzh.b, DefaultTextureGetter.INSTANCE));
        }
        ProgressManager.pop(bakeBar);
        for (Map.Entry entry : this.stateModels.entrySet()) {
            this.p.a(entry.getKey(), bakedModels.get(entry.getValue()));
        }
        return this.p;
    }

    @Override
    protected void e() {
    }

    @Override
    protected void f() {
    }

    @Override
    protected void b() {
        ArrayList blocks = Lists.newArrayList((Iterable)Iterables.filter(alu.h, (Predicate)new Predicate<alu>(){

            public boolean apply(alu block) {
                return block.getRegistryName() != null;
            }
        }));
        Collections.sort(blocks, new Comparator<alu>(){

            @Override
            public int compare(alu b1, alu b2) {
                return b1.getRegistryName().toString().compareTo(b2.getRegistryName().toString());
            }
        });
        ProgressManager.ProgressBar blockBar = ProgressManager.push("ModelLoader: blocks", blocks.size());
        bsd mapper = this.m.a();
        for (alu block : blocks) {
            blockBar.step(block.getRegistryName().toString());
            for (kq location : mapper.a(block)) {
                this.loadBlock(mapper, block, location);
            }
        }
        ProgressManager.pop(blockBar);
    }

    @Override
    protected void a(brj definition, cbm location) {
        IModel model;
        try {
            model = ModelLoaderRegistry.getModel(location);
        }
        catch (Exception e2) {
            this.storeException(location, e2);
            model = ModelLoaderRegistry.getMissingModel(location, e2);
        }
        this.stateModels.put(location, model);
    }

    @Override
    protected void registerMultipartVariant(brj definition, Collection<cbm> locations) {
        for (cbm location : locations) {
            this.a(null, location);
        }
    }

    private void storeException(kq location, Exception exception) {
        this.loadingExceptions.put(location, exception);
    }

    @Override
    protected brj a(kq location) {
        try {
            return super.a(location);
        }
        catch (Exception exception) {
            this.storeException(location, new Exception("Could not load model definition for variant " + location, exception));
            return new brj(new ArrayList<brj>());
        }
    }

    @Override
    protected void g() {
        if (FluidRegistry.isUniversalBucketEnabled()) {
            ModelLoader.setBucketModelDefinition(ForgeModContainer.getInstance().universalBucket);
        }
        this.h();
        ArrayList items = Lists.newArrayList((Iterable)Iterables.filter(afh.g, (Predicate)new Predicate<afh>(){

            public boolean apply(afh item) {
                return item.getRegistryName() != null;
            }
        }));
        Collections.sort(items, new Comparator<afh>(){

            @Override
            public int compare(afh i1, afh i2) {
                return i1.getRegistryName().toString().compareTo(i2.getRegistryName().toString());
            }
        });
        ProgressManager.ProgressBar itemBar = ProgressManager.push("ModelLoader: items", items.size());
        for (afh item : items) {
            itemBar.step(item.getRegistryName().toString());
            for (String s2 : this.a(item)) {
                kq file = this.a(s2);
                cbm memory = ModelLoader.getInventoryVariant(s2);
                IModel model = ModelLoaderRegistry.getMissingModel();
                ItemLoadingException exception = null;
                try {
                    model = ModelLoaderRegistry.getModel(file);
                }
                catch (Exception normalException) {
                    FMLLog.fine("Item json isn't found for '" + memory + "', trying to load the variant from the blockstate json", new Object[0]);
                    try {
                        model = ModelLoaderRegistry.getModel(memory);
                    }
                    catch (Exception blockstateException) {
                        exception = new ItemLoadingException("Could not load item model either from the normal location " + file + " or from the blockstate", normalException, blockstateException);
                    }
                }
                if (exception != null) {
                    this.storeException(memory, exception);
                    model = ModelLoaderRegistry.getMissingModel(memory, exception);
                }
                this.stateModels.put(memory, model);
            }
        }
        ProgressManager.pop(itemBar);
        if (ForgeModContainer.replaceVanillaBucketModel) {
            IModel model;
            cbm memory;
            if (!this.stateModels.containsKey(ModelDynBucket.LOCATION)) {
                try {
                    this.a(this.a(ModelDynBucket.LOCATION), ModelDynBucket.LOCATION);
                }
                catch (Exception exception) {
                    FMLLog.getLogger().error("Could not load the forge bucket model from the blockstate", (Throwable)exception);
                    return;
                }
            }
            for (String s3 : this.a(afl.az)) {
                memory = ModelLoader.getInventoryVariant(s3);
                model = ModelLoaderRegistry.getModelOrMissing(new kq("forge", "item/bucket"));
                if (model == this.getMissingModel()) continue;
                this.stateModels.put(memory, model);
            }
            this.setBucketModel(afl.aA);
            this.setBucketModel(afl.aB);
            if (FluidRegistry.isFluidRegistered("milk")) {
                Fluid milk = FluidRegistry.getFluid("milk");
                FluidStack milkStack = new FluidStack(milk, 1000);
                IFluidHandlerItem bucketHandler = FluidUtil.getFluidHandler(new afj(afl.az));
                if (bucketHandler != null && bucketHandler.fill(milkStack, false) == 1000) {
                    this.setBucketModel(afl.aO);
                }
            } else {
                for (String s3 : this.a(afl.aO)) {
                    memory = ModelLoader.getInventoryVariant(s3);
                    model = ModelLoaderRegistry.getModelOrMissing(new kq("forge", "item/bucket_milk"));
                    if (model == this.getMissingModel()) continue;
                    this.stateModels.put(memory, model);
                }
            }
        }
    }

    private void setBucketModel(afh item) {
        for (String s2 : this.a(item)) {
            cbm memory = ModelLoader.getInventoryVariant(s2);
            IModel model = this.stateModels.get(ModelDynBucket.LOCATION);
            if (model == null) continue;
            this.stateModels.put(memory, model);
        }
    }

    public static cbm getInventoryVariant(String s2) {
        if (s2.contains("#")) {
            return new cbm(s2);
        }
        return new cbm(s2, "inventory");
    }

    @Override
    protected kq d(kq model) {
        return new kq(model.b(), model.a() + ".json");
    }

    protected IModel getMissingModel() {
        if (this.missingModel == null) {
            try {
                this.missingModel = VanillaLoader.INSTANCE.loadModel(new kq(a.b(), a.a()));
            }
            catch (Exception e2) {
                throw new RuntimeException("Missing the missing model, this should never happen");
            }
        }
        return this.missingModel;
    }

    public void onPostBakeEvent(dh<cbm, cbh> modelRegistry) {
        cbh missingModel = modelRegistry.c(a);
        HashMap modelErrors = Maps.newHashMap();
        HashSet printedBlockStateErrors = Sets.newHashSet();
        HashMultimap reverseBlockMap = null;
        HashMultimap reverseItemMap = null;
        if (this.enableVerboseMissingInfo) {
            reverseBlockMap = HashMultimap.create();
            for (Map.Entry entry : this.m.a().a().entrySet()) {
                reverseBlockMap.put(entry.getValue(), entry.getKey());
            }
            reverseItemMap = HashMultimap.create();
            for (afh afh2 : GameData.getItemRegistry().typeSafeIterable()) {
                for (String s2 : this.a(afh2)) {
                    cbm memory = ModelLoader.getInventoryVariant(s2);
                    reverseItemMap.put((Object)memory, (Object)afh2.getRegistryName().toString());
                }
            }
        }
        for (Map.Entry<Object, Object> entry : this.loadingExceptions.entrySet()) {
            if (!(entry.getKey() instanceof cbm)) continue;
            cbm location = (cbm)entry.getKey();
            cbh model = modelRegistry.c(location);
            if (model == null || model == missingModel) {
                int errorCount;
                String domain = ((kq)entry.getKey()).b();
                Integer errorCountBox = (Integer)modelErrors.get(domain);
                int n2 = errorCount = errorCountBox == null ? 0 : errorCountBox;
                if (++errorCount < this.verboseMissingInfoCount) {
                    String errorMsg = "Exception loading model for variant " + entry.getKey();
                    if (this.enableVerboseMissingInfo) {
                        Collection items;
                        Collection blocks = reverseBlockMap.get((Object)location);
                        if (!blocks.isEmpty()) {
                            errorMsg = blocks.size() == 1 ? errorMsg + " for blockstate \"" + blocks.iterator().next() + "\"" : errorMsg + " for blockstates [\"" + Joiner.on((String)"\", \"").join((Iterable)blocks) + "\"]";
                        }
                        if (!(items = reverseItemMap.get((Object)location)).isEmpty()) {
                            if (!blocks.isEmpty()) {
                                errorMsg = errorMsg + " and";
                            }
                            errorMsg = items.size() == 1 ? errorMsg + " for item \"" + (String)items.iterator().next() + "\"" : errorMsg + " for items [\"" + Joiner.on((String)"\", \"").join((Iterable)items) + "\"]";
                        }
                    }
                    if (entry.getValue() instanceof ItemLoadingException) {
                        ItemLoadingException ex2 = (ItemLoadingException)entry.getValue();
                        FMLLog.getLogger().error(errorMsg + ", normal location exception: ", (Throwable)ex2.normalException);
                        FMLLog.getLogger().error(errorMsg + ", blockstate location exception: ", (Throwable)ex2.blockstateException);
                    } else {
                        FMLLog.getLogger().error(errorMsg, (Throwable)entry.getValue());
                    }
                    kq blockstateLocation = new kq(location.b(), location.a());
                    if (this.loadingExceptions.containsKey(blockstateLocation) && !printedBlockStateErrors.contains(blockstateLocation)) {
                        FMLLog.getLogger().error("Exception loading blockstate for the variant " + location + ": ", (Throwable)this.loadingExceptions.get(blockstateLocation));
                        printedBlockStateErrors.add(blockstateLocation);
                    }
                }
                modelErrors.put(domain, errorCount);
            }
            if (model != null) continue;
            modelRegistry.a(location, missingModel);
        }
        for (cbm cbm2 : this.missingVariants) {
            cbh model = modelRegistry.c(cbm2);
            if (model == null || model == missingModel) {
                int errorCount;
                String domain = cbm2.b();
                Integer errorCountBox = (Integer)modelErrors.get(domain);
                int n3 = errorCount = errorCountBox == null ? 0 : errorCountBox;
                if (++errorCount < this.verboseMissingInfoCount) {
                    FMLLog.severe("Model definition for location %s not found", cbm2);
                }
                modelErrors.put(domain, errorCount);
            }
            if (model != null) continue;
            modelRegistry.a(cbm2, missingModel);
        }
        for (Map.Entry entry : modelErrors.entrySet()) {
            if ((Integer)entry.getValue() < this.verboseMissingInfoCount) continue;
            FMLLog.severe("Suppressed additional %s model loading errors for domain %s", (Integer)entry.getValue() - this.verboseMissingInfoCount, entry.getKey());
        }
        this.isLoading = false;
    }

    public static void setCustomStateMapper(alu block, bsg mapper) {
        customStateMappers.put(block.delegate, mapper);
    }

    public static void onRegisterAllBlocks(bqz shapes) {
        for (Map.Entry<RegistryDelegate<alu>, bsg> e2 : customStateMappers.entrySet()) {
            shapes.a(e2.getKey().get(), e2.getValue());
        }
    }

    public static void setCustomModelResourceLocation(afh item, int metadata, cbm model) {
        customModels.put((Pair<RegistryDelegate<afh>, Integer>)Pair.of((Object)item.delegate, (Object)metadata), model);
        cbk.registerItemVariants(item, model);
    }

    public static void setCustomMeshDefinition(afh item, bqk meshDefinition) {
        customMeshDefinitions.put(item.delegate, meshDefinition);
    }

    public static void setBucketModelDefinition(afh item) {
        ModelLoader.setCustomMeshDefinition(item, new bqk(){

            @Override
            public cbm a(@Nonnull afj stack) {
                return ModelDynBucket.LOCATION;
            }
        });
        cbk.registerItemVariants(item, ModelDynBucket.LOCATION);
    }

    public static void onRegisterItems(bqj mesher) {
        for (Map.Entry<RegistryDelegate<afh>, bqk> entry : customMeshDefinitions.entrySet()) {
            mesher.a(entry.getKey().get(), entry.getValue());
        }
        for (Map.Entry<RegistryDelegate<afh>, Object> entry : customModels.entrySet()) {
            mesher.a((afh)((RegistryDelegate)((Pair)entry.getKey()).getLeft()).get(), (Integer)((Pair)entry.getKey()).getRight(), (cbm)entry.getValue());
        }
    }

    public static Function<kq, byz> defaultTextureGetter() {
        return DefaultTextureGetter.INSTANCE;
    }

    private static class MultipartModel
    implements IModel {
        private final kq location;
        private final brw multipart;
        private final ImmutableMap<bry, IModel> partModels;

        public MultipartModel(kq location, brw multipart) throws Exception {
            this.location = location;
            this.multipart = multipart;
            ImmutableMap.Builder builder = ImmutableMap.builder();
            for (bry selector : multipart.a()) {
                builder.put((Object)selector, (Object)new WeightedRandomModel(location, selector.a()));
            }
            this.partModels = builder.build();
        }

        @Override
        public Collection<kq> getDependencies() {
            return ImmutableSet.of();
        }

        @Override
        public Collection<kq> getTextures() {
            return ImmutableSet.of();
        }

        @Override
        public cbh bake(IModelState state, bzj format, Function<kq, byz> bakedTextureGetter) {
            cbn.a builder = new cbn.a();
            for (bry selector : this.multipart.a()) {
                builder.a(selector.a(this.multipart.c()), ((IModel)this.partModels.get((Object)selector)).bake(((IModel)this.partModels.get((Object)selector)).getDefaultState(), format, bakedTextureGetter));
            }
            cbh bakedModel = builder.a();
            return bakedModel;
        }

        @Override
        public IModelState getDefaultState() {
            return TRSRTransformation.identity();
        }
    }

    protected static enum VariantLoader implements ICustomModelLoader
    {
        INSTANCE;

        private ModelLoader loader;

        void setLoader(ModelLoader loader) {
            this.loader = loader;
        }

        @Override
        public void a(bzy resourceManager) {
        }

        @Override
        public boolean accepts(kq modelLocation) {
            return modelLocation instanceof cbm;
        }

        @Override
        public IModel loadModel(kq modelLocation) throws Exception {
            cbm variant = (cbm)modelLocation;
            brj definition = this.loader.a(variant);
            try {
                brr variants = definition.c(variant.c());
                return new WeightedRandomModel(variant, variants);
            }
            catch (brj.b e2) {
                if (definition.b()) {
                    return new MultipartModel(new kq(variant.b(), variant.a()), definition.c());
                }
                throw e2;
            }
        }

        public String toString() {
            return "VariantLoader.INSTANCE";
        }
    }

    private static enum DefaultTextureGetter implements Function<kq, byz>
    {
        INSTANCE;


        public byz apply(kq location) {
            return bes.z().R().a(location.toString());
        }
    }

    private static class ItemLoadingException
    extends ModelLoaderRegistry.LoaderException {
        private final Exception normalException;
        private final Exception blockstateException;

        public ItemLoadingException(String message, Exception normalException, Exception blockstateException) {
            super(message);
            this.normalException = normalException;
            this.blockstateException = blockstateException;
        }
    }

    public static final class White
    extends byz {
        public static final kq LOCATION = new kq("white");
        public static final White INSTANCE = new White();

        private White() {
            super(LOCATION.toString());
            this.g = 16;
            this.f = 16;
        }

        @Override
        public boolean hasCustomLoader(bzy manager, kq location) {
            return true;
        }

        @Override
        public boolean load(bzy manager, kq location) {
            BufferedImage image = new BufferedImage(this.c(), this.d(), 2);
            Graphics2D graphics = image.createGraphics();
            graphics.setBackground(Color.WHITE);
            graphics.clearRect(0, 0, this.c(), this.d());
            int[][] pixels = new int[bes.z().u.K + 1][];
            pixels[0] = new int[image.getWidth() * image.getHeight()];
            image.getRGB(0, 0, image.getWidth(), image.getHeight(), pixels[0], 0, image.getWidth());
            this.l();
            this.a.add(pixels);
            return false;
        }

        public void register(byy map) {
            map.setTextureEntry(INSTANCE);
        }
    }

    protected static enum VanillaLoader implements ICustomModelLoader
    {
        INSTANCE;

        private ModelLoader loader;
        private LoadingCache<BakedModelCacheKey, cbh> modelCache = CacheBuilder.newBuilder().maximumSize(50L).expireAfterWrite(100L, TimeUnit.MILLISECONDS).build((CacheLoader)new CacheLoader<BakedModelCacheKey, cbh>(){

            public cbh load(BakedModelCacheKey key) throws Exception {
                return key.model.bakeImpl(key.state, key.format, (Function<kq, byz>)key.bakedTextureGetter);
            }
        });

        void setLoader(ModelLoader loader) {
            this.loader = loader;
        }

        ModelLoader getLoader() {
            return this.loader;
        }

        @Override
        public void a(bzy resourceManager) {
        }

        @Override
        public boolean accepts(kq modelLocation) {
            return true;
        }

        @Override
        public IModel loadModel(kq modelLocation) throws Exception {
            if (modelLocation.equals(a) && this.loader.missingModel != null) {
                return this.loader.getMissingModel();
            }
            String modelPath = modelLocation.a();
            if (modelLocation.a().startsWith("models/")) {
                modelPath = modelPath.substring("models/".length());
            }
            kq armatureLocation = new kq(modelLocation.b(), "armatures/" + modelPath + ".json");
            ModelBlockAnimation animation = ModelBlockAnimation.loadVanillaAnimation(this.loader.g, armatureLocation);
            bri model = this.loader.c(modelLocation);
            ModelLoader modelLoader = this.loader;
            modelLoader.getClass();
            VanillaModelWrapper iModel = modelLoader.new VanillaModelWrapper(modelLocation, model, false, animation);
            if (this.loader.missingModel == null && modelLocation.equals(a)) {
                this.loader.missingModel = iModel;
            }
            return iModel;
        }

        public String toString() {
            return "VanillaLoader.INSTANCE";
        }
    }

    protected final class BakedModelCacheKey {
        private final VanillaModelWrapper model;
        private final IModelState state;
        private final bzj format;
        private final Function<kq, byz> bakedTextureGetter;

        public BakedModelCacheKey(VanillaModelWrapper model, IModelState state, bzj format, Function<kq, byz> bakedTextureGetter) {
            this.model = model;
            this.state = state;
            this.format = format;
            this.bakedTextureGetter = bakedTextureGetter;
        }

        public boolean equals(Object o2) {
            if (this == o2) {
                return true;
            }
            if (o2 == null || this.getClass() != o2.getClass()) {
                return false;
            }
            BakedModelCacheKey that = (BakedModelCacheKey)o2;
            return Objects.equal((Object)this.model, (Object)that.model) && Objects.equal((Object)this.state, (Object)that.state) && Objects.equal((Object)this.format, (Object)that.format) && Objects.equal(this.bakedTextureGetter, that.bakedTextureGetter);
        }

        public int hashCode() {
            return Objects.hashCode((Object[])new Object[]{this.model, this.state, this.format, this.bakedTextureGetter});
        }
    }

    private static final class WeightedRandomModel
    implements IModel {
        private final List<brs> variants;
        private final List<kq> locations = new ArrayList<kq>();
        private final Set<kq> textures = Sets.newHashSet();
        private final List<IModel> models = new ArrayList<IModel>();
        private final IModelState defaultState;

        public WeightedRandomModel(kq parent, brr variants) throws Exception {
            this.variants = variants.a();
            ImmutableList.Builder builder = ImmutableList.builder();
            for (brs v2 : this.variants) {
                kq loc = v2.a();
                this.locations.add(loc);
                IModel model = loc.equals(a) ? ModelLoaderRegistry.getMissingModel() : ModelLoaderRegistry.getModel(loc);
                model = v2.process(model);
                for (kq location : model.getDependencies()) {
                    ModelLoaderRegistry.getModelOrMissing(location);
                }
                this.textures.addAll(model.getTextures());
                this.models.add(model);
                builder.add((Object)Pair.of((Object)model, (Object)v2.getState()));
            }
            if (this.models.size() == 0) {
                IModel missing = ModelLoaderRegistry.getMissingModel();
                this.models.add(missing);
                builder.add((Object)Pair.of((Object)missing, (Object)TRSRTransformation.identity()));
            }
            this.defaultState = new MultiModelState(builder.build());
        }

        @Override
        public Collection<kq> getDependencies() {
            return ImmutableList.copyOf(this.locations);
        }

        @Override
        public Collection<kq> getTextures() {
            return ImmutableSet.copyOf(this.textures);
        }

        @Override
        public cbh bake(IModelState state, bzj format, Function<kq, byz> bakedTextureGetter) {
            if (!Attributes.moreSpecific(format, Attributes.DEFAULT_BAKED_FORMAT)) {
                throw new IllegalArgumentException("can't bake vanilla weighted models to the format that doesn't fit into the default one: " + format);
            }
            if (this.variants.size() == 1) {
                IModel model = this.models.get(0);
                return model.bake(MultiModelState.getPartState(state, model, 0), format, bakedTextureGetter);
            }
            cbp.a builder = new cbp.a();
            for (int i2 = 0; i2 < this.variants.size(); ++i2) {
                IModel model = this.models.get(i2);
                builder.a(model.bake(MultiModelState.getPartState(state, model, i2), format, bakedTextureGetter), this.variants.get(i2).d());
            }
            return builder.a();
        }

        @Override
        public IModelState getDefaultState() {
            return this.defaultState;
        }
    }

    private final class VanillaModelWrapper
    implements IRetexturableModel,
    IModelSimpleProperties,
    IModelUVLock,
    IAnimatedModel {
        private final kq location;
        private final bri model;
        private final boolean uvlock;
        private final ModelBlockAnimation animation;

        public VanillaModelWrapper(kq location, bri model, boolean uvlock, ModelBlockAnimation animation) {
            this.location = location;
            this.model = model;
            this.uvlock = uvlock;
            this.animation = animation;
        }

        @Override
        public Collection<kq> getDependencies() {
            HashSet set = Sets.newHashSet();
            for (kq dep : this.model.e()) {
                if (this.location.equals(dep)) continue;
                set.add(dep);
                ModelLoader.this.stateModels.put(ModelLoader.getInventoryVariant(dep.toString()), ModelLoaderRegistry.getModelOrLogError(dep, "Could not load override model " + dep + " for model " + this.location));
            }
            if (this.model.h() != null && !this.model.h().a().startsWith("builtin/")) {
                set.add(this.model.h());
            }
            return ImmutableSet.copyOf((Collection)set);
        }

        @Override
        public Collection<kq> getTextures() {
            if (this.model.h() != null) {
                if (this.model.h().a().equals("builtin/generated")) {
                    this.model.d = r;
                } else {
                    IModel parent = ModelLoaderRegistry.getModelOrLogError(this.model.h(), "Could not load vanilla model parent '" + this.model.h() + "' for '" + this.model);
                    if (parent instanceof VanillaModelWrapper) {
                        this.model.d = ((VanillaModelWrapper)parent).model;
                    } else {
                        throw new IllegalStateException("vanilla model '" + this.model + "' can't have non-vanilla parent");
                    }
                }
            }
            ImmutableSet.Builder builder = ImmutableSet.builder();
            if (ModelLoader.this.b(this.model)) {
                for (String s2 : brm.a) {
                    String r2 = this.model.c(s2);
                    kq loc = new kq(r2);
                    if (r2.equals(s2)) continue;
                    builder.add((Object)loc);
                }
            }
            for (String s2 : this.model.c.values()) {
                if (s2.startsWith("#")) continue;
                builder.add((Object)new kq(s2));
            }
            return builder.build();
        }

        @Override
        public cbh bake(IModelState state, bzj format, Function<kq, byz> bakedTextureGetter) {
            return (cbh)VanillaLoader.INSTANCE.modelCache.getUnchecked((Object)new BakedModelCacheKey(this, state, format, bakedTextureGetter));
        }

        public cbh bakeImpl(IModelState state, bzj format, Function<kq, byz> bakedTextureGetter) {
            if (!Attributes.moreSpecific(format, Attributes.DEFAULT_BAKED_FORMAT)) {
                throw new IllegalArgumentException("can't bake vanilla models to the format that doesn't fit into the default one: " + format);
            }
            bri model = this.model;
            if (model == null) {
                return ModelLoader.this.getMissingModel().bake(ModelLoader.this.getMissingModel().getDefaultState(), format, bakedTextureGetter);
            }
            ArrayList newTransforms = Lists.newArrayList();
            for (int i2 = 0; i2 < model.a().size(); ++i2) {
                bre part = model.a().get(i2);
                newTransforms.add(this.animation.getPartTransform(state, part, i2));
            }
            brq transforms = model.j();
            HashMap tMap = Maps.newHashMap();
            tMap.putAll(IPerspectiveAwareModel.MapWrapper.getTransforms(transforms));
            tMap.putAll(IPerspectiveAwareModel.MapWrapper.getTransforms(state));
            SimpleModelState perState = new SimpleModelState((ImmutableMap<? extends IModelPart, TRSRTransformation>)ImmutableMap.copyOf((Map)tMap));
            if (ModelLoader.this.b(model)) {
                return new ItemLayerModel(model).bake(perState, format, bakedTextureGetter);
            }
            if (ModelLoader.this.c(model)) {
                return new cbj(transforms, model.g());
            }
            return this.bakeNormal(model, perState, state, newTransforms, format, bakedTextureGetter, this.uvlock);
        }

        private cbh bakeNormal(bri model, IModelState perState, final IModelState modelState, List<TRSRTransformation> newTransforms, final bzj format, final Function<kq, byz> bakedTextureGetter, boolean uvLocked) {
            TRSRTransformation baseState = (TRSRTransformation)modelState.apply((Optional<? extends IModelPart>)Optional.absent()).or((Object)TRSRTransformation.identity());
            byz particle = (byz)bakedTextureGetter.apply((Object)new kq(model.c("particle")));
            cbo.a builder = new cbo.a(model, model.g()).a(particle);
            for (int i2 = 0; i2 < model.a().size(); ++i2) {
                if (modelState.apply((Optional<? extends IModelPart>)Optional.of((Object)Models.getHiddenModelPart((ImmutableList<String>)ImmutableList.of((Object)Integer.toString(i2))))).isPresent()) continue;
                bre part = model.a().get(i2);
                TRSRTransformation transformation = baseState;
                if (newTransforms.get(i2) != null) {
                    transformation = transformation.compose(newTransforms.get(i2));
                    brg rot = part.d;
                    if (rot == null) {
                        rot = new brg(new Vector3f(), cv.a.b, 0.0f, false);
                    }
                    part = new bre(part.a, part.b, part.c, rot, part.e);
                }
                for (Map.Entry<cv, brf> e2 : part.c.entrySet()) {
                    byz textureatlassprite1 = (byz)bakedTextureGetter.apply((Object)new kq(model.c(e2.getValue().d)));
                    if (e2.getValue().b == null || !TRSRTransformation.isInteger(transformation.getMatrix())) {
                        builder.a(ModelLoader.this.makeBakedQuad(part, e2.getValue(), textureatlassprite1, e2.getKey(), transformation, uvLocked));
                        continue;
                    }
                    builder.a(baseState.rotate(e2.getValue().b), ModelLoader.this.makeBakedQuad(part, e2.getValue(), textureatlassprite1, e2.getKey(), transformation, uvLocked));
                }
            }
            return new IPerspectiveAwareModel.MapWrapper(builder.b(), perState){
                private final bro overrides;
                {
                    super(parent, state);
                    this.overrides = new AnimationItemOverrideList((IModel)VanillaModelWrapper.this, modelState, format, (Function<kq, byz>)bakedTextureGetter, super.f());
                }

                @Override
                public List<brd> a(atl state, cv side, long rand) {
                    IExtendedBlockState exState;
                    if (state instanceof IExtendedBlockState && (exState = (IExtendedBlockState)state).getUnlistedNames().contains(Properties.AnimationProperty)) {
                        IModelState newState = exState.getValue(Properties.AnimationProperty);
                        IExtendedBlockState newExState = exState.withProperty(Properties.AnimationProperty, null);
                        if (newState != null) {
                            return VanillaModelWrapper.this.bake(new ModelStateComposition(modelState, newState), format, (Function<kq, byz>)bakedTextureGetter).a(newExState, side, rand);
                        }
                    }
                    return super.a(state, side, rand);
                }

                @Override
                public bro f() {
                    return this.overrides;
                }
            };
        }

        @Override
        public VanillaModelWrapper retexture(ImmutableMap<String, String> textures) {
            if (textures.isEmpty()) {
                return this;
            }
            ArrayList elements = Lists.newArrayList();
            for (bre part : this.model.a()) {
                elements.add(new bre(part.a, part.b, Maps.newHashMap(part.c), part.d, part.e));
            }
            bri newModel = new bri(this.model.h(), elements, Maps.newHashMap(this.model.c), this.model.b(), this.model.c(), this.model.j(), Lists.newArrayList(this.model.f()));
            newModel.b = this.model.b;
            newModel.d = this.model.d;
            HashSet removed = Sets.newHashSet();
            for (Map.Entry e2 : textures.entrySet()) {
                if ("".equals(e2.getValue())) {
                    removed.add(e2.getKey());
                    newModel.c.remove(e2.getKey());
                    continue;
                }
                newModel.c.put((String)e2.getKey(), (String)e2.getValue());
            }
            HashMap remapped = Maps.newHashMap();
            for (Map.Entry<String, String> e3 : newModel.c.entrySet()) {
                String key;
                if (!e3.getValue().startsWith("#") || !newModel.c.containsKey(key = e3.getValue().substring(1))) continue;
                remapped.put(e3.getKey(), newModel.c.get(key));
            }
            newModel.c.putAll(remapped);
            for (bre part : newModel.a()) {
                Iterator<Map.Entry<cv, brf>> itr = part.c.entrySet().iterator();
                while (itr.hasNext()) {
                    Map.Entry<cv, brf> entry = itr.next();
                    if (!removed.contains(entry.getValue().d)) continue;
                    itr.remove();
                }
            }
            return new VanillaModelWrapper(this.location, newModel, this.uvlock, this.animation);
        }

        @Override
        public Optional<? extends IClip> getClip(String name) {
            if (this.animation.getClips().containsKey((Object)name)) {
                return Optional.fromNullable((Object)this.animation.getClips().get((Object)name));
            }
            return Optional.absent();
        }

        @Override
        public IModelState getDefaultState() {
            return cbi.a;
        }

        @Override
        public VanillaModelWrapper smoothLighting(boolean value) {
            if (this.model.i == value) {
                return this;
            }
            bri newModel = new bri(this.model.h(), this.model.a(), this.model.c, value, this.model.c(), this.model.j(), Lists.newArrayList(this.model.f()));
            newModel.d = this.model.d;
            newModel.b = this.model.b;
            return new VanillaModelWrapper(this.location, newModel, this.uvlock, this.animation);
        }

        @Override
        public VanillaModelWrapper gui3d(boolean value) {
            if (this.model.c() == value) {
                return this;
            }
            bri newModel = new bri(this.model.h(), this.model.a(), this.model.c, this.model.i, value, this.model.j(), Lists.newArrayList(this.model.f()));
            newModel.d = this.model.d;
            newModel.b = this.model.b;
            return new VanillaModelWrapper(this.location, newModel, this.uvlock, this.animation);
        }

        @Override
        public IModel uvlock(boolean value) {
            if (this.uvlock == value) {
                return this;
            }
            return new VanillaModelWrapper(this.location, this.model, value, this.animation);
        }
    }
}

