/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.client.model;

import com.google.common.base.Objects;
import com.google.common.base.Optional;
import net.minecraftforge.common.model.IModelPart;
import net.minecraftforge.common.model.IModelState;
import net.minecraftforge.common.model.TRSRTransformation;

public class ModelStateComposition
implements IModelState {
    private final IModelState first;
    private final IModelState second;

    public ModelStateComposition(IModelState first, IModelState second) {
        this.first = first;
        this.second = second;
    }

    @Override
    public Optional<TRSRTransformation> apply(Optional<? extends IModelPart> part) {
        Optional<TRSRTransformation> f2 = this.first.apply(part);
        Optional<TRSRTransformation> s2 = this.second.apply(part);
        if (f2.isPresent() && s2.isPresent()) {
            return Optional.of((Object)((TRSRTransformation)f2.get()).compose((TRSRTransformation)s2.get()));
        }
        return f2.or(s2);
    }

    public boolean equals(Object o2) {
        if (this == o2) {
            return true;
        }
        if (o2 == null || this.getClass() != o2.getClass()) {
            return false;
        }
        ModelStateComposition that = (ModelStateComposition)o2;
        return Objects.equal((Object)this.first, (Object)that.first) && Objects.equal((Object)this.second, (Object)that.second);
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.first, this.second});
    }
}

