/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.client.model;

import com.google.common.base.Function;
import com.google.common.base.Optional;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.gson.JsonElement;
import com.google.gson.JsonParser;
import java.util.Collection;
import java.util.List;
import javax.annotation.Nonnull;
import javax.vecmath.Matrix4f;
import net.minecraftforge.client.MinecraftForgeClient;
import net.minecraftforge.client.model.ICustomModelLoader;
import net.minecraftforge.client.model.IModel;
import net.minecraftforge.client.model.IModelCustomData;
import net.minecraftforge.client.model.IPerspectiveAwareModel;
import net.minecraftforge.client.model.ModelLoaderRegistry;
import net.minecraftforge.client.model.ModelStateComposition;
import net.minecraftforge.common.model.IModelState;
import net.minecraftforge.common.model.TRSRTransformation;
import net.minecraftforge.fml.common.FMLLog;
import org.apache.commons.lang3.tuple.Pair;

public final class MultiLayerModel
implements IModelCustomData {
    public static final MultiLayerModel INSTANCE = new MultiLayerModel((ImmutableMap<Optional<ajk>, cbm>)ImmutableMap.of());
    private final ImmutableMap<Optional<ajk>, cbm> models;

    public MultiLayerModel(ImmutableMap<Optional<ajk>, cbm> models) {
        this.models = models;
    }

    @Override
    public Collection<kq> getDependencies() {
        return ImmutableList.copyOf((Collection)this.models.values());
    }

    @Override
    public Collection<kq> getTextures() {
        return ImmutableList.of();
    }

    private static ImmutableMap<Optional<ajk>, cbh> buildModels(ImmutableMap<Optional<ajk>, cbm> models, IModelState state, bzj format, Function<kq, byz> bakedTextureGetter) {
        ImmutableMap.Builder builder = ImmutableMap.builder();
        for (Optional key : models.keySet()) {
            IModel model = ModelLoaderRegistry.getModelOrLogError((kq)models.get((Object)key), "Couldn't load MultiLayerModel dependency: " + models.get((Object)key));
            builder.put((Object)key, (Object)model.bake(new ModelStateComposition(state, model.getDefaultState()), format, bakedTextureGetter));
        }
        return builder.build();
    }

    @Override
    public cbh bake(IModelState state, bzj format, Function<kq, byz> bakedTextureGetter) {
        IModel missing = ModelLoaderRegistry.getMissingModel();
        return new MultiLayerBakedModel(MultiLayerModel.buildModels(this.models, state, format, bakedTextureGetter), missing.bake(missing.getDefaultState(), format, bakedTextureGetter), IPerspectiveAwareModel.MapWrapper.getTransforms(state));
    }

    @Override
    public IModelState getDefaultState() {
        return TRSRTransformation.identity();
    }

    @Override
    public MultiLayerModel process(ImmutableMap<String, String> customData) {
        ImmutableMap.Builder builder = ImmutableMap.builder();
        for (String key : customData.keySet()) {
            if ("base".equals(key)) {
                builder.put((Object)Optional.absent(), (Object)this.getLocation((String)customData.get((Object)key)));
            }
            for (ajk layer : ajk.values()) {
                if (!layer.toString().equals(key)) continue;
                builder.put((Object)Optional.of((Object)((Object)layer)), (Object)this.getLocation((String)customData.get((Object)key)));
            }
        }
        ImmutableMap models = builder.build();
        if (models.isEmpty()) {
            return INSTANCE;
        }
        return new MultiLayerModel((ImmutableMap<Optional<ajk>, cbm>)models);
    }

    private cbm getLocation(String json) {
        JsonElement e2 = new JsonParser().parse(json);
        if (e2.isJsonPrimitive() && e2.getAsJsonPrimitive().isString()) {
            return new cbm(e2.getAsString());
        }
        FMLLog.severe("Expect ModelResourceLocation, got: ", json);
        return new cbm("builtin/missing", "missing");
    }

    public static enum Loader implements ICustomModelLoader
    {
        INSTANCE;


        @Override
        public void a(bzy resourceManager) {
        }

        @Override
        public boolean accepts(kq modelLocation) {
            return modelLocation.b().equals("forge") && (modelLocation.a().equals("multi-layer") || modelLocation.a().equals("models/block/multi-layer") || modelLocation.a().equals("models/item/multi-layer"));
        }

        @Override
        public IModel loadModel(kq modelLocation) {
            return INSTANCE;
        }
    }

    private static final class MultiLayerBakedModel
    implements IPerspectiveAwareModel {
        private final ImmutableMap<Optional<ajk>, cbh> models;
        private final ImmutableMap<brq.b, TRSRTransformation> cameraTransforms;
        private final cbh base;
        private final cbh missing;
        private final ImmutableMap<Optional<cv>, ImmutableList<brd>> quads;

        public MultiLayerBakedModel(ImmutableMap<Optional<ajk>, cbh> models, cbh missing, ImmutableMap<brq.b, TRSRTransformation> cameraTransforms) {
            this.models = models;
            this.cameraTransforms = cameraTransforms;
            this.missing = missing;
            this.base = models.containsKey((Object)Optional.absent()) ? (cbh)models.get((Object)Optional.absent()) : missing;
            ImmutableMap.Builder quadBuilder = ImmutableMap.builder();
            quadBuilder.put((Object)Optional.absent(), MultiLayerBakedModel.buildQuads(models, (Optional<cv>)Optional.absent()));
            for (cv side : cv.values()) {
                quadBuilder.put((Object)Optional.of((Object)side), MultiLayerBakedModel.buildQuads(models, (Optional<cv>)Optional.of((Object)side)));
            }
            this.quads = quadBuilder.build();
        }

        private static ImmutableList<brd> buildQuads(ImmutableMap<Optional<ajk>, cbh> models, Optional<cv> side) {
            ImmutableList.Builder builder = ImmutableList.builder();
            for (cbh model : models.values()) {
                builder.addAll(model.a(null, (cv)side.orNull(), 0L));
            }
            return builder.build();
        }

        @Override
        @Nonnull
        public List<brd> a(atl state, cv side, long rand) {
            ajk layer = MinecraftForgeClient.getRenderLayer();
            if (layer == null) {
                return (List)this.quads.get((Object)Optional.fromNullable((Object)side));
            }
            cbh model = !this.models.containsKey((Object)Optional.of((Object)((Object)layer))) ? this.missing : (cbh)this.models.get((Object)Optional.of((Object)((Object)layer)));
            return model.a(state, side, rand);
        }

        @Override
        public boolean a() {
            return this.base.a();
        }

        @Override
        public boolean b() {
            return this.base.b();
        }

        @Override
        public boolean c() {
            return this.base.c();
        }

        @Override
        public byz d() {
            return this.base.d();
        }

        @Override
        public brq e() {
            return brq.a;
        }

        @Override
        public Pair<? extends cbh, Matrix4f> handlePerspective(brq.b cameraTransformType) {
            return IPerspectiveAwareModel.MapWrapper.handlePerspective((cbh)this, this.cameraTransforms, cameraTransformType);
        }

        @Override
        public bro f() {
            return bro.a;
        }
    }
}

