/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.client.model;

import com.google.common.base.Objects;
import com.google.common.base.Optional;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import net.minecraftforge.client.model.IModel;
import net.minecraftforge.common.model.IModelPart;
import net.minecraftforge.common.model.IModelState;
import net.minecraftforge.common.model.TRSRTransformation;
import org.apache.commons.lang3.tuple.Pair;

public final class MultiModelState
implements IModelState {
    private final ImmutableMap<MultiModelPart, ? extends IModelState> states;

    public <M extends IModel, S extends IModelState> MultiModelState(ImmutableList<Pair<M, S>> states) {
        ImmutableMap.Builder builder = ImmutableMap.builder();
        for (int i2 = 0; i2 < states.size(); ++i2) {
            Pair pair = (Pair)states.get(i2);
            builder.put((Object)new MultiModelPart((IModel)pair.getLeft(), i2), pair.getRight());
        }
        this.states = builder.build();
    }

    public static IModelState getPartState(IModelState state, IModel model, int index) {
        if (state.apply((Optional<? extends IModelPart>)Optional.of((Object)new MultiModelPart(model, index))).isPresent()) {
            return new PartState(state, model, index);
        }
        return state;
    }

    @Override
    public Optional<TRSRTransformation> apply(Optional<? extends IModelPart> part) {
        if (part.isPresent()) {
            PartPart partPart;
            MultiModelPart key;
            if (part.get() instanceof MultiModelPart) {
                MultiModelPart key2 = (MultiModelPart)part.get();
                if (this.states.containsKey((Object)key2)) {
                    return Optional.of((Object)((IModelState)this.states.get((Object)key2)).apply((Optional<? extends IModelPart>)Optional.absent()).or((Object)TRSRTransformation.identity()));
                }
            } else if (part.get() instanceof PartPart && this.states.containsKey((Object)(key = new MultiModelPart((partPart = (PartPart)part.get()).model, partPart.index)))) {
                return ((IModelState)this.states.get((Object)key)).apply((Optional<? extends IModelPart>)partPart.part);
            }
        }
        return Optional.absent();
    }

    private static class PartPart
    implements IModelPart {
        private final IModel model;
        private final int index;
        private final Optional<? extends IModelPart> part;

        public PartPart(IModel model, int index, Optional<? extends IModelPart> part) {
            this.model = model;
            this.index = index;
            this.part = part;
        }
    }

    private static class MultiModelPart
    implements IModelPart {
        private final IModel model;
        private final int index;

        public MultiModelPart(IModel model, int index) {
            this.model = model;
            this.index = index;
        }

        public int hashCode() {
            return Objects.hashCode((Object[])new Object[]{this.model, this.index});
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            MultiModelPart other = (MultiModelPart)obj;
            return Objects.equal((Object)this.model, (Object)other.model) && this.index == other.index;
        }
    }

    private static class PartState
    implements IModelState {
        private final IModelState state;
        private final IModel model;
        private final int index;

        public PartState(IModelState state, IModel model, int index) {
            this.state = state;
            this.model = model;
            this.index = index;
        }

        @Override
        public Optional<TRSRTransformation> apply(Optional<? extends IModelPart> part) {
            Optional<TRSRTransformation> normal = this.state.apply(part);
            Optional<TRSRTransformation> multi = this.state.apply((Optional<? extends IModelPart>)Optional.of((Object)new PartPart(this.model, this.index, part)));
            if (normal.isPresent() && multi.isPresent()) {
                return Optional.of((Object)((TRSRTransformation)normal.get()).compose((TRSRTransformation)multi.get()));
            }
            return normal.or(multi);
        }
    }
}

