/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.client.model.pipeline;

public class BlockInfo {
    private final bfb colors;
    private ajw world;
    private atl state;
    private co blockPos;
    private final boolean[][][] translucent = new boolean[3][3][3];
    private final int[][][] s = new int[3][3][3];
    private final int[][][] b = new int[3][3][3];
    private final float[][][][] skyLight = new float[3][2][2][2];
    private final float[][][][] blockLight = new float[3][2][2][2];
    private final float[][][] ao = new float[3][3][3];
    private float shx = 0.0f;
    private float shy = 0.0f;
    private float shz = 0.0f;
    private int cachedTint = -1;
    private int cachedMultiplier = -1;

    public BlockInfo(bfb colors) {
        this.colors = colors;
    }

    public int getColorMultiplier(int tint) {
        if (this.cachedTint == tint) {
            return this.cachedMultiplier;
        }
        this.cachedTint = tint;
        this.cachedMultiplier = this.colors.a(this.state, this.world, this.blockPos, tint);
        return this.cachedMultiplier;
    }

    public void updateShift() {
        this.updateShift(false);
    }

    public void updateShift(boolean ignoreY) {
        long rand = 0L;
        if (this.state.v().u() != alu.a.a) {
            rand = ot.c(this.blockPos.p(), ignoreY ? 0 : this.blockPos.q(), this.blockPos.r());
            this.shx = ((float)(rand >> 16 & 0xFL) / 15.0f - 0.5f) * 0.5f;
            this.shz = ((float)(rand >> 24 & 0xFL) / 15.0f - 0.5f) * 0.5f;
            if (this.state.v().u() == alu.a.c) {
                this.shy = ((float)(rand >> 20 & 0xFL) / 15.0f - 1.0f) * 0.2f;
            }
        }
    }

    public void setWorld(ajw world) {
        this.world = world;
        this.cachedTint = -1;
        this.cachedMultiplier = -1;
    }

    public void setState(atl state) {
        this.state = state;
        this.cachedTint = -1;
        this.cachedMultiplier = -1;
    }

    public void setBlockPos(co blockPos) {
        this.blockPos = blockPos;
        this.cachedTint = -1;
        this.cachedMultiplier = -1;
        this.shz = 0.0f;
        this.shy = 0.0f;
        this.shx = 0.0f;
    }

    private float combine(int c2, int s1, int s2, int s3) {
        if (c2 == 0) {
            c2 = Math.max(0, Math.max(s1, s2) - 1);
        }
        if (s1 == 0) {
            s1 = Math.max(0, c2 - 1);
        }
        if (s2 == 0) {
            s2 = Math.max(0, c2 - 1);
        }
        if (s3 == 0) {
            s3 = Math.max(0, Math.max(s1, s2) - 1);
        }
        return (float)(c2 + s1 + s2 + s3) * 32.0f / 262140.0f;
    }

    public void updateLightMatrix() {
        int z2;
        int y2;
        int x22;
        boolean full = false;
        for (x22 = 0; x22 <= 2; ++x22) {
            for (y2 = 0; y2 <= 2; ++y2) {
                for (z2 = 0; z2 <= 2; ++z2) {
                    co pos = this.blockPos.a(x22 - 1, y2 - 1, z2 - 1);
                    atl state = this.world.o(pos);
                    this.translucent[x22][y2][z2] = state.e();
                    int brightness = state.a(this.world, pos);
                    this.s[x22][y2][z2] = brightness >> 20 & 0xF;
                    this.b[x22][y2][z2] = brightness >> 4 & 0xF;
                    this.ao[x22][y2][z2] = state.k();
                    if (x22 != 1 || y2 != 1 || z2 != 1) continue;
                    full = state.h();
                }
            }
        }
        if (!full) {
            cv[] x22 = cv.values();
            y2 = x22.length;
            for (z2 = 0; z2 < y2; ++z2) {
                cv side = x22[z2];
                int x3 = side.g() + 1;
                int y3 = side.h() + 1;
                int z3 = side.i() + 1;
                this.s[x3][y3][z3] = Math.max(this.s[1][1][1] - 1, this.s[x3][y3][z3]);
                this.b[x3][y3][z3] = Math.max(this.b[1][1][1] - 1, this.b[x3][y3][z3]);
            }
        }
        for (x22 = 0; x22 < 2; ++x22) {
            for (y2 = 0; y2 < 2; ++y2) {
                for (z2 = 0; z2 < 2; ++z2) {
                    int x1 = x22 * 2;
                    int y1 = y2 * 2;
                    int z1 = z2 * 2;
                    boolean tx = this.translucent[x1][1][z1] || this.translucent[x1][y1][1];
                    this.skyLight[0][x22][y2][z2] = this.combine(this.s[x1][1][1], this.s[x1][1][z1], this.s[x1][y1][1], tx ? this.s[x1][y1][z1] : this.s[x1][1][1]);
                    this.blockLight[0][x22][y2][z2] = this.combine(this.b[x1][1][1], this.b[x1][1][z1], this.b[x1][y1][1], tx ? this.b[x1][y1][z1] : this.b[x1][1][1]);
                    boolean ty2 = this.translucent[x1][y1][1] || this.translucent[1][y1][z1];
                    this.skyLight[1][x22][y2][z2] = this.combine(this.s[1][y1][1], this.s[x1][y1][1], this.s[1][y1][z1], ty2 ? this.s[x1][y1][z1] : this.s[1][y1][1]);
                    this.blockLight[1][x22][y2][z2] = this.combine(this.b[1][y1][1], this.b[x1][y1][1], this.b[1][y1][z1], ty2 ? this.b[x1][y1][z1] : this.b[1][y1][1]);
                    boolean tz2 = this.translucent[1][y1][z1] || this.translucent[x1][1][z1];
                    this.skyLight[2][x22][y2][z2] = this.combine(this.s[1][1][z1], this.s[1][y1][z1], this.s[x1][1][z1], tz2 ? this.s[x1][y1][z1] : this.s[1][1][z1]);
                    this.blockLight[2][x22][y2][z2] = this.combine(this.b[1][1][z1], this.b[1][y1][z1], this.b[x1][1][z1], tz2 ? this.b[x1][y1][z1] : this.b[1][1][z1]);
                }
            }
        }
    }

    public ajw getWorld() {
        return this.world;
    }

    public atl getState() {
        return this.state;
    }

    public co getBlockPos() {
        return this.blockPos;
    }

    public boolean[][][] getTranslucent() {
        return this.translucent;
    }

    public float[][][][] getSkyLight() {
        return this.skyLight;
    }

    public float[][][][] getBlockLight() {
        return this.blockLight;
    }

    public float[][][] getAo() {
        return this.ao;
    }

    public float getShx() {
        return this.shx;
    }

    public float getShy() {
        return this.shy;
    }

    public float getShz() {
        return this.shz;
    }

    public int getCachedTint() {
        return this.cachedTint;
    }

    public int getCachedMultiplier() {
        return this.cachedMultiplier;
    }
}

