/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.client.model.pipeline;

import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import net.minecraftforge.client.ForgeHooksClient;
import net.minecraftforge.client.model.pipeline.IVertexConsumer;
import net.minecraftforge.client.model.pipeline.VertexBufferConsumer;
import net.minecraftforge.client.model.pipeline.VertexTransformer;
import org.apache.commons.lang3.tuple.Pair;

public class LightUtil {
    private static final float s2 = (float)Math.pow(2.0, 0.5);
    private static final LoadingCache<Pair<bzj, bzj>, int[]> formatMaps = CacheBuilder.newBuilder().maximumSize(10L).build((CacheLoader)new CacheLoader<Pair<bzj, bzj>, int[]>(){

        public int[] load(Pair<bzj, bzj> pair) {
            return LightUtil.mapFormats((bzj)pair.getLeft(), (bzj)pair.getRight());
        }
    });
    private static IVertexConsumer tessellator = null;
    private static ItemConsumer itemConsumer = null;

    public static float diffuseLight(float x2, float y2, float z2) {
        float y1 = y2 + 3.0f - 2.0f * s2;
        return x2 * x2 * 0.6f + y1 * y1 * (3.0f + 2.0f * s2) / 8.0f + z2 * z2 * 0.8f;
    }

    public static float diffuseLight(cv side) {
        switch (side) {
            case a: {
                return 0.5f;
            }
            case b: {
                return 1.0f;
            }
            case c: 
            case d: {
                return 0.8f;
            }
        }
        return 0.6f;
    }

    public static cv toSide(float x2, float y2, float z2) {
        if (Math.abs(x2) > Math.abs(y2)) {
            if (Math.abs(x2) > Math.abs(z2)) {
                if (x2 < 0.0f) {
                    return cv.e;
                }
                return cv.f;
            }
            if (z2 < 0.0f) {
                return cv.c;
            }
            return cv.d;
        }
        if (Math.abs(y2) > Math.abs(z2)) {
            if (y2 < 0.0f) {
                return cv.a;
            }
            return cv.b;
        }
        if (z2 < 0.0f) {
            return cv.c;
        }
        return cv.d;
    }

    public static void putBakedQuad(IVertexConsumer consumer, brd quad) {
        consumer.setTexture(quad.a());
        consumer.setQuadOrientation(quad.e());
        if (quad.c()) {
            consumer.setQuadTint(quad.d());
        }
        consumer.setApplyDiffuseLighting(quad.shouldApplyDiffuseLighting());
        float[] data = new float[4];
        bzj formatFrom = consumer.getVertexFormat();
        bzj formatTo = quad.getFormat();
        int countFrom = formatFrom.i();
        int countTo = formatTo.i();
        int[] eMap = (int[])formatMaps.getUnchecked((Object)Pair.of((Object)formatFrom, (Object)formatTo));
        for (int v2 = 0; v2 < 4; ++v2) {
            for (int e2 = 0; e2 < countFrom; ++e2) {
                if (eMap[e2] != countTo) {
                    LightUtil.unpack(quad.b(), data, quad.getFormat(), v2, eMap[e2]);
                    consumer.put(e2, data);
                    continue;
                }
                consumer.put(e2, new float[0]);
            }
        }
    }

    public static int[] mapFormats(bzj from, bzj to2) {
        int fromCount = from.i();
        int toCount = to2.i();
        int[] eMap = new int[fromCount];
        for (int e2 = 0; e2 < fromCount; ++e2) {
            int e22;
            bzk expected = from.c(e2);
            for (e22 = 0; e22 < toCount; ++e22) {
                bzk current = to2.c(e22);
                if (expected.b() == current.b() && expected.d() == current.d()) break;
            }
            eMap[e2] = e22;
        }
        return eMap;
    }

    public static void unpack(int[] from, float[] to2, bzj formatFrom, int v2, int e2) {
        int length = 4 < to2.length ? 4 : to2.length;
        bzk element = formatFrom.c(e2);
        int vertexStart = v2 * formatFrom.g() + formatFrom.d(e2);
        int count = element.c();
        bzk.a type = element.a();
        int size = type.a();
        int mask = (256 << 8 * (size - 1)) - 1;
        for (int i2 = 0; i2 < length; ++i2) {
            if (i2 < count) {
                int pos = vertexStart + size * i2;
                int index = pos >> 2;
                int offset = pos & 3;
                int bits = from[index];
                bits >>>= offset * 8;
                if ((pos + size - 1) / 4 != index) {
                    bits |= from[index + 1] << (4 - offset) * 8;
                }
                bits &= mask;
                if (type == bzk.a.a) {
                    to2[i2] = Float.intBitsToFloat(bits);
                    continue;
                }
                if (type == bzk.a.b || type == bzk.a.d) {
                    to2[i2] = (float)bits / (float)mask;
                    continue;
                }
                if (type == bzk.a.f) {
                    to2[i2] = (float)((double)((long)bits & 0xFFFFFFFFL) / 4.294967295E9);
                    continue;
                }
                if (type == bzk.a.c) {
                    to2[i2] = (float)((byte)bits) / (float)mask * 2.0f;
                    continue;
                }
                if (type == bzk.a.e) {
                    to2[i2] = (float)((short)bits) / (float)mask * 2.0f;
                    continue;
                }
                if (type != bzk.a.g) continue;
                to2[i2] = (float)((long)bits & 0xFFFFFFFFL) / 4.2949673E9f * 2.0f;
                continue;
            }
            to2[i2] = 0.0f;
        }
    }

    public static void pack(float[] from, int[] to2, bzj formatTo, int v2, int e2) {
        bzk element = formatTo.c(e2);
        int vertexStart = v2 * formatTo.g() + formatTo.d(e2);
        int count = element.c();
        bzk.a type = element.a();
        int size = type.a();
        int mask = (256 << 8 * (size - 1)) - 1;
        for (int i2 = 0; i2 < 4; ++i2) {
            float f2;
            if (i2 >= count) continue;
            int pos = vertexStart + size * i2;
            int index = pos >> 2;
            int offset = pos & 3;
            int bits = 0;
            float f3 = f2 = i2 < from.length ? from[i2] : 0.0f;
            bits = type == bzk.a.a ? Float.floatToRawIntBits(f2) : (type == bzk.a.b || type == bzk.a.d || type == bzk.a.f ? (int)(f2 * (float)mask) : (int)(f2 * (float)mask / 2.0f));
            int n2 = index;
            to2[n2] = to2[n2] & ~(mask << offset * 8);
            int n3 = index;
            to2[n3] = to2[n3] | (bits & mask) << offset * 8;
        }
    }

    public static IVertexConsumer getTessellator() {
        if (tessellator == null) {
            bqs tes = bqs.a();
            bpy wr2 = tes.c();
            tessellator = new VertexBufferConsumer(wr2);
        }
        return tessellator;
    }

    public static ItemConsumer getItemConsumer() {
        if (itemConsumer == null) {
            itemConsumer = new ItemConsumer(LightUtil.getTessellator());
        }
        return itemConsumer;
    }

    public static void renderQuadColorSlow(bpy wr2, brd quad, int auxColor) {
        ItemConsumer cons = wr2 == bqs.a().c() ? LightUtil.getItemConsumer() : new ItemConsumer(new VertexBufferConsumer(wr2));
        float b2 = (float)(auxColor & 0xFF) / 255.0f;
        float g2 = (float)(auxColor >>> 8 & 0xFF) / 255.0f;
        float r2 = (float)(auxColor >>> 16 & 0xFF) / 255.0f;
        float a2 = (float)(auxColor >>> 24 & 0xFF) / 255.0f;
        cons.setAuxColor(r2, g2, b2, a2);
        quad.pipe(cons);
    }

    public static void renderQuadColor(bpy wr2, brd quad, int auxColor) {
        wr2.a(quad.b());
        ForgeHooksClient.putQuadColor(wr2, quad, auxColor);
    }

    public static class ItemConsumer
    extends VertexTransformer {
        private int vertices = 0;
        private float[] auxColor = new float[]{1.0f, 1.0f, 1.0f, 1.0f};
        private float[] buf = new float[4];

        public ItemConsumer(IVertexConsumer parent) {
            super(parent);
        }

        public void setAuxColor(float ... auxColor) {
            System.arraycopy(auxColor, 0, this.auxColor, 0, this.auxColor.length);
        }

        @Override
        public void put(int element, float ... data) {
            if (this.getVertexFormat().c(element).b() == bzk.b.c) {
                System.arraycopy(this.auxColor, 0, this.buf, 0, this.buf.length);
                for (int i2 = 0; i2 < 4; ++i2) {
                    int n2 = i2;
                    this.buf[n2] = this.buf[n2] * data[i2];
                }
                super.put(element, this.buf);
            } else {
                super.put(element, data);
            }
            if (element == this.getVertexFormat().i() - 1) {
                ++this.vertices;
                if (this.vertices == 4) {
                    this.vertices = 0;
                }
            }
        }
    }
}

