/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.client.model.pipeline;

import com.google.common.base.Objects;
import javax.vecmath.Tuple3f;
import javax.vecmath.Vector3f;
import net.minecraftforge.client.model.pipeline.BlockInfo;
import net.minecraftforge.client.model.pipeline.IVertexConsumer;
import net.minecraftforge.client.model.pipeline.LightUtil;
import net.minecraftforge.client.model.pipeline.QuadGatheringTransformer;

public class VertexLighterFlat
extends QuadGatheringTransformer {
    protected final BlockInfo blockInfo;
    private int tint = -1;
    private boolean diffuse = true;
    protected int posIndex = -1;
    protected int normalIndex = -1;
    protected int colorIndex = -1;
    protected int lightmapIndex = -1;

    public VertexLighterFlat(bfb colors) {
        this.blockInfo = new BlockInfo(colors);
    }

    @Override
    public void setParent(IVertexConsumer parent) {
        super.setParent(parent);
        if (Objects.equal((Object)this.getVertexFormat(), (Object)parent.getVertexFormat())) {
            return;
        }
        this.setVertexFormat(VertexLighterFlat.getVertexFormat(parent));
        block6: for (int i2 = 0; i2 < this.getVertexFormat().i(); ++i2) {
            switch (this.getVertexFormat().c(i2).b()) {
                case a: {
                    this.posIndex = i2;
                    continue block6;
                }
                case b: {
                    this.normalIndex = i2;
                    continue block6;
                }
                case c: {
                    this.colorIndex = i2;
                    continue block6;
                }
                case d: {
                    if (this.getVertexFormat().c(i2).d() != 1) continue block6;
                    this.lightmapIndex = i2;
                    continue block6;
                }
            }
        }
        if (this.posIndex == -1) {
            throw new IllegalArgumentException("vertex lighter needs format with position");
        }
        if (this.lightmapIndex == -1) {
            throw new IllegalArgumentException("vertex lighter needs format with lightmap");
        }
        if (this.colorIndex == -1) {
            throw new IllegalArgumentException("vertex lighter needs format with color");
        }
    }

    private static bzj getVertexFormat(IVertexConsumer parent) {
        bzj format = parent.getVertexFormat();
        if (format.b()) {
            return format;
        }
        format = new bzj(format);
        format.a(new bzk(0, bzk.a.a, bzk.b.b, 4));
        return format;
    }

    @Override
    protected void processQuad() {
        int v2;
        float[][] position = this.quadData[this.posIndex];
        float[][] normal = null;
        float[][] lightmap = this.quadData[this.lightmapIndex];
        float[][] color = this.quadData[this.colorIndex];
        if (this.normalIndex != -1 && (this.quadData[this.normalIndex][0][0] != -1.0f || this.quadData[this.normalIndex][0][1] != -1.0f || this.quadData[this.normalIndex][0][2] != -1.0f)) {
            normal = this.quadData[this.normalIndex];
        } else {
            normal = new float[4][4];
            Vector3f v1 = new Vector3f(position[3]);
            Vector3f t2 = new Vector3f(position[1]);
            Vector3f v22 = new Vector3f(position[2]);
            v1.sub((Tuple3f)t2);
            t2.set(position[0]);
            v22.sub((Tuple3f)t2);
            v1.cross(v22, v1);
            v1.normalize();
            for (v2 = 0; v2 < 4; ++v2) {
                normal[v2][0] = v1.x;
                normal[v2][1] = v1.y;
                normal[v2][2] = v1.z;
                normal[v2][3] = 0.0f;
            }
        }
        int multiplier = -1;
        if (this.tint != -1) {
            multiplier = this.blockInfo.getColorMultiplier(this.tint);
        }
        bzj format = this.parent.getVertexFormat();
        int count = format.i();
        for (v2 = 0; v2 < 4; ++v2) {
            float[] fArray = position[v2];
            fArray[0] = fArray[0] + this.blockInfo.getShx();
            float[] fArray2 = position[v2];
            fArray2[1] = fArray2[1] + this.blockInfo.getShy();
            float[] fArray3 = position[v2];
            fArray3[2] = fArray3[2] + this.blockInfo.getShz();
            float x2 = position[v2][0] - 0.5f;
            float y2 = position[v2][1] - 0.5f;
            float z2 = position[v2][2] - 0.5f;
            float blockLight = lightmap[v2][0];
            float skyLight = lightmap[v2][1];
            this.updateLightmap(normal[v2], lightmap[v2], x2 += normal[v2][0] * 0.5f, y2 += normal[v2][1] * 0.5f, z2 += normal[v2][2] * 0.5f);
            if (this.dataLength[this.lightmapIndex] > 1) {
                if (blockLight > lightmap[v2][0]) {
                    lightmap[v2][0] = blockLight;
                }
                if (skyLight > lightmap[v2][1]) {
                    lightmap[v2][1] = skyLight;
                }
            }
            this.updateColor(normal[v2], color[v2], x2, y2, z2, this.tint, multiplier);
            if (this.diffuse) {
                float d2 = LightUtil.diffuseLight(normal[v2][0], normal[v2][1], normal[v2][2]);
                int i2 = 0;
                while (i2 < 3) {
                    float[] fArray4 = color[v2];
                    int n2 = i2++;
                    fArray4[n2] = fArray4[n2] * d2;
                }
            }
            if (bqe.a) {
                this.applyAnaglyph(color[v2]);
            }
            block9: for (int e2 = 0; e2 < count; ++e2) {
                bzk element = format.c(e2);
                switch (element.b()) {
                    case a: {
                        this.parent.put(e2, position[v2]);
                        continue block9;
                    }
                    case b: {
                        if (this.normalIndex != -1) {
                            this.parent.put(e2, normal[v2]);
                            continue block9;
                        }
                    }
                    case c: {
                        this.parent.put(e2, color[v2]);
                        continue block9;
                    }
                    case d: {
                        if (element.d() == 1) {
                            this.parent.put(e2, lightmap[v2]);
                            continue block9;
                        }
                    }
                    default: {
                        this.parent.put(e2, this.quadData[e2][v2]);
                    }
                }
            }
        }
        this.tint = -1;
    }

    protected void applyAnaglyph(float[] color) {
        float r2 = color[0];
        color[0] = (r2 * 30.0f + color[1] * 59.0f + color[2] * 11.0f) / 100.0f;
        color[1] = (r2 * 3.0f + color[1] * 7.0f) / 10.0f;
        color[2] = (r2 * 3.0f + color[2] * 7.0f) / 10.0f;
    }

    protected void updateLightmap(float[] normal, float[] lightmap, float x2, float y2, float z2) {
        float e1 = 0.99f;
        float e2 = 0.95f;
        co pos = this.blockInfo.getBlockPos();
        boolean full = this.blockInfo.getState().h();
        if ((full || y2 < -e1) && normal[1] < -e2) {
            pos = pos.b();
        }
        if ((full || y2 > e1) && normal[1] > e2) {
            pos = pos.a();
        }
        if ((full || z2 < -e1) && normal[2] < -e2) {
            pos = pos.c();
        }
        if ((full || z2 > e1) && normal[2] > e2) {
            pos = pos.d();
        }
        if ((full || x2 < -e1) && normal[0] < -e2) {
            pos = pos.e();
        }
        if ((full || x2 > e1) && normal[0] > e2) {
            pos = pos.f();
        }
        int brightness = this.blockInfo.getState().a(this.blockInfo.getWorld(), pos);
        lightmap[0] = (float)(brightness >> 4 & 0xF) * 32.0f / 65535.0f;
        lightmap[1] = (float)(brightness >> 20 & 0xF) * 32.0f / 65535.0f;
    }

    protected void updateColor(float[] normal, float[] color, float x2, float y2, float z2, float tint, int multiplier) {
        if (tint != -1.0f) {
            color[0] = color[0] * ((float)(multiplier >> 16 & 0xFF) / 255.0f);
            color[1] = color[1] * ((float)(multiplier >> 8 & 0xFF) / 255.0f);
            color[2] = color[2] * ((float)(multiplier & 0xFF) / 255.0f);
        }
    }

    @Override
    public void setQuadTint(int tint) {
        this.tint = tint;
    }

    @Override
    public void setQuadOrientation(cv orientation) {
    }

    public void setQuadCulled() {
    }

    @Override
    public void setTexture(byz texture) {
    }

    @Override
    public void setApplyDiffuseLighting(boolean diffuse) {
        this.diffuse = diffuse;
    }

    public void setWorld(ajw world) {
        this.blockInfo.setWorld(world);
    }

    public void setState(atl state) {
        this.blockInfo.setState(state);
    }

    public void setBlockPos(co blockPos) {
        this.blockInfo.setBlockPos(blockPos);
    }

    public void updateBlockInfo() {
        this.blockInfo.updateShift(true);
    }
}

