/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.common;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import java.util.ArrayDeque;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nonnull;
import net.minecraftforge.fml.common.FMLLog;
import net.minecraftforge.fml.common.registry.ForgeRegistries;

public class BiomeDictionary {
    private static final Map<kq, BiomeInfo> biomeInfoMap = new HashMap<kq, BiomeInfo>();

    public static void addTypes(akf biome, Type ... types) {
        Preconditions.checkArgument((boolean)ForgeRegistries.BIOMES.containsValue(biome), (String)"Cannot add types to unregistered biome %s", (Object[])new Object[]{biome});
        Collection<Type> supertypes = BiomeDictionary.listSupertypes(types);
        for (Type type : supertypes) {
            type.biomes.add(biome);
        }
        BiomeInfo biomeInfo = BiomeDictionary.getBiomeInfo(biome);
        Collections.addAll(biomeInfo.types, types);
        biomeInfo.types.addAll(supertypes);
    }

    @Nonnull
    public static Set<akf> getBiomes(Type type) {
        return type.biomesUn;
    }

    @Nonnull
    public static Set<Type> getTypes(akf biome) {
        BiomeDictionary.ensureHasTypes(biome);
        return BiomeDictionary.getBiomeInfo(biome).typesUn;
    }

    public static boolean areSimilar(akf biomeA, akf biomeB) {
        for (Type type : BiomeDictionary.getTypes(biomeA)) {
            if (!BiomeDictionary.getTypes(biomeB).contains(type)) continue;
            return true;
        }
        return false;
    }

    public static boolean hasType(akf biome, Type type) {
        return BiomeDictionary.getTypes(biome).contains(type);
    }

    public static boolean hasAnyType(akf biome) {
        return !BiomeDictionary.getBiomeInfo(biome).types.isEmpty();
    }

    public static void makeBestGuess(akf biome) {
        if (biome.t.z >= 3) {
            if (biome.e() && biome.n() >= 0.9f) {
                BiomeDictionary.addTypes(biome, Type.JUNGLE);
            } else if (!biome.e()) {
                BiomeDictionary.addTypes(biome, Type.FOREST);
                if (biome.n() <= 0.2f) {
                    BiomeDictionary.addTypes(biome, Type.CONIFEROUS);
                }
            }
        } else if (biome.m() <= 0.3f && biome.m() >= 0.0f && (!biome.e() || biome.j() >= 0.0f)) {
            BiomeDictionary.addTypes(biome, Type.PLAINS);
        }
        if (biome.k() > 0.85f) {
            BiomeDictionary.addTypes(biome, Type.WET);
        }
        if (biome.k() < 0.15f) {
            BiomeDictionary.addTypes(biome, Type.DRY);
        }
        if (biome.n() > 0.85f) {
            BiomeDictionary.addTypes(biome, Type.HOT);
        }
        if (biome.n() < 0.15f) {
            BiomeDictionary.addTypes(biome, Type.COLD);
        }
        if (biome.t.z > 0 && biome.t.z < 3) {
            BiomeDictionary.addTypes(biome, Type.SPARSE);
        } else if (biome.t.z >= 10) {
            BiomeDictionary.addTypes(biome, Type.DENSE);
        }
        if (biome.e() && biome.j() < 0.0f && biome.m() <= 0.3f && biome.m() >= 0.0f) {
            BiomeDictionary.addTypes(biome, Type.SWAMP);
        }
        if (biome.j() <= -0.5f) {
            if (biome.m() == 0.0f) {
                BiomeDictionary.addTypes(biome, Type.RIVER);
            } else {
                BiomeDictionary.addTypes(biome, Type.OCEAN);
            }
        }
        if (biome.m() >= 0.4f && biome.m() < 1.5f) {
            BiomeDictionary.addTypes(biome, Type.HILLS);
        }
        if (biome.m() >= 1.5f) {
            BiomeDictionary.addTypes(biome, Type.MOUNTAIN);
        }
        if (biome.c()) {
            BiomeDictionary.addTypes(biome, Type.SNOWY);
        }
        if (biome.r != alv.m && biome.n() >= 1.0f && biome.k() < 0.2f) {
            BiomeDictionary.addTypes(biome, Type.SAVANNA);
        }
        if (biome.r == alv.m) {
            BiomeDictionary.addTypes(biome, Type.SANDY);
        } else if (biome.r == alv.bw) {
            BiomeDictionary.addTypes(biome, Type.MUSHROOM);
        }
        if (biome.s == alv.cz) {
            BiomeDictionary.addTypes(biome, Type.MESA);
        }
    }

    private static BiomeInfo getBiomeInfo(akf biome) {
        BiomeInfo info = biomeInfoMap.get(biome.getRegistryName());
        if (info == null) {
            info = new BiomeInfo();
            biomeInfoMap.put(biome.getRegistryName(), info);
        }
        return info;
    }

    static void ensureHasTypes(akf biome) {
        if (!BiomeDictionary.hasAnyType(biome)) {
            BiomeDictionary.makeBestGuess(biome);
            FMLLog.warning("No types have been added to Biome %s, types have been assigned on a best-effort guess: %s", biome.getRegistryName(), BiomeDictionary.getTypes(biome));
        }
    }

    private static Collection<Type> listSupertypes(Type ... types) {
        HashSet<Type> supertypes = new HashSet<Type>();
        ArrayDeque<Type> next = new ArrayDeque<Type>();
        Collections.addAll(next, types);
        while (!next.isEmpty()) {
            Type type = (Type)next.remove();
            for (Type sType : Type.byName.values()) {
                if (!type.subTypes.contains(type) || !supertypes.add(sType)) continue;
                next.add(sType);
            }
        }
        return supertypes;
    }

    private static void registerVanillaBiomes() {
        BiomeDictionary.addTypes(akk.a, Type.OCEAN);
        BiomeDictionary.addTypes(akk.c, Type.PLAINS);
        BiomeDictionary.addTypes(akk.d, Type.HOT, Type.DRY, Type.SANDY);
        BiomeDictionary.addTypes(akk.e, Type.MOUNTAIN, Type.HILLS);
        BiomeDictionary.addTypes(akk.f, Type.FOREST);
        BiomeDictionary.addTypes(akk.g, Type.COLD, Type.CONIFEROUS, Type.FOREST);
        BiomeDictionary.addTypes(akk.h, Type.WET, Type.SWAMP);
        BiomeDictionary.addTypes(akk.i, Type.RIVER);
        BiomeDictionary.addTypes(akk.j, Type.HOT, Type.DRY, Type.NETHER);
        BiomeDictionary.addTypes(akk.k, Type.COLD, Type.DRY, Type.END);
        BiomeDictionary.addTypes(akk.l, Type.COLD, Type.OCEAN, Type.SNOWY);
        BiomeDictionary.addTypes(akk.m, Type.COLD, Type.RIVER, Type.SNOWY);
        BiomeDictionary.addTypes(akk.n, Type.COLD, Type.SNOWY, Type.WASTELAND);
        BiomeDictionary.addTypes(akk.o, Type.COLD, Type.SNOWY, Type.MOUNTAIN);
        BiomeDictionary.addTypes(akk.p, Type.MUSHROOM, Type.RARE);
        BiomeDictionary.addTypes(akk.q, Type.MUSHROOM, Type.BEACH, Type.RARE);
        BiomeDictionary.addTypes(akk.r, Type.BEACH);
        BiomeDictionary.addTypes(akk.s, Type.HOT, Type.DRY, Type.SANDY, Type.HILLS);
        BiomeDictionary.addTypes(akk.t, Type.FOREST, Type.HILLS);
        BiomeDictionary.addTypes(akk.u, Type.COLD, Type.CONIFEROUS, Type.FOREST, Type.HILLS);
        BiomeDictionary.addTypes(akk.v, Type.MOUNTAIN);
        BiomeDictionary.addTypes(akk.w, Type.HOT, Type.WET, Type.DENSE, Type.JUNGLE);
        BiomeDictionary.addTypes(akk.x, Type.HOT, Type.WET, Type.DENSE, Type.JUNGLE, Type.HILLS);
        BiomeDictionary.addTypes(akk.y, Type.HOT, Type.WET, Type.JUNGLE, Type.FOREST, Type.RARE);
        BiomeDictionary.addTypes(akk.z, Type.OCEAN);
        BiomeDictionary.addTypes(akk.A, Type.BEACH);
        BiomeDictionary.addTypes(akk.B, Type.COLD, Type.BEACH, Type.SNOWY);
        BiomeDictionary.addTypes(akk.C, Type.FOREST);
        BiomeDictionary.addTypes(akk.D, Type.FOREST, Type.HILLS);
        BiomeDictionary.addTypes(akk.E, Type.SPOOKY, Type.DENSE, Type.FOREST);
        BiomeDictionary.addTypes(akk.F, Type.COLD, Type.CONIFEROUS, Type.FOREST, Type.SNOWY);
        BiomeDictionary.addTypes(akk.G, Type.COLD, Type.CONIFEROUS, Type.FOREST, Type.SNOWY, Type.HILLS);
        BiomeDictionary.addTypes(akk.H, Type.COLD, Type.CONIFEROUS, Type.FOREST);
        BiomeDictionary.addTypes(akk.I, Type.COLD, Type.CONIFEROUS, Type.FOREST, Type.HILLS);
        BiomeDictionary.addTypes(akk.J, Type.MOUNTAIN, Type.FOREST, Type.SPARSE);
        BiomeDictionary.addTypes(akk.K, Type.HOT, Type.SAVANNA, Type.PLAINS, Type.SPARSE);
        BiomeDictionary.addTypes(akk.L, Type.HOT, Type.SAVANNA, Type.PLAINS, Type.SPARSE, Type.RARE);
        BiomeDictionary.addTypes(akk.M, Type.MESA, Type.SANDY);
        BiomeDictionary.addTypes(akk.N, Type.MESA, Type.SPARSE, Type.SANDY);
        BiomeDictionary.addTypes(akk.O, Type.MESA, Type.SANDY);
        BiomeDictionary.addTypes(akk.P, Type.VOID);
        BiomeDictionary.addTypes(akk.Q, Type.PLAINS, Type.RARE);
        BiomeDictionary.addTypes(akk.R, Type.HOT, Type.DRY, Type.SANDY, Type.RARE);
        BiomeDictionary.addTypes(akk.S, Type.MOUNTAIN, Type.SPARSE, Type.RARE);
        BiomeDictionary.addTypes(akk.T, Type.FOREST, Type.HILLS, Type.RARE);
        BiomeDictionary.addTypes(akk.U, Type.COLD, Type.CONIFEROUS, Type.FOREST, Type.MOUNTAIN, Type.RARE);
        BiomeDictionary.addTypes(akk.V, Type.WET, Type.SWAMP, Type.HILLS, Type.RARE);
        BiomeDictionary.addTypes(akk.W, Type.COLD, Type.SNOWY, Type.HILLS, Type.RARE);
        BiomeDictionary.addTypes(akk.X, Type.HOT, Type.WET, Type.DENSE, Type.JUNGLE, Type.MOUNTAIN, Type.RARE);
        BiomeDictionary.addTypes(akk.Y, Type.HOT, Type.SPARSE, Type.JUNGLE, Type.HILLS, Type.RARE);
        BiomeDictionary.addTypes(akk.Z, Type.FOREST, Type.DENSE, Type.HILLS, Type.RARE);
        BiomeDictionary.addTypes(akk.aa, Type.FOREST, Type.DENSE, Type.MOUNTAIN, Type.RARE);
        BiomeDictionary.addTypes(akk.ab, Type.SPOOKY, Type.DENSE, Type.FOREST, Type.MOUNTAIN, Type.RARE);
        BiomeDictionary.addTypes(akk.ac, Type.COLD, Type.CONIFEROUS, Type.FOREST, Type.SNOWY, Type.MOUNTAIN, Type.RARE);
        BiomeDictionary.addTypes(akk.ad, Type.DENSE, Type.FOREST, Type.RARE);
        BiomeDictionary.addTypes(akk.ae, Type.DENSE, Type.FOREST, Type.HILLS, Type.RARE);
        BiomeDictionary.addTypes(akk.af, Type.MOUNTAIN, Type.SPARSE, Type.RARE);
        BiomeDictionary.addTypes(akk.ag, Type.HOT, Type.DRY, Type.SPARSE, Type.SAVANNA, Type.MOUNTAIN, Type.RARE);
        BiomeDictionary.addTypes(akk.ah, Type.HOT, Type.DRY, Type.SPARSE, Type.SAVANNA, Type.HILLS, Type.RARE);
        BiomeDictionary.addTypes(akk.ai, Type.HOT, Type.DRY, Type.SPARSE, Type.SAVANNA, Type.MOUNTAIN, Type.RARE);
        BiomeDictionary.addTypes(akk.aj, Type.HOT, Type.DRY, Type.SPARSE, Type.HILLS, Type.RARE);
        BiomeDictionary.addTypes(akk.ak, Type.HOT, Type.DRY, Type.SPARSE, Type.SAVANNA, Type.MOUNTAIN, Type.RARE);
    }

    static {
        BiomeDictionary.registerVanillaBiomes();
    }

    private static class BiomeInfo {
        private final Set<Type> types = new HashSet<Type>();
        private final Set<Type> typesUn = Collections.unmodifiableSet(this.types);

        private BiomeInfo() {
        }
    }

    public static final class Type {
        private static final Map<String, Type> byName = new HashMap<String, Type>();
        public static final Type HOT = new Type("HOT", new Type[0]);
        public static final Type COLD = new Type("COLD", new Type[0]);
        public static final Type SPARSE = new Type("SPARSE", new Type[0]);
        public static final Type DENSE = new Type("DENSE", new Type[0]);
        public static final Type WET = new Type("WET", new Type[0]);
        public static final Type DRY = new Type("DRY", new Type[0]);
        public static final Type SAVANNA = new Type("SAVANNA", new Type[0]);
        public static final Type CONIFEROUS = new Type("CONIFEROUS", new Type[0]);
        public static final Type JUNGLE = new Type("JUNGLE", new Type[0]);
        public static final Type SPOOKY = new Type("SPOOKY", new Type[0]);
        public static final Type DEAD = new Type("DEAD", new Type[0]);
        public static final Type LUSH = new Type("LUSH", new Type[0]);
        public static final Type NETHER = new Type("NETHER", new Type[0]);
        public static final Type END = new Type("END", new Type[0]);
        public static final Type MUSHROOM = new Type("MUSHROOM", new Type[0]);
        public static final Type MAGICAL = new Type("MAGICAL", new Type[0]);
        public static final Type RARE = new Type("RARE", new Type[0]);
        public static final Type OCEAN = new Type("OCEAN", new Type[0]);
        public static final Type RIVER = new Type("RIVER", new Type[0]);
        public static final Type WATER = new Type("WATER", OCEAN, RIVER);
        public static final Type MESA = new Type("MESA", new Type[0]);
        public static final Type FOREST = new Type("FOREST", new Type[0]);
        public static final Type PLAINS = new Type("PLAINS", new Type[0]);
        public static final Type MOUNTAIN = new Type("MOUNTAIN", new Type[0]);
        public static final Type HILLS = new Type("HILLS", new Type[0]);
        public static final Type SWAMP = new Type("SWAMP", new Type[0]);
        public static final Type SANDY = new Type("SANDY", new Type[0]);
        public static final Type SNOWY = new Type("SNOWY", new Type[0]);
        public static final Type WASTELAND = new Type("WASTELAND", new Type[0]);
        public static final Type BEACH = new Type("BEACH", new Type[0]);
        public static final Type VOID = new Type("VOID", new Type[0]);
        private final String name;
        private final List<Type> subTypes;
        private final Set<akf> biomes = new HashSet<akf>();
        private final Set<akf> biomesUn = Collections.unmodifiableSet(this.biomes);

        private Type(String name, Type ... subTypes) {
            this.name = name;
            this.subTypes = ImmutableList.copyOf((Object[])subTypes);
            byName.put(name, this);
        }

        private boolean hasSubTypes() {
            return !this.subTypes.isEmpty();
        }

        public String getName() {
            return this.name;
        }

        public String toString() {
            return this.name;
        }

        public static Type getType(String name, Type ... subTypes) {
            Type t2 = byName.get(name = name.toUpperCase());
            if (t2 == null) {
                t2 = new Type(name, subTypes);
            }
            return t2;
        }
    }
}

