/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.common;

import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraftforge.common.util.EnumHelper;

public class BiomeManager {
    private static TrackedList<BiomeEntry>[] biomes = BiomeManager.setupBiomes();
    public static List<akf> oceanBiomes = new ArrayList<akf>();
    public static ArrayList<akf> strongHoldBiomes = new ArrayList();
    public static ArrayList<akf> strongHoldBiomesBlackList = new ArrayList();

    private static TrackedList<BiomeEntry>[] setupBiomes() {
        TrackedList[] currentBiomes = new TrackedList[BiomeType.values().length];
        ArrayList<BiomeEntry> list = new ArrayList<BiomeEntry>();
        list.add(new BiomeEntry(akk.f, 10));
        list.add(new BiomeEntry(akk.E, 10));
        list.add(new BiomeEntry(akk.e, 10));
        list.add(new BiomeEntry(akk.c, 10));
        list.add(new BiomeEntry(akk.C, 10));
        list.add(new BiomeEntry(akk.h, 10));
        currentBiomes[BiomeType.WARM.ordinal()] = new TrackedList(list);
        list.clear();
        list.add(new BiomeEntry(akk.f, 10));
        list.add(new BiomeEntry(akk.e, 10));
        list.add(new BiomeEntry(akk.g, 10));
        list.add(new BiomeEntry(akk.c, 10));
        currentBiomes[BiomeType.COOL.ordinal()] = new TrackedList(list);
        list.clear();
        list.add(new BiomeEntry(akk.n, 30));
        list.add(new BiomeEntry(akk.F, 10));
        currentBiomes[BiomeType.ICY.ordinal()] = new TrackedList(list);
        list.clear();
        currentBiomes[BiomeType.DESERT.ordinal()] = new TrackedList(list);
        return currentBiomes;
    }

    public static void addVillageBiome(akf biome, boolean canSpawn) {
        if (!ayt.a.contains(biome)) {
            ArrayList<akf> biomes = new ArrayList<akf>(ayt.a);
            biomes.add(biome);
            ayt.a = biomes;
        }
    }

    public static void removeVillageBiome(akf biome) {
        if (ayt.a.contains(biome)) {
            ArrayList<akf> biomes = new ArrayList<akf>(ayt.a);
            biomes.remove(biome);
            ayt.a = biomes;
        }
    }

    public static void addStrongholdBiome(akf biome) {
        if (!strongHoldBiomes.contains(biome)) {
            strongHoldBiomes.add(biome);
        }
    }

    public static void removeStrongholdBiome(akf biome) {
        if (!strongHoldBiomesBlackList.contains(biome)) {
            strongHoldBiomesBlackList.add(biome);
        }
    }

    public static void addSpawnBiome(akf biome) {
        if (!akj.allowedBiomes.contains(biome)) {
            akj.allowedBiomes.add(biome);
        }
    }

    public static void removeSpawnBiome(akf biome) {
        if (akj.allowedBiomes.contains(biome)) {
            akj.allowedBiomes.remove(biome);
        }
    }

    public static void addBiome(BiomeType type, BiomeEntry entry) {
        TrackedList<BiomeEntry> list;
        int idx = type.ordinal();
        TrackedList<BiomeEntry> trackedList = list = idx > biomes.length ? null : biomes[idx];
        if (list != null) {
            list.add(entry);
        }
    }

    public static void removeBiome(BiomeType type, BiomeEntry entry) {
        TrackedList<BiomeEntry> list;
        int idx = type.ordinal();
        TrackedList<BiomeEntry> trackedList = list = idx > biomes.length ? null : biomes[idx];
        if (list != null && list.contains(entry)) {
            list.remove(entry);
        }
    }

    @Nullable
    public static ImmutableList<BiomeEntry> getBiomes(BiomeType type) {
        int idx = type.ordinal();
        TrackedList<BiomeEntry> list = idx >= biomes.length ? null : biomes[idx];
        return list != null ? ImmutableList.copyOf(list) : null;
    }

    public static boolean isTypeListModded(BiomeType type) {
        TrackedList<BiomeEntry> list;
        int idx = type.ordinal();
        TrackedList<BiomeEntry> trackedList = list = idx > biomes.length ? null : biomes[idx];
        if (list != null) {
            return list.isModded();
        }
        return false;
    }

    static /* synthetic */ TrackedList[] access$002(TrackedList[] x0) {
        biomes = x0;
        return x0;
    }

    static {
        oceanBiomes.add(akk.a);
        oceanBiomes.add(akk.z);
        oceanBiomes.add(akk.l);
    }

    private static class TrackedList<E>
    extends ArrayList<E> {
        private static final long serialVersionUID = 1L;
        private boolean isModded = false;

        public TrackedList(Collection<? extends E> c2) {
            super(c2);
        }

        @Override
        public E set(int index, E element) {
            this.isModded = true;
            return super.set(index, element);
        }

        @Override
        public boolean add(E e2) {
            this.isModded = true;
            return super.add(e2);
        }

        @Override
        public void add(int index, E element) {
            this.isModded = true;
            super.add(index, element);
        }

        @Override
        public E remove(int index) {
            this.isModded = true;
            return super.remove(index);
        }

        @Override
        public boolean remove(Object o2) {
            this.isModded = true;
            return super.remove(o2);
        }

        @Override
        public void clear() {
            this.isModded = true;
            super.clear();
        }

        @Override
        public boolean addAll(Collection<? extends E> c2) {
            this.isModded = true;
            return super.addAll(c2);
        }

        @Override
        public boolean addAll(int index, Collection<? extends E> c2) {
            this.isModded = true;
            return super.addAll(index, c2);
        }

        @Override
        public boolean removeAll(Collection<?> c2) {
            this.isModded = true;
            return super.removeAll(c2);
        }

        @Override
        public boolean retainAll(Collection<?> c2) {
            this.isModded = true;
            return super.retainAll(c2);
        }

        public boolean isModded() {
            return this.isModded;
        }
    }

    public static class BiomeEntry
    extends pb.a {
        public final akf biome;

        public BiomeEntry(akf biome, int weight) {
            super(weight);
            this.biome = biome;
        }
    }

    public static enum BiomeType {
        DESERT,
        WARM,
        COOL,
        ICY;


        public static BiomeType getType(String name) {
            name = name.toUpperCase();
            for (BiomeType t2 : BiomeType.values()) {
                if (!t2.name().equals(name)) continue;
                return t2;
            }
            BiomeType ret = EnumHelper.addEnum(BiomeType.class, name, new Class[0], new Object[0]);
            if (ret.ordinal() >= biomes.length) {
                BiomeManager.access$002(Arrays.copyOf(biomes, ret.ordinal() + 1));
            }
            return ret;
        }
    }
}

