/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.common;

import com.google.common.collect.HashMultiset;
import com.google.common.collect.Lists;
import com.google.common.collect.MapMaker;
import com.google.common.collect.Multiset;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.BitSet;
import java.util.Hashtable;
import java.util.ListIterator;
import java.util.Map;
import java.util.concurrent.ConcurrentMap;
import javax.annotation.Nullable;
import net.minecraft.server.MinecraftServer;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.world.WorldEvent;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.common.FMLLog;
import org.apache.logging.log4j.Level;

public class DimensionManager {
    private static Hashtable<Integer, lw> worlds = new Hashtable();
    private static boolean hasInit = false;
    private static Hashtable<Integer, avg> dimensions = new Hashtable();
    private static ArrayList<Integer> unloadQueue = new ArrayList();
    private static BitSet dimensionMap = new BitSet(1024);
    private static ConcurrentMap<ajs, ajs> weakWorldMap = new MapMaker().weakKeys().weakValues().makeMap();
    private static Multiset<Integer> leakedWorlds = HashMultiset.create();

    public static int[] getDimensions(avg type) {
        int[] ret = new int[dimensions.size()];
        int x2 = 0;
        for (Map.Entry<Integer, avg> ent : dimensions.entrySet()) {
            if (ent.getValue() != type) continue;
            ret[x2++] = ent.getKey();
        }
        return Arrays.copyOf(ret, x2);
    }

    public static void init() {
        if (hasInit) {
            return;
        }
        hasInit = true;
        DimensionManager.registerDimension(0, avg.a);
        DimensionManager.registerDimension(-1, avg.b);
        DimensionManager.registerDimension(1, avg.c);
    }

    public static void registerDimension(int id2, avg type) {
        avg.a(type.a());
        if (dimensions.containsKey(id2)) {
            throw new IllegalArgumentException(String.format("Failed to register dimension for id %d, One is already registered", id2));
        }
        dimensions.put(id2, type);
        if (id2 >= 0) {
            dimensionMap.set(id2);
        }
    }

    public static void unregisterDimension(int id2) {
        if (!dimensions.containsKey(id2)) {
            throw new IllegalArgumentException(String.format("Failed to unregister dimension for id %d; No provider registered", id2));
        }
        dimensions.remove(id2);
    }

    public static boolean isDimensionRegistered(int dim) {
        return dimensions.containsKey(dim);
    }

    public static avg getProviderType(int dim) {
        if (!dimensions.containsKey(dim)) {
            throw new IllegalArgumentException(String.format("Could not get provider type for dimension %d, does not exist", dim));
        }
        return dimensions.get(dim);
    }

    public static avf getProvider(int dim) {
        return DimensionManager.getWorld((int)dim).s;
    }

    public static Integer[] getIDs(boolean check) {
        if (check) {
            ArrayList allWorlds = Lists.newArrayList(weakWorldMap.keySet());
            allWorlds.removeAll(worlds.values());
            ListIterator li2 = allWorlds.listIterator();
            while (li2.hasNext()) {
                ajs w2 = (ajs)li2.next();
                leakedWorlds.add((Object)System.identityHashCode(w2));
            }
            for (ajs w2 : allWorlds) {
                int leakCount = leakedWorlds.count((Object)System.identityHashCode(w2));
                if (leakCount == 5) {
                    FMLLog.fine("The world %x (%s) may have leaked: first encounter (5 occurrences).\n", System.identityHashCode(w2), w2.T().j());
                    continue;
                }
                if (leakCount % 5 != 0) continue;
                FMLLog.fine("The world %x (%s) may have leaked: seen %d times.\n", System.identityHashCode(w2), w2.T().j(), leakCount);
            }
        }
        return DimensionManager.getIDs();
    }

    public static Integer[] getIDs() {
        return worlds.keySet().toArray(new Integer[worlds.size()]);
    }

    public static void setWorld(int id2, @Nullable lw world, MinecraftServer server) {
        if (world != null) {
            worlds.put(id2, world);
            weakWorldMap.put(world, world);
            server.worldTickTimes.put(id2, new long[100]);
            FMLLog.info("Loading dimension %d (%s) (%s)", id2, world.T().j(), world.u());
        } else {
            worlds.remove(id2);
            server.worldTickTimes.remove(id2);
            FMLLog.info("Unloading dimension %d", id2);
        }
        ArrayList<lw> tmp = new ArrayList<lw>();
        if (worlds.get(0) != null) {
            tmp.add(worlds.get(0));
        }
        if (worlds.get(-1) != null) {
            tmp.add(worlds.get(-1));
        }
        if (worlds.get(1) != null) {
            tmp.add(worlds.get(1));
        }
        for (Map.Entry<Integer, lw> entry : worlds.entrySet()) {
            int dim = entry.getKey();
            if (dim >= -1 && dim <= 1) continue;
            tmp.add(entry.getValue());
        }
        server.d = tmp.toArray(new lw[tmp.size()]);
    }

    public static void initDimension(int dim) {
        lw overworld = DimensionManager.getWorld(0);
        if (overworld == null) {
            throw new RuntimeException("Cannot Hotload Dim: Overworld is not Loaded!");
        }
        try {
            DimensionManager.getProviderType(dim);
        }
        catch (Exception e2) {
            System.err.println("Cannot Hotload Dim: " + e2.getMessage());
            return;
        }
        MinecraftServer mcServer = overworld.u();
        bbw savehandler = overworld.S();
        lw world = dim == 0 ? overworld : (lw)new ls(mcServer, savehandler, dim, overworld, mcServer.c).b();
        world.a(new lx(mcServer, world));
        MinecraftForge.EVENT_BUS.post(new WorldEvent.Load(world));
        if (!mcServer.R()) {
            world.T().a(mcServer.n());
        }
        mcServer.a(mcServer.o());
    }

    public static lw getWorld(int id2) {
        return worlds.get(id2);
    }

    public static lw[] getWorlds() {
        return worlds.values().toArray(new lw[worlds.size()]);
    }

    public static Integer[] getStaticDimensionIDs() {
        return dimensions.keySet().toArray(new Integer[dimensions.keySet().size()]);
    }

    public static avf createProviderFor(int dim) {
        try {
            if (dimensions.containsKey(dim)) {
                avf ret = DimensionManager.getProviderType(dim).d();
                ret.setDimension(dim);
                return ret;
            }
            throw new RuntimeException(String.format("No WorldProvider bound for dimension %d", dim));
        }
        catch (Exception e2) {
            FMLCommonHandler.instance().getFMLLogger().log(Level.ERROR, String.format("An error occurred trying to create an instance of WorldProvider %d (%s)", new Object[]{dim, DimensionManager.getProviderType(dim)}), (Throwable)e2);
            throw new RuntimeException(e2);
        }
    }

    public static void unloadWorld(int id2) {
        unloadQueue.add(id2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void unloadWorlds(Hashtable<Integer, long[]> worldTickTimes) {
        for (int id2 : unloadQueue) {
            lw w2 = worlds.get(id2);
            try {
                if (w2 != null) {
                    w2.a(true, null);
                    continue;
                }
                FMLLog.warning("Unexpected world unload - world %d is already unloaded", id2);
            }
            catch (ajt e2) {
                e2.printStackTrace();
            }
            finally {
                if (w2 == null) continue;
                MinecraftForge.EVENT_BUS.post(new WorldEvent.Unload(w2));
                w2.s();
                DimensionManager.setWorld(id2, null, w2.u());
            }
        }
        unloadQueue.clear();
    }

    public static int getNextFreeDimId() {
        int next = 0;
        while (dimensions.containsKey(next = dimensionMap.nextClearBit(next))) {
            dimensionMap.set(next);
        }
        return next;
    }

    public static du saveDimensionDataMap() {
        int[] data = new int[(dimensionMap.length() + 32 - 1) / 32];
        du dimMap = new du();
        for (int i2 = 0; i2 < data.length; ++i2) {
            int val = 0;
            for (int j2 = 0; j2 < 32; ++j2) {
                val |= dimensionMap.get(i2 * 32 + j2) ? 1 << j2 : 0;
            }
            data[i2] = val;
        }
        dimMap.a("DimensionArray", data);
        return dimMap;
    }

    public static void loadDimensionDataMap(@Nullable du compoundTag) {
        dimensionMap.clear();
        if (compoundTag == null) {
            for (Integer id2 : dimensions.keySet()) {
                if (id2 < 0) continue;
                dimensionMap.set(id2);
            }
        } else {
            int[] intArray = compoundTag.n("DimensionArray");
            for (int i2 = 0; i2 < intArray.length; ++i2) {
                for (int j2 = 0; j2 < 32; ++j2) {
                    dimensionMap.set(i2 * 32 + j2, (intArray[i2] & 1 << j2) != 0);
                }
            }
        }
    }

    @Nullable
    public static File getCurrentSaveRootDirectory() {
        if (DimensionManager.getWorld(0) != null) {
            return DimensionManager.getWorld(0).S().b();
        }
        return null;
    }

    static {
        DimensionManager.init();
    }
}

