/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.common;

import com.google.common.collect.Queues;
import com.google.common.collect.Sets;
import com.google.gson.Gson;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Deque;
import java.util.HashSet;
import java.util.List;
import java.util.Random;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraftforge.common.ForgeModContainer;
import net.minecraftforge.common.ISpecialArmor;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.util.BlockSnapshot;
import net.minecraftforge.event.AnvilUpdateEvent;
import net.minecraftforge.event.ForgeEventFactory;
import net.minecraftforge.event.ServerChatEvent;
import net.minecraftforge.event.entity.EntityTravelToDimensionEvent;
import net.minecraftforge.event.entity.ThrowableImpactEvent;
import net.minecraftforge.event.entity.item.ItemTossEvent;
import net.minecraftforge.event.entity.living.LivingAttackEvent;
import net.minecraftforge.event.entity.living.LivingDeathEvent;
import net.minecraftforge.event.entity.living.LivingDropsEvent;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.event.entity.living.LivingFallEvent;
import net.minecraftforge.event.entity.living.LivingHurtEvent;
import net.minecraftforge.event.entity.living.LivingSetAttackTargetEvent;
import net.minecraftforge.event.entity.living.LootingLevelEvent;
import net.minecraftforge.event.entity.player.AnvilRepairEvent;
import net.minecraftforge.event.entity.player.AttackEntityEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.event.world.BlockEvent;
import net.minecraftforge.event.world.NoteBlockEvent;
import net.minecraftforge.fluids.IFluidBlock;
import net.minecraftforge.fml.common.eventhandler.Event;
import net.minecraftforge.fml.relauncher.ReflectionHelper;

public class ForgeHooks {
    static final List<SeedEntry> seedList = new ArrayList<SeedEntry>();
    private static boolean toolInit = false;
    static final Pattern URL_PATTERN;
    private static ThreadLocal<aay> craftingPlayer;
    private static ThreadLocal<Deque<LootTableContext>> lootContext;

    @Nonnull
    public static afj getGrassSeed(Random rand, int fortune) {
        SeedEntry entry = pb.a(rand, seedList);
        if (entry == null || entry.seed.b()) {
            return afj.a;
        }
        return entry.getStack(rand, fortune);
    }

    public static boolean canHarvestBlock(@Nonnull alu block, @Nonnull aay player, @Nonnull ajw world, @Nonnull co pos) {
        atl state = world.o(pos);
        if ((state = state.v().c(state, world, pos)).a().l()) {
            return true;
        }
        afj stack = player.cg();
        String tool = block.getHarvestTool(state);
        if (stack.b() || tool == null) {
            return player.b(state);
        }
        int toolLevel = stack.c().getHarvestLevel(stack, tool, player, state);
        if (toolLevel < 0) {
            return player.b(state);
        }
        return toolLevel >= block.getHarvestLevel(state);
    }

    public static boolean canToolHarvestBlock(ajw world, co pos, @Nonnull afj stack) {
        atl state = world.o(pos);
        state = state.v().c(state, world, pos);
        String tool = state.v().getHarvestTool(state);
        if (stack.b() || tool == null) {
            return false;
        }
        return stack.c().getHarvestLevel(stack, tool, null, null) >= state.v().getHarvestLevel(state);
    }

    public static float blockStrength(@Nonnull atl state, @Nonnull aay player, @Nonnull ajs world, @Nonnull co pos) {
        float hardness = state.b(world, pos);
        if (hardness < 0.0f) {
            return 0.0f;
        }
        if (!ForgeHooks.canHarvestBlock(state.v(), player, world, pos)) {
            return player.getDigSpeed(state, pos) / hardness / 100.0f;
        }
        return player.getDigSpeed(state, pos) / hardness / 30.0f;
    }

    public static boolean isToolEffective(ajw world, co pos, @Nonnull afj stack) {
        atl state = world.o(pos);
        state = state.v().c(state, world, pos);
        for (String type : stack.c().getToolClasses(stack)) {
            if (!state.v().isToolEffective(type, state)) continue;
            return true;
        }
        return false;
    }

    static void initTools() {
        alu[] oreBlocks;
        if (toolInit) {
            return;
        }
        toolInit = true;
        Set blocks = (Set)ReflectionHelper.getPrivateValue(afu.class, null, 0);
        for (alu block : blocks) {
            block.setHarvestLevel("pickaxe", 0);
        }
        blocks = (Set)ReflectionHelper.getPrivateValue(agg.class, null, 0);
        for (alu block : blocks) {
            block.setHarvestLevel("shovel", 0);
        }
        blocks = (Set)ReflectionHelper.getPrivateValue(ads.class, null, 0);
        for (alu block : blocks) {
            block.setHarvestLevel("axe", 0);
        }
        alv.Z.setHarvestLevel("pickaxe", 3);
        alv.bC.setHarvestLevel("pickaxe", 0);
        for (alu block : oreBlocks = new alu[]{alv.bP, alv.bT, alv.ag, alv.ah, alv.o, alv.R, alv.aC, alv.aD}) {
            block.setHarvestLevel("pickaxe", 2);
        }
        alv.p.setHarvestLevel("pickaxe", 1);
        alv.S.setHarvestLevel("pickaxe", 1);
        alv.x.setHarvestLevel("pickaxe", 1);
        alv.y.setHarvestLevel("pickaxe", 1);
        alv.co.setHarvestLevel("pickaxe", 0);
    }

    public static int getTotalArmorValue(aay player) {
        int ret = 0;
        for (int x2 = 0; x2 < player.bs.b.size(); ++x2) {
            afj stack = player.bs.b.get(x2);
            if (stack.c() instanceof ISpecialArmor) {
                ret += ((ISpecialArmor)((Object)stack.c())).getArmorDisplay(player, stack, x2);
                continue;
            }
            if (!(stack.c() instanceof adp)) continue;
            ret += ((adp)stack.c()).d;
        }
        return ret;
    }

    public static boolean onPickBlock(bdu target, aay player, ajs world) {
        afj result;
        boolean isCreative = player.bK.d;
        asc te2 = null;
        if (target.a == bdu.a.b) {
            atl state = world.o(target.a());
            if (state.v().isAir(state, world, target.a())) {
                return false;
            }
            if (isCreative && bho.q() && state.v().hasTileEntity(state)) {
                te2 = world.r(target.a());
            }
            result = state.v().getPickBlock(state, target, world, target.a(), player);
        } else {
            if (target.a != bdu.a.c || target.d == null || !isCreative) {
                return false;
            }
            result = target.d.getPickedResult(target);
        }
        if (result.b()) {
            return false;
        }
        if (te2 != null) {
            bes.z().a(result, te2);
        }
        if (isCreative) {
            player.bs.a(result);
            bes.z().c.a(player.b(ri.a), 36 + player.bs.d);
            return true;
        }
        int slot = player.bs.b(result);
        if (slot != -1) {
            if (aax.e(slot)) {
                player.bs.d = slot;
            } else {
                bes.z().c.a(slot);
            }
            return true;
        }
        return false;
    }

    public static void onLivingSetAttackTarget(sw entity, sw target) {
        MinecraftForge.EVENT_BUS.post(new LivingSetAttackTargetEvent(entity, target));
    }

    public static boolean onLivingUpdate(sw entity) {
        return MinecraftForge.EVENT_BUS.post(new LivingEvent.LivingUpdateEvent(entity));
    }

    public static boolean onLivingAttack(sw entity, ry src, float amount) {
        return !MinecraftForge.EVENT_BUS.post(new LivingAttackEvent(entity, src, amount));
    }

    public static float onLivingHurt(sw entity, ry src, float amount) {
        LivingHurtEvent event = new LivingHurtEvent(entity, src, amount);
        return MinecraftForge.EVENT_BUS.post(event) ? 0.0f : event.getAmount();
    }

    public static boolean onLivingDeath(sw entity, ry src) {
        return MinecraftForge.EVENT_BUS.post(new LivingDeathEvent(entity, src));
    }

    public static boolean onLivingDrops(sw entity, ry source, ArrayList<zj> drops, int lootingLevel, boolean recentlyHit) {
        return MinecraftForge.EVENT_BUS.post(new LivingDropsEvent(entity, source, drops, lootingLevel, recentlyHit));
    }

    @Nullable
    public static float[] onLivingFall(sw entity, float distance, float damageMultiplier) {
        float[] fArray;
        LivingFallEvent event = new LivingFallEvent(entity, distance, damageMultiplier);
        if (MinecraftForge.EVENT_BUS.post(event)) {
            fArray = null;
        } else {
            float[] fArray2 = new float[2];
            fArray2[0] = event.getDistance();
            fArray = fArray2;
            fArray2[1] = event.getDamageMultiplier();
        }
        return fArray;
    }

    public static int getLootingLevel(sn target, @Nullable sn killer, ry cause) {
        int looting = 0;
        if (killer instanceof sw) {
            looting = aik.g((sw)killer);
        }
        if (target instanceof sw) {
            looting = ForgeHooks.getLootingLevel((sw)target, cause, looting);
        }
        return looting;
    }

    public static int getLootingLevel(sw target, ry cause, int level) {
        LootingLevelEvent event = new LootingLevelEvent(target, cause, level);
        MinecraftForge.EVENT_BUS.post(event);
        return event.getLootingLevel();
    }

    public static double getPlayerVisibilityDistance(aay player, double xzDistance, double maxXZDistance) {
        PlayerEvent.Visibility event = new PlayerEvent.Visibility(player);
        MinecraftForge.EVENT_BUS.post(event);
        double value = event.getVisibilityModifier() * xzDistance;
        return value >= maxXZDistance ? maxXZDistance : value;
    }

    public static boolean isLivingOnLadder(@Nonnull atl state, @Nonnull ajs world, @Nonnull co pos, @Nonnull sw entity) {
        boolean isSpectator;
        boolean bl2 = isSpectator = entity instanceof aay && ((aay)entity).y();
        if (isSpectator) {
            return false;
        }
        if (!ForgeModContainer.fullBoundingBoxLadders) {
            return state.v().isLadder(state, world, pos, entity);
        }
        bdt bb2 = entity.bo();
        int mX = ot.c(bb2.a);
        int mY = ot.c(bb2.b);
        int mZ = ot.c(bb2.c);
        int y2 = mY;
        while ((double)y2 < bb2.e) {
            int x2 = mX;
            while ((double)x2 < bb2.d) {
                int z2 = mZ;
                while ((double)z2 < bb2.f) {
                    co tmp = new co(x2, y2, z2);
                    state = world.o(tmp);
                    if (state.v().isLadder(state, world, tmp, entity)) {
                        return true;
                    }
                    ++z2;
                }
                ++x2;
            }
            ++y2;
        }
        return false;
    }

    public static void onLivingJump(sw entity) {
        MinecraftForge.EVENT_BUS.post(new LivingEvent.LivingJumpEvent(entity));
    }

    @Nullable
    public static zj onPlayerTossEvent(@Nonnull aay player, @Nonnull afj item, boolean includeName) {
        player.captureDrops = true;
        zj ret = player.a(item, false, includeName);
        player.capturedDrops.clear();
        player.captureDrops = false;
        if (ret == null) {
            return null;
        }
        ItemTossEvent event = new ItemTossEvent(ret, player);
        if (MinecraftForge.EVENT_BUS.post(event)) {
            return null;
        }
        if (!player.l.E) {
            player.e().a(event.getEntityItem());
        }
        return event.getEntityItem();
    }

    public static float getEnchantPower(@Nonnull ajs world, @Nonnull co pos) {
        return world.o(pos).v().getEnchantPowerBonus(world, pos);
    }

    @Nullable
    public static fb onServerChatEvent(mi net, String raw, fb comp) {
        ServerChatEvent event = new ServerChatEvent(net.b, raw, comp);
        if (MinecraftForge.EVENT_BUS.post(event)) {
            return null;
        }
        return event.getComponent();
    }

    public static fb newChatWithLinks(String string) {
        return ForgeHooks.newChatWithLinks(string, true);
    }

    public static fb newChatWithLinks(String string, boolean allowMissingHeader) {
        fh ichat = null;
        Matcher matcher = URL_PATTERN.matcher(string);
        int lastEnd = 0;
        while (matcher.find()) {
            fh link;
            String url;
            block13: {
                int start = matcher.start();
                int end = matcher.end();
                String part = string.substring(lastEnd, start);
                if (part.length() > 0) {
                    if (ichat == null) {
                        ichat = new fh(part);
                    } else {
                        ichat.a(part);
                    }
                }
                lastEnd = end;
                url = string.substring(start, end);
                link = new fh(url);
                try {
                    if (new URI(url).getScheme() != null) break block13;
                    if (!allowMissingHeader) {
                        if (ichat == null) {
                            ichat = new fh(url);
                            continue;
                        }
                        ichat.a(url);
                        continue;
                    }
                    url = "http://" + url;
                }
                catch (URISyntaxException e2) {
                    if (ichat == null) {
                        ichat = new fh(url);
                        continue;
                    }
                    ichat.a(url);
                    continue;
                }
            }
            fa click = new fa(fa.a.a, url);
            link.b().a(click);
            link.b().d(true);
            link.b().a(a.j);
            if (ichat == null) {
                ichat = link;
                continue;
            }
            ichat.a(link);
        }
        String end = string.substring(lastEnd);
        if (ichat == null) {
            ichat = new fh(end);
        } else if (end.length() > 0) {
            ichat.a(string.substring(lastEnd));
        }
        return ichat;
    }

    public static int onBlockBreakEvent(ajs world, ajq gameType, ly entityPlayer, co pos) {
        boolean preCancelEvent = false;
        if (gameType.d() && !entityPlayer.cg().b() && entityPlayer.cg().c() instanceof agr) {
            preCancelEvent = true;
        }
        if (gameType.c()) {
            afj itemstack;
            if (gameType == ajq.e) {
                preCancelEvent = true;
            }
            if (!(entityPlayer.dc() || !(itemstack = entityPlayer.cg()).b() && itemstack.a(world.o(pos).v()))) {
                preCancelEvent = true;
            }
        }
        if (world.r(pos) == null) {
            gb packet = new gb(world, pos);
            packet.b = alv.a.t();
            entityPlayer.a.a(packet);
        }
        atl state = world.o(pos);
        BlockEvent.BreakEvent event = new BlockEvent.BreakEvent(world, pos, state, entityPlayer);
        event.setCanceled(preCancelEvent);
        MinecraftForge.EVENT_BUS.post(event);
        if (event.isCanceled()) {
            fz pkt;
            entityPlayer.a.a(new gb(world, pos));
            asc tileentity = world.r(pos);
            if (tileentity != null && (pkt = tileentity.c()) != null) {
                entityPlayer.a.a(pkt);
            }
        }
        return event.isCanceled() ? -1 : event.getExpToDrop();
    }

    public static rk onPlaceItemIntoWorld(@Nonnull afj itemstack, @Nonnull aay player, @Nonnull ajs world, @Nonnull co pos, @Nonnull cv side, float hitX, float hitY, float hitZ, @Nonnull ri hand) {
        int meta = itemstack.i();
        int size = itemstack.E();
        du nbt = null;
        if (itemstack.p() != null) {
            nbt = itemstack.p().g();
        }
        if (!(itemstack.c() instanceof aec)) {
            world.captureBlockSnapshots = true;
        }
        rk ret = itemstack.c().a(player, world, pos, hand, side, hitX, hitY, hitZ);
        world.captureBlockSnapshots = false;
        if (ret == rk.a) {
            int newMeta = itemstack.i();
            int newSize = itemstack.E();
            du newNBT = null;
            if (itemstack.p() != null) {
                newNBT = itemstack.p().g();
            }
            BlockEvent.PlaceEvent placeEvent = null;
            List blockSnapshots = (List)world.capturedBlockSnapshots.clone();
            world.capturedBlockSnapshots.clear();
            itemstack.b(meta);
            itemstack.e(size);
            if (nbt != null) {
                itemstack.b(nbt);
            }
            if (blockSnapshots.size() > 1) {
                placeEvent = ForgeEventFactory.onPlayerMultiBlockPlace(player, blockSnapshots, side, hand);
            } else if (blockSnapshots.size() == 1) {
                placeEvent = ForgeEventFactory.onPlayerBlockPlace(player, (BlockSnapshot)blockSnapshots.get(0), side, hand);
            }
            if (placeEvent != null && placeEvent.isCanceled()) {
                ret = rk.c;
                for (BlockSnapshot blocksnapshot : blockSnapshots) {
                    world.restoringBlockSnapshots = true;
                    blocksnapshot.restore(true, false);
                    world.restoringBlockSnapshots = false;
                }
            } else {
                itemstack.b(newMeta);
                itemstack.e(newSize);
                if (nbt != null) {
                    itemstack.b(newNBT);
                }
                for (BlockSnapshot snap : blockSnapshots) {
                    int updateFlag = snap.getFlag();
                    atl oldBlock = snap.getReplacedBlock();
                    atl newBlock = world.o(snap.getPos());
                    if (!newBlock.v().hasTileEntity(newBlock)) {
                        newBlock.v().c(world, snap.getPos(), newBlock);
                    }
                    world.markAndNotifyBlock(snap.getPos(), null, oldBlock, newBlock, updateFlag);
                }
                player.b(oa.b(itemstack.c()));
            }
        }
        world.capturedBlockSnapshots.clear();
        return ret;
    }

    public static boolean onAnvilChange(acm container, @Nonnull afj left, @Nonnull afj right, rc outputSlot, String name, int baseCost) {
        AnvilUpdateEvent e2 = new AnvilUpdateEvent(left, right, name, baseCost);
        if (MinecraftForge.EVENT_BUS.post(e2)) {
            return false;
        }
        if (e2.getOutput().b()) {
            return true;
        }
        outputSlot.a(0, e2.getOutput());
        container.a = e2.getCost();
        container.k = e2.getMaterialCost();
        return false;
    }

    public static float onAnvilRepair(aay player, @Nonnull afj output, @Nonnull afj left, @Nonnull afj right) {
        AnvilRepairEvent e2 = new AnvilRepairEvent(player, left, right, output);
        MinecraftForge.EVENT_BUS.post(e2);
        return e2.getBreakChance();
    }

    public static boolean onNoteChange(ass te2, byte old) {
        NoteBlockEvent.Change e2 = new NoteBlockEvent.Change(te2.D(), te2.w(), te2.D().o(te2.w()), old, te2.a);
        if (MinecraftForge.EVENT_BUS.post(e2)) {
            te2.a = old;
            return false;
        }
        te2.a = (byte)e2.getVanillaNoteId();
        return true;
    }

    public static dd<afj> defaultRecipeGetRemainingItems(acs inv) {
        dd<afj> ret = dd.a(inv.v_(), afj.a);
        for (int i2 = 0; i2 < ret.size(); ++i2) {
            ret.set(i2, ForgeHooks.getContainerItem(inv.a(i2)));
        }
        return ret;
    }

    public static void setCraftingPlayer(aay player) {
        craftingPlayer.set(player);
    }

    public static aay getCraftingPlayer() {
        return craftingPlayer.get();
    }

    @Nonnull
    public static afj getContainerItem(@Nonnull afj stack) {
        if (stack.c().hasContainerItem(stack)) {
            if (!(stack = stack.c().getContainerItem(stack)).b() && stack.f() && stack.j() > stack.k()) {
                ForgeEventFactory.onPlayerDestroyItem(craftingPlayer.get(), stack, null);
                return afj.a;
            }
            return stack;
        }
        return afj.a;
    }

    public static boolean isInsideOfMaterial(azs material, sn entity, co pos) {
        atl state = entity.l.o(pos);
        alu block = state.v();
        double eyes = entity.q + (double)entity.bq();
        double filled = 1.0;
        if (block instanceof IFluidBlock) {
            filled = ((IFluidBlock)((Object)block)).getFilledPercentage(entity.l, pos);
        } else if (block instanceof aoq) {
            filled = aoq.e(block.e(state));
        }
        if (filled < 0.0) {
            return eyes > (double)(pos.q() + 1) + (1.0 - (filled *= -1.0));
        }
        return eyes < (double)(pos.q() + 1) + filled;
    }

    public static boolean onPlayerAttackTarget(aay player, sn target) {
        if (MinecraftForge.EVENT_BUS.post(new AttackEntityEvent(player, target))) {
            return false;
        }
        afj stack = player.cg();
        return stack.b() || !stack.c().onLeftClickEntity(stack, player, target);
    }

    public static boolean onTravelToDimension(sn entity, int dimension) {
        EntityTravelToDimensionEvent event = new EntityTravelToDimensionEvent(entity, dimension);
        MinecraftForge.EVENT_BUS.post(event);
        if (event.isCanceled() && entity instanceof acb) {
            ((acb)entity).b = true;
        }
        return !event.isCanceled();
    }

    @Nullable
    public static bdu rayTraceEyes(sw entity, double length) {
        bdw startPos = new bdw(entity.p, entity.q + (double)entity.bq(), entity.r);
        bdw endPos = startPos.e(new bdw(entity.aB().b * length, entity.aB().c * length, entity.aB().d * length));
        return entity.l.a(startPos, endPos);
    }

    @Nullable
    public static bdw rayTraceEyeHitVec(sw entity, double length) {
        bdu git = ForgeHooks.rayTraceEyes(entity, length);
        return git == null ? null : git.c;
    }

    public static boolean onInteractEntityAt(aay player, sn entity, bdu ray, ri hand) {
        bdw vec3d = new bdw(ray.c.b - entity.p, ray.c.c - entity.q, ray.c.d - entity.r);
        return ForgeHooks.onInteractEntityAt(player, entity, vec3d, hand);
    }

    public static boolean onInteractEntityAt(aay player, sn entity, bdw vec3d, ri hand) {
        return MinecraftForge.EVENT_BUS.post(new PlayerInteractEvent.EntityInteractSpecific(player, hand, entity, vec3d));
    }

    public static boolean onInteractEntity(aay player, sn entity, ri hand) {
        return MinecraftForge.EVENT_BUS.post(new PlayerInteractEvent.EntityInteract(player, hand, entity));
    }

    public static boolean onItemRightClick(aay player, ri hand) {
        return MinecraftForge.EVENT_BUS.post(new PlayerInteractEvent.RightClickItem(player, hand));
    }

    public static PlayerInteractEvent.LeftClickBlock onLeftClickBlock(aay player, co pos, cv face, bdw hitVec) {
        PlayerInteractEvent.LeftClickBlock evt = new PlayerInteractEvent.LeftClickBlock(player, pos, face, hitVec);
        MinecraftForge.EVENT_BUS.post(evt);
        return evt;
    }

    public static PlayerInteractEvent.RightClickBlock onRightClickBlock(aay player, ri hand, co pos, cv face, bdw hitVec) {
        PlayerInteractEvent.RightClickBlock evt = new PlayerInteractEvent.RightClickBlock(player, hand, pos, face, hitVec);
        MinecraftForge.EVENT_BUS.post(evt);
        return evt;
    }

    public static void onEmptyClick(aay player, ri hand) {
        MinecraftForge.EVENT_BUS.post(new PlayerInteractEvent.RightClickEmpty(player, hand));
    }

    public static void onEmptyLeftClick(aay player) {
        MinecraftForge.EVENT_BUS.post(new PlayerInteractEvent.LeftClickEmpty(player));
    }

    @Deprecated
    public static void onEmptyLeftClick(aay player, @Nonnull afj stack) {
        ForgeHooks.onEmptyLeftClick(player);
    }

    private static LootTableContext getLootTableContext() {
        LootTableContext ctx = lootContext.get().peek();
        if (ctx == null) {
            throw new JsonParseException("Invalid call stack, could to grab json context!");
        }
        return ctx;
    }

    @Nullable
    public static bck loadLootTable(Gson gson, kq name, String data, boolean custom) {
        ArrayDeque que = lootContext.get();
        if (que == null) {
            que = Queues.newArrayDeque();
            lootContext.set(que);
        }
        bck ret = null;
        try {
            que.push(new LootTableContext(name, custom));
            ret = (bck)gson.fromJson(data, bck.class);
            que.pop();
        }
        catch (JsonParseException e2) {
            que.pop();
            throw e2;
        }
        if (!custom) {
            ret = ForgeEventFactory.loadLootTable(name, ret);
        }
        if (ret != null) {
            ret.freeze();
        }
        return ret;
    }

    public static String readPoolName(JsonObject json) {
        LootTableContext ctx = ForgeHooks.getLootTableContext();
        ctx.resetPoolCtx();
        if (json.has("name")) {
            return ok.h(json, "name");
        }
        if (ctx.custom) {
            return "custom#" + json.hashCode();
        }
        ++ctx.poolCount;
        if (!ctx.vanilla) {
            throw new JsonParseException("Loot Table \"" + ctx.name.toString() + "\" Missing `name` entry for pool #" + (ctx.poolCount - 1));
        }
        return ctx.poolCount == 1 ? "main" : "pool" + (ctx.poolCount - 1);
    }

    public static String readLootEntryName(JsonObject json, String type) {
        LootTableContext ctx = ForgeHooks.getLootTableContext();
        ++ctx.entryCount;
        if (json.has("entryName")) {
            return ctx.validateEntryName(ok.h(json, "entryName"));
        }
        if (ctx.custom) {
            return "custom#" + json.hashCode();
        }
        String name = null;
        if ("item".equals(type)) {
            name = ok.h(json, "name");
        } else if ("loot_table".equals(type)) {
            name = ok.h(json, "name");
        } else if ("empty".equals(type)) {
            name = "empty";
        }
        return ctx.validateEntryName(name);
    }

    public static bcj deserializeJsonLootEntry(String type, JsonObject json, int weight, int quality, bdd[] conditions) {
        return null;
    }

    public static String getLootEntryType(bcj entry) {
        return null;
    }

    public static boolean onThrowableImpact(abp throwable, bdu ray) {
        return MinecraftForge.EVENT_BUS.post(new ThrowableImpactEvent(throwable, ray));
    }

    public static boolean onCropsGrowPre(ajs worldIn, co pos, atl state, boolean def) {
        BlockEvent.CropGrowEvent.Pre ev2 = new BlockEvent.CropGrowEvent.Pre(worldIn, pos, state);
        MinecraftForge.EVENT_BUS.post(ev2);
        return ev2.getResult() == Event.Result.ALLOW || ev2.getResult() == Event.Result.DEFAULT && def;
    }

    public static void onCropsGrowPost(ajs worldIn, co pos, atl state, atl blockState) {
        MinecraftForge.EVENT_BUS.post(new BlockEvent.CropGrowEvent.Post(worldIn, pos, state, worldIn.o(pos)));
    }

    static {
        seedList.add(new SeedEntry(new afj(afl.Q), 10){

            @Override
            @Nonnull
            public afj getStack(Random rand, int fortune) {
                return new afj(afl.Q, 1 + rand.nextInt(fortune * 2 + 1));
            }
        });
        ForgeHooks.initTools();
        URL_PATTERN = Pattern.compile("((?:[a-z0-9]{2,}:\\/\\/)?(?:(?:[0-9]{1,3}\\.){3}[0-9]{1,3}|(?:[-\\w_]{1,}\\.[a-z]{2,}?))(?::[0-9]{1,5})?.*?(?=[!\"\u00a7 \n]|$))", 2);
        craftingPlayer = new ThreadLocal();
        lootContext = new ThreadLocal();
    }

    private static class LootTableContext {
        public final kq name;
        private final boolean vanilla;
        public final boolean custom;
        public int poolCount = 0;
        public int entryCount = 0;
        private HashSet<String> entryNames = Sets.newHashSet();

        private LootTableContext(kq name, boolean custom) {
            this.name = name;
            this.custom = custom;
            this.vanilla = "minecraft".equals(this.name.b());
        }

        private void resetPoolCtx() {
            this.entryCount = 0;
            this.entryNames.clear();
        }

        public String validateEntryName(@Nullable String name) {
            if (name != null && !this.entryNames.contains(name)) {
                this.entryNames.add(name);
                return name;
            }
            if (!this.vanilla) {
                throw new JsonParseException("Loot Table \"" + this.name.toString() + "\" Duplicate entry name \"" + name + "\" for pool #" + (this.poolCount - 1) + " entry #" + (this.entryCount - 1));
            }
            int x2 = 0;
            while (this.entryNames.contains(name + "#" + x2)) {
                ++x2;
            }
            name = name + "#" + x2;
            this.entryNames.add(name);
            return name;
        }
    }

    static class SeedEntry
    extends pb.a {
        @Nonnull
        public final afj seed;

        public SeedEntry(@Nonnull afj seed, int weight) {
            super(weight);
            this.seed = seed;
        }

        @Nonnull
        public afj getStack(Random rand, int fortune) {
            return this.seed.l();
        }
    }
}

